/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.ir.backend.js.JsCommonBackendContext;
import org.jetbrains.kotlin.ir.backend.js.utils.JsMainFunctionDetectorKt;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00132\u00020\u0001:\u0002\u0012\u0013B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0014\u0010\b\u001a\u00020\t*\u00020\n2\u0006\u0010\u000b\u001a\u00020\tH\u0002J\u0014\u0010\f\u001a\u00020\t*\u00020\n2\u0006\u0010\u000b\u001a\u00020\tH\u0002J\u0010\u0010\r\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0010\u0010\r\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0010\u001a\u00020\u0011R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/utils/JsMainFunctionDetector;", "", "context", "Lorg/jetbrains/kotlin/ir/backend/js/JsCommonBackendContext;", "<init>", "(Lorg/jetbrains/kotlin/ir/backend/js/JsCommonBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/ir/backend/js/JsCommonBackendContext;", "isSuitableForMainParametersSize", "", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "allowEmptyParameters", "isMain", "getMainFunctionOrNull", "file", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "module", "Lorg/jetbrains/kotlin/ir/declarations/IrModuleFragment;", "MainFunctionCandidate", "Companion", "backend.js"})
@SourceDebugExtension(value={"SMAP\nJsMainFunctionDetector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JsMainFunctionDetector.kt\norg/jetbrains/kotlin/ir/backend/js/utils/JsMainFunctionDetector\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,112:1\n808#2,11:113\n1755#2,3:124\n808#2,11:127\n669#2,11:138\n1863#2,2:149\n*S KotlinDebug\n*F\n+ 1 JsMainFunctionDetector.kt\norg/jetbrains/kotlin/ir/backend/js/utils/JsMainFunctionDetector\n*L\n45#1:113,11\n45#1:124,3\n51#1:127,11\n51#1:138,11\n58#1:149,2\n*E\n"})
public final class JsMainFunctionDetector {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final JsCommonBackendContext context;

    public JsMainFunctionDetector(@NotNull JsCommonBackendContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
    }

    @NotNull
    public final JsCommonBackendContext getContext() {
        return this.context;
    }

    private final boolean isSuitableForMainParametersSize(IrSimpleFunction $this$isSuitableForMainParametersSize, boolean allowEmptyParameters) {
        boolean bl;
        switch ($this$isSuitableForMainParametersSize.getValueParameters().size()) {
            case 1: 
            case 2: {
                bl = true;
                break;
            }
            case 0: {
                bl = allowEmptyParameters;
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isMain(IrSimpleFunction $this$isMain, boolean allowEmptyParameters) {
        boolean bl;
        block13: {
            void $this$any$iv;
            void $this$filterIsInstanceTo$iv$iv;
            if (!((Collection)$this$isMain.getTypeParameters()).isEmpty()) {
                return false;
            }
            if (!this.isSuitableForMainParametersSize($this$isMain, allowEmptyParameters)) {
                return false;
            }
            boolean isLoweredSuspendFunction = JsMainFunctionDetectorKt.isLoweredSuspendFunction((IrFunction)$this$isMain, this.context);
            if (!(IrTypePredicatesKt.isUnit((IrType)$this$isMain.getReturnType()) || isLoweredSuspendFunction && (Intrinsics.areEqual((Object)$this$isMain.getReturnType(), (Object)this.context.getIrBuiltIns().getAnyNType()) || Intrinsics.areEqual((Object)$this$isMain.getReturnType(), (Object)this.context.getIrBuiltIns().getAnyType())))) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)$this$isMain.getName().asString(), (Object)"main")) {
                return false;
            }
            if ($this$isMain.getExtensionReceiverParameter() != null) {
                return false;
            }
            if ($this$isMain.getValueParameters().size() == 1) {
                return isLoweredSuspendFunction || JsMainFunctionDetectorKt.isStringArrayParameter((IrValueParameter)CollectionsKt.single((List)$this$isMain.getValueParameters()));
            }
            if ($this$isMain.getValueParameters().size() == 2) {
                return JsMainFunctionDetectorKt.isStringArrayParameter((IrValueParameter)$this$isMain.getValueParameters().get(0)) && isLoweredSuspendFunction;
            }
            if (!allowEmptyParameters) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            if (!$this$isMain.getValueParameters().isEmpty()) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            IrDeclarationParent irDeclarationParent = $this$isMain.getParent();
            Intrinsics.checkNotNull((Object)irDeclarationParent, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrFile");
            IrFile file = (IrFile)irDeclarationParent;
            Iterable $this$filterIsInstance$iv = file.getDeclarations();
            boolean $i$f$filterIsInstance = false;
            Iterable iterable = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof IrSimpleFunction)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filterIsInstance$iv = (List)destination$iv$iv;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    IrSimpleFunction it = (IrSimpleFunction)element$iv;
                    boolean bl2 = false;
                    if (!this.isMain(it, false)) continue;
                    bl = true;
                    break block13;
                }
                bl = false;
            }
        }
        return !bl;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final IrSimpleFunction getMainFunctionOrNull(@NotNull IrFile file) {
        Object v0;
        block3: {
            void $this$filterIsInstanceTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Iterable $this$filterIsInstance$iv = file.getDeclarations();
            boolean $i$f$filterIsInstance = false;
            Iterable iterable = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof IrSimpleFunction)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$singleOrNull$iv = (List)destination$iv$iv;
            boolean $i$f$singleOrNull = false;
            Object single$iv = null;
            boolean found$iv = false;
            for (Object element$iv : $this$singleOrNull$iv) {
                IrSimpleFunction it = (IrSimpleFunction)element$iv;
                boolean bl = false;
                if (!this.isMain(it, true)) continue;
                if (found$iv) {
                    v0 = null;
                    break block3;
                }
                single$iv = element$iv;
                found$iv = true;
            }
            v0 = !found$iv ? null : single$iv;
        }
        return v0;
    }

    @Nullable
    public final IrSimpleFunction getMainFunctionOrNull(@NotNull IrModuleFragment module2) {
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        Pair resultPair = null;
        Iterable $this$forEach$iv = module2.getFiles();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IrSimpleFunction it;
            String fqn;
            IrFile f = (IrFile)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)f.getPackageFqName().asString(), (String)"asString(...)");
            if (this.getMainFunctionOrNull(f) == null) continue;
            boolean bl2 = false;
            Pair result = resultPair;
            if (result == null) {
                resultPair = new Pair((Object)fqn, (Object)it);
                continue;
            }
            if (fqn.compareTo((String)result.getFirst()) >= 0) continue;
            resultPair = new Pair((Object)fqn, (Object)it);
        }
        Pair pair = resultPair;
        return pair != null ? (IrSimpleFunction)pair.getSecond() : null;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J;\u0010\u0004\u001a\u0004\u0018\u0001H\u0005\"\u0004\b\u0000\u0010\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u0002H\u00050\u00072\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u0002H\u0005\u0012\u0004\u0012\u00020\n0\tH\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000b\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/utils/JsMainFunctionDetector$Companion;", "", "<init>", "()V", "pickMainFunctionFromCandidates", "T", "candidates", "", "convertToCandidate", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/ir/backend/js/utils/JsMainFunctionDetector$MainFunctionCandidate;", "(Ljava/util/List;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "backend.js"})
    @SourceDebugExtension(value={"SMAP\nJsMainFunctionDetector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JsMainFunctionDetector.kt\norg/jetbrains/kotlin/ir/backend/js/utils/JsMainFunctionDetector$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,112:1\n1557#2:113\n1628#2,3:114\n1053#2:117\n295#2,2:118\n*S KotlinDebug\n*F\n+ 1 JsMainFunctionDetector.kt\norg/jetbrains/kotlin/ir/backend/js/utils/JsMainFunctionDetector$Companion\n*L\n79#1:113\n79#1:114,3\n80#1:117\n81#1:118,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        public final <T> T pickMainFunctionFromCandidates(@NotNull List<? extends T> candidates, @NotNull Function1<? super T, MainFunctionCandidate> convertToCandidate) {
            Object v0;
            block2: {
                void $this$firstOrNull$iv;
                Iterable $this$sortedBy$iv;
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv;
                Intrinsics.checkNotNullParameter(candidates, (String)"candidates");
                Intrinsics.checkNotNullParameter(convertToCandidate, (String)"convertToCandidate");
                boolean $i$f$pickMainFunctionFromCandidates = false;
                Iterable iterable = candidates;
                boolean $i$f$map = false;
                Iterator iterator2 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                Iterator iterator3 = $this$mapTo$iv$iv.iterator();
                while (iterator3.hasNext()) {
                    void it;
                    Object item$iv$iv;
                    Object t = item$iv$iv = iterator3.next();
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(TuplesKt.to((Object)it, (Object)convertToCandidate.invoke((Object)it)));
                }
                $this$map$iv = (List)destination$iv$iv;
                boolean $i$f$sortedBy = false;
                $this$sortedBy$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                    public final int compare(T a, T b) {
                        Pair it = (Pair)a;
                        boolean bl = false;
                        Comparable comparable = (Comparable)((Object)((MainFunctionCandidate)it.getSecond()).getPackageFqn());
                        it = (Pair)b;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)((MainFunctionCandidate)it.getSecond()).getPackageFqn())));
                    }
                });
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    Pair it = (Pair)element$iv;
                    boolean bl = false;
                    if (!(((MainFunctionCandidate)it.getSecond()).getMainFunctionTag() != null)) continue;
                    v0 = element$iv;
                    break block2;
                }
                v0 = null;
            }
            Pair pair = v0;
            return (T)(pair != null ? pair.getFirst() : null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/utils/JsMainFunctionDetector$MainFunctionCandidate;", "", "packageFqn", "", "mainFunctionTag", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "getPackageFqn", "()Ljava/lang/String;", "getMainFunctionTag", "backend.js"})
    public static final class MainFunctionCandidate {
        @NotNull
        private final String packageFqn;
        @Nullable
        private final String mainFunctionTag;

        public MainFunctionCandidate(@NotNull String packageFqn, @Nullable String mainFunctionTag) {
            Intrinsics.checkNotNullParameter((Object)packageFqn, (String)"packageFqn");
            this.packageFqn = packageFqn;
            this.mainFunctionTag = mainFunctionTag;
        }

        @NotNull
        public final String getPackageFqn() {
            return this.packageFqn;
        }

        @Nullable
        public final String getMainFunctionTag() {
            return this.mainFunctionTag;
        }
    }
}

