/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.callTranslator;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.contracts.parsing.PsiContractsUtilsKt;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.js.backend.ast.JsBlock;
import org.jetbrains.kotlin.js.backend.ast.JsConditional;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsIf;
import org.jetbrains.kotlin.js.backend.ast.JsNullLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.backend.ast.metadata.MetadataProperties;
import org.jetbrains.kotlin.js.translate.callTranslator.CallInfo;
import org.jetbrains.kotlin.js.translate.callTranslator.CallTranslatorKt;
import org.jetbrains.kotlin.js.translate.callTranslator.ExplicitReceivers;
import org.jetbrains.kotlin.js.translate.callTranslator.FunctionCallInfo;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.reference.CallArgumentTranslator;
import org.jetbrains.kotlin.js.translate.reference.ReferenceTranslator;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import org.jetbrains.kotlin.js.translate.utils.JsDescriptorUtils;
import org.jetbrains.kotlin.js.translate.utils.TranslationUtils;
import org.jetbrains.kotlin.js.translate.utils.UtilsKt;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.tasks.ExplicitReceiverKind;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u00004\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a$\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u000e\u0010\u0003\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u00042\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u001a\"\u0010\u0000\u001a\u00020\b*\u00020\u00022\u000e\u0010\u0003\u001a\n\u0012\u0006\b\u0001\u0012\u00020\t0\u00042\u0006\u0010\n\u001a\u00020\u000b\u001a\u0014\u0010\f\u001a\u00020\u0007*\u00020\u00022\u0006\u0010\r\u001a\u00020\u000eH\u0002\u001a$\u0010\u000f\u001a\u00020\u0001*\u00020\u00022\u000e\u0010\u0003\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u00042\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\u0010"}, d2={"getCallInfo", "Lorg/jetbrains/kotlin/js/translate/callTranslator/CallInfo;", "Lorg/jetbrains/kotlin/js/translate/context/TranslationContext;", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "extensionOrDispatchReceiver", "Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;", "Lorg/jetbrains/kotlin/js/translate/callTranslator/FunctionCallInfo;", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "explicitReceivers", "Lorg/jetbrains/kotlin/js/translate/callTranslator/ExplicitReceivers;", "getDispatchReceiver", "receiverValue", "Lorg/jetbrains/kotlin/resolve/scopes/receivers/ReceiverValue;", "createCallInfo", "js.translator"})
public final class CallInfoKt {
    @NotNull
    public static final CallInfo getCallInfo(@NotNull TranslationContext $this$getCallInfo, @NotNull ResolvedCall<? extends CallableDescriptor> resolvedCall2, @Nullable JsExpression extensionOrDispatchReceiver) {
        Intrinsics.checkNotNullParameter((Object)$this$getCallInfo, (String)"<this>");
        Intrinsics.checkNotNullParameter(resolvedCall2, (String)"resolvedCall");
        return CallInfoKt.createCallInfo($this$getCallInfo, resolvedCall2, new ExplicitReceivers(extensionOrDispatchReceiver, null, 2, null));
    }

    @NotNull
    public static final FunctionCallInfo getCallInfo(@NotNull TranslationContext $this$getCallInfo, @NotNull ResolvedCall<? extends FunctionDescriptor> resolvedCall2, @NotNull ExplicitReceivers explicitReceivers) {
        ExplicitReceivers explicitReceivers2;
        Intrinsics.checkNotNullParameter((Object)$this$getCallInfo, (String)"<this>");
        Intrinsics.checkNotNullParameter(resolvedCall2, (String)"resolvedCall");
        Intrinsics.checkNotNullParameter((Object)explicitReceivers, (String)"explicitReceivers");
        JsBlock argsBlock = new JsBlock();
        CallArgumentTranslator.ArgumentsInfo argumentsInfo = CallArgumentTranslator.Companion.translate(resolvedCall2, explicitReceivers.getExtensionOrDispatchReceiver(), $this$getCallInfo, argsBlock);
        if (!argsBlock.isEmpty() && explicitReceivers.getExtensionOrDispatchReceiver() != null) {
            JsExpression jsExpression = $this$getCallInfo.cacheExpressionIfNeeded(explicitReceivers.getExtensionOrDispatchReceiver());
            Intrinsics.checkNotNullExpressionValue((Object)jsExpression, (String)"cacheExpressionIfNeeded(...)");
            JsExpression receiverOrThisRef = jsExpression;
            JsExpression receiverRef = explicitReceivers.getExtensionReceiver();
            if (receiverRef != null) {
                JsExpression jsExpression2 = explicitReceivers.getExtensionReceiver();
                Intrinsics.checkNotNull((Object)jsExpression2);
                receiverRef = $this$getCallInfo.defineTemporary(jsExpression2);
            }
            explicitReceivers2 = new ExplicitReceivers(receiverOrThisRef, receiverRef);
        } else {
            explicitReceivers2 = explicitReceivers;
        }
        ExplicitReceivers explicitReceiversCorrected = explicitReceivers2;
        $this$getCallInfo.addStatementsToCurrentBlockFrom(argsBlock);
        CallInfo callInfo = CallInfoKt.createCallInfo($this$getCallInfo, resolvedCall2, explicitReceiversCorrected);
        return new FunctionCallInfo(callInfo, argumentsInfo);
    }

    private static final JsExpression getDispatchReceiver(TranslationContext $this$getDispatchReceiver, ReceiverValue receiverValue) {
        JsExpression jsExpression = $this$getDispatchReceiver.getDispatchReceiver(JsDescriptorUtils.getReceiverParameterForReceiver(receiverValue));
        Intrinsics.checkNotNullExpressionValue((Object)jsExpression, (String)"getDispatchReceiver(...)");
        return jsExpression;
    }

    private static final CallInfo createCallInfo(TranslationContext $this$createCallInfo, ResolvedCall<? extends CallableDescriptor> resolvedCall2, ExplicitReceivers explicitReceivers) {
        JsExpression jsExpression;
        JsExpression it;
        Ref.ObjectRef objectRef;
        ExplicitReceiverKind explicitReceiverKind = resolvedCall2.getExplicitReceiverKind();
        Intrinsics.checkNotNullExpressionValue((Object)explicitReceiverKind, (String)"getExplicitReceiverKind(...)");
        ExplicitReceiverKind receiverKind = explicitReceiverKind;
        Ref.ObjectRef dispatchReceiver = new Ref.ObjectRef();
        dispatchReceiver.element = CallInfoKt.createCallInfo$getDispatchReceiver(resolvedCall2, receiverKind, explicitReceivers, $this$createCallInfo);
        KotlinType dispatchReceiverType = null;
        KotlinType kotlinType = resolvedCall2.getSmartCastDispatchReceiverType();
        if (kotlinType == null) {
            ReceiverValue receiverValue = resolvedCall2.getDispatchReceiver();
            kotlinType = receiverValue != null ? receiverValue.getType() : null;
        }
        if ((dispatchReceiverType = kotlinType) != null) {
            CallableDescriptor callableDescriptor = resolvedCall2.getResultingDescriptor();
            Object object = callableDescriptor instanceof FunctionDescriptor ? (FunctionDescriptor)callableDescriptor : null;
            boolean bl = object != null && (object = object.getKind()) != null ? !((CallableMemberDescriptor.Kind)((Object)object)).isReal() : false;
            if (bl) {
                dispatchReceiverType = TranslationUtils.getDispatchReceiverTypeForCoercion(resolvedCall2.getResultingDescriptor());
            } else if (KotlinBuiltIns.isChar(dispatchReceiverType)) {
                CallableDescriptor callableDescriptor2 = resolvedCall2.getResultingDescriptor();
                Intrinsics.checkNotNullExpressionValue((Object)callableDescriptor2, (String)"getResultingDescriptor(...)");
                if (PsiContractsUtilsKt.isEqualsDescriptor(callableDescriptor2)) {
                    Collection<? extends CallableDescriptor> collection = resolvedCall2.getResultingDescriptor().getOverriddenDescriptors();
                    Intrinsics.checkNotNullExpressionValue(collection, (String)"getOverriddenDescriptors(...)");
                    ReceiverParameterDescriptor receiverParameterDescriptor = ((CallableDescriptor)CollectionsKt.single((Iterable)collection)).getDispatchReceiverParameter();
                    Intrinsics.checkNotNull((Object)receiverParameterDescriptor);
                    dispatchReceiverType = receiverParameterDescriptor.getType();
                }
            }
        }
        Ref.ObjectRef extensionReceiver = new Ref.ObjectRef();
        extensionReceiver.element = CallInfoKt.createCallInfo$getExtensionReceiver(resolvedCall2, receiverKind, explicitReceivers, $this$createCallInfo);
        Ref.ObjectRef notNullConditional = new Ref.ObjectRef();
        Call call2 = resolvedCall2.getCall();
        Intrinsics.checkNotNullExpressionValue((Object)call2, (String)"getCall(...)");
        if (CallUtilKt.isSafeCall(call2)) {
            switch (WhenMappings.$EnumSwitchMapping$0[resolvedCall2.getExplicitReceiverKind().ordinal()]) {
                case 2: 
                case 3: {
                    Object object = extensionReceiver.element;
                    Intrinsics.checkNotNull((Object)object);
                    notNullConditional.element = TranslationUtils.notNullConditional((JsExpression)object, new JsNullLiteral(), $this$createCallInfo);
                    extensionReceiver.element = ((JsConditional)notNullConditional.element).getThenExpression();
                    break;
                }
                default: {
                    Object object = dispatchReceiver.element;
                    Intrinsics.checkNotNull((Object)object);
                    notNullConditional.element = TranslationUtils.notNullConditional((JsExpression)object, new JsNullLiteral(), $this$createCallInfo);
                    dispatchReceiver.element = ((JsConditional)notNullConditional.element).getThenExpression();
                }
            }
        }
        if (dispatchReceiver.element == null) {
            DeclarationDescriptor declarationDescriptor = resolvedCall2.getResultingDescriptor().getContainingDeclaration();
            Intrinsics.checkNotNullExpressionValue((Object)declarationDescriptor, (String)"getContainingDeclaration(...)");
            DeclarationDescriptor container = declarationDescriptor;
            if (DescriptorUtils.isObject(container)) {
                dispatchReceiver.element = ReferenceTranslator.translateAsValueReference(container, $this$createCallInfo);
                dispatchReceiverType = ((ClassDescriptor)container).getDefaultType();
            }
        }
        if (dispatchReceiverType != null) {
            JsExpression jsExpression2;
            Ref.ObjectRef objectRef2 = dispatchReceiver;
            JsExpression jsExpression3 = (JsExpression)dispatchReceiver.element;
            if (jsExpression3 != null) {
                JsExpression jsExpression4 = jsExpression3;
                objectRef = objectRef2;
                boolean bl = false;
                jsExpression2 = TranslationUtils.coerce($this$createCallInfo, it, dispatchReceiverType);
                objectRef2 = objectRef;
            } else {
                jsExpression2 = null;
            }
            objectRef2.element = jsExpression2;
        }
        Ref.ObjectRef objectRef3 = extensionReceiver;
        JsExpression jsExpression5 = (JsExpression)extensionReceiver.element;
        if (jsExpression5 != null) {
            it = jsExpression5;
            objectRef = objectRef3;
            boolean bl = false;
            ReceiverParameterDescriptor receiverParameterDescriptor = resolvedCall2.getCandidateDescriptor().getExtensionReceiverParameter();
            Intrinsics.checkNotNull((Object)receiverParameterDescriptor);
            jsExpression = TranslationUtils.coerce($this$createCallInfo, it, receiverParameterDescriptor.getType());
            objectRef3 = objectRef;
        } else {
            jsExpression = null;
        }
        objectRef3.element = jsExpression;
        return new CallInfo($this$createCallInfo, resolvedCall2, (Ref.ObjectRef<JsExpression>)dispatchReceiver, (Ref.ObjectRef<JsExpression>)extensionReceiver, (Ref.ObjectRef<JsConditional>)notNullConditional){
            private final TranslationContext context;
            private final ResolvedCall<? extends CallableDescriptor> resolvedCall;
            private final JsExpression dispatchReceiver;
            private final JsExpression extensionReceiver;
            private final JsConditional notNullConditionalForSafeCall;
            final /* synthetic */ ResolvedCall<? extends CallableDescriptor> $resolvedCall;
            {
                this.$resolvedCall = $resolvedCall;
                this.context = $receiver;
                this.resolvedCall = $resolvedCall;
                this.dispatchReceiver = (JsExpression)$dispatchReceiver.element;
                this.extensionReceiver = (JsExpression)$extensionReceiver.element;
                this.notNullConditionalForSafeCall = (JsConditional)$notNullConditional.element;
            }

            public TranslationContext getContext() {
                return this.context;
            }

            public ResolvedCall<? extends CallableDescriptor> getResolvedCall() {
                return this.resolvedCall;
            }

            public JsExpression getDispatchReceiver() {
                return this.dispatchReceiver;
            }

            public JsExpression getExtensionReceiver() {
                return this.extensionReceiver;
            }

            public final JsConditional getNotNullConditionalForSafeCall() {
                return this.notNullConditionalForSafeCall;
            }

            public JsExpression constructSafeCallIfNeeded(JsExpression result) {
                JsExpression jsExpression;
                Intrinsics.checkNotNullParameter((Object)result, (String)"result");
                if (this.notNullConditionalForSafeCall == null) {
                    jsExpression = result;
                } else {
                    KotlinType type = CallTranslatorKt.getReturnType(this.$resolvedCall);
                    MetadataProperties.setType(result, type);
                    this.notNullConditionalForSafeCall.setThenExpression(TranslationUtils.coerce(this.getContext(), result, TypeUtilsKt.makeNullable(type)));
                    jsExpression = this.notNullConditionalForSafeCall;
                }
                return jsExpression;
            }

            public JsStatement constructSuspendSafeCallIfNeeded(JsStatement result) {
                JsStatement jsStatement;
                Intrinsics.checkNotNullParameter((Object)result, (String)"result");
                if (this.notNullConditionalForSafeCall == null) {
                    jsStatement = result;
                } else {
                    JsStatement jsStatement2;
                    KtElement ktElement = this.$resolvedCall.getCall().getCallElement();
                    Intrinsics.checkNotNullExpressionValue((Object)ktElement, (String)"getCallElement(...)");
                    KtElement callElement = ktElement;
                    JsExpression coroutineResult = UtilsKt.createCoroutineResult(this.getContext(), this.$resolvedCall);
                    JsExpression nullAssignment = JsAstUtils.assignment(coroutineResult, new JsNullLiteral()).source(callElement);
                    JsBlock thenBlock = new JsBlock();
                    List<JsStatement> list = thenBlock.getStatements();
                    Intrinsics.checkNotNullExpressionValue(list, (String)"getStatements(...)");
                    ((Collection)list).add(result);
                    TranslationContext translationContext = this.getContext().innerBlock(thenBlock);
                    Intrinsics.checkNotNullExpressionValue((Object)translationContext, (String)"innerBlock(...)");
                    TranslationContext thenContext = translationContext;
                    JsExpression jsExpression = coroutineResult.deepCopy();
                    Intrinsics.checkNotNullExpressionValue((Object)jsExpression, (String)"deepCopy(...)");
                    JsExpression lhs = jsExpression;
                    Object object = coroutineResult.deepCopy();
                    ResolvedCall<? extends CallableDescriptor> resolvedCall2 = this.$resolvedCall;
                    JsExpression $this$constructSuspendSafeCallIfNeeded_u24lambda_u240 = object;
                    boolean bl = false;
                    Intrinsics.checkNotNull((Object)$this$constructSuspendSafeCallIfNeeded_u24lambda_u240);
                    MetadataProperties.setType($this$constructSuspendSafeCallIfNeeded_u24lambda_u240, CallTranslatorKt.getReturnType(resolvedCall2));
                    JsExpression jsExpression2 = object;
                    Intrinsics.checkNotNullExpressionValue((Object)jsExpression2, (String)"apply(...)");
                    JsExpression rhsOriginal = jsExpression2;
                    JsExpression jsExpression3 = TranslationUtils.coerce(thenContext, rhsOriginal, TypeUtilsKt.makeNullable(CallTranslatorKt.getReturnType(this.$resolvedCall)));
                    Intrinsics.checkNotNullExpressionValue((Object)jsExpression3, (String)"coerce(...)");
                    JsExpression rhs = jsExpression3;
                    if (!Intrinsics.areEqual((Object)rhs, (Object)rhsOriginal)) {
                        List<JsStatement> list2 = thenBlock.getStatements();
                        Intrinsics.checkNotNullExpressionValue(list2, (String)"getStatements(...)");
                        object = list2;
                        object.add(JsAstUtils.asSyntheticStatement(JsAstUtils.assignment(lhs, rhs).source(callElement)));
                    }
                    if (thenBlock.getStatements().size() == 1) {
                        List<JsStatement> list3 = thenBlock.getStatements();
                        Intrinsics.checkNotNullExpressionValue(list3, (String)"getStatements(...)");
                        jsStatement2 = (JsStatement)CollectionsKt.first(list3);
                    } else {
                        jsStatement2 = thenBlock;
                    }
                    JsStatement thenStatement = jsStatement2;
                    jsStatement = new JsIf(this.notNullConditionalForSafeCall.getTestExpression(), thenStatement, nullAssignment.makeStmt());
                }
                return jsStatement;
            }
        };
    }

    private static final JsExpression createCallInfo$getDispatchReceiver(ResolvedCall<? extends CallableDescriptor> $resolvedCall, ExplicitReceiverKind receiverKind, ExplicitReceivers $explicitReceivers, TranslationContext $this_createCallInfo) {
        JsExpression jsExpression;
        ReceiverValue receiverValue = $resolvedCall.getDispatchReceiver();
        if (receiverValue == null) {
            return null;
        }
        ReceiverValue receiverValue2 = receiverValue;
        switch (WhenMappings.$EnumSwitchMapping$0[receiverKind.ordinal()]) {
            case 1: 
            case 2: {
                jsExpression = $explicitReceivers.getExtensionOrDispatchReceiver();
                break;
            }
            default: {
                jsExpression = CallInfoKt.getDispatchReceiver($this_createCallInfo, receiverValue2);
            }
        }
        return jsExpression;
    }

    private static final JsExpression createCallInfo$getExtensionReceiver(ResolvedCall<? extends CallableDescriptor> $resolvedCall, ExplicitReceiverKind receiverKind, ExplicitReceivers $explicitReceivers, TranslationContext $this_createCallInfo) {
        JsExpression jsExpression;
        ReceiverValue receiverValue = $resolvedCall.getExtensionReceiver();
        if (receiverValue == null) {
            return null;
        }
        ReceiverValue receiverValue2 = receiverValue;
        switch (WhenMappings.$EnumSwitchMapping$0[receiverKind.ordinal()]) {
            case 3: {
                jsExpression = $explicitReceivers.getExtensionOrDispatchReceiver();
                break;
            }
            case 2: {
                jsExpression = $explicitReceivers.getExtensionReceiver();
                break;
            }
            default: {
                jsExpression = CallInfoKt.getDispatchReceiver($this_createCallInfo, receiverValue2);
            }
        }
        return jsExpression;
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ExplicitReceiverKind.values().length];
            try {
                nArray[ExplicitReceiverKind.DISPATCH_RECEIVER.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ExplicitReceiverKind.BOTH_RECEIVERS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ExplicitReceiverKind.EXTENSION_RECEIVER.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

