/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.types;

import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.builtins.UnsignedTypes;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DescriptorUtilKt;
import org.jetbrains.kotlin.descriptors.FindClassInModuleKt;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotated;
import org.jetbrains.kotlin.diagnostics.PsiDiagnosticUtils;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.FqNameUnsafe;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtForExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeProjection;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000V\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\b\u0014\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0018\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u000e\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u000e\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u000e\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u001e\u0010\u000b\u001a\u00020\u00012\u0006\u0010\f\u001a\u00020\u00032\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\b0\u000eH\u0002\u001a \u0010$\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010%\u001a\b\u0012\u0004\u0012\u00020\b0#\u001a\u0016\u0010&\u001a\u0004\u0018\u00010'*\u00020(2\u0006\u0010)\u001a\u00020*H\u0002\u001a\u0012\u0010+\u001a\u00020\u0003*\u00020,2\u0006\u0010-\u001a\u00020.\u001a\u000e\u0010/\u001a\u00020\u00012\u0006\u00100\u001a\u000201\u001a\u000e\u00102\u001a\u00020\u00012\u0006\u00100\u001a\u000201\u001a\u0010\u00103\u001a\u00020\u00012\b\u00104\u001a\u0004\u0018\u00010(\u001a1\u00105\u001a\u00020\u0001*\u0002012\u0006\u00106\u001a\u00020\b2\u0006\u00107\u001a\u00020\b2\u0012\u00108\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u000109H\u0082\b\u001a\u0010\u0010:\u001a\u00020\u00012\u0006\u00104\u001a\u000201H\u0002\u001a\u000e\u0010;\u001a\u00020\u00012\u0006\u00104\u001a\u000201\u001a\u000e\u0010<\u001a\u00020\u00012\u0006\u00104\u001a\u000201\u001a\u000e\u0010=\u001a\u00020\u00012\u0006\u00104\u001a\u000201\u001a\u000e\u0010>\u001a\u00020\u00012\u0006\u00104\u001a\u000201\u001a\u000e\u0010?\u001a\u00020\u00012\u0006\u00104\u001a\u000201\u001a\u000e\u0010@\u001a\u00020\u00012\u0006\u00104\u001a\u000201\u001a\u000e\u0010A\u001a\u00020\u00012\u0006\u00104\u001a\u000201\u001a\u000e\u0010B\u001a\u00020\u00012\u0006\u00104\u001a\u000201\u001a\u000e\u0010C\u001a\u00020\u00012\u0006\u00104\u001a\u000201\u001a\u000e\u0010D\u001a\u00020\u00012\u0006\u00104\u001a\u000201\u001a\u000e\u0010E\u001a\u00020\u00012\u0006\u00104\u001a\u000201\u001a\u000e\u0010F\u001a\u00020\u00012\u0006\u00104\u001a\u000201\u001a\u000e\u0010G\u001a\u00020\u00012\u0006\u00104\u001a\u000201\u001a\u000e\u0010H\u001a\u00020\u00012\u0006\u00104\u001a\u000201\u001a\u000e\u0010I\u001a\u00020\u00012\u0006\u00104\u001a\u000201\u001a\u000e\u0010J\u001a\u00020\u00012\u0006\u00104\u001a\u000201\u001a\u000e\u0010K\u001a\u00020\u00012\u0006\u00104\u001a\u000201\u001a\u0010\u0010L\u001a\u00020\u00012\u0006\u0010M\u001a\u00020\u0003H\u0002\u001a\u000e\u0010N\u001a\u00020\u00012\u0006\u00104\u001a\u000201\u001a\u000e\u0010O\u001a\u00020\u00012\u0006\u00104\u001a\u000201\u001a\u0010\u0010P\u001a\u00020\u00012\b\u00104\u001a\u0004\u0018\u00010(\"\u001a\u0010\u0007\u001a\u0004\u0018\u00010\b*\u00020\u00038BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\"\u000e\u0010\u000f\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0010\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0011\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\b0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0013\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0014\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0015\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\b0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0017\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0018\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0019\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u001a\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u001b\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u001c\u001a\u00020\bX\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u001d\u001a\u00020\bX\u0080T\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\b0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u001f\u001a\u00020\bX\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010 \u001a\u00020\bX\u0080T\u00a2\u0006\u0002\n\u0000\"\u0014\u0010!\u001a\b\u0012\u0004\u0012\u00020\b0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\"\u001a\b\u0012\u0004\u0012\u00020\b0#X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006Q"}, d2={"isPrimitiveRange", "", "rangeType", "Lorg/jetbrains/kotlin/types/KotlinType;", "isUnsignedRange", "isPrimitiveProgression", "isUnsignedProgression", "classFqnString", "", "getClassFqnString", "(Lorg/jetbrains/kotlin/types/KotlinType;)Ljava/lang/String;", "isClassTypeWithFqn", "kotlinType", "fqns", "", "CHAR_RANGE_FQN", "INT_RANGE_FQN", "LONG_RANGE_FQN", "PRIMITIVE_RANGE_FQNS", "CHAR_PROGRESSION_FQN", "INT_PROGRESSION_FQN", "LONG_PROGRESSION_FQN", "PRIMITIVE_PROGRESSION_FQNS", "CLOSED_FLOAT_RANGE_FQN", "CLOSED_DOUBLE_RANGE_FQN", "CLOSED_RANGE_FQN", "CLOSED_FLOATING_POINT_RANGE_FQN", "COMPARABLE_RANGE_FQN", "UINT_RANGE_FQN", "ULONG_RANGE_FQN", "UNSIGNED_RANGE_FQNS", "UINT_PROGRESSION_FQN", "ULONG_PROGRESSION_FQN", "UNSIGNED_PROGRESSION_FQNS", "ALL_PROGRESSION_AND_RANGES", "", "getRangeOrProgressionElementType", "progressionsAndRanges", "findTypeInModuleByTopLevelClassFqName", "Lorg/jetbrains/kotlin/types/SimpleType;", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "fqName", "Lorg/jetbrains/kotlin/name/FqName;", "getElementType", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "forExpression", "Lorg/jetbrains/kotlin/psi/KtForExpression;", "isPrimitiveNumberRangeTo", "rangeTo", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "isUnsignedIntegerRangeTo", "isUnsignedIntegerClassDescriptor", "descriptor", "isTopLevelExtensionOnType", "name", "packageFQN", "receiverTypePredicate", "Lkotlin/Function1;", "isPrimitiveRangeToExtension", "isPrimitiveNumberDownTo", "isUnsignedIntegerDownTo", "isPrimitiveNumberUntil", "isUnsignedIntegerUntil", "isArrayOrPrimitiveArrayIndices", "isArrayOrPrimitiveArrayWithIndex", "isCollectionIndices", "isIterableWithIndex", "isSequenceWithIndex", "isCharSequenceIndices", "isCharSequenceWithIndex", "isComparableRangeTo", "isClosedRangeContains", "isPrimitiveRangeContains", "isUnsignedIntegerRangeContains", "isPrimitiveNumberRangeExtensionContainsPrimitiveNumber", "isPrimitiveProgressionReverse", "isPrimitiveNumberType", "type", "isClosedFloatingPointRangeContains", "isCharSequenceIterator", "isPrimitiveNumberClassDescriptor", "frontend"})
@SourceDebugExtension(value={"SMAP\nRangeUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RangeUtil.kt\norg/jetbrains/kotlin/types/RangeUtilKt\n*L\n1#1,286:1\n133#1,3:287\n133#1,3:290\n133#1,3:293\n133#1,3:296\n133#1,3:299\n133#1,3:302\n133#1,3:305\n133#1,3:308\n133#1,3:311\n133#1,3:314\n133#1,3:317\n133#1,3:320\n133#1,3:323\n133#1,3:326\n133#1,3:329\n*S KotlinDebug\n*F\n+ 1 RangeUtil.kt\norg/jetbrains/kotlin/types/RangeUtilKt\n*L\n139#1:287,3\n144#1:290,3\n149#1:293,3\n154#1:296,3\n159#1:299,3\n164#1:302,3\n169#1:305,3\n174#1:308,3\n179#1:311,3\n184#1:314,3\n190#1:317,3\n195#1:320,3\n200#1:323,3\n256#1:326,3\n278#1:329,3\n*E\n"})
public final class RangeUtilKt {
    @NotNull
    public static final String CHAR_RANGE_FQN = "kotlin.ranges.CharRange";
    @NotNull
    public static final String INT_RANGE_FQN = "kotlin.ranges.IntRange";
    @NotNull
    public static final String LONG_RANGE_FQN = "kotlin.ranges.LongRange";
    @NotNull
    private static final Set<String> PRIMITIVE_RANGE_FQNS;
    @NotNull
    public static final String CHAR_PROGRESSION_FQN = "kotlin.ranges.CharProgression";
    @NotNull
    public static final String INT_PROGRESSION_FQN = "kotlin.ranges.IntProgression";
    @NotNull
    public static final String LONG_PROGRESSION_FQN = "kotlin.ranges.LongProgression";
    @NotNull
    private static final Set<String> PRIMITIVE_PROGRESSION_FQNS;
    @NotNull
    private static final String CLOSED_FLOAT_RANGE_FQN = "kotlin.ranges.ClosedFloatRange";
    @NotNull
    private static final String CLOSED_DOUBLE_RANGE_FQN = "kotlin.ranges.ClosedDoubleRange";
    @NotNull
    private static final String CLOSED_RANGE_FQN = "kotlin.ranges.ClosedRange";
    @NotNull
    private static final String CLOSED_FLOATING_POINT_RANGE_FQN = "kotlin.ranges.ClosedFloatingPointRange";
    @NotNull
    private static final String COMPARABLE_RANGE_FQN = "kotlin.ranges.ComparableRange";
    @NotNull
    public static final String UINT_RANGE_FQN = "kotlin.ranges.UIntRange";
    @NotNull
    public static final String ULONG_RANGE_FQN = "kotlin.ranges.ULongRange";
    @NotNull
    private static final Set<String> UNSIGNED_RANGE_FQNS;
    @NotNull
    public static final String UINT_PROGRESSION_FQN = "kotlin.ranges.UIntProgression";
    @NotNull
    public static final String ULONG_PROGRESSION_FQN = "kotlin.ranges.ULongProgression";
    @NotNull
    private static final Set<String> UNSIGNED_PROGRESSION_FQNS;
    @NotNull
    private static final List<String> ALL_PROGRESSION_AND_RANGES;

    public static final boolean isPrimitiveRange(@NotNull KotlinType rangeType) {
        Intrinsics.checkNotNullParameter((Object)rangeType, (String)"rangeType");
        return RangeUtilKt.isClassTypeWithFqn(rangeType, PRIMITIVE_RANGE_FQNS);
    }

    public static final boolean isUnsignedRange(@NotNull KotlinType rangeType) {
        Intrinsics.checkNotNullParameter((Object)rangeType, (String)"rangeType");
        return RangeUtilKt.isClassTypeWithFqn(rangeType, UNSIGNED_RANGE_FQNS);
    }

    public static final boolean isPrimitiveProgression(@NotNull KotlinType rangeType) {
        Intrinsics.checkNotNullParameter((Object)rangeType, (String)"rangeType");
        return RangeUtilKt.isClassTypeWithFqn(rangeType, PRIMITIVE_PROGRESSION_FQNS);
    }

    public static final boolean isUnsignedProgression(@NotNull KotlinType rangeType) {
        Intrinsics.checkNotNullParameter((Object)rangeType, (String)"rangeType");
        return RangeUtilKt.isClassTypeWithFqn(rangeType, UNSIGNED_PROGRESSION_FQNS);
    }

    private static final String getClassFqnString(KotlinType $this$classFqnString) {
        ClassifierDescriptor classifierDescriptor = $this$classFqnString.getConstructor().getDeclarationDescriptor();
        ClassDescriptor classDescriptor = classifierDescriptor instanceof ClassDescriptor ? (ClassDescriptor)classifierDescriptor : null;
        if (classDescriptor == null) {
            return null;
        }
        ClassDescriptor declarationDescriptor = classDescriptor;
        FqNameUnsafe fqNameUnsafe = DescriptorUtils.getFqName(declarationDescriptor);
        Intrinsics.checkNotNullExpressionValue((Object)fqNameUnsafe, (String)"getFqName(...)");
        FqNameUnsafe fqn = fqNameUnsafe;
        return fqn.isSafe() ? fqn.asString() : null;
    }

    private static final boolean isClassTypeWithFqn(KotlinType kotlinType, Set<String> fqns) {
        return CollectionsKt.contains((Iterable)fqns, (Object)RangeUtilKt.getClassFqnString(kotlinType));
    }

    @Nullable
    public static final KotlinType getRangeOrProgressionElementType(@NotNull KotlinType rangeType, @NotNull List<String> progressionsAndRanges) {
        KotlinType kotlinType;
        Intrinsics.checkNotNullParameter((Object)rangeType, (String)"rangeType");
        Intrinsics.checkNotNullParameter(progressionsAndRanges, (String)"progressionsAndRanges");
        ClassifierDescriptor classifierDescriptor = rangeType.getConstructor().getDeclarationDescriptor();
        ClassDescriptor classDescriptor = classifierDescriptor instanceof ClassDescriptor ? (ClassDescriptor)classifierDescriptor : null;
        if (classDescriptor == null) {
            return null;
        }
        ClassDescriptor rangeClassDescriptor = classDescriptor;
        KotlinBuiltIns builtIns = DescriptorUtilsKt.getBuiltIns(rangeClassDescriptor);
        String string = DescriptorUtilsKt.getFqNameSafe(rangeClassDescriptor).asString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
        String fqName = string;
        if (!progressionsAndRanges.contains(fqName)) {
            return null;
        }
        switch (fqName) {
            case "kotlin.ranges.CharRange": 
            case "kotlin.ranges.CharProgression": {
                kotlinType = builtIns.getCharType();
                break;
            }
            case "kotlin.ranges.IntProgression": 
            case "kotlin.ranges.IntRange": {
                kotlinType = builtIns.getIntType();
                break;
            }
            case "kotlin.ranges.LongProgression": 
            case "kotlin.ranges.LongRange": {
                kotlinType = builtIns.getLongType();
                break;
            }
            case "kotlin.ranges.ClosedFloatRange": {
                kotlinType = builtIns.getFloatType();
                break;
            }
            case "kotlin.ranges.ClosedDoubleRange": {
                kotlinType = builtIns.getDoubleType();
                break;
            }
            case "kotlin.ranges.ClosedRange": {
                TypeProjection typeProjection = (TypeProjection)CollectionsKt.singleOrNull(rangeType.getArguments());
                if (typeProjection != null) {
                    kotlinType = typeProjection.getType();
                    break;
                }
                kotlinType = null;
                break;
            }
            case "kotlin.ranges.ClosedFloatingPointRange": {
                TypeProjection typeProjection = (TypeProjection)CollectionsKt.singleOrNull(rangeType.getArguments());
                if (typeProjection != null) {
                    kotlinType = typeProjection.getType();
                    break;
                }
                kotlinType = null;
                break;
            }
            case "kotlin.ranges.ComparableRange": {
                TypeProjection typeProjection = (TypeProjection)CollectionsKt.singleOrNull(rangeType.getArguments());
                if (typeProjection != null) {
                    kotlinType = typeProjection.getType();
                    break;
                }
                kotlinType = null;
                break;
            }
            case "kotlin.ranges.UIntProgression": 
            case "kotlin.ranges.UIntRange": {
                kotlinType = RangeUtilKt.findTypeInModuleByTopLevelClassFqName(rangeClassDescriptor, StandardNames.FqNames.uIntFqName);
                break;
            }
            case "kotlin.ranges.ULongRange": 
            case "kotlin.ranges.ULongProgression": {
                kotlinType = RangeUtilKt.findTypeInModuleByTopLevelClassFqName(rangeClassDescriptor, StandardNames.FqNames.uLongFqName);
                break;
            }
            default: {
                kotlinType = null;
            }
        }
        return kotlinType;
    }

    public static /* synthetic */ KotlinType getRangeOrProgressionElementType$default(KotlinType kotlinType, List list, int n, Object object) {
        if ((n & 2) != 0) {
            list = ALL_PROGRESSION_AND_RANGES;
        }
        return RangeUtilKt.getRangeOrProgressionElementType(kotlinType, list);
    }

    private static final SimpleType findTypeInModuleByTopLevelClassFqName(DeclarationDescriptor $this$findTypeInModuleByTopLevelClassFqName, FqName fqName) {
        ClassDescriptor classDescriptor = FindClassInModuleKt.findClassAcrossModuleDependencies(DescriptorUtilsKt.getModule($this$findTypeInModuleByTopLevelClassFqName), ClassId.Companion.topLevel(fqName));
        return classDescriptor != null ? classDescriptor.getDefaultType() : null;
    }

    @NotNull
    public static final KotlinType getElementType(@NotNull BindingContext $this$getElementType, @NotNull KtForExpression forExpression) {
        Intrinsics.checkNotNullParameter((Object)$this$getElementType, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)forExpression, (String)"forExpression");
        KtExpression ktExpression = forExpression.getLoopRange();
        Intrinsics.checkNotNull((Object)ktExpression);
        KtExpression loopRange = ktExpression;
        ResolvedCall resolvedCall2 = (ResolvedCall)$this$getElementType.get(BindingContext.LOOP_RANGE_NEXT_RESOLVED_CALL, loopRange);
        if (resolvedCall2 == null) {
            throw new AssertionError((Object)("No next() function " + PsiDiagnosticUtils.atLocation((KtExpression)loopRange)));
        }
        ResolvedCall nextCall = resolvedCall2;
        KotlinType kotlinType = ((FunctionDescriptor)nextCall.getResultingDescriptor()).getReturnType();
        Intrinsics.checkNotNull((Object)kotlinType);
        return kotlinType;
    }

    public static final boolean isPrimitiveNumberRangeTo(@NotNull CallableDescriptor rangeTo) {
        Intrinsics.checkNotNullParameter((Object)rangeTo, (String)"rangeTo");
        return Intrinsics.areEqual((Object)"rangeTo", (Object)rangeTo.getName().asString()) && RangeUtilKt.isPrimitiveNumberClassDescriptor(rangeTo.getContainingDeclaration()) || RangeUtilKt.isPrimitiveRangeToExtension(rangeTo);
    }

    public static final boolean isUnsignedIntegerRangeTo(@NotNull CallableDescriptor rangeTo) {
        Intrinsics.checkNotNullParameter((Object)rangeTo, (String)"rangeTo");
        return Intrinsics.areEqual((Object)"rangeTo", (Object)rangeTo.getName().asString()) && RangeUtilKt.isUnsignedIntegerClassDescriptor(rangeTo.getContainingDeclaration());
    }

    public static final boolean isUnsignedIntegerClassDescriptor(@Nullable DeclarationDescriptor descriptor) {
        return descriptor != null && UnsignedTypes.INSTANCE.isUnsignedClass(descriptor);
    }

    private static final boolean isTopLevelExtensionOnType(CallableDescriptor $this$isTopLevelExtensionOnType, String name, String packageFQN, Function1<? super KotlinType, Boolean> receiverTypePredicate) {
        boolean $i$f$isTopLevelExtensionOnType = false;
        if (!DescriptorUtilKt.isTopLevelInPackage($this$isTopLevelExtensionOnType, name, packageFQN)) {
            return false;
        }
        Annotated annotated = $this$isTopLevelExtensionOnType.getOriginal().getExtensionReceiverParameter();
        if (annotated == null || (annotated = annotated.getType()) == null) {
            return false;
        }
        Annotated extensionReceiverType = annotated;
        return (Boolean)receiverTypePredicate.invoke((Object)extensionReceiverType);
    }

    /*
     * WARNING - void declaration
     */
    private static final boolean isPrimitiveRangeToExtension(CallableDescriptor descriptor) {
        boolean bl;
        void name$iv;
        void $this$isTopLevelExtensionOnType$iv;
        CallableDescriptor callableDescriptor = descriptor;
        String string = "rangeTo";
        String packageFQN$iv = "kotlin.ranges";
        boolean $i$f$isTopLevelExtensionOnType = false;
        if (!DescriptorUtilKt.isTopLevelInPackage((DeclarationDescriptor)$this$isTopLevelExtensionOnType$iv, (String)name$iv, packageFQN$iv)) {
            bl = false;
        } else {
            Annotated annotated = $this$isTopLevelExtensionOnType$iv.getOriginal().getExtensionReceiverParameter();
            if (annotated == null || (annotated = annotated.getType()) == null) {
                bl = false;
            } else {
                Annotated extensionReceiverType$iv;
                Annotated it = extensionReceiverType$iv = annotated;
                boolean bl2 = false;
                bl = KotlinBuiltIns.isPrimitiveType((KotlinType)it);
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    public static final boolean isPrimitiveNumberDownTo(@NotNull CallableDescriptor descriptor) {
        boolean bl;
        void name$iv;
        void $this$isTopLevelExtensionOnType$iv;
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        CallableDescriptor callableDescriptor = descriptor;
        String string = "downTo";
        String packageFQN$iv = "kotlin.ranges";
        boolean $i$f$isTopLevelExtensionOnType = false;
        if (!DescriptorUtilKt.isTopLevelInPackage((DeclarationDescriptor)$this$isTopLevelExtensionOnType$iv, (String)name$iv, packageFQN$iv)) {
            bl = false;
        } else {
            Annotated annotated = $this$isTopLevelExtensionOnType$iv.getOriginal().getExtensionReceiverParameter();
            if (annotated == null || (annotated = annotated.getType()) == null) {
                bl = false;
            } else {
                Annotated extensionReceiverType$iv;
                Annotated it = extensionReceiverType$iv = annotated;
                boolean bl2 = false;
                bl = RangeUtilKt.isPrimitiveNumberClassDescriptor(((KotlinType)it).getConstructor().getDeclarationDescriptor());
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    public static final boolean isUnsignedIntegerDownTo(@NotNull CallableDescriptor descriptor) {
        boolean bl;
        void name$iv;
        void $this$isTopLevelExtensionOnType$iv;
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        CallableDescriptor callableDescriptor = descriptor;
        String string = "downTo";
        String packageFQN$iv = "kotlin.ranges";
        boolean $i$f$isTopLevelExtensionOnType = false;
        if (!DescriptorUtilKt.isTopLevelInPackage((DeclarationDescriptor)$this$isTopLevelExtensionOnType$iv, (String)name$iv, packageFQN$iv)) {
            bl = false;
        } else {
            Annotated annotated = $this$isTopLevelExtensionOnType$iv.getOriginal().getExtensionReceiverParameter();
            if (annotated == null || (annotated = annotated.getType()) == null) {
                bl = false;
            } else {
                Annotated extensionReceiverType$iv;
                Annotated it = extensionReceiverType$iv = annotated;
                boolean bl2 = false;
                bl = RangeUtilKt.isUnsignedIntegerClassDescriptor(((KotlinType)it).getConstructor().getDeclarationDescriptor());
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    public static final boolean isPrimitiveNumberUntil(@NotNull CallableDescriptor descriptor) {
        boolean bl;
        void name$iv;
        void $this$isTopLevelExtensionOnType$iv;
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        CallableDescriptor callableDescriptor = descriptor;
        String string = "until";
        String packageFQN$iv = "kotlin.ranges";
        boolean $i$f$isTopLevelExtensionOnType = false;
        if (!DescriptorUtilKt.isTopLevelInPackage((DeclarationDescriptor)$this$isTopLevelExtensionOnType$iv, (String)name$iv, packageFQN$iv)) {
            bl = false;
        } else {
            Annotated annotated = $this$isTopLevelExtensionOnType$iv.getOriginal().getExtensionReceiverParameter();
            if (annotated == null || (annotated = annotated.getType()) == null) {
                bl = false;
            } else {
                Annotated extensionReceiverType$iv;
                Annotated it = extensionReceiverType$iv = annotated;
                boolean bl2 = false;
                bl = RangeUtilKt.isPrimitiveNumberClassDescriptor(((KotlinType)it).getConstructor().getDeclarationDescriptor());
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    public static final boolean isUnsignedIntegerUntil(@NotNull CallableDescriptor descriptor) {
        boolean bl;
        void name$iv;
        void $this$isTopLevelExtensionOnType$iv;
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        CallableDescriptor callableDescriptor = descriptor;
        String string = "until";
        String packageFQN$iv = "kotlin.ranges";
        boolean $i$f$isTopLevelExtensionOnType = false;
        if (!DescriptorUtilKt.isTopLevelInPackage((DeclarationDescriptor)$this$isTopLevelExtensionOnType$iv, (String)name$iv, packageFQN$iv)) {
            bl = false;
        } else {
            Annotated annotated = $this$isTopLevelExtensionOnType$iv.getOriginal().getExtensionReceiverParameter();
            if (annotated == null || (annotated = annotated.getType()) == null) {
                bl = false;
            } else {
                Annotated extensionReceiverType$iv;
                Annotated it = extensionReceiverType$iv = annotated;
                boolean bl2 = false;
                bl = RangeUtilKt.isUnsignedIntegerClassDescriptor(((KotlinType)it).getConstructor().getDeclarationDescriptor());
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    public static final boolean isArrayOrPrimitiveArrayIndices(@NotNull CallableDescriptor descriptor) {
        boolean bl;
        void name$iv;
        void $this$isTopLevelExtensionOnType$iv;
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        CallableDescriptor callableDescriptor = descriptor;
        String string = "indices";
        String packageFQN$iv = "kotlin.collections";
        boolean $i$f$isTopLevelExtensionOnType = false;
        if (!DescriptorUtilKt.isTopLevelInPackage((DeclarationDescriptor)$this$isTopLevelExtensionOnType$iv, (String)name$iv, packageFQN$iv)) {
            bl = false;
        } else {
            Annotated annotated = $this$isTopLevelExtensionOnType$iv.getOriginal().getExtensionReceiverParameter();
            if (annotated == null || (annotated = annotated.getType()) == null) {
                bl = false;
            } else {
                Annotated extensionReceiverType$iv;
                Annotated it = extensionReceiverType$iv = annotated;
                boolean bl2 = false;
                bl = KotlinBuiltIns.isArray((KotlinType)it) || KotlinBuiltIns.isPrimitiveArray((KotlinType)it);
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    public static final boolean isArrayOrPrimitiveArrayWithIndex(@NotNull CallableDescriptor descriptor) {
        boolean bl;
        void name$iv;
        void $this$isTopLevelExtensionOnType$iv;
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        CallableDescriptor callableDescriptor = descriptor;
        String string = "withIndex";
        String packageFQN$iv = "kotlin.collections";
        boolean $i$f$isTopLevelExtensionOnType = false;
        if (!DescriptorUtilKt.isTopLevelInPackage((DeclarationDescriptor)$this$isTopLevelExtensionOnType$iv, (String)name$iv, packageFQN$iv)) {
            bl = false;
        } else {
            Annotated annotated = $this$isTopLevelExtensionOnType$iv.getOriginal().getExtensionReceiverParameter();
            if (annotated == null || (annotated = annotated.getType()) == null) {
                bl = false;
            } else {
                Annotated extensionReceiverType$iv;
                Annotated it = extensionReceiverType$iv = annotated;
                boolean bl2 = false;
                bl = KotlinBuiltIns.isArray((KotlinType)it) || KotlinBuiltIns.isPrimitiveArray((KotlinType)it);
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    public static final boolean isCollectionIndices(@NotNull CallableDescriptor descriptor) {
        boolean bl;
        void name$iv;
        void $this$isTopLevelExtensionOnType$iv;
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        CallableDescriptor callableDescriptor = descriptor;
        String string = "indices";
        String packageFQN$iv = "kotlin.collections";
        boolean $i$f$isTopLevelExtensionOnType = false;
        if (!DescriptorUtilKt.isTopLevelInPackage((DeclarationDescriptor)$this$isTopLevelExtensionOnType$iv, (String)name$iv, packageFQN$iv)) {
            bl = false;
        } else {
            Annotated annotated = $this$isTopLevelExtensionOnType$iv.getOriginal().getExtensionReceiverParameter();
            if (annotated == null || (annotated = annotated.getType()) == null) {
                bl = false;
            } else {
                Annotated extensionReceiverType$iv;
                Annotated it = extensionReceiverType$iv = annotated;
                boolean bl2 = false;
                bl = KotlinBuiltIns.isCollectionOrNullableCollection((KotlinType)it);
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    public static final boolean isIterableWithIndex(@NotNull CallableDescriptor descriptor) {
        boolean bl;
        void name$iv;
        void $this$isTopLevelExtensionOnType$iv;
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        CallableDescriptor callableDescriptor = descriptor;
        String string = "withIndex";
        String packageFQN$iv = "kotlin.collections";
        boolean $i$f$isTopLevelExtensionOnType = false;
        if (!DescriptorUtilKt.isTopLevelInPackage((DeclarationDescriptor)$this$isTopLevelExtensionOnType$iv, (String)name$iv, packageFQN$iv)) {
            bl = false;
        } else {
            Annotated annotated = $this$isTopLevelExtensionOnType$iv.getOriginal().getExtensionReceiverParameter();
            if (annotated == null || (annotated = annotated.getType()) == null) {
                bl = false;
            } else {
                Annotated extensionReceiverType$iv;
                Annotated it = extensionReceiverType$iv = annotated;
                boolean bl2 = false;
                bl = KotlinBuiltIns.isIterableOrNullableIterable((KotlinType)it);
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    public static final boolean isSequenceWithIndex(@NotNull CallableDescriptor descriptor) {
        boolean bl;
        void name$iv;
        void $this$isTopLevelExtensionOnType$iv;
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        CallableDescriptor callableDescriptor = descriptor;
        String string = "withIndex";
        String packageFQN$iv = "kotlin.sequences";
        boolean $i$f$isTopLevelExtensionOnType = false;
        if (!DescriptorUtilKt.isTopLevelInPackage((DeclarationDescriptor)$this$isTopLevelExtensionOnType$iv, (String)name$iv, packageFQN$iv)) {
            bl = false;
        } else {
            Annotated annotated = $this$isTopLevelExtensionOnType$iv.getOriginal().getExtensionReceiverParameter();
            if (annotated == null || (annotated = annotated.getType()) == null) {
                bl = false;
            } else {
                Annotated extensionReceiverType$iv;
                Annotated it = extensionReceiverType$iv = annotated;
                boolean bl2 = false;
                ClassifierDescriptor classifierDescriptor = ((KotlinType)it).getConstructor().getDeclarationDescriptor();
                if (classifierDescriptor == null) {
                    return false;
                }
                ClassifierDescriptor typeDescriptor = classifierDescriptor;
                bl = DescriptorUtilKt.isTopLevelInPackage(typeDescriptor, "Sequence", "kotlin.sequences");
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    public static final boolean isCharSequenceIndices(@NotNull CallableDescriptor descriptor) {
        boolean bl;
        void name$iv;
        void $this$isTopLevelExtensionOnType$iv;
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        CallableDescriptor callableDescriptor = descriptor;
        String string = "indices";
        String packageFQN$iv = "kotlin.text";
        boolean $i$f$isTopLevelExtensionOnType = false;
        if (!DescriptorUtilKt.isTopLevelInPackage((DeclarationDescriptor)$this$isTopLevelExtensionOnType$iv, (String)name$iv, packageFQN$iv)) {
            bl = false;
        } else {
            Annotated annotated = $this$isTopLevelExtensionOnType$iv.getOriginal().getExtensionReceiverParameter();
            if (annotated == null || (annotated = annotated.getType()) == null) {
                bl = false;
            } else {
                Annotated extensionReceiverType$iv;
                Annotated it = extensionReceiverType$iv = annotated;
                boolean bl2 = false;
                bl = KotlinBuiltIns.isCharSequenceOrNullableCharSequence((KotlinType)it);
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    public static final boolean isCharSequenceWithIndex(@NotNull CallableDescriptor descriptor) {
        boolean bl;
        void name$iv;
        void $this$isTopLevelExtensionOnType$iv;
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        CallableDescriptor callableDescriptor = descriptor;
        String string = "withIndex";
        String packageFQN$iv = "kotlin.text";
        boolean $i$f$isTopLevelExtensionOnType = false;
        if (!DescriptorUtilKt.isTopLevelInPackage((DeclarationDescriptor)$this$isTopLevelExtensionOnType$iv, (String)name$iv, packageFQN$iv)) {
            bl = false;
        } else {
            Annotated annotated = $this$isTopLevelExtensionOnType$iv.getOriginal().getExtensionReceiverParameter();
            if (annotated == null || (annotated = annotated.getType()) == null) {
                bl = false;
            } else {
                Annotated extensionReceiverType$iv;
                Annotated it = extensionReceiverType$iv = annotated;
                boolean bl2 = false;
                bl = KotlinBuiltIns.isCharSequenceOrNullableCharSequence((KotlinType)it);
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    public static final boolean isComparableRangeTo(@NotNull CallableDescriptor descriptor) {
        boolean bl;
        void name$iv;
        void $this$isTopLevelExtensionOnType$iv;
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        CallableDescriptor callableDescriptor = descriptor;
        String string = "rangeTo";
        String packageFQN$iv = "kotlin.ranges";
        boolean $i$f$isTopLevelExtensionOnType = false;
        if (!DescriptorUtilKt.isTopLevelInPackage((DeclarationDescriptor)$this$isTopLevelExtensionOnType$iv, (String)name$iv, packageFQN$iv)) {
            bl = false;
        } else {
            Annotated annotated = $this$isTopLevelExtensionOnType$iv.getOriginal().getExtensionReceiverParameter();
            if (annotated == null || (annotated = annotated.getType()) == null) {
                bl = false;
            } else {
                Annotated extensionReceiverType$iv;
                Annotated it = extensionReceiverType$iv = annotated;
                boolean bl2 = false;
                ClassifierDescriptor classifierDescriptor = ((KotlinType)it).getConstructor().getDeclarationDescriptor();
                TypeParameterDescriptor typeParameterDescriptor = classifierDescriptor instanceof TypeParameterDescriptor ? (TypeParameterDescriptor)classifierDescriptor : null;
                if (typeParameterDescriptor == null) {
                    return false;
                }
                TypeParameterDescriptor extensionReceiverTypeDescriptor = typeParameterDescriptor;
                List<KotlinType> list = extensionReceiverTypeDescriptor.getUpperBounds();
                Intrinsics.checkNotNullExpressionValue(list, (String)"getUpperBounds(...)");
                KotlinType kotlinType = (KotlinType)CollectionsKt.singleOrNull(list);
                if (kotlinType == null) {
                    return false;
                }
                KotlinType upperBoundType = kotlinType;
                ClassifierDescriptor classifierDescriptor2 = upperBoundType.getConstructor().getDeclarationDescriptor();
                ClassDescriptor classDescriptor = classifierDescriptor2 instanceof ClassDescriptor ? (ClassDescriptor)classifierDescriptor2 : null;
                if (classDescriptor == null) {
                    return false;
                }
                ClassDescriptor upperBoundClassDescriptor = classDescriptor;
                bl = DescriptorUtilKt.isTopLevelInPackage(upperBoundClassDescriptor, "Comparable", "kotlin");
            }
        }
        return bl;
    }

    public static final boolean isClosedRangeContains(@NotNull CallableDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        if (!Intrinsics.areEqual((Object)descriptor.getName().asString(), (Object)"contains")) {
            return false;
        }
        DeclarationDescriptor declarationDescriptor = descriptor.getContainingDeclaration();
        ClassDescriptor classDescriptor = declarationDescriptor instanceof ClassDescriptor ? (ClassDescriptor)declarationDescriptor : null;
        if (classDescriptor == null) {
            return false;
        }
        ClassDescriptor containingClassDescriptor = classDescriptor;
        return DescriptorUtilKt.isTopLevelInPackage(containingClassDescriptor, "ClosedRange", "kotlin.ranges");
    }

    public static final boolean isPrimitiveRangeContains(@NotNull CallableDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        if (!Intrinsics.areEqual((Object)descriptor.getName().asString(), (Object)"contains")) {
            return false;
        }
        Annotated annotated = descriptor.getDispatchReceiverParameter();
        if (annotated == null || (annotated = annotated.getType()) == null) {
            return false;
        }
        Annotated dispatchReceiverType = annotated;
        return RangeUtilKt.isPrimitiveRange((KotlinType)dispatchReceiverType);
    }

    public static final boolean isUnsignedIntegerRangeContains(@NotNull CallableDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        ReceiverParameterDescriptor receiverParameterDescriptor = descriptor.getDispatchReceiverParameter();
        KotlinType dispatchReceiverType = receiverParameterDescriptor != null ? receiverParameterDescriptor.getType() : null;
        ReceiverParameterDescriptor receiverParameterDescriptor2 = descriptor.getExtensionReceiverParameter();
        KotlinType extensionReceiverType = receiverParameterDescriptor2 != null ? receiverParameterDescriptor2.getType() : null;
        if (dispatchReceiverType != null && extensionReceiverType == null) {
            if (!Intrinsics.areEqual((Object)descriptor.getName().asString(), (Object)"contains")) {
                return false;
            }
            return RangeUtilKt.isUnsignedRange(dispatchReceiverType);
        }
        if (extensionReceiverType != null && dispatchReceiverType == null) {
            if (!DescriptorUtilKt.isTopLevelInPackage(descriptor, "contains", "kotlin.ranges")) {
                return false;
            }
            return RangeUtilKt.isUnsignedRange(extensionReceiverType);
        }
        return false;
    }

    public static final boolean isPrimitiveNumberRangeExtensionContainsPrimitiveNumber(@NotNull CallableDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        if (!DescriptorUtilKt.isTopLevelInPackage(descriptor, "contains", "kotlin.ranges")) {
            return false;
        }
        Annotated annotated = descriptor.getExtensionReceiverParameter();
        if (annotated == null || (annotated = annotated.getType()) == null) {
            return false;
        }
        Annotated extensionReceiverType = annotated;
        KotlinType kotlinType = RangeUtilKt.getRangeOrProgressionElementType$default((KotlinType)extensionReceiverType, null, 2, null);
        if (kotlinType == null) {
            return false;
        }
        KotlinType rangeElementType = kotlinType;
        if (!RangeUtilKt.isPrimitiveNumberType(rangeElementType)) {
            return false;
        }
        List<ValueParameterDescriptor> list = descriptor.getValueParameters();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getValueParameters(...)");
        Annotated annotated2 = (ValueParameterDescriptor)CollectionsKt.singleOrNull(list);
        if (annotated2 == null || (annotated2 = annotated2.getType()) == null) {
            return false;
        }
        Annotated argumentType = annotated2;
        return RangeUtilKt.isPrimitiveNumberType((KotlinType)argumentType);
    }

    /*
     * WARNING - void declaration
     */
    public static final boolean isPrimitiveProgressionReverse(@NotNull CallableDescriptor descriptor) {
        boolean bl;
        void name$iv;
        void $this$isTopLevelExtensionOnType$iv;
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        CallableDescriptor callableDescriptor = descriptor;
        String string = "reversed";
        String packageFQN$iv = "kotlin.ranges";
        boolean $i$f$isTopLevelExtensionOnType = false;
        if (!DescriptorUtilKt.isTopLevelInPackage((DeclarationDescriptor)$this$isTopLevelExtensionOnType$iv, (String)name$iv, packageFQN$iv)) {
            bl = false;
        } else {
            Annotated annotated = $this$isTopLevelExtensionOnType$iv.getOriginal().getExtensionReceiverParameter();
            if (annotated == null || (annotated = annotated.getType()) == null) {
                bl = false;
            } else {
                Annotated extensionReceiverType$iv;
                Annotated it = extensionReceiverType$iv = annotated;
                boolean bl2 = false;
                bl = RangeUtilKt.isPrimitiveProgression((KotlinType)it);
            }
        }
        return bl;
    }

    private static final boolean isPrimitiveNumberType(KotlinType type) {
        return KotlinBuiltIns.isByte(type) || KotlinBuiltIns.isShort(type) || KotlinBuiltIns.isInt(type) || KotlinBuiltIns.isChar(type) || KotlinBuiltIns.isLong(type) || KotlinBuiltIns.isFloat(type) || KotlinBuiltIns.isDouble(type);
    }

    public static final boolean isClosedFloatingPointRangeContains(@NotNull CallableDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        if (!Intrinsics.areEqual((Object)descriptor.getName().asString(), (Object)"contains")) {
            return false;
        }
        DeclarationDescriptor declarationDescriptor = descriptor.getContainingDeclaration();
        ClassDescriptor classDescriptor = declarationDescriptor instanceof ClassDescriptor ? (ClassDescriptor)declarationDescriptor : null;
        if (classDescriptor == null) {
            return false;
        }
        ClassDescriptor containingClassDescriptor = classDescriptor;
        return DescriptorUtilKt.isTopLevelInPackage(containingClassDescriptor, "ClosedFloatingPointRange", "kotlin.ranges");
    }

    /*
     * WARNING - void declaration
     */
    public static final boolean isCharSequenceIterator(@NotNull CallableDescriptor descriptor) {
        boolean bl;
        void name$iv;
        void $this$isTopLevelExtensionOnType$iv;
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        CallableDescriptor callableDescriptor = descriptor;
        String string = "iterator";
        String packageFQN$iv = "kotlin.text";
        boolean $i$f$isTopLevelExtensionOnType = false;
        if (!DescriptorUtilKt.isTopLevelInPackage((DeclarationDescriptor)$this$isTopLevelExtensionOnType$iv, (String)name$iv, packageFQN$iv)) {
            bl = false;
        } else {
            Annotated annotated = $this$isTopLevelExtensionOnType$iv.getOriginal().getExtensionReceiverParameter();
            if (annotated == null || (annotated = annotated.getType()) == null) {
                bl = false;
            } else {
                Annotated extensionReceiverType$iv;
                Annotated it = extensionReceiverType$iv = annotated;
                boolean bl2 = false;
                ClassifierDescriptor classifierDescriptor = ((KotlinType)it).getConstructor().getDeclarationDescriptor();
                bl = classifierDescriptor != null ? DescriptorUtilKt.isTopLevelInPackage(classifierDescriptor, "CharSequence", "kotlin") : false;
            }
        }
        return bl;
    }

    public static final boolean isPrimitiveNumberClassDescriptor(@Nullable DeclarationDescriptor descriptor) {
        return descriptor instanceof ClassDescriptor && KotlinBuiltIns.isPrimitiveClass((ClassDescriptor)descriptor) && !KotlinBuiltIns.isBoolean((ClassDescriptor)descriptor);
    }

    static {
        Object[] objectArray = new String[]{CHAR_RANGE_FQN, INT_RANGE_FQN, LONG_RANGE_FQN};
        PRIMITIVE_RANGE_FQNS = SetsKt.setOf((Object[])objectArray);
        objectArray = new String[]{CHAR_PROGRESSION_FQN, INT_PROGRESSION_FQN, LONG_PROGRESSION_FQN};
        PRIMITIVE_PROGRESSION_FQNS = SetsKt.setOf((Object[])objectArray);
        objectArray = new String[]{UINT_RANGE_FQN, ULONG_RANGE_FQN};
        UNSIGNED_RANGE_FQNS = SetsKt.setOf((Object[])objectArray);
        objectArray = new String[]{UINT_PROGRESSION_FQN, ULONG_PROGRESSION_FQN};
        UNSIGNED_PROGRESSION_FQNS = SetsKt.setOf((Object[])objectArray);
        objectArray = new String[]{CHAR_RANGE_FQN, CHAR_PROGRESSION_FQN, INT_RANGE_FQN, INT_PROGRESSION_FQN, LONG_RANGE_FQN, LONG_PROGRESSION_FQN, CLOSED_FLOAT_RANGE_FQN, CLOSED_DOUBLE_RANGE_FQN, CLOSED_RANGE_FQN, CLOSED_FLOATING_POINT_RANGE_FQN, COMPARABLE_RANGE_FQN, UINT_RANGE_FQN, UINT_PROGRESSION_FQN, ULONG_RANGE_FQN, ULONG_PROGRESSION_FQN};
        ALL_PROGRESSION_AND_RANGES = CollectionsKt.listOf((Object[])objectArray);
    }
}

