/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.data.index;

import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsCommitMetadata;
import com.intellij.vcs.log.VcsFullCommitDetails;
import com.intellij.vcs.log.VcsLogBundle;
import com.intellij.vcs.log.VcsLogDetailsFilter;
import com.intellij.vcs.log.VcsLogStructureFilter;
import com.intellij.vcs.log.VcsLogTextFilter;
import com.intellij.vcs.log.VcsLogUserFilter;
import com.intellij.vcs.log.VcsUser;
import com.intellij.vcs.log.data.DataPack;
import com.intellij.vcs.log.data.VcsLogStorage;
import com.intellij.vcs.log.data.index.IndexDataGetter;
import com.intellij.vcs.log.data.index.IndexDiagnostic;
import com.intellij.vcs.log.data.index.IndexedDetails;
import com.intellij.vcs.log.data.index.VcsLogStorageBackend;
import com.intellij.vcs.log.graph.PermanentGraph;
import com.intellij.vcs.log.graph.api.EdgeFilter;
import com.intellij.vcs.log.graph.api.LiteLinearGraph;
import com.intellij.vcs.log.graph.api.permanent.PermanentGraphInfo;
import com.intellij.vcs.log.graph.utils.BfsWalk;
import com.intellij.vcs.log.graph.utils.IntHashSetFlags;
import com.intellij.vcs.log.graph.utils.LinearGraphUtils;
import com.intellij.vcs.log.visible.filters.VcsLogFilterObject;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.ranges.IntProgression;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0002J\u001e\u0010\f\u001a\u0004\u0018\u00010\b*\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J0\u0010\f\u001a\u00020\b*\u00020\r2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00040\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00100\u00122\b\b\u0002\u0010\u0014\u001a\u00020\u0015J\u001e\u0010\u0016\u001a\u0004\u0018\u00010\b*\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u0010H\u0002J.\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00040\u0019*\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001e2\u0006\u0010 \u001a\u00020\u0015J&\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00040\u0019*\u00020\u001a2\u0006\u0010\"\u001a\u00020\r2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001eJ<\u0010#\u001a\u00020$*\u00060%j\u0002`&2\u0006\u0010'\u001a\u00020\n2\u0006\u0010(\u001a\u00020\n2\u0006\u0010)\u001a\u00020\b2\u0012\u0010*\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00010+H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lcom/intellij/vcs/log/data/index/IndexDiagnostic;", "", "()V", "COMMITS_TO_CHECK", "", "FILTERED_PATHS_LIMIT", "INDEXED_COMMITS_ITERATIONS_LIMIT", "getCommitDetailsDiff", "", "expected", "Lcom/intellij/vcs/log/VcsCommitMetadata;", "actual", "getDiffFor", "Lcom/intellij/vcs/log/data/index/IndexDataGetter;", "commitId", "commitDetails", "Lcom/intellij/vcs/log/VcsFullCommitDetails;", "commitsIdList", "", "commitDetailsList", "checkAllCommits", "", "getFilteringDiff", "details", "pickCommits", "", "Lcom/intellij/vcs/log/data/DataPack;", "storage", "Lcom/intellij/vcs/log/data/VcsLogStorage;", "roots", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "old", "pickIndexedCommits", "dataGetter", "reportDiff", "", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "expectedMetadata", "actualMetadata", "attributeKey", "attributeGetter", "Lkotlin/Function1;", "intellij.platform.vcs.log.impl"})
@SourceDebugExtension(value={"SMAP\nIndexDiagnostic.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IndexDiagnostic.kt\ncom/intellij/vcs/log/data/index/IndexDiagnostic\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 KtUtils.kt\ncom/intellij/util/KotlinUtils\n*L\n1#1,160:1\n179#2,2:161\n1446#3,5:163\n766#3:168\n857#3,2:169\n35#4:171\n*S KotlinDebug\n*F\n+ 1 IndexDiagnostic.kt\ncom/intellij/vcs/log/data/index/IndexDiagnostic\n*L\n74#1:161,2\n77#1:163,5\n79#1:168\n79#1:169,2\n103#1:171\n*E\n"})
public final class IndexDiagnostic {
    @NotNull
    public static final IndexDiagnostic INSTANCE = new IndexDiagnostic();
    private static final int FILTERED_PATHS_LIMIT = 15;
    private static final int COMMITS_TO_CHECK = 10;
    private static final int INDEXED_COMMITS_ITERATIONS_LIMIT = 5000;

    private IndexDiagnostic() {
    }

    @NotNull
    public final String getDiffFor(@NotNull IndexDataGetter $this$getDiffFor, @NotNull List<Integer> commitsIdList, @NotNull List<? extends VcsFullCommitDetails> commitDetailsList, boolean checkAllCommits) {
        Intrinsics.checkNotNullParameter((Object)$this$getDiffFor, (String)"<this>");
        Intrinsics.checkNotNullParameter(commitsIdList, (String)"commitsIdList");
        Intrinsics.checkNotNullParameter(commitDetailsList, (String)"commitDetailsList");
        StringBuilder report = new StringBuilder();
        for (Pair pair : CollectionsKt.zip((Iterable)commitsIdList, (Iterable)commitDetailsList)) {
            VcsFullCommitDetails commitDetails;
            int commitId2 = ((Number)pair.component1()).intValue();
            if (this.getDiffFor($this$getDiffFor, commitId2, commitDetails = (VcsFullCommitDetails)pair.component2()) != null) {
                String commitReport;
                boolean bl = false;
                report.append(commitReport).append("\n");
            }
            if (!checkAllCommits && !StringsKt.isBlank((CharSequence)report)) {
                String string = report.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                return string;
            }
            ProgressManager.checkCanceled();
        }
        String string = report.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    public static /* synthetic */ String getDiffFor$default(IndexDiagnostic indexDiagnostic, IndexDataGetter indexDataGetter, List list, List list2, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = true;
        }
        return indexDiagnostic.getDiffFor(indexDataGetter, list, list2, bl);
    }

    private final String getDiffFor(IndexDataGetter $this$getDiffFor, int commitId2, VcsFullCommitDetails commitDetails) {
        String difference;
        VcsCommitMetadata vcsCommitMetadata = (VcsCommitMetadata)commitDetails;
        VcsLogStorage vcsLogStorage = $this$getDiffFor.getLogStorage();
        Intrinsics.checkNotNullExpressionValue((Object)vcsLogStorage, (String)"getLogStorage(...)");
        String string = this.getCommitDetailsDiff(vcsCommitMetadata, (VcsCommitMetadata)new IndexedDetails($this$getDiffFor, vcsLogStorage, commitId2, 0L, 8, null));
        if (string == null) {
            string = this.getFilteringDiff($this$getDiffFor, commitId2, commitDetails);
        }
        if ((difference = string) == null) {
            return null;
        }
        Object[] objectArray = new Object[]{((Hash)commitDetails.getId()).asString(), difference};
        return VcsLogBundle.message("vcs.log.index.diagnostic.error.for.commit", objectArray);
    }

    private final String getCommitDetailsDiff(VcsCommitMetadata expected, VcsCommitMetadata actual) {
        StringBuilder sb = new StringBuilder();
        this.reportDiff(sb, expected, actual, "vcs.log.index.diagnostic.error.attribute.name.author", (Function1<? super VcsCommitMetadata, ? extends Object>)((Function1)getCommitDetailsDiff.1.INSTANCE));
        this.reportDiff(sb, expected, actual, "vcs.log.index.diagnostic.error.attribute.name.committer", (Function1<? super VcsCommitMetadata, ? extends Object>)((Function1)getCommitDetailsDiff.2.INSTANCE));
        this.reportDiff(sb, expected, actual, "vcs.log.index.diagnostic.error.attribute.name.author.time", (Function1<? super VcsCommitMetadata, ? extends Object>)((Function1)getCommitDetailsDiff.3.INSTANCE));
        this.reportDiff(sb, expected, actual, "vcs.log.index.diagnostic.error.attribute.name.committer.time", (Function1<? super VcsCommitMetadata, ? extends Object>)((Function1)getCommitDetailsDiff.4.INSTANCE));
        this.reportDiff(sb, expected, actual, "vcs.log.index.diagnostic.error.attribute.name.message", (Function1<? super VcsCommitMetadata, ? extends Object>)((Function1)getCommitDetailsDiff.5.INSTANCE));
        this.reportDiff(sb, expected, actual, "vcs.log.index.diagnostic.error.attribute.name.parents", (Function1<? super VcsCommitMetadata, ? extends Object>)((Function1)getCommitDetailsDiff.6.INSTANCE));
        if (((CharSequence)sb).length() == 0) {
            return null;
        }
        return sb.toString();
    }

    private final void reportDiff(StringBuilder $this$reportDiff, VcsCommitMetadata expectedMetadata, VcsCommitMetadata actualMetadata, String attributeKey, Function1<? super VcsCommitMetadata, ? extends Object> attributeGetter) {
        Object actualValue;
        Object expectedValue = attributeGetter.invoke((Object)expectedMetadata);
        if (Intrinsics.areEqual((Object)expectedValue, (Object)(actualValue = attributeGetter.invoke((Object)actualMetadata)))) {
            return;
        }
        Object[] objectArray = new Object[]{VcsLogBundle.message(attributeKey, new Object[0]), expectedValue, actualValue};
        $this$reportDiff.append(VcsLogBundle.message("vcs.log.index.diagnostic.error.message", objectArray)).append("\n");
    }

    /*
     * WARNING - void declaration
     */
    private final String getFilteringDiff(IndexDataGetter $this$getFilteringDiff, int commitId2, VcsFullCommitDetails details) {
        void $this$filterTo$iv$iv;
        void destination$iv;
        void $this$flatMapTo$iv;
        VcsLogTextFilter vcsLogTextFilter;
        Object v2;
        Object element$iv2;
        Object $this$firstOrNull$iv;
        VcsLogUserFilter authorFilter;
        block8: {
            VcsUser vcsUser = details.getAuthor();
            Intrinsics.checkNotNullExpressionValue((Object)vcsUser, (String)"getAuthor(...)");
            authorFilter = VcsLogFilterObject.fromUser$default(vcsUser, null, 2, null);
            String string = details.getFullMessage();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getFullMessage(...)");
            $this$firstOrNull$iv = StringsKt.lineSequence((CharSequence)string);
            boolean $i$f$firstOrNull = false;
            for (Object element$iv2 : $this$firstOrNull$iv) {
                String it = (String)element$iv2;
                boolean bl = false;
                if (!(it.length() > 5)) continue;
                v2 = element$iv2;
                break block8;
            }
            v2 = null;
        }
        String string = v2;
        if (string != null) {
            String it = string;
            boolean bl = false;
            vcsLogTextFilter = VcsLogFilterObject.fromPattern(StringsKt.take((String)it, (int)25), false, true);
        } else {
            vcsLogTextFilter = null;
        }
        VcsLogTextFilter textFilter = vcsLogTextFilter;
        List list = details.getParents();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getParents(...)");
        $this$firstOrNull$iv = (Iterable)CollectionsKt.getIndices((Collection)list);
        Collection it = new LinkedHashSet();
        boolean $i$f$flatMapTo22 = false;
        element$iv2 = $this$flatMapTo$iv.iterator();
        while (element$iv2.hasNext()) {
            int element$iv3;
            int parentIndex = element$iv3 = ((IntIterator)element$iv2).nextInt();
            boolean bl = false;
            List list2 = ChangesUtil.getPaths((Collection)details.getChanges(parentIndex));
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getPaths(...)");
            Iterable list$iv = list2;
            CollectionsKt.addAll((Collection)destination$iv, (Iterable)list$iv);
        }
        Iterable $this$filter$iv = CollectionsKt.take((Iterable)((Iterable)destination$iv), (int)15);
        boolean $i$f$filter = false;
        Iterable $i$f$flatMapTo22 = $this$filter$iv;
        Object[] destination$iv$iv = (Object[])new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            FilePath it2 = (FilePath)element$iv$iv;
            boolean bl = false;
            VirtualFile virtualFile = $this$getFilteringDiff.getRoot(it2);
            if (!Intrinsics.areEqual((Object)(virtualFile != null ? virtualFile.getPath() : null), (Object)details.getRoot().getPath())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List paths = (List)destination$iv$iv;
        VcsLogStructureFilter pathsFilter = !((Collection)paths).isEmpty() ? VcsLogFilterObject.fromPaths(paths) : null;
        StringBuilder sb = new StringBuilder();
        destination$iv$iv = new VcsLogDetailsFilter[]{authorFilter, textFilter, pathsFilter};
        for (VcsLogDetailsFilter filter : CollectionsKt.listOfNotNull((Object[])destination$iv$iv)) {
            if (!$this$getFilteringDiff.filter(CollectionsKt.listOf((Object)filter)).contains(commitId2)) {
                Object[] objectArray = new Object[]{filter, ((Hash)details.getId()).toShortString()};
                sb.append(VcsLogBundle.message("vcs.log.index.diagnostic.error.filter", objectArray)).append("\n");
            }
            ProgressManager.checkCanceled();
        }
        if (((CharSequence)sb).length() == 0) {
            return null;
        }
        return sb.toString();
    }

    @NotNull
    public final Set<Integer> pickCommits(@NotNull DataPack $this$pickCommits, @NotNull VcsLogStorage storage, @NotNull Collection<? extends VirtualFile> roots, boolean old) {
        IntRange intRange;
        Intrinsics.checkNotNullParameter((Object)$this$pickCommits, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)storage, (String)"storage");
        Intrinsics.checkNotNullParameter(roots, (String)"roots");
        IntOpenHashSet result2 = new IntOpenHashSet();
        Set rootsToCheck = CollectionsKt.toMutableSet((Iterable)roots);
        PermanentGraph<Integer> permanentGraph = $this$pickCommits.getPermanentGraph();
        PermanentGraphInfo permanentGraphInfo = permanentGraph instanceof PermanentGraphInfo ? (PermanentGraphInfo)permanentGraph : null;
        if (permanentGraphInfo == null) {
            return SetsKt.emptySet();
        }
        PermanentGraphInfo permanentGraphInfo2 = permanentGraphInfo;
        LiteLinearGraph liteLinearGraph = LinearGraphUtils.asLiteLinearGraph(permanentGraphInfo2.getLinearGraph());
        Intrinsics.checkNotNullExpressionValue((Object)liteLinearGraph, (String)"asLiteLinearGraph(...)");
        LiteLinearGraph graph = liteLinearGraph;
        IntRange $this$applyIf$iv = RangesKt.until((int)0, (int)graph.nodesCount());
        boolean $i$f$applyIf = false;
        if (old) {
            IntProgression $this$pickCommits_u24lambda_u245 = (IntProgression)$this$applyIf$iv;
            boolean bl = false;
            intRange = RangesKt.reversed((IntProgression)$this$pickCommits_u24lambda_u245);
        } else {
            intRange = $this$applyIf$iv;
        }
        IntProgression nodeRange = (IntProgression)intRange;
        int node = nodeRange.getFirst();
        int n = nodeRange.getLast();
        int n2 = nodeRange.getStep();
        if (n2 > 0 && node <= n || n2 < 0 && n <= node) {
            while (true) {
                if (graph.getNodes(node, old ? LiteLinearGraph.NodeFilter.DOWN : LiteLinearGraph.NodeFilter.UP).isEmpty()) {
                    VirtualFile root;
                    Object CommitId2 = permanentGraphInfo2.getPermanentCommitsInfo().getCommitId(node);
                    Intrinsics.checkNotNullExpressionValue(CommitId2, (String)"getCommitId(...)");
                    CommitId commitId2 = storage.getCommitId(((Number)CommitId2).intValue());
                    Object object = root = commitId2 != null ? commitId2.getRoot() : null;
                    if (TypeIntrinsics.asMutableCollection((Object)rootsToCheck).remove(root)) {
                        new BfsWalk(node, graph, new IntHashSetFlags(graph.nodesCount()), !old).walk((Function1<? super Integer, Boolean>)((Function1)new Function1<Integer, Boolean>(graph, result2, (PermanentGraphInfo<Integer>)permanentGraphInfo2){
                            final /* synthetic */ LiteLinearGraph $graph;
                            final /* synthetic */ IntOpenHashSet $result;
                            final /* synthetic */ PermanentGraphInfo<Integer> $permanentGraphInfo;
                            {
                                this.$graph = $graph;
                                this.$result = $result;
                                this.$permanentGraphInfo = $permanentGraphInfo;
                                super(1);
                            }

                            @NotNull
                            public final Boolean invoke(int nextNode) {
                                if (this.$graph.getNodes(nextNode, LiteLinearGraph.NodeFilter.DOWN).size() == 1) {
                                    Integer n = this.$permanentGraphInfo.getPermanentCommitsInfo().getCommitId(nextNode);
                                    Intrinsics.checkNotNullExpressionValue((Object)n, (String)"getCommitId(...)");
                                    this.$result.add(((Number)n).intValue());
                                }
                                return this.$result.size() < 10;
                            }
                        }));
                        if (rootsToCheck.isEmpty()) break;
                    }
                }
                if (node == n) break;
                node += n2;
            }
        }
        return (Set)result2;
    }

    @NotNull
    public final Set<Integer> pickIndexedCommits(@NotNull DataPack $this$pickIndexedCommits, @NotNull IndexDataGetter dataGetter, @NotNull Collection<? extends VirtualFile> roots) {
        Intrinsics.checkNotNullParameter((Object)$this$pickIndexedCommits, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)dataGetter, (String)"dataGetter");
        Intrinsics.checkNotNullParameter(roots, (String)"roots");
        if (roots.isEmpty()) {
            return SetsKt.emptySet();
        }
        IntOpenHashSet result2 = new IntOpenHashSet();
        PermanentGraph<Integer> permanentGraph = $this$pickIndexedCommits.getPermanentGraph();
        PermanentGraphInfo permanentGraphInfo = permanentGraph instanceof PermanentGraphInfo ? (PermanentGraphInfo)permanentGraph : null;
        if (permanentGraphInfo == null) {
            return SetsKt.emptySet();
        }
        PermanentGraphInfo permanentGraphInfo2 = permanentGraphInfo;
        for (int i = 0; i < 10; ++i) {
            CommitId root;
            int node = i * (permanentGraphInfo2.getLinearGraph().nodesCount() / 10);
            if (permanentGraphInfo2.getLinearGraph().getAdjacentEdges(node, EdgeFilter.NORMAL_DOWN).size() != 1) continue;
            Integer commit = (Integer)permanentGraphInfo2.getPermanentCommitsInfo().getCommitId(node);
            VcsLogStorageBackend vcsLogStorageBackend = dataGetter.getIndexStorageBackend();
            Intrinsics.checkNotNull((Object)commit);
            if (!vcsLogStorageBackend.containsCommit(commit)) continue;
            CommitId commitId2 = dataGetter.getLogStorage().getCommitId(commit);
            if (commitId2 == null) continue;
            if ((commitId2 = commitId2.getRoot()) == null || !roots.contains(root = commitId2)) continue;
            result2.add(commit.intValue());
        }
        if (result2.size() >= 10) {
            return (Set)result2;
        }
        dataGetter.iterateIndexedCommits(5000, arg_0 -> IndexDiagnostic.pickIndexedCommits$lambda$6(permanentGraphInfo2, dataGetter, roots, result2, arg_0));
        return (Set)result2;
    }

    private static final Boolean pickIndexedCommits$lambda$6(PermanentGraphInfo $permanentGraphInfo, IndexDataGetter $dataGetter, Collection $roots, IntOpenHashSet $result, int commit) {
        Intrinsics.checkNotNullParameter((Object)$permanentGraphInfo, (String)"$permanentGraphInfo");
        Intrinsics.checkNotNullParameter((Object)$dataGetter, (String)"$dataGetter");
        Intrinsics.checkNotNullParameter((Object)$roots, (String)"$roots");
        Intrinsics.checkNotNullParameter((Object)$result, (String)"$result");
        int node = $permanentGraphInfo.getPermanentCommitsInfo().getNodeId(commit);
        if (node >= 0 && $permanentGraphInfo.getLinearGraph().getAdjacentEdges(node, EdgeFilter.NORMAL_DOWN).size() == 1) {
            VirtualFile root;
            CommitId commitId2 = $dataGetter.getLogStorage().getCommitId(commit);
            Object object = root = commitId2 != null ? commitId2.getRoot() : null;
            if (root != null && $roots.contains(root)) {
                $result.add(commit);
            }
        }
        return $result.size() < 10;
    }
}

