/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graph.impl.facade;

import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.graph.GraphCommit;
import com.intellij.vcs.log.graph.GraphCommitImpl;
import com.intellij.vcs.log.graph.api.GraphLayout;
import com.intellij.vcs.log.graph.api.LinearGraph;
import com.intellij.vcs.log.graph.api.LiteLinearGraph;
import com.intellij.vcs.log.graph.api.permanent.PermanentCommitsInfo;
import com.intellij.vcs.log.graph.api.permanent.PermanentGraphInfo;
import com.intellij.vcs.log.graph.impl.permanent.GraphLayoutImpl;
import com.intellij.vcs.log.graph.impl.permanent.PermanentCommitsInfoImpl;
import com.intellij.vcs.log.graph.impl.permanent.PermanentLinearGraphBuilder;
import com.intellij.vcs.log.graph.impl.permanent.PermanentLinearGraphImpl;
import com.intellij.vcs.log.graph.utils.LinearGraphUtils;
import com.intellij.vcs.log.graph.utils.TimestampGetter;
import com.intellij.vcs.log.graph.utils.impl.CompressedIntList;
import com.intellij.vcs.log.graph.utils.impl.IntTimestampGetter;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;

public final class SimpleGraphInfo<CommitId>
implements PermanentGraphInfo<CommitId> {
    @NotNull
    private final LinearGraph myLinearGraph;
    @NotNull
    private final GraphLayout myGraphLayout;
    @NotNull
    private final @NotNull Function<? super Integer, ? extends @NotNull CommitId> myFunction;
    @NotNull
    private final TimestampGetter myTimestampGetter;
    @NotNull
    private final Set<Integer> myBranchNodeIds;

    private SimpleGraphInfo(@NotNull LinearGraph linearGraph, @NotNull GraphLayout graphLayout, @NotNull @NotNull Function<? super Integer, ? extends @NotNull CommitId> function, @NotNull TimestampGetter timestampGetter, @NotNull Set<Integer> branchNodeIds) {
        if (linearGraph == null) {
            SimpleGraphInfo.$$$reportNull$$$0(0);
        }
        if (graphLayout == null) {
            SimpleGraphInfo.$$$reportNull$$$0(1);
        }
        if (function == null) {
            SimpleGraphInfo.$$$reportNull$$$0(2);
        }
        if (timestampGetter == null) {
            SimpleGraphInfo.$$$reportNull$$$0(3);
        }
        if (branchNodeIds == null) {
            SimpleGraphInfo.$$$reportNull$$$0(4);
        }
        this.myLinearGraph = linearGraph;
        this.myGraphLayout = graphLayout;
        this.myFunction = function;
        this.myTimestampGetter = timestampGetter;
        this.myBranchNodeIds = branchNodeIds;
    }

    public static <CommitId> SimpleGraphInfo<CommitId> build(@NotNull LinearGraph linearGraph, @NotNull GraphLayout oldLayout, @NotNull PermanentCommitsInfo<CommitId> permanentCommitsInfo, int permanentGraphSize, @NotNull Set<Integer> branchNodeIds, int visibleRow, int visibleRange) {
        if (linearGraph == null) {
            SimpleGraphInfo.$$$reportNull$$$0(5);
        }
        if (oldLayout == null) {
            SimpleGraphInfo.$$$reportNull$$$0(6);
        }
        if (permanentCommitsInfo == null) {
            SimpleGraphInfo.$$$reportNull$$$0(7);
        }
        if (branchNodeIds == null) {
            SimpleGraphInfo.$$$reportNull$$$0(8);
        }
        int start2 = Math.max(0, visibleRow - visibleRange);
        int end = Math.min(linearGraph.nodesCount(), start2 + 2 * visibleRange);
        ArrayList<GraphCommit<CommitId>> graphCommits = new ArrayList<GraphCommit<CommitId>>(end - start2);
        ArrayList<CommitId> commitsIdMap = new ArrayList<CommitId>(end - start2);
        for (int row2 = start2; row2 < end; ++row2) {
            int nodeId = linearGraph.getNodeId(row2);
            CommitId commit = permanentCommitsInfo.getCommitId(nodeId);
            SmartList parents = new SmartList();
            parents.addAll(ContainerUtil.mapNotNull(LinearGraphUtils.asLiteLinearGraph(linearGraph).getNodes(row2, LiteLinearGraph.NodeFilter.DOWN), row1 -> {
                if (row1 < start2 || row1 >= end) {
                    return null;
                }
                return permanentCommitsInfo.getCommitId(linearGraph.getNodeId((int)row1));
            }));
            graphCommits.add(GraphCommitImpl.createCommit(commit, parents, permanentCommitsInfo.getTimestamp(nodeId)));
            commitsIdMap.add(commit);
        }
        IntTimestampGetter timestampGetter = PermanentCommitsInfoImpl.createTimestampGetter(graphCommits);
        Function<Integer, @NotNull E> commitIdMapping = SimpleGraphInfo.createCommitIdMapFunction(commitsIdMap);
        PermanentLinearGraphImpl newLinearGraph = PermanentLinearGraphBuilder.newInstance(graphCommits).build();
        int[] layoutIndexes = new int[end - start2];
        IntArrayList headNodeIndexes = new IntArrayList();
        Object2IntMap<CommitId> commitIdToInteger = SimpleGraphInfo.reverseCommitIdMap(permanentCommitsInfo, permanentGraphSize);
        for (int row3 = start2; row3 < end; ++row3) {
            int layoutIndex;
            Object commitId2 = commitsIdMap.get(row3 - start2);
            layoutIndexes[row3 - start2] = layoutIndex = oldLayout.getLayoutIndex(commitIdToInteger.getInt(commitId2));
            if (!LinearGraphUtils.asLiteLinearGraph(newLinearGraph).getNodes(row3 - start2, LiteLinearGraph.NodeFilter.UP).isEmpty()) continue;
            headNodeIndexes.add(row3 - start2);
        }
        ContainerUtil.sort((List)headNodeIndexes, Comparator.comparingInt(o -> layoutIndexes[o]));
        GraphLayoutImpl newLayout = new GraphLayoutImpl(layoutIndexes, (IntList)headNodeIndexes);
        return new SimpleGraphInfo(newLinearGraph, newLayout, commitIdMapping, timestampGetter, LinearGraphUtils.convertIdsToNodeIndexes(linearGraph, branchNodeIds));
    }

    @NotNull
    private static <CommitId> @NotNull Function<Integer, @NotNull CommitId> createCommitIdMapFunction(@NotNull List<? extends CommitId> commitsIdMap) {
        if (commitsIdMap == null) {
            SimpleGraphInfo.$$$reportNull$$$0(9);
        }
        if (!commitsIdMap.isEmpty() && commitsIdMap.get(0) instanceof Integer) {
            int[] ints = new int[commitsIdMap.size()];
            for (int row2 = 0; row2 < commitsIdMap.size(); ++row2) {
                ints[row2] = (Integer)commitsIdMap.get(row2);
            }
            return new IntegerCommitIdMapFunction(CompressedIntList.newInstance(ints));
        }
        return new CommitIdMapFunction<CommitId>(commitsIdMap);
    }

    @NotNull
    private static <CommitId> Object2IntMap<CommitId> reverseCommitIdMap(@NotNull PermanentCommitsInfo<CommitId> permanentCommitsInfo, int size) {
        if (permanentCommitsInfo == null) {
            SimpleGraphInfo.$$$reportNull$$$0(10);
        }
        Object2IntOpenHashMap result2 = new Object2IntOpenHashMap();
        for (int i = 0; i < size; ++i) {
            result2.put(permanentCommitsInfo.getCommitId(i), i);
        }
        Object2IntOpenHashMap object2IntOpenHashMap = result2;
        if (object2IntOpenHashMap == null) {
            SimpleGraphInfo.$$$reportNull$$$0(11);
        }
        return object2IntOpenHashMap;
    }

    @Override
    @NotNull
    public PermanentCommitsInfo<CommitId> getPermanentCommitsInfo() {
        return new PermanentCommitsInfo<CommitId>(){

            @Override
            @NotNull
            public CommitId getCommitId(int nodeId) {
                Object CommitId = SimpleGraphInfo.this.myFunction.apply(nodeId);
                if (CommitId == null) {
                    1.$$$reportNull$$$0(0);
                }
                return CommitId;
            }

            @Override
            public long getTimestamp(int nodeId) {
                return SimpleGraphInfo.this.myTimestampGetter.getTimestamp(nodeId);
            }

            @Override
            public int getNodeId(@NotNull CommitId commitId2) {
                if (commitId2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                for (int id = 0; id < SimpleGraphInfo.this.myLinearGraph.nodesCount(); ++id) {
                    if (!SimpleGraphInfo.this.myFunction.apply(id).equals(commitId2)) continue;
                    return id;
                }
                return -1;
            }

            @Override
            @NotNull
            public Set<Integer> convertToNodeIds(@NotNull Collection<? extends CommitId> commitIds) {
                if (commitIds == null) {
                    1.$$$reportNull$$$0(2);
                }
                HashSet<Integer> result2 = new HashSet<Integer>();
                for (int id = 0; id < SimpleGraphInfo.this.myLinearGraph.nodesCount(); ++id) {
                    if (!commitIds.contains(SimpleGraphInfo.this.myFunction.apply(id))) continue;
                    result2.add(id);
                }
                HashSet<Integer> hashSet = result2;
                if (hashSet == null) {
                    1.$$$reportNull$$$0(3);
                }
                return hashSet;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 2;
                    case 1, 2 -> 3;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/vcs/log/graph/impl/facade/SimpleGraphInfo$1";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "commitId";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "commitIds";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getCommitId";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/vcs/log/graph/impl/facade/SimpleGraphInfo$1";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "convertToNodeIds";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "getNodeId";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "convertToNodeIds";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalStateException(string);
                    case 1, 2 -> new IllegalArgumentException(string);
                };
            }
        };
    }

    @Override
    @NotNull
    public LinearGraph getLinearGraph() {
        LinearGraph linearGraph = this.myLinearGraph;
        if (linearGraph == null) {
            SimpleGraphInfo.$$$reportNull$$$0(12);
        }
        return linearGraph;
    }

    @Override
    @NotNull
    public GraphLayout getPermanentGraphLayout() {
        GraphLayout graphLayout = this.myGraphLayout;
        if (graphLayout == null) {
            SimpleGraphInfo.$$$reportNull$$$0(13);
        }
        return graphLayout;
    }

    @Override
    @NotNull
    public Set<Integer> getBranchNodeIds() {
        Set<Integer> set = this.myBranchNodeIds;
        if (set == null) {
            SimpleGraphInfo.$$$reportNull$$$0(14);
        }
        return set;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 11, 12, 13, 14 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "linearGraph";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "graphLayout";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "timestampGetter";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "branchNodeIds";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldLayout";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "permanentCommitsInfo";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commitsIdMap";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/graph/impl/facade/SimpleGraphInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/graph/impl/facade/SimpleGraphInfo";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "reverseCommitIdMap";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getLinearGraph";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getPermanentGraphLayout";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getBranchNodeIds";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "build";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createCommitIdMapFunction";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "reverseCommitIdMap";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 11, 12, 13, 14 -> new IllegalStateException(string);
        };
    }

    private static final class IntegerCommitIdMapFunction
    implements Function<Integer, Integer> {
        private final com.intellij.vcs.log.graph.utils.IntList myCommitsIdMap;

        IntegerCommitIdMapFunction(com.intellij.vcs.log.graph.utils.IntList commitsIdMap) {
            this.myCommitsIdMap = commitsIdMap;
        }

        @Override
        @NotNull
        public Integer apply(Integer dom) {
            Integer n = this.myCommitsIdMap.get(dom);
            if (n == null) {
                IntegerCommitIdMapFunction.$$$reportNull$$$0(0);
            }
            return n;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/facade/SimpleGraphInfo$IntegerCommitIdMapFunction", "apply"));
        }
    }

    private static final class CommitIdMapFunction<CommitId>
    implements Function<Integer, CommitId> {
        private final List<? extends CommitId> myCommitsIdMap;

        CommitIdMapFunction(List<? extends CommitId> commitsIdMap) {
            this.myCommitsIdMap = commitsIdMap;
        }

        @Override
        @NotNull
        public CommitId apply(Integer dom) {
            CommitId CommitId = this.myCommitsIdMap.get(dom);
            if (CommitId == null) {
                CommitIdMapFunction.$$$reportNull$$$0(0);
            }
            return CommitId;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/facade/SimpleGraphInfo$CommitIdMapFunction", "apply"));
        }
    }
}

