/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graph.impl.permanent;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.vcs.log.graph.api.LinearGraph;
import com.intellij.vcs.log.graph.impl.permanent.GraphLayoutImpl;
import com.intellij.vcs.log.graph.utils.DfsUtilKt;
import com.intellij.vcs.log.graph.utils.LinearGraphUtils;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntComparator;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\b\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\rH\u0002J&\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u0011\u0010\u0011\u001a\u00020\r*\u00020\tH\u0000\u00a2\u0006\u0002\b\u0012J\u0014\u0010\u0013\u001a\u00020\r*\u00020\r2\u0006\u0010\n\u001a\u00020\u000bH\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/vcs/log/graph/impl/permanent/GraphLayoutBuilder;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "build", "Lcom/intellij/vcs/log/graph/impl/permanent/GraphLayoutImpl;", "graph", "Lcom/intellij/vcs/log/graph/api/LinearGraph;", "comparator", "Lit/unimi/dsi/fastutil/ints/IntComparator;", "sortedHeads", "Lit/unimi/dsi/fastutil/ints/IntList;", "branches", "", "", "getHeads", "getHeads$intellij_platform_vcs_log_graph_impl", "sortCatching", "intellij.platform.vcs.log.graph.impl"})
public final class GraphLayoutBuilder {
    @NotNull
    public static final GraphLayoutBuilder INSTANCE = new GraphLayoutBuilder();
    @NotNull
    private static final Logger LOG;

    private GraphLayoutBuilder() {
    }

    @JvmStatic
    @NotNull
    public static final GraphLayoutImpl build(@NotNull LinearGraph graph, @NotNull IntComparator comparator2) {
        Intrinsics.checkNotNullParameter((Object)graph, (String)"graph");
        Intrinsics.checkNotNullParameter((Object)comparator2, (String)"comparator");
        return GraphLayoutBuilder.build(graph, SetsKt.emptySet(), comparator2);
    }

    @JvmStatic
    @NotNull
    public static final GraphLayoutImpl build(@NotNull LinearGraph graph, @NotNull Set<Integer> branches, @NotNull IntComparator comparator2) {
        Intrinsics.checkNotNullParameter((Object)graph, (String)"graph");
        Intrinsics.checkNotNullParameter(branches, (String)"branches");
        Intrinsics.checkNotNullParameter((Object)comparator2, (String)"comparator");
        Set allHeads = SetsKt.plus(branches, (Iterable)((Iterable)INSTANCE.getHeads$intellij_platform_vcs_log_graph_impl(graph)));
        IntList sortedHeads = INSTANCE.sortCatching((IntList)new IntArrayList((Collection)allHeads), comparator2);
        return INSTANCE.build(graph, sortedHeads);
    }

    private final IntList sortCatching(IntList $this$sortCatching, IntComparator comparator2) {
        try {
            $this$sortCatching.sort(comparator2);
        }
        catch (ProcessCanceledException pce) {
            throw pce;
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
        return $this$sortCatching;
    }

    @NotNull
    public final IntList getHeads$intellij_platform_vcs_log_graph_impl(@NotNull LinearGraph $this$getHeads) {
        Intrinsics.checkNotNullParameter((Object)$this$getHeads, (String)"<this>");
        IntArrayList heads = new IntArrayList();
        int n = $this$getHeads.nodesCount();
        for (int i = 0; i < n; ++i) {
            if (!LinearGraphUtils.getUpNodes($this$getHeads, i).isEmpty()) continue;
            heads.add(i);
        }
        return (IntList)heads;
    }

    private final GraphLayoutImpl build(LinearGraph graph, IntList sortedHeads) {
        int[] layoutIndex = new int[graph.nodesCount()];
        IntArrayList importantHeads = new IntArrayList();
        Ref.IntRef currentLayoutIndex = new Ref.IntRef();
        currentLayoutIndex.element = 1;
        int n = sortedHeads.size();
        for (int i = 0; i < n; ++i) {
            int head = sortedHeads.getInt(i);
            if (layoutIndex[head] != 0) continue;
            importantHeads.add(head);
            DfsUtilKt.walk(head, (Function1<? super Integer, Integer>)((Function1)new Function1<Integer, Integer>(layoutIndex, currentLayoutIndex, graph){
                final /* synthetic */ int[] $layoutIndex;
                final /* synthetic */ Ref.IntRef $currentLayoutIndex;
                final /* synthetic */ LinearGraph $graph;
                {
                    this.$layoutIndex = $layoutIndex;
                    this.$currentLayoutIndex = $currentLayoutIndex;
                    this.$graph = $graph;
                    super(1);
                }

                /*
                 * WARNING - void declaration
                 */
                @NotNull
                public final Integer invoke(int currentNode) {
                    Object v2;
                    boolean firstVisit;
                    block4: {
                        void $this$firstOrNull$iv;
                        boolean bl = firstVisit = this.$layoutIndex[currentNode] == 0;
                        if (firstVisit) {
                            this.$layoutIndex[currentNode] = this.$currentLayoutIndex.element;
                        }
                        List<Integer> list = LinearGraphUtils.getDownNodes(this.$graph, currentNode);
                        Intrinsics.checkNotNullExpressionValue(list, (String)"getDownNodes(...)");
                        Iterable iterable = list;
                        int[] nArray = this.$layoutIndex;
                        boolean $i$f$firstOrNull = false;
                        for (T element$iv : $this$firstOrNull$iv) {
                            Integer it = (Integer)element$iv;
                            boolean bl2 = false;
                            Intrinsics.checkNotNull((Object)it);
                            if (!(nArray[it] == 0)) continue;
                            v2 = element$iv;
                            break block4;
                        }
                        v2 = null;
                    }
                    Integer childWithoutLayoutIndex = v2;
                    if (childWithoutLayoutIndex == null) {
                        if (firstVisit) {
                            int n = this.$currentLayoutIndex.element;
                            this.$currentLayoutIndex.element = n + 1;
                        }
                        return -1;
                    }
                    return childWithoutLayoutIndex;
                }
            }));
        }
        return new GraphLayoutImpl(layoutIndex, (IntList)importantHeads);
    }

    static {
        Logger logger = Logger.getInstance(GraphLayoutBuilder.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }
}

