/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.actions;

import com.intellij.icons.AllIcons;
import com.intellij.ide.HelpTooltip;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcs.log.VcsLogBundle;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.data.index.VcsLogIndex;
import com.intellij.vcs.log.data.index.VcsLogIndexUtils;
import com.intellij.vcs.log.data.index.VcsLogModifiableIndex;
import com.intellij.vcs.log.data.index.VcsLogPersistentIndex;
import com.intellij.vcs.log.impl.VcsLogIndexer;
import com.intellij.vcs.log.impl.VcsProjectLog;
import com.intellij.vcs.log.statistics.VcsLogUsageTriggerCollector;
import com.intellij.vcs.log.ui.VcsLogInternalDataKeys;
import com.intellij.vcs.log.ui.actions.ResumeIndexingAction;
import com.intellij.vcs.log.util.VcsLogUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0016J\u0016\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0002J\u0010\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006\u0010"}, d2={"Lcom/intellij/vcs/log/ui/actions/ResumeIndexingAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "getText", "", "repositories", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "update", "updateHelpTooltip", "intellij.platform.vcs.log.impl"})
@SourceDebugExtension(value={"SMAP\nResumeIndexingAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ResumeIndexingAction.kt\ncom/intellij/vcs/log/ui/actions/ResumeIndexingAction\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,101:1\n59#2:102\n1549#3:103\n1620#3,3:104\n766#3:107\n857#3,2:108\n766#3:110\n857#3,2:111\n1549#3:113\n1620#3,3:114\n1549#3:117\n1620#3,3:118\n*S KotlinDebug\n*F\n+ 1 ResumeIndexingAction.kt\ncom/intellij/vcs/log/ui/actions/ResumeIndexingAction\n*L\n28#1:102\n41#1:103\n41#1:104,3\n55#1:107\n55#1:108,2\n56#1:110\n56#1:111,2\n59#1:113\n59#1:114,3\n84#1:117\n84#1:118,3\n*E\n"})
public final class ResumeIndexingAction
extends DumbAwareAction {
    /*
     * WARNING - void declaration
     */
    public void update(@NotNull AnActionEvent e) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable $this$filterTo$iv$iv;
        void $this$filterTo$iv$iv2;
        VcsLogModifiableIndex index;
        VcsLogData data;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        if (project == null) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        VcsLogData vcsLogData = (VcsLogData)e.getData(VcsLogInternalDataKeys.LOG_DATA);
        if (vcsLogData == null) {
            ComponentManager $this$serviceIfCreated$iv = (ComponentManager)project;
            boolean $i$f$serviceIfCreated = false;
            VcsProjectLog vcsProjectLog = (VcsProjectLog)$this$serviceIfCreated$iv.getServiceIfCreated(VcsProjectLog.class);
            vcsLogData = vcsProjectLog != null ? vcsProjectLog.getDataManager() : null;
        }
        VcsLogData vcsLogData2 = data = vcsLogData;
        VcsLogIndex vcsLogIndex = vcsLogData2 != null ? vcsLogData2.getIndex() : null;
        VcsLogModifiableIndex vcsLogModifiableIndex = index = vcsLogIndex instanceof VcsLogModifiableIndex ? (VcsLogModifiableIndex)vcsLogIndex : null;
        if (data == null || index == null || !VcsLogUtil.isProjectLog(project, data.getLogProviders())) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        if (!VcsLogIndexUtils.isIndexingEnabled(project)) {
            void $this$mapTo$iv$iv2;
            void $this$map$iv2;
            Map<VirtualFile, VcsLogIndexer> map = VcsLogPersistentIndex.getAvailableIndexers(data.getLogProviders());
            Intrinsics.checkNotNullExpressionValue(map, (String)"getAvailableIndexers(...)");
            Map<VirtualFile, VcsLogIndexer> availableIndexers = map;
            if (availableIndexers.isEmpty()) {
                e.getPresentation().setEnabledAndVisible(false);
                return;
            }
            Iterable iterable = availableIndexers.keySet();
            Project project2 = project;
            boolean $i$f$map = false;
            void var10_20 = $this$map$iv2;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                void it;
                VirtualFile virtualFile = (VirtualFile)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(data.getLogProvider((VirtualFile)it));
            }
            String string = VcsLogUtil.getVcsDisplayName(project2, (List)destination$iv$iv);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getVcsDisplayName(...)");
            String vcsDisplayName = string;
            Object[] $i$f$serviceIfCreated = new Object[]{vcsDisplayName};
            e.getPresentation().setText(VcsLogBundle.message("action.title.enable.indexing", $i$f$serviceIfCreated));
            $i$f$serviceIfCreated = new Object[]{vcsDisplayName};
            e.getPresentation().setDescription(VcsLogBundle.message("action.description.was.disabled", $i$f$serviceIfCreated));
            e.getPresentation().setIcon(AllIcons.Process.ProgressResumeSmall);
            this.updateHelpTooltip(e);
            return;
        }
        Set<VirtualFile> set = index.getIndexingRoots();
        Intrinsics.checkNotNullExpressionValue(set, (String)"getIndexingRoots(...)");
        Set<VirtualFile> rootsForIndexing = set;
        if (rootsForIndexing.isEmpty()) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        Iterable $this$filter$iv = rootsForIndexing;
        boolean $i$f$filter = false;
        Iterable $i$f$map = $this$filter$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv2) {
            VirtualFile it = (VirtualFile)element$iv$iv;
            boolean bl = false;
            VcsLogIndex vcsLogIndex2 = data.getIndex();
            Intrinsics.checkNotNullExpressionValue((Object)vcsLogIndex2, (String)"getIndex(...)");
            Intrinsics.checkNotNull((Object)it);
            if (!VcsLogIndexUtils.isScheduledForIndexing(vcsLogIndex2, it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List rootsScheduledForIndexing = (List)destination$iv$iv;
        Iterable $this$filter$iv2 = rootsForIndexing;
        boolean $i$f$filter2 = false;
        destination$iv$iv = $this$filter$iv2;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo22 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            VirtualFile it = (VirtualFile)element$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            if (!VcsLogIndexUtils.isIndexingPausedFor(it)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List rootsWithPausedIndexing = (List)destination$iv$iv2;
        e.getPresentation().setEnabledAndVisible(!((Collection)rootsWithPausedIndexing).isEmpty() || !((Collection)rootsScheduledForIndexing).isEmpty());
        $this$filterTo$iv$iv = rootsForIndexing;
        Project project3 = project;
        boolean $i$f$map2 = false;
        void $i$f$filterTo22 = $this$map$iv;
        Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            VirtualFile virtualFile = (VirtualFile)item$iv$iv;
            Collection collection = destination$iv$iv3;
            boolean bl = false;
            collection.add(data.getLogProvider((VirtualFile)it));
        }
        String string = VcsLogUtil.getVcsDisplayName(project3, (List)destination$iv$iv3);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getVcsDisplayName(...)");
        String vcsDisplayName = string;
        if (!((Collection)rootsScheduledForIndexing).isEmpty()) {
            Object[] objectArray = new Object[]{vcsDisplayName};
            e.getPresentation().setText(VcsLogBundle.message("action.title.pause.indexing", objectArray));
            objectArray = new Object[]{this.getText(rootsScheduledForIndexing)};
            e.getPresentation().setDescription(VcsLogBundle.message("action.description.is.scheduled", objectArray));
            e.getPresentation().setIcon(AllIcons.Process.ProgressPauseSmall);
        } else {
            Object[] objectArray = new Object[]{vcsDisplayName};
            e.getPresentation().setText(VcsLogBundle.message("action.title.resume.indexing", objectArray));
            objectArray = new Object[]{this.getText(rootsWithPausedIndexing)};
            e.getPresentation().setDescription(VcsLogBundle.message("action.description.was.paused", objectArray));
            e.getPresentation().setIcon(AllIcons.Process.ProgressResumeSmall);
        }
        this.updateHelpTooltip(e);
    }

    /*
     * WARNING - void declaration
     */
    private final void updateHelpTooltip(AnActionEvent e) {
        void $this$updateHelpTooltip_u24lambda_u244;
        HelpTooltip helpTooltip;
        HelpTooltip helpTooltip2 = helpTooltip = new HelpTooltip();
        Key key = ActionButton.CUSTOM_HELP_TOOLTIP;
        Presentation presentation = e.getPresentation();
        boolean bl = false;
        $this$updateHelpTooltip_u24lambda_u244.setTitle(e.getPresentation().getText());
        $this$updateHelpTooltip_u24lambda_u244.setShortcut(KeymapUtil.getFirstKeyboardShortcutText((AnAction)((AnAction)this)));
        $this$updateHelpTooltip_u24lambda_u244.setDescription(VcsLogBundle.message("action.help.tooltip.resume.indexing", new Object[0]));
        Unit unit = Unit.INSTANCE;
        presentation.putClientProperty(key, (Object)helpTooltip);
    }

    /*
     * WARNING - void declaration
     */
    private final String getText(List<? extends VirtualFile> repositories) {
        void $this$mapTo$iv$iv;
        int repositoriesLimit = 3;
        Iterable $this$map$iv = repositories;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            VirtualFile virtualFile = (VirtualFile)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getName());
        }
        String result2 = CollectionsKt.joinToString$default((Iterable)CollectionsKt.take((Iterable)CollectionsKt.sorted((Iterable)((List)destination$iv$iv)), (int)repositoriesLimit), (CharSequence)", ", null, null, (int)0, null, (Function1)getText.result.2.INSTANCE, (int)30, null);
        if (repositories.size() > repositoriesLimit) {
            return result2 + ", ...";
        }
        return result2;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        VcsLogUsageTriggerCollector.triggerUsage(e, (Object)this);
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        VcsLogData vcsLogData = (VcsLogData)e.getData(VcsLogInternalDataKeys.LOG_DATA);
        if (vcsLogData == null && (vcsLogData = VcsProjectLog.Companion.getInstance(project2).getDataManager()) == null) {
            return;
        }
        VcsLogData data = vcsLogData;
        VcsLogIndexUtils.toggleIndexing(data);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }
}

