/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.filter;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcs.log.VcsLogFilter;
import com.intellij.vcs.log.VcsLogFilterCollection;
import com.intellij.vcs.log.VcsLogRootFilter;
import com.intellij.vcs.log.VcsLogStructureFilter;
import com.intellij.vcs.log.impl.MainVcsLogUiProperties;
import com.intellij.vcs.log.ui.filter.FilterModel;
import com.intellij.vcs.log.visible.filters.VcsLogFilterObject;
import com.intellij.vcsUtil.VcsUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.properties.ReadWriteProperty;
import kotlin.reflect.KProperty;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u0000 %2\u00020\u0001:\u0001%B%\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\tJ$\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\n\u0010\u001e\u001a\u0006\u0012\u0002\b\u00030\u001f2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!H\u0014J\u0018\u0010#\u001a\n\u0012\u0004\u0012\u00020\"\u0018\u00010!2\u0006\u0010$\u001a\u00020\u001dH\u0014R/\u0010\f\u001a\u0004\u0018\u00010\u000b2\b\u0010\n\u001a\u0004\u0018\u00010\u000b8F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u0011\u0010\u0012\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R/\u0010\u0016\u001a\u0004\u0018\u00010\u00152\b\u0010\n\u001a\u0004\u0018\u00010\u00158F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u001b\u0010\u0012\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001a\u00a8\u0006&"}, d2={"Lcom/intellij/vcs/log/ui/filter/FileFilterModel;", "Lcom/intellij/vcs/log/ui/filter/FilterModel$MultipleFilterModel;", "roots", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "uiProperties", "Lcom/intellij/vcs/log/impl/MainVcsLogUiProperties;", "filters", "Lcom/intellij/vcs/log/VcsLogFilterCollection;", "(Ljava/util/Set;Lcom/intellij/vcs/log/impl/MainVcsLogUiProperties;Lcom/intellij/vcs/log/VcsLogFilterCollection;)V", "<set-?>", "Lcom/intellij/vcs/log/VcsLogRootFilter;", "rootFilter", "getRootFilter", "()Lcom/intellij/vcs/log/VcsLogRootFilter;", "setRootFilter", "(Lcom/intellij/vcs/log/VcsLogRootFilter;)V", "rootFilter$delegate", "Lkotlin/properties/ReadWriteProperty;", "getRoots", "()Ljava/util/Set;", "Lcom/intellij/vcs/log/VcsLogStructureFilter;", "structureFilter", "getStructureFilter", "()Lcom/intellij/vcs/log/VcsLogStructureFilter;", "setStructureFilter", "(Lcom/intellij/vcs/log/VcsLogStructureFilter;)V", "structureFilter$delegate", "createFilter", "Lcom/intellij/vcs/log/VcsLogFilter;", "key", "Lcom/intellij/vcs/log/VcsLogFilterCollection$FilterKey;", "values", "", "", "getFilterValues", "filter", "Companion", "intellij.platform.vcs.log.impl"})
public final class FileFilterModel
extends FilterModel.MultipleFilterModel {
    @NotNull
    public static final Companion Companion;
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final Set<VirtualFile> roots;
    @NotNull
    private final ReadWriteProperty rootFilter$delegate;
    @NotNull
    private final ReadWriteProperty structureFilter$delegate;
    @NotNull
    private static final String DIR = "dir:";
    @NotNull
    private static final String FILE = "file:";
    @NotNull
    private static final Logger LOG;

    public FileFilterModel(@NotNull Set<? extends VirtualFile> roots, @NotNull MainVcsLogUiProperties uiProperties, @Nullable VcsLogFilterCollection filters) {
        Intrinsics.checkNotNullParameter(roots, (String)"roots");
        Intrinsics.checkNotNullParameter((Object)uiProperties, (String)"uiProperties");
        Object[] objectArray = new VcsLogFilterCollection.FilterKey[]{VcsLogFilterCollection.STRUCTURE_FILTER, VcsLogFilterCollection.ROOT_FILTER};
        super(CollectionsKt.listOf((Object[])objectArray), uiProperties, filters);
        this.roots = roots;
        VcsLogFilterCollection.FilterKey filterKey = VcsLogFilterCollection.ROOT_FILTER;
        Intrinsics.checkNotNullExpressionValue((Object)filterKey, (String)"ROOT_FILTER");
        this.rootFilter$delegate = this.filterProperty(filterKey, true);
        VcsLogFilterCollection.FilterKey filterKey2 = VcsLogFilterCollection.STRUCTURE_FILTER;
        Intrinsics.checkNotNullExpressionValue((Object)filterKey2, (String)"STRUCTURE_FILTER");
        this.structureFilter$delegate = this.filterProperty(filterKey2, true);
    }

    @NotNull
    public final Set<VirtualFile> getRoots() {
        return this.roots;
    }

    @Override
    @Nullable
    protected List<String> getFilterValues(@NotNull VcsLogFilter filter) {
        Intrinsics.checkNotNullParameter((Object)filter, (String)"filter");
        VcsLogFilter vcsLogFilter = filter;
        return vcsLogFilter instanceof VcsLogStructureFilter ? Companion.getStructureFilterValues((VcsLogStructureFilter)filter) : (vcsLogFilter instanceof VcsLogRootFilter ? Companion.getRootFilterValues((VcsLogRootFilter)filter) : null);
    }

    @Override
    @Nullable
    protected VcsLogFilter createFilter(@NotNull VcsLogFilterCollection.FilterKey<?> key, @NotNull List<String> values) {
        VcsLogFilter vcsLogFilter;
        Intrinsics.checkNotNullParameter(key, (String)"key");
        Intrinsics.checkNotNullParameter(values, (String)"values");
        VcsLogFilterCollection.FilterKey<?> filterKey = key;
        if (Intrinsics.areEqual(filterKey, (Object)VcsLogFilterCollection.STRUCTURE_FILTER)) {
            vcsLogFilter = (VcsLogFilter)Companion.createStructureFilter(values);
        } else {
            if (Intrinsics.areEqual(filterKey, (Object)VcsLogFilterCollection.ROOT_FILTER)) {
                List selectedRoots = new ArrayList();
                for (String path : values) {
                    VirtualFile root = LocalFileSystem.getInstance().findFileByPath(path);
                    if (root != null) {
                        if (this.roots.contains(root)) {
                            selectedRoots.add(root);
                            continue;
                        }
                        LOG.warn("Can not find VCS root for filtering " + root);
                        continue;
                    }
                    LOG.warn("Can not filter by root that does not exist " + path);
                }
                if (selectedRoots.isEmpty()) {
                    return null;
                }
                return (VcsLogFilter)VcsLogFilterObject.fromRoots(selectedRoots);
            }
            vcsLogFilter = null;
        }
        return vcsLogFilter;
    }

    @Nullable
    public final VcsLogRootFilter getRootFilter() {
        return (VcsLogRootFilter)this.rootFilter$delegate.getValue((Object)this, $$delegatedProperties[0]);
    }

    public final void setRootFilter(@Nullable VcsLogRootFilter vcsLogRootFilter) {
        this.rootFilter$delegate.setValue((Object)this, $$delegatedProperties[0], (Object)vcsLogRootFilter);
    }

    @Nullable
    public final VcsLogStructureFilter getStructureFilter() {
        return (VcsLogStructureFilter)this.structureFilter$delegate.getValue((Object)this, $$delegatedProperties[1]);
    }

    public final void setStructureFilter(@Nullable VcsLogStructureFilter vcsLogStructureFilter) {
        this.structureFilter$delegate.setValue((Object)this, $$delegatedProperties[1], (Object)vcsLogStructureFilter);
    }

    @JvmStatic
    @NotNull
    public static final List<String> getStructureFilterValues(@NotNull VcsLogStructureFilter filter) {
        return Companion.getStructureFilterValues(filter);
    }

    @JvmStatic
    @NotNull
    public static final VcsLogStructureFilter createStructureFilter(@NotNull List<String> values) {
        return Companion.createStructureFilter(values);
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(FileFilterModel.class, "rootFilter", "getRootFilter()Lcom/intellij/vcs/log/VcsLogRootFilter;", 0))), Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(FileFilterModel.class, "structureFilter", "getStructureFilter()Lcom/intellij/vcs/log/VcsLogStructureFilter;", 0)))};
        $$delegatedProperties = kPropertyArray;
        Companion = new Companion(null);
        Logger logger = Logger.getInstance(FileFilterModel.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\rH\u0007J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0004J\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00040\r2\u0006\u0010\u0012\u001a\u00020\u0013J\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00040\r2\u0006\u0010\u0012\u001a\u00020\u000bH\u0007R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0006\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0007\u001a\u00070\b\u00a2\u0006\u0002\b\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/vcs/log/ui/filter/FileFilterModel$Companion;", "", "()V", "DIR", "", "Lorg/jetbrains/annotations/NonNls;", "FILE", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "createStructureFilter", "Lcom/intellij/vcs/log/VcsLogStructureFilter;", "values", "", "extractPath", "Lcom/intellij/openapi/vcs/FilePath;", "path", "getRootFilterValues", "filter", "Lcom/intellij/vcs/log/VcsLogRootFilter;", "getStructureFilterValues", "intellij.platform.vcs.log.impl"})
    @SourceDebugExtension(value={"SMAP\nFileFilterModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileFilterModel.kt\ncom/intellij/vcs/log/ui/filter/FileFilterModel$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,87:1\n1549#2:88\n1620#2,3:89\n1549#2:92\n1620#2,3:93\n1549#2:96\n1620#2,3:97\n*S KotlinDebug\n*F\n+ 1 FileFilterModel.kt\ncom/intellij/vcs/log/ui/filter/FileFilterModel$Companion\n*L\n64#1:88\n64#1:89,3\n69#1:92\n69#1:93,3\n74#1:96\n74#1:97,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<String> getRootFilterValues(@NotNull VcsLogRootFilter filter) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)filter, (String)"filter");
            Collection collection = filter.getRoots();
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getRoots(...)");
            Iterable $this$map$iv = collection;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                VirtualFile virtualFile = (VirtualFile)item$iv$iv;
                Collection collection2 = destination$iv$iv;
                boolean bl = false;
                collection2.add(it.getPath());
            }
            return (List)destination$iv$iv;
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @NotNull
        public final List<String> getStructureFilterValues(@NotNull VcsLogStructureFilter filter) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)filter, (String)"filter");
            Collection collection = filter.getFiles();
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getFiles(...)");
            Iterable $this$map$iv = collection;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void path;
                FilePath filePath = (FilePath)item$iv$iv;
                Collection collection2 = destination$iv$iv;
                boolean bl = false;
                collection2.add((path.isDirectory() ? FileFilterModel.DIR : FileFilterModel.FILE) + path.getPath());
            }
            return (List)destination$iv$iv;
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @NotNull
        public final VcsLogStructureFilter createStructureFilter(@NotNull List<String> values) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter(values, (String)"values");
            Iterable $this$map$iv = values;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void path;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(Companion.extractPath((String)path));
            }
            return VcsLogFilterObject.fromPaths((List)destination$iv$iv);
        }

        @NotNull
        public final FilePath extractPath(@NotNull String path) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            if (StringsKt.startsWith$default((String)path, (String)FileFilterModel.DIR, (boolean)false, (int)2, null)) {
                String string = path.substring(4);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                FilePath filePath = VcsUtil.getFilePath((String)string, (boolean)true);
                Intrinsics.checkNotNullExpressionValue((Object)filePath, (String)"getFilePath(...)");
                return filePath;
            }
            if (StringsKt.startsWith$default((String)path, (String)FileFilterModel.FILE, (boolean)false, (int)2, null)) {
                String string = path.substring(5);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                FilePath filePath = VcsUtil.getFilePath((String)string, (boolean)false);
                Intrinsics.checkNotNullExpressionValue((Object)filePath, (String)"getFilePath(...)");
                return filePath;
            }
            FilePath filePath = VcsUtil.getFilePath((String)path);
            Intrinsics.checkNotNullExpressionValue((Object)filePath, (String)"getFilePath(...)");
            return filePath;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

