/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger;

import com.intellij.debugger.ExecutionWithDebuggerToolsTestCase;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.util.ConcurrencyUtil;
import java.util.Iterator;
import java.util.concurrent.ThreadPoolExecutor;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.SequenceScope;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u00002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a!\u0010\u0000\u001a\u0002H\u0001\"\u0004\b\u0000\u0010\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u0002H\u00010\u0003H\u0002\u00a2\u0006\u0002\u0010\u0004\u001a@\u0010\u0005\u001a\u00020\u0006*\u00020\u00072/\u0010\b\u001a+\b\u0001\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\f\u0012\u0006\u0012\u0004\u0018\u00010\r0\t\u00a2\u0006\u0002\b\u000e\u00a2\u0006\u0002\u0010\u000f\u001a\u001a\u0010\u0010\u001a\u00020\u0006*\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\nH\u0086@\u00a2\u0006\u0002\u0010\u0011\u00a8\u0006\u0012"}, d2={"logException", "R", "action", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "processBreakpoints", "", "Lcom/intellij/debugger/ExecutionWithDebuggerToolsTestCase;", "test", "Lkotlin/Function2;", "Lkotlin/sequences/SequenceScope;", "", "Lkotlin/coroutines/Continuation;", "", "Lkotlin/ExtensionFunctionType;", "(Lcom/intellij/debugger/ExecutionWithDebuggerToolsTestCase;Lkotlin/jvm/functions/Function2;)V", "waitAndResumeBreakpoint", "(Lkotlin/sequences/SequenceScope;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.java.testFramework"})
public final class DebuggerBreakpointTestUtilsKt {
    public static final void processBreakpoints(@NotNull ExecutionWithDebuggerToolsTestCase $this$processBreakpoints, @NotNull Function2<? super SequenceScope, ? super Continuation<? super Unit>, ? extends Object> test) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$processBreakpoints), (String)"<this>");
        Intrinsics.checkNotNullParameter(test, (String)"test");
        ThreadPoolExecutor threadPoolExecutor = ConcurrencyUtil.newSingleThreadExecutor((String)"DebuggerTestExecutor");
        Intrinsics.checkNotNullExpressionValue((Object)threadPoolExecutor, (String)"newSingleThreadExecutor(...)");
        ThreadPoolExecutor executor = threadPoolExecutor;
        $this$processBreakpoints.getDebugProcess().addProcessListener((ProcessListener)new ProcessAdapter(executor){
            final /* synthetic */ ThreadPoolExecutor $executor;
            {
                this.$executor = $executor;
            }

            public void processTerminated(@NotNull ProcessEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                this.$executor.shutdown();
            }
        });
        Iterator iterator = SequencesKt.iterator(test);
        $this$processBreakpoints.onEveryBreakpoint(arg_0 -> DebuggerBreakpointTestUtilsKt.processBreakpoints$lambda$1($this$processBreakpoints, executor, iterator, arg_0));
        executor.execute(() -> DebuggerBreakpointTestUtilsKt.processBreakpoints$lambda$2(iterator));
    }

    private static final <R> R logException(Function0<? extends R> action) {
        Object object;
        try {
            object = action.invoke();
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            throw ex;
        }
        return (R)object;
    }

    @Nullable
    public static final Object waitAndResumeBreakpoint(@NotNull SequenceScope $this$waitAndResumeBreakpoint, @NotNull Continuation<? super Unit> $completion) {
        Object object = $this$waitAndResumeBreakpoint.yield(null, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    private static final void processBreakpoints$lambda$1$lambda$0(Iterator $iterator) {
        Intrinsics.checkNotNullParameter((Object)$iterator, (String)"$iterator");
        $iterator.next();
        DebuggerBreakpointTestUtilsKt.logException((Function0)new Function0<Unit>($iterator){
            final /* synthetic */ Iterator $iterator;
            {
                this.$iterator = $iterator;
                super(0);
            }

            public final void invoke() {
                this.$iterator.hasNext();
            }
        });
    }

    private static final void processBreakpoints$lambda$1(ExecutionWithDebuggerToolsTestCase $this_processBreakpoints, ThreadPoolExecutor $executor, Iterator $iterator, SuspendContextImpl context2) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this_processBreakpoints), (String)"$this_processBreakpoints");
        Intrinsics.checkNotNullParameter((Object)$executor, (String)"$executor");
        Intrinsics.checkNotNullParameter((Object)$iterator, (String)"$iterator");
        $this_processBreakpoints.resume(context2);
        $executor.execute(() -> DebuggerBreakpointTestUtilsKt.processBreakpoints$lambda$1$lambda$0($iterator));
    }

    private static final void processBreakpoints$lambda$2(Iterator $iterator) {
        Intrinsics.checkNotNullParameter((Object)$iterator, (String)"$iterator");
        DebuggerBreakpointTestUtilsKt.logException((Function0)new Function0<Unit>($iterator){
            final /* synthetic */ Iterator $iterator;
            {
                this.$iterator = $iterator;
                super(0);
            }

            public final void invoke() {
                this.$iterator.hasNext();
            }
        });
    }
}

