/*
 * Decompiled with CFR 0.152.
 */
package org.editorconfig.configmanagement.editor;

import com.intellij.application.options.CodeStyle;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighterFactory;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.impl.text.PsiAwareTextEditorProvider;
import com.intellij.openapi.fileEditor.impl.text.TextEditorProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.codeStyle.CodeStyleSettingsListener;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.LanguageCodeStyleSettingsProvider;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.editorconfig.configmanagement.editor.EditorBuilderState;
import org.editorconfig.configmanagement.editor.EditorConfigEditorProvider;
import org.editorconfig.configmanagement.editor.EditorConfigEditorWithPreview;
import org.editorconfig.configmanagement.editor.EditorConfigPreviewFile;
import org.editorconfig.configmanagement.editor.EditorConfigPreviewFileEditor;
import org.editorconfig.configmanagement.editor.EditorConfigStatusListener;
import org.editorconfig.settings.EditorConfigSettings;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u00000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a \u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0003\u001a \u0010\n\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u0010\u0010\u000f\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"EDITOR_TYPE_ID", "", "build", "Lcom/intellij/openapi/fileEditor/FileEditor;", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "precomputedState", "Lorg/editorconfig/configmanagement/editor/EditorBuilderState;", "createPreviewEditor", "document", "Lcom/intellij/openapi/editor/Document;", "previewFile", "Lorg/editorconfig/configmanagement/editor/EditorConfigPreviewFile;", "getPreviewText", "intellij.editorconfig"})
public final class EditorConfigEditorProviderKt {
    @NotNull
    private static final String EDITOR_TYPE_ID = "org.editorconfig.configmanagement.editor";

    @RequiresEdt
    private static final FileEditor build(Project project, VirtualFile file, EditorBuilderState precomputedState2) {
        FileEditor result2 = null;
        VirtualFile contextFile = precomputedState2.contextFile;
        if (contextFile != null && ((EditorConfigSettings)CodeStyle.getSettings((Project)project).getCustomSettings(EditorConfigSettings.class)).ENABLED) {
            Document document = EditorFactory.getInstance().createDocument((CharSequence)EditorConfigEditorProviderKt.getPreviewText(contextFile));
            Intrinsics.checkNotNullExpressionValue((Object)document, (String)"createDocument(...)");
            Document document2 = document;
            Disposable disposable = Disposer.newDisposable();
            Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"newDisposable(...)");
            Disposable disposable2 = disposable;
            EditorConfigPreviewFile previewFile = new EditorConfigPreviewFile(project, contextFile, document2, disposable2);
            FileEditor previewEditor = EditorConfigEditorProviderKt.createPreviewEditor(document2, previewFile, project);
            FileEditor fileEditor = TextEditorProvider.Companion.getInstance().createEditor(project, file);
            Intrinsics.checkNotNull((Object)fileEditor, (String)"null cannot be cast to non-null type com.intellij.openapi.fileEditor.TextEditor");
            TextEditor ecTextEditor = (TextEditor)fileEditor;
            result2 = (FileEditor)new EditorConfigEditorWithPreview(file, project, ecTextEditor, previewEditor);
            Disposer.register((Disposable)((Disposable)result2), (Disposable)disposable2);
        } else {
            result2 = new PsiAwareTextEditorProvider().createEditor(project, file);
        }
        EditorConfigStatusListener statusListener = new EditorConfigStatusListener(project, file, precomputedState2.encodings);
        CodeStyleSettingsManager.getInstance((Project)project).subscribe((CodeStyleSettingsListener)statusListener, (Disposable)result2);
        return result2;
    }

    private static final FileEditor createPreviewEditor(Document document, EditorConfigPreviewFile previewFile, Project project) {
        Editor previewEditor = EditorFactory.getInstance().createEditor(document, project);
        if (previewEditor instanceof EditorEx) {
            EditorHighlighter highlighter = EditorHighlighterFactory.Companion.getInstance().createEditorHighlighter(project, (VirtualFile)previewFile);
            ((EditorEx)previewEditor).setHighlighter(highlighter);
        }
        return new EditorConfigPreviewFileEditor(previewEditor, previewFile);
    }

    private static final String getPreviewText(VirtualFile file) {
        String sample;
        LanguageCodeStyleSettingsProvider provider;
        Language language;
        if (file.getLength() <= 10000L) {
            try {
                String string = StringUtil.convertLineSeparators((String)VfsUtilCore.loadText((VirtualFile)file));
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"convertLineSeparators(...)");
                return string;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if ((language = EditorConfigEditorProvider.Companion.getLanguage(file)) != null && (provider = LanguageCodeStyleSettingsProvider.forLanguage((Language)language)) != null && (sample = provider.getCodeSample(LanguageCodeStyleSettingsProvider.SettingsType.INDENT_SETTINGS)) != null) {
            return sample;
        }
        return "No preview";
    }

    public static final /* synthetic */ String access$getPreviewText(VirtualFile file) {
        return EditorConfigEditorProviderKt.getPreviewText(file);
    }

    public static final /* synthetic */ FileEditor access$createPreviewEditor(Document document, EditorConfigPreviewFile previewFile, Project project) {
        return EditorConfigEditorProviderKt.createPreviewEditor(document, previewFile, project);
    }

    public static final /* synthetic */ FileEditor access$build(Project project, VirtualFile file, EditorBuilderState precomputedState2) {
        return EditorConfigEditorProviderKt.build(project, file, precomputedState2);
    }
}

