/*
 * Decompiled with CFR 0.152.
 */
package org.editorconfig.language.codeinsight.actions.intention;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.editorconfig.language.messages.EditorConfigBundle;
import org.editorconfig.language.psi.interfaces.EditorConfigDescribableElement;
import org.editorconfig.language.schema.descriptors.EditorConfigDescriptor;
import org.editorconfig.language.schema.descriptors.impl.EditorConfigConstantDescriptor;
import org.editorconfig.language.schema.descriptors.impl.EditorConfigUnionDescriptor;
import org.editorconfig.language.schema.descriptors.impl.EditorConfigUnsetValueDescriptor;
import org.editorconfig.language.util.EditorConfigPsiTreeUtil;
import org.editorconfig.language.util.EditorConfigTextMatchingUtil;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0014\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0002J\u001a\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\b\u0010\u0011\u001a\u00020\bH\u0016J\u001c\u0010\u0012\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\u0013\u001a\u0004\u0018\u00010\nH\u0002J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0014\u001a\u00020\fH\u0002J\r\u0010\u0015\u001a\u00070\b\u00a2\u0006\u0002\b\u0016H\u0016J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J!\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0096\u0002J \u0010\u001b\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u001c\u001a\u00020\u0004H\u0016\u00a8\u0006\u001d"}, d2={"Lorg/editorconfig/language/codeinsight/actions/intention/EditorConfigInvertValueIntention;", "Lcom/intellij/codeInsight/intention/IntentionAction;", "()V", "constantMatches", "", "descriptor", "Lorg/editorconfig/language/schema/descriptors/EditorConfigDescriptor;", "value", "", "findUnionDescriptor", "Lorg/editorconfig/language/schema/descriptors/impl/EditorConfigUnionDescriptor;", "getDescribableElement", "Lorg/editorconfig/language/psi/interfaces/EditorConfigDescribableElement;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "getFamilyName", "getInvertedValue", "union", "element", "getText", "Lorg/jetbrains/annotations/Nls;", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "isAvailable", "startInWriteAction", "intellij.editorconfig"})
@SourceDebugExtension(value={"SMAP\nEditorConfigInvertValueIntention.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EditorConfigInvertValueIntention.kt\norg/editorconfig/language/codeinsight/actions/intention/EditorConfigInvertValueIntention\n+ 2 EditorConfigPsiTreeUtil.kt\norg/editorconfig/language/util/EditorConfigPsiTreeUtil\n*L\n1#1,70:1\n24#2,2:71\n*S KotlinDebug\n*F\n+ 1 EditorConfigInvertValueIntention.kt\norg/editorconfig/language/codeinsight/actions/intention/EditorConfigInvertValueIntention\n*L\n53#1:71,2\n*E\n"})
public final class EditorConfigInvertValueIntention
implements IntentionAction {
    @NotNull
    public String getText() {
        return EditorConfigBundle.INSTANCE.get("intention.invert-option-value");
    }

    @NotNull
    public String getFamilyName() {
        return EditorConfigBundle.INSTANCE.get("intention.invert-option-value");
    }

    public boolean startInWriteAction() {
        return true;
    }

    public boolean isAvailable(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        EditorConfigDescribableElement editorConfigDescribableElement = this.getDescribableElement(editor, file);
        if (editorConfigDescribableElement == null) {
            return false;
        }
        EditorConfigDescribableElement value = editorConfigDescribableElement;
        return this.getInvertedValue(value) != null;
    }

    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        EditorConfigDescribableElement editorConfigDescribableElement = this.getDescribableElement(editor, file);
        if (editorConfigDescribableElement == null) {
            return;
        }
        EditorConfigDescribableElement optionValue = editorConfigDescribableElement;
        String string = this.getInvertedValue(optionValue);
        if (string == null) {
            return;
        }
        String notValue = string;
        Document document = editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        Document document2 = document;
        TextRange textRange = optionValue.getTextRange();
        document2.replaceString(textRange.getStartOffset(), textRange.getEndOffset(), (CharSequence)notValue);
    }

    private final String getInvertedValue(EditorConfigDescribableElement element) {
        EditorConfigUnionDescriptor descriptor2 = this.findUnionDescriptor(element.getDescriptor(true));
        String string = element.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return this.getInvertedValue(string, descriptor2);
    }

    private final String getInvertedValue(String value, EditorConfigUnionDescriptor union) {
        Object object = union;
        if (!(object != null && (object = ((EditorConfigUnionDescriptor)object).getChildren()) != null ? object.size() == 2 : false)) {
            return null;
        }
        EditorConfigDescriptor first = union.getChildren().get(0);
        EditorConfigDescriptor second = union.getChildren().get(1);
        return this.constantMatches(first, value) ? this.getText(second) : (this.constantMatches(second, value) ? this.getText(first) : null);
    }

    private final EditorConfigDescribableElement getDescribableElement(Editor editor, PsiFile file) {
        EditorConfigDescribableElement editorConfigDescribableElement;
        PsiElement psiElement = EditorConfigPsiTreeUtil.INSTANCE.findIdentifierUnderCaret(editor, file);
        if (psiElement != null) {
            EditorConfigPsiTreeUtil editorConfigPsiTreeUtil = EditorConfigPsiTreeUtil.INSTANCE;
            Class[] stopAt$iv = new Class[]{};
            boolean strict$iv = false;
            boolean $i$f$getParentOfType = false;
            editorConfigDescribableElement = (EditorConfigDescribableElement)PsiTreeUtil.getParentOfType((PsiElement)psiElement, EditorConfigDescribableElement.class, (boolean)strict$iv, (Class[])Arrays.copyOf(stopAt$iv, stopAt$iv.length));
        } else {
            editorConfigDescribableElement = null;
        }
        return editorConfigDescribableElement;
    }

    private final String getText(EditorConfigDescriptor descriptor2) {
        if (!(descriptor2 instanceof EditorConfigConstantDescriptor)) {
            return null;
        }
        return ((EditorConfigConstantDescriptor)descriptor2).getText();
    }

    private final boolean constantMatches(EditorConfigDescriptor descriptor2, String value) {
        if (!(descriptor2 instanceof EditorConfigConstantDescriptor)) {
            return false;
        }
        return EditorConfigTextMatchingUtil.INSTANCE.textMatchesToIgnoreCase(((EditorConfigConstantDescriptor)descriptor2).getText(), (CharSequence)value);
    }

    private final EditorConfigUnionDescriptor findUnionDescriptor(EditorConfigDescriptor descriptor2) {
        if (descriptor2 instanceof EditorConfigUnsetValueDescriptor) {
            return null;
        }
        EditorConfigDescriptor editorConfigDescriptor = descriptor2;
        EditorConfigDescriptor editorConfigDescriptor2 = editorConfigDescriptor != null ? editorConfigDescriptor.getParent() : null;
        return editorConfigDescriptor2 instanceof EditorConfigUnionDescriptor ? (EditorConfigUnionDescriptor)editorConfigDescriptor2 : null;
    }
}

