/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.lvcs.impl.ui;

import com.intellij.diff.chains.DiffRequestProducer;
import com.intellij.diff.impl.DiffEditorViewer;
import com.intellij.diff.impl.DiffRequestProcessor;
import com.intellij.diff.impl.DiffRequestProcessorListener;
import com.intellij.history.integration.LocalHistoryBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.ListSelection;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.EditorTabDiffPreview;
import com.intellij.platform.lvcs.impl.ActivityScope;
import com.intellij.platform.lvcs.impl.ActivityScopeKt;
import com.intellij.platform.lvcs.impl.ActivitySelection;
import com.intellij.platform.lvcs.impl.statistics.LocalHistoryCounter;
import com.intellij.platform.lvcs.impl.ui.ActivityModelListener;
import com.intellij.platform.lvcs.impl.ui.ActivityViewModel;
import com.intellij.platform.lvcs.impl.ui.SingleFileActivityDiffPreviewKt;
import com.intellij.platform.lvcs.impl.ui.SingleFileActivityDiffRequestProcessor;
import com.intellij.util.EventDispatcher;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.awt.Component;
import java.util.EventListener;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u001d\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u00a2\u0006\u0002\b\u0011J\u0018\u0010\u0012\u001a\n\u0012\u0004\u0012\u00020\u0014\u0018\u00010\u00132\u0006\u0010\u0015\u001a\u00020\u0016H\u0014J\b\u0010\u0017\u001a\u00020\u0018H\u0014J\u0017\u0010\u0019\u001a\u00070\u001a\u00a2\u0006\u0002\b\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0018H\u0014J\b\u0010\u001d\u001a\u00020\u0016H\u0016J\b\u0010\u001e\u001a\u00020\u0016H\u0016R!\u0010\t\u001a\u0015\u0012\f\u0012\n \f*\u0004\u0018\u00010\u000b0\u000b0\n\u00a2\u0006\u0002\b\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/intellij/platform/lvcs/impl/ui/SingleFileActivityDiffPreview;", "Lcom/intellij/openapi/vcs/changes/EditorTabDiffPreview;", "project", "Lcom/intellij/openapi/project/Project;", "model", "Lcom/intellij/platform/lvcs/impl/ui/ActivityViewModel;", "disposable", "Lcom/intellij/openapi/Disposable;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/platform/lvcs/impl/ui/ActivityViewModel;Lcom/intellij/openapi/Disposable;)V", "eventDispatcher", "Lcom/intellij/util/EventDispatcher;", "Lcom/intellij/diff/impl/DiffRequestProcessorListener;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "addListener", "", "listener", "addListener$intellij_platform_lvcs_impl", "collectDiffProducers", "Lcom/intellij/openapi/ListSelection;", "Lcom/intellij/diff/chains/DiffRequestProducer;", "selectedOnly", "", "createViewer", "Lcom/intellij/diff/impl/DiffEditorViewer;", "getEditorTabName", "", "Lorg/jetbrains/annotations/Nls;", "processor", "hasContent", "performDiffAction", "Companion", "intellij.platform.lvcs.impl"})
public final class SingleFileActivityDiffPreview
extends EditorTabDiffPreview {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ActivityViewModel model;
    @NotNull
    private final EventDispatcher<DiffRequestProcessorListener> eventDispatcher;
    @NotNull
    public static final String DIFF_PLACE = "ActivityView";

    public SingleFileActivityDiffPreview(@NotNull Project project, @NotNull ActivityViewModel model, @NotNull Disposable disposable) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        super(project);
        this.model = model;
        EventDispatcher eventDispatcher = EventDispatcher.create(DiffRequestProcessorListener.class);
        Intrinsics.checkNotNullExpressionValue((Object)eventDispatcher, (String)"create(...)");
        this.eventDispatcher = eventDispatcher;
        Disposer.register((Disposable)disposable, (Disposable)((Disposable)this));
    }

    public boolean hasContent() {
        return this.model.getSelection$intellij_platform_lvcs_impl() != null;
    }

    @NotNull
    protected DiffEditorViewer createViewer() {
        DiffRequestProcessor diffRequestProcessor;
        DiffRequestProcessor viewer = diffRequestProcessor = Companion.createViewer$intellij_platform_lvcs_impl(this.getProject(), this.model);
        boolean bl = false;
        viewer.addListener(() -> SingleFileActivityDiffPreview.createViewer$lambda$1$lambda$0(this), (Disposable)this);
        return (DiffEditorViewer)diffRequestProcessor;
    }

    @Nullable
    protected ListSelection<DiffRequestProducer> collectDiffProducers(boolean selectedOnly) {
        DiffRequestProducer diffRequestProducer = SingleFileActivityDiffPreviewKt.access$getSingleDiffRequestProducer(this.model);
        if (diffRequestProducer == null) {
            return null;
        }
        DiffRequestProducer diffRequestProducer2 = diffRequestProducer;
        return ListSelection.createSingleton((Object)diffRequestProducer2);
    }

    public boolean performDiffAction() {
        LocalHistoryCounter.INSTANCE.logActionInvoked(LocalHistoryCounter.ActionKind.Diff, this.model.getActivityScope$intellij_platform_lvcs_impl());
        return super.performDiffAction();
    }

    @NotNull
    protected String getEditorTabName(@Nullable DiffEditorViewer processor2) {
        ActivityScope activityScope = this.model.getActivityScope$intellij_platform_lvcs_impl();
        ActivityScope.File file = activityScope instanceof ActivityScope.File ? (ActivityScope.File)activityScope : null;
        return Companion.getDiffTitleFor((FilePath)(file != null ? ActivityScopeKt.getFilePath(file) : null), this.model.getActivityScope$intellij_platform_lvcs_impl());
    }

    public final void addListener$intellij_platform_lvcs_impl(@NotNull DiffRequestProcessorListener listener, @NotNull Disposable disposable) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        this.eventDispatcher.addListener((EventListener)listener, disposable);
    }

    private static final void createViewer$lambda$1$lambda$0(SingleFileActivityDiffPreview this$0) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        ((DiffRequestProcessorListener)this$0.eventDispatcher.getMulticaster()).onViewerChanged();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0000\u00a2\u0006\u0002\b\u000bJ\u001d\u0010\f\u001a\u00070\u0004\u00a2\u0006\u0002\b\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0011R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/platform/lvcs/impl/ui/SingleFileActivityDiffPreview$Companion;", "", "()V", "DIFF_PLACE", "", "createViewer", "Lcom/intellij/diff/impl/DiffRequestProcessor;", "project", "Lcom/intellij/openapi/project/Project;", "model", "Lcom/intellij/platform/lvcs/impl/ui/ActivityViewModel;", "createViewer$intellij_platform_lvcs_impl", "getDiffTitleFor", "Lorg/jetbrains/annotations/Nls;", "filePath", "Lcom/intellij/openapi/vcs/FilePath;", "activityScope", "Lcom/intellij/platform/lvcs/impl/ActivityScope;", "intellij.platform.lvcs.impl"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getDiffTitleFor(@Nullable FilePath filePath, @NotNull ActivityScope activityScope) {
            Intrinsics.checkNotNullParameter((Object)activityScope, (String)"activityScope");
            if (filePath != null) {
                Object[] objectArray = new Object[]{filePath.getName()};
                String string = LocalHistoryBundle.message("activity.diff.tab.title.file", objectArray);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                return string;
            }
            if (Intrinsics.areEqual((Object)activityScope, (Object)ActivityScope.Recent.INSTANCE)) {
                String string = LocalHistoryBundle.message("activity.diff.tab.title.recent", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                return string;
            }
            String string = LocalHistoryBundle.message("activity.diff.tab.title", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }

        @NotNull
        public final DiffRequestProcessor createViewer$intellij_platform_lvcs_impl(@NotNull Project project, @NotNull ActivityViewModel model) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)model, (String)"model");
            SingleFileActivityDiffRequestProcessor processor2 = new SingleFileActivityDiffRequestProcessor(project, model);
            model.addListener(new ActivityModelListener(processor2){
                final /* synthetic */ SingleFileActivityDiffRequestProcessor $processor;
                {
                    this.$processor = $processor;
                }

                public void onSelectionChanged(@Nullable ActivitySelection selection) {
                    this.$processor.updatePreview();
                }
            }, (Disposable)processor2);
            JComponent jComponent = processor2.getComponent();
            Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"<get-component>(...)");
            UiNotifyConnector.Companion.installOn((Component)jComponent, new Activatable(processor2){
                final /* synthetic */ SingleFileActivityDiffRequestProcessor $processor;
                {
                    this.$processor = $processor;
                }

                public void showNotify() {
                    this.$processor.updatePreview();
                }
            });
            return (DiffRequestProcessor)processor2;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

