/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.maven.server.telemetry;

import com.intellij.maven.server.telemetry.MavenFilteringSpanDataCollector;
import com.intellij.maven.server.telemetry.MavenServerOpenTelemetry;
import com.intellij.maven.server.telemetry.MavenSpanDataSerializer;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.api.trace.SpanContext;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.api.trace.TraceFlags;
import io.opentelemetry.api.trace.TraceState;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.api.trace.propagation.W3CTraceContextPropagator;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.ImplicitContextKeyed;
import io.opentelemetry.context.Scope;
import io.opentelemetry.context.propagation.ContextPropagators;
import io.opentelemetry.context.propagation.TextMapPropagator;
import io.opentelemetry.sdk.OpenTelemetrySdk;
import io.opentelemetry.sdk.resources.Resource;
import io.opentelemetry.sdk.trace.SdkTracerProvider;
import io.opentelemetry.sdk.trace.SpanProcessor;
import io.opentelemetry.sdk.trace.data.SpanData;
import io.opentelemetry.sdk.trace.export.BatchSpanProcessor;
import io.opentelemetry.sdk.trace.export.SpanExporter;
import java.io.Closeable;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.server.ParallelRunnerForServer;

final class MavenServerOpenTelemetryImpl
implements MavenServerOpenTelemetry {
    private static final String INSTRUMENTATION_NAME = "MavenServer";
    @NotNull
    private final OpenTelemetry myOpenTelemetry;
    @NotNull
    private final MavenFilteringSpanDataCollector mySpanDataCollector;
    @NotNull
    private final Tracer tracer;
    @NotNull
    private final Span rootSpan;
    @NotNull
    private final Scope myScope;

    MavenServerOpenTelemetryImpl(@NotNull String traceId, @NotNull String parentSpanId) {
        if (traceId == null) {
            MavenServerOpenTelemetryImpl.$$$reportNull$$$0(0);
        }
        if (parentSpanId == null) {
            MavenServerOpenTelemetryImpl.$$$reportNull$$$0(1);
        }
        this.mySpanDataCollector = new MavenFilteringSpanDataCollector();
        this.myOpenTelemetry = OpenTelemetrySdk.builder().setTracerProvider(SdkTracerProvider.builder().addSpanProcessor((SpanProcessor)BatchSpanProcessor.builder((SpanExporter)this.mySpanDataCollector).setMaxExportBatchSize(128).build()).setResource(Resource.create((Attributes)Attributes.of((AttributeKey)AttributeKey.stringKey((String)"service.name"), (Object)INSTRUMENTATION_NAME))).build()).setPropagators(ContextPropagators.create((TextMapPropagator)W3CTraceContextPropagator.getInstance())).build();
        SpanContext parentSpanContext = SpanContext.createFromRemoteParent((String)traceId, (String)parentSpanId, (TraceFlags)TraceFlags.getSampled(), (TraceState)TraceState.getDefault());
        Context context = Context.root().with((ImplicitContextKeyed)Span.wrap((SpanContext)parentSpanContext));
        this.tracer = this.myOpenTelemetry.getTracer(INSTRUMENTATION_NAME);
        this.rootSpan = this.tracer.spanBuilder("MavenServerRootSpan").setParent(context).startSpan();
        this.myScope = this.rootSpan.makeCurrent();
    }

    @NotNull
    public OpenTelemetry getTelemetry() {
        OpenTelemetry openTelemetry = this.myOpenTelemetry;
        if (openTelemetry == null) {
            MavenServerOpenTelemetryImpl.$$$reportNull$$$0(2);
        }
        return openTelemetry;
    }

    @Override
    public <T> T callWithSpan(@NotNull String spanName, @NotNull Supplier<T> fn) {
        if (spanName == null) {
            MavenServerOpenTelemetryImpl.$$$reportNull$$$0(3);
        }
        if (fn == null) {
            MavenServerOpenTelemetryImpl.$$$reportNull$$$0(4);
        }
        SpanBuilder spanBuilder = this.tracer.spanBuilder(spanName);
        Span span = spanBuilder.startSpan();
        try {
            T t;
            block13: {
                Scope ignore = span.makeCurrent();
                try {
                    t = fn.get();
                    if (ignore == null) break block13;
                }
                catch (Throwable throwable) {
                    try {
                        if (ignore != null) {
                            try {
                                ignore.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        span.recordException((Throwable)e);
                        span.setStatus(StatusCode.ERROR);
                        throw e;
                    }
                }
                ignore.close();
            }
            return t;
        }
        finally {
            span.end();
        }
    }

    @Override
    public <T, R> List<R> execute(boolean inParallel, @NotNull Collection<T> collection, @NotNull Function<T, R> method) {
        if (collection == null) {
            MavenServerOpenTelemetryImpl.$$$reportNull$$$0(5);
        }
        if (method == null) {
            MavenServerOpenTelemetryImpl.$$$reportNull$$$0(6);
        }
        Context context = Context.current();
        return ParallelRunnerForServer.execute((boolean)inParallel, collection, (Function)context.wrapFunction(method));
    }

    public <T> T callWithSpan(@NotNull String spanName, @NotNull Function<Span, T> fn) {
        if (spanName == null) {
            MavenServerOpenTelemetryImpl.$$$reportNull$$$0(7);
        }
        if (fn == null) {
            MavenServerOpenTelemetryImpl.$$$reportNull$$$0(8);
        }
        return this.callWithSpan(spanName, ignore -> {}, fn);
    }

    public <T> T callWithSpan(@NotNull String spanName, @NotNull Consumer<SpanBuilder> configurator, @NotNull Function<Span, T> fn) {
        if (spanName == null) {
            MavenServerOpenTelemetryImpl.$$$reportNull$$$0(9);
        }
        if (configurator == null) {
            MavenServerOpenTelemetryImpl.$$$reportNull$$$0(10);
        }
        if (fn == null) {
            MavenServerOpenTelemetryImpl.$$$reportNull$$$0(11);
        }
        SpanBuilder spanBuilder = this.tracer.spanBuilder(spanName);
        configurator.accept(spanBuilder);
        Span span = spanBuilder.startSpan();
        try {
            T t;
            block14: {
                Scope ignore = span.makeCurrent();
                try {
                    t = fn.apply(span);
                    if (ignore == null) break block14;
                }
                catch (Throwable throwable) {
                    try {
                        if (ignore != null) {
                            try {
                                ignore.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        span.recordException((Throwable)e);
                        span.setStatus(StatusCode.ERROR);
                        throw e;
                    }
                }
                ignore.close();
            }
            return t;
        }
        finally {
            span.end();
        }
    }

    public void runWithSpan(@NotNull String spanName, @NotNull Consumer<Span> consumer) {
        if (spanName == null) {
            MavenServerOpenTelemetryImpl.$$$reportNull$$$0(12);
        }
        if (consumer == null) {
            MavenServerOpenTelemetryImpl.$$$reportNull$$$0(13);
        }
        this.callWithSpan(spanName, (Span span) -> {
            consumer.accept((Span)span);
            return null;
        });
    }

    @Override
    public byte[] shutdown() {
        try {
            this.rootSpan.end();
            this.myScope.close();
            if (this.myOpenTelemetry instanceof Closeable) {
                ((Closeable)this.myOpenTelemetry).close();
            }
            Collection<SpanData> collectedSpans = this.mySpanDataCollector.getCollectedSpans();
            return MavenSpanDataSerializer.serialize(collectedSpans);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "traceId";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentSpanId";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/maven/server/telemetry/MavenServerOpenTelemetryImpl";
                break;
            }
            case 3: 
            case 7: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "spanName";
                break;
            }
            case 4: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fn";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collection";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurator";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/maven/server/telemetry/MavenServerOpenTelemetryImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getTelemetry";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "callWithSpan";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "runWithSpan";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

