/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gitlab.ui;

import com.intellij.collaboration.ui.codereview.issues.IssueIdsProcessorKt;
import com.intellij.markdown.utils.CodeFenceSyntaxHighlighterGeneratingProvider;
import com.intellij.markdown.utils.MarkdownToHtmlConverter;
import com.intellij.markdown.utils.lang.CodeBlockHtmlSyntaxHighlighter;
import com.intellij.markdown.utils.lang.HtmlSyntaxHighlighter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.HtmlChunk;
import git4idea.repo.GitRepository;
import java.net.URI;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.intellij.markdown.IElementType;
import org.intellij.markdown.MarkdownElementTypes;
import org.intellij.markdown.MarkdownTokenTypes;
import org.intellij.markdown.ast.ASTNode;
import org.intellij.markdown.ast.ASTUtilKt;
import org.intellij.markdown.flavours.MarkdownFlavourDescriptor;
import org.intellij.markdown.flavours.gfm.GFMFlavourDescriptor;
import org.intellij.markdown.html.GeneratingProvider;
import org.intellij.markdown.html.HtmlGenerator;
import org.intellij.markdown.parser.LinkMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gitlab.util.GitLabProjectPath;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002\u0012\u0013B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J7\u0010\u0006\u001a\u00070\u0004\u00a2\u0006\u0002\b\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u000b\u0010\u000e\u001a\u00070\u0004\u00a2\u0006\u0002\b\u000fH\u0000\u00a2\u0006\u0002\b\u0010J\u0010\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/plugins/gitlab/ui/GitLabUIUtil;", "", "()V", "OPEN_FILE_LINK_PREFIX", "", "OPEN_MR_LINK_PREFIX", "convertToHtml", "Lcom/intellij/openapi/util/NlsSafe;", "project", "Lcom/intellij/openapi/project/Project;", "gitRepository", "Lgit4idea/repo/GitRepository;", "projectPath", "Lorg/jetbrains/plugins/gitlab/util/GitLabProjectPath;", "markdownSource", "Lorg/jetbrains/annotations/NonNls;", "convertToHtml$intellij_vcs_gitlab", "preprocessMergeRequestIds", "GitLabFlavourDescriptor", "GitLabLinkGeneratingProvider", "intellij.vcs.gitlab"})
public final class GitLabUIUtil {
    @NotNull
    public static final GitLabUIUtil INSTANCE = new GitLabUIUtil();
    @NotNull
    public static final String OPEN_FILE_LINK_PREFIX = "glfilelink:";
    @NotNull
    public static final String OPEN_MR_LINK_PREFIX = "glmergerequest:";

    private GitLabUIUtil() {
    }

    @NotNull
    public final String convertToHtml$intellij_vcs_gitlab(@NotNull Project project, @NotNull GitRepository gitRepository, @NotNull GitLabProjectPath projectPath, @NotNull String markdownSource) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)gitRepository, (String)"gitRepository");
        Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
        Intrinsics.checkNotNullParameter((Object)markdownSource, (String)"markdownSource");
        if (StringsKt.isBlank((CharSequence)markdownSource)) {
            return markdownSource;
        }
        String text2 = StringsKt.replace$default((String)this.preprocessMergeRequestIds(IssueIdsProcessorKt.processIssueIdsMarkdown((Project)project, (String)markdownSource)), (String)"\r", (String)"", (boolean)false, (int)4, null);
        GitLabFlavourDescriptor flavourDescriptor = new GitLabFlavourDescriptor(gitRepository, projectPath, (HtmlSyntaxHighlighter)new CodeBlockHtmlSyntaxHighlighter(project));
        return new MarkdownToHtmlConverter((MarkdownFlavourDescriptor)flavourDescriptor).convertMarkdownToHtml(text2, null);
    }

    private final String preprocessMergeRequestIds(String markdownSource) {
        CharSequence charSequence = markdownSource;
        Regex regex = new Regex("(!\\d+)");
        String string = "[$1]($1)";
        return regex.replace(charSequence, string);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ&\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/plugins/gitlab/ui/GitLabUIUtil$GitLabFlavourDescriptor;", "Lorg/intellij/markdown/flavours/gfm/GFMFlavourDescriptor;", "gitRepository", "Lgit4idea/repo/GitRepository;", "projectPath", "Lorg/jetbrains/plugins/gitlab/util/GitLabProjectPath;", "htmlSyntaxHighlighter", "Lcom/intellij/markdown/utils/lang/HtmlSyntaxHighlighter;", "(Lgit4idea/repo/GitRepository;Lorg/jetbrains/plugins/gitlab/util/GitLabProjectPath;Lcom/intellij/markdown/utils/lang/HtmlSyntaxHighlighter;)V", "createHtmlGeneratingProviders", "", "Lorg/intellij/markdown/IElementType;", "Lorg/intellij/markdown/html/GeneratingProvider;", "linkMap", "Lorg/intellij/markdown/parser/LinkMap;", "baseURI", "Ljava/net/URI;", "intellij.vcs.gitlab"})
    private static final class GitLabFlavourDescriptor
    extends GFMFlavourDescriptor {
        @NotNull
        private final GitRepository gitRepository;
        @NotNull
        private final GitLabProjectPath projectPath;
        @NotNull
        private final HtmlSyntaxHighlighter htmlSyntaxHighlighter;

        public GitLabFlavourDescriptor(@NotNull GitRepository gitRepository, @NotNull GitLabProjectPath projectPath, @NotNull HtmlSyntaxHighlighter htmlSyntaxHighlighter) {
            Intrinsics.checkNotNullParameter((Object)gitRepository, (String)"gitRepository");
            Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
            Intrinsics.checkNotNullParameter((Object)htmlSyntaxHighlighter, (String)"htmlSyntaxHighlighter");
            super(false, false, false, 7, null);
            this.gitRepository = gitRepository;
            this.projectPath = projectPath;
            this.htmlSyntaxHighlighter = htmlSyntaxHighlighter;
        }

        @NotNull
        public Map<IElementType, GeneratingProvider> createHtmlGeneratingProviders(@NotNull LinkMap linkMap, @Nullable URI baseURI) {
            Intrinsics.checkNotNullParameter((Object)linkMap, (String)"linkMap");
            Map map2 = super.createHtmlGeneratingProviders(linkMap, baseURI);
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)MarkdownElementTypes.CODE_FENCE, (Object)new CodeFenceSyntaxHighlighterGeneratingProvider(this.htmlSyntaxHighlighter)), TuplesKt.to((Object)MarkdownElementTypes.INLINE_LINK, (Object)new GitLabLinkGeneratingProvider(this.gitRepository, this.projectPath, (GeneratingProvider)map2.get(MarkdownElementTypes.INLINE_LINK)))};
            return MapsKt.plus((Map)map2, (Map)MapsKt.hashMapOf((Pair[])pairArray));
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0001\u00a2\u0006\u0002\u0010\u0007J$\u0010\b\u001a\u00020\t2\n\u0010\n\u001a\u00060\u000bR\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/plugins/gitlab/ui/GitLabUIUtil$GitLabLinkGeneratingProvider;", "Lorg/intellij/markdown/html/GeneratingProvider;", "gitRepository", "Lgit4idea/repo/GitRepository;", "projectPath", "Lorg/jetbrains/plugins/gitlab/util/GitLabProjectPath;", "fallback", "(Lgit4idea/repo/GitRepository;Lorg/jetbrains/plugins/gitlab/util/GitLabProjectPath;Lorg/intellij/markdown/html/GeneratingProvider;)V", "processNode", "", "visitor", "Lorg/intellij/markdown/html/HtmlGenerator$HtmlGeneratingVisitor;", "Lorg/intellij/markdown/html/HtmlGenerator;", "text", "", "node", "Lorg/intellij/markdown/ast/ASTNode;", "intellij.vcs.gitlab"})
    private static final class GitLabLinkGeneratingProvider
    implements GeneratingProvider {
        @NotNull
        private final GitRepository gitRepository;
        @NotNull
        private final GitLabProjectPath projectPath;
        @Nullable
        private final GeneratingProvider fallback;

        public GitLabLinkGeneratingProvider(@NotNull GitRepository gitRepository, @NotNull GitLabProjectPath projectPath, @Nullable GeneratingProvider fallback) {
            Intrinsics.checkNotNullParameter((Object)gitRepository, (String)"gitRepository");
            Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
            this.gitRepository = gitRepository;
            this.projectPath = projectPath;
            this.fallback = fallback;
        }

        public void processNode(@NotNull HtmlGenerator.HtmlGeneratingVisitor visitor, @NotNull String text2, @NotNull ASTNode node) {
            char[] mrUrl2;
            CharSequence linkDestination;
            ASTNode aSTNode;
            Intrinsics.checkNotNullParameter((Object)visitor, (String)"visitor");
            Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            ASTNode aSTNode2 = ASTUtilKt.findChildOfType((ASTNode)node, (IElementType)MarkdownElementTypes.LINK_TEXT);
            CharSequence linkText = aSTNode2 != null && (aSTNode = ASTUtilKt.findChildOfType((ASTNode)aSTNode2, (IElementType)MarkdownTokenTypes.TEXT)) != null ? ASTUtilKt.getTextInNode((ASTNode)aSTNode, (CharSequence)text2) : null;
            ASTNode aSTNode3 = ASTUtilKt.findChildOfType((ASTNode)node, (IElementType)MarkdownElementTypes.LINK_DESTINATION);
            CharSequence charSequence = linkDestination = aSTNode3 != null ? ASTUtilKt.getTextInNode((ASTNode)aSTNode3, (CharSequence)text2) : null;
            if (linkText == null || linkDestination == null) {
                GeneratingProvider generatingProvider = this.fallback;
                if (generatingProvider != null) {
                    generatingProvider.processNode(visitor, text2, node);
                }
                return;
            }
            String cfr_ignored_0 = (String)linkText;
            String cfr_ignored_1 = (String)linkDestination;
            if (StringsKt.startsWith$default((CharSequence)linkDestination, (char)'!', (boolean)false, (int)2, null)) {
                String string = ((String)linkDestination).substring(1);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                String mrIid = string;
                String mrUrl2 = GitLabUIUtil.OPEN_MR_LINK_PREFIX + mrIid;
                String string2 = HtmlChunk.link((String)mrUrl2, (String)("!" + mrIid)).toString();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
                visitor.consumeHtml((CharSequence)string2);
                return;
            }
            String fullProjectPath = GitLabProjectPath.fullPath$default(this.projectPath, false, 1, null);
            if (StringsKt.startsWith$default((String)((String)linkDestination), (String)"http:", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)((String)linkDestination), (String)"https:", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)StringsKt.trimStart((String)((String)linkDestination), (char[])(mrUrl2 = new char[]{'/'})), (String)fullProjectPath, (boolean)false, (int)2, null)) {
                String string = HtmlChunk.link((String)((String)linkDestination), (String)((String)linkText)).toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                visitor.consumeHtml((CharSequence)string);
                return;
            }
            try {
                String fileDestination = ((Object)this.gitRepository.getRoot().toNioPath().resolve(StringsKt.replace$default((String)((String)linkDestination), (char)'\\', (char)'/', (boolean)false, (int)4, null))).toString();
                String fileDescription = GitLabUIUtil.OPEN_FILE_LINK_PREFIX + fileDestination;
                String string = HtmlChunk.link((String)fileDescription, (String)((String)linkText)).toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                visitor.consumeHtml((CharSequence)string);
            }
            catch (Exception e) {
                String string = HtmlChunk.link((String)((String)linkDestination), (String)((String)linkText)).toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                visitor.consumeHtml((CharSequence)string);
            }
        }
    }
}

