/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.server;

import com.intellij.util.text.VersionComparatorUtil;
import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.model.Activation;
import org.apache.maven.model.Model;
import org.apache.maven.model.Profile;
import org.apache.maven.model.building.DefaultModelBuildingRequest;
import org.apache.maven.model.building.ModelBuildingRequest;
import org.apache.maven.model.building.ModelProblemCollector;
import org.apache.maven.model.building.ModelProblemCollectorRequest;
import org.apache.maven.model.path.PathTranslator;
import org.apache.maven.model.profile.DefaultProfileInjector;
import org.apache.maven.profiles.activation.JdkPrefixProfileActivator;
import org.apache.maven.profiles.activation.OperatingSystemProfileActivator;
import org.apache.maven.profiles.activation.ProfileActivator;
import org.apache.maven.profiles.activation.SystemPropertyProfileActivator;
import org.apache.maven.project.DefaultProjectBuilderConfiguration;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuilderConfiguration;
import org.apache.maven.project.interpolation.ModelInterpolationException;
import org.apache.maven.project.path.DefaultPathTranslator;
import org.codehaus.plexus.context.Context;
import org.codehaus.plexus.context.ContextException;
import org.codehaus.plexus.context.DefaultContext;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.InitializationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.model.MavenExplicitProfiles;
import org.jetbrains.idea.maven.model.MavenModel;
import org.jetbrains.idea.maven.server.Maven3ModelConverter;
import org.jetbrains.idea.maven.server.MavenServerConfigUtil;
import org.jetbrains.idea.maven.server.MavenServerGlobals;
import org.jetbrains.idea.maven.server.MavenServerUtil;
import org.jetbrains.idea.maven.server.MyFileProfileActivator;
import org.jetbrains.idea.maven.server.ProfileApplicationResult;
import org.jetbrains.idea.maven.server.embedder.CustomMaven3ModelInterpolator;
import org.jetbrains.idea.maven.server.embedder.CustomMaven3ModelInterpolator2;

public final class Maven3XProfileUtil {
    public static ProfileApplicationResult applyProfiles(MavenModel model, File basedir, MavenExplicitProfiles explicitProfiles, Collection<String> alwaysOnProfiles) {
        Model nativeModel = Maven3ModelConverter.toNativeModel((MavenModel)model);
        Collection enabledProfiles = explicitProfiles.getEnabledProfiles();
        Collection disabledProfiles = explicitProfiles.getDisabledProfiles();
        ArrayList<Profile> activatedPom = new ArrayList<Profile>();
        ArrayList<Profile> activatedExternal = new ArrayList<Profile>();
        ArrayList<Profile> activeByDefault = new ArrayList<Profile>();
        List rawProfiles = nativeModel.getProfiles();
        List expandedProfilesCache = null;
        ArrayList<Profile> deactivatedProfiles = new ArrayList<Profile>();
        for (int i = 0; i < rawProfiles.size(); ++i) {
            Profile eachRawProfile = (Profile)rawProfiles.get(i);
            if (disabledProfiles.contains(eachRawProfile.getId())) {
                deactivatedProfiles.add(eachRawProfile);
                continue;
            }
            boolean shouldAdd = enabledProfiles.contains(eachRawProfile.getId()) || alwaysOnProfiles.contains(eachRawProfile.getId());
            Activation activation = eachRawProfile.getActivation();
            if (activation != null) {
                if (activation.isActiveByDefault()) {
                    activeByDefault.add(eachRawProfile);
                }
                if (expandedProfilesCache == null) {
                    expandedProfilesCache = Maven3XProfileUtil.doInterpolate(nativeModel, basedir).getProfiles();
                }
                Profile eachExpandedProfile = (Profile)expandedProfilesCache.get(i);
                for (ProfileActivator eachActivator : Maven3XProfileUtil.getProfileActivators(basedir)) {
                    try {
                        if (!eachActivator.canDetermineActivation(eachExpandedProfile) || !eachActivator.isActive(eachExpandedProfile)) continue;
                        shouldAdd = true;
                        break;
                    }
                    catch (Exception e) {
                        MavenServerGlobals.getLogger().warn((Throwable)e);
                    }
                }
            }
            if (!shouldAdd) continue;
            if ("pom".equals(eachRawProfile.getSource())) {
                activatedPom.add(eachRawProfile);
                continue;
            }
            activatedExternal.add(eachRawProfile);
        }
        ArrayList<Profile> activatedProfiles = new ArrayList<Profile>(activatedPom.isEmpty() ? activeByDefault : activatedPom);
        activatedProfiles.addAll(activatedExternal);
        for (Profile each : activatedProfiles) {
            new DefaultProfileInjector().injectProfile(nativeModel, each, null, null);
        }
        return new ProfileApplicationResult(Maven3ModelConverter.convertModel((Model)nativeModel, null), new MavenExplicitProfiles(Maven3XProfileUtil.collectProfilesIds(activatedProfiles), Maven3XProfileUtil.collectProfilesIds(deactivatedProfiles)));
    }

    @NotNull
    public static MavenModel interpolateAndAlignModel(MavenModel model, File basedir, File pomDir) {
        Model nativeModel = Maven3ModelConverter.toNativeModel((MavenModel)model);
        Model result = Maven3XProfileUtil.doInterpolate(nativeModel, basedir);
        DefaultPathTranslator pathTranslator = new DefaultPathTranslator();
        pathTranslator.alignToBaseDirectory(result, pomDir);
        MavenModel mavenModel = Maven3ModelConverter.convertModel((Model)result, null);
        if (mavenModel == null) {
            Maven3XProfileUtil.$$$reportNull$$$0(0);
        }
        return mavenModel;
    }

    public static Collection<String> collectActivatedProfiles(MavenProject mavenProject) {
        ArrayList<Profile> profiles = new ArrayList<Profile>();
        try {
            while (mavenProject != null) {
                profiles.addAll(mavenProject.getActiveProfiles());
                mavenProject = mavenProject.getParent();
            }
        }
        catch (Exception e) {
            MavenServerGlobals.getLogger().info((Throwable)e);
        }
        return Maven3XProfileUtil.collectProfilesIds(profiles);
    }

    @NotNull
    private static Model doInterpolate(@NotNull Model result, File basedir) {
        String mavenVersion;
        if (result == null) {
            Maven3XProfileUtil.$$$reportNull$$$0(1);
        }
        if (VersionComparatorUtil.compare((String)(mavenVersion = System.getProperty("idea.maven.embedder.version")), (String)"3.3.1") >= 0) {
            return Maven3XProfileUtil.doInterpolate330(result, basedir);
        }
        Model model = Maven3XProfileUtil.doInterpolate325(result, basedir);
        DefaultPathTranslator pathTranslator = new DefaultPathTranslator();
        pathTranslator.alignToBaseDirectory(model, basedir);
        Model model2 = model;
        if (model2 == null) {
            Maven3XProfileUtil.$$$reportNull$$$0(2);
        }
        return model2;
    }

    @NotNull
    private static Model doInterpolate325(@NotNull Model result, File basedir) {
        if (result == null) {
            Maven3XProfileUtil.$$$reportNull$$$0(3);
        }
        try {
            CustomMaven3ModelInterpolator interpolator = new CustomMaven3ModelInterpolator(new DefaultPathTranslator());
            interpolator.initialize();
            Properties props = MavenServerUtil.collectSystemProperties();
            ProjectBuilderConfiguration config = new DefaultProjectBuilderConfiguration().setExecutionProperties(props);
            config.setBuildStartTime(new Date());
            Properties userProperties = new Properties();
            userProperties.putAll((Map<?, ?>)MavenServerConfigUtil.getMavenAndJvmConfigPropertiesForBaseDir((File)basedir));
            config.setUserProperties(userProperties);
            result = interpolator.interpolate(result, basedir, config, false);
        }
        catch (ModelInterpolationException e) {
            MavenServerGlobals.getLogger().warn((Throwable)e);
        }
        catch (InitializationException e) {
            MavenServerGlobals.getLogger().error((Throwable)e);
        }
        Model model = result;
        if (model == null) {
            Maven3XProfileUtil.$$$reportNull$$$0(4);
        }
        return model;
    }

    @NotNull
    private static Model doInterpolate330(@NotNull Model result, File basedir) {
        if (result == null) {
            Maven3XProfileUtil.$$$reportNull$$$0(5);
        }
        try {
            CustomMaven3ModelInterpolator2 interpolator = new CustomMaven3ModelInterpolator2();
            if (VersionComparatorUtil.compare((String)System.getProperty("idea.maven.embedder.version"), (String)"3.8.5") >= 0) {
                try {
                    Class<?> clazz = Class.forName("org.apache.maven.model.interpolation.DefaultModelVersionProcessor");
                    Constructor<?> constructor = clazz.getConstructor(new Class[0]);
                    Object component = constructor.newInstance(new Object[0]);
                    Method processor = interpolator.getClass().getMethod("setVersionPropertiesProcessor", Class.forName("org.apache.maven.model.interpolation.ModelVersionProcessor"));
                    processor.invoke((Object)interpolator, component);
                }
                catch (Exception e) {
                    MavenServerGlobals.getLogger().error((Throwable)e);
                }
            }
            Properties userProperties = new Properties();
            userProperties.putAll((Map<?, ?>)MavenServerConfigUtil.getMavenAndJvmConfigPropertiesForBaseDir((File)basedir));
            DefaultModelBuildingRequest request = new DefaultModelBuildingRequest();
            request.setUserProperties(userProperties);
            request.setSystemProperties(MavenServerUtil.collectSystemProperties());
            request.setBuildStartTime(new Date());
            request.setRawModel(result);
            interpolator.setPathTranslator(new PathTranslator(){

                public String alignToBaseDirectory(String path, File basedir) {
                    String result = path;
                    if (path != null && basedir != null) {
                        File file = new File(path = path.replace('\\', File.separatorChar).replace('/', File.separatorChar));
                        result = file.isAbsolute() ? file.getPath() : (file.getPath().startsWith(File.separator) ? file.getAbsolutePath() : new File(new File(basedir, path).toURI().normalize()).getAbsolutePath());
                    }
                    return result;
                }
            });
            final ArrayList problems = new ArrayList();
            result = interpolator.interpolateModel(result, basedir, (ModelBuildingRequest)request, new ModelProblemCollector(){

                public void add(ModelProblemCollectorRequest request) {
                    problems.add(request);
                }
            });
            for (ModelProblemCollectorRequest problem : problems) {
                if (problem.getException() == null) continue;
                MavenServerGlobals.getLogger().warn((Throwable)problem.getException());
            }
        }
        catch (Exception e) {
            MavenServerGlobals.getLogger().error((Throwable)e);
        }
        Model model = result;
        if (model == null) {
            Maven3XProfileUtil.$$$reportNull$$$0(6);
        }
        return model;
    }

    private static Collection<String> collectProfilesIds(List<Profile> profiles) {
        HashSet<String> result = new HashSet<String>();
        for (Profile each : profiles) {
            if (each.getId() == null) continue;
            result.add(each.getId());
        }
        return result;
    }

    private static ProfileActivator[] getProfileActivators(File basedir) {
        SystemPropertyProfileActivator sysPropertyActivator = new SystemPropertyProfileActivator();
        DefaultContext context = new DefaultContext();
        context.put((Object)"SystemProperties", (Object)MavenServerUtil.collectSystemProperties());
        try {
            sysPropertyActivator.contextualize((Context)context);
        }
        catch (ContextException e) {
            MavenServerGlobals.getLogger().error((Throwable)e);
            return new ProfileActivator[0];
        }
        return new ProfileActivator[]{new MyFileProfileActivator(basedir), sysPropertyActivator, new JdkPrefixProfileActivator(), new OperatingSystemProfileActivator()};
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/maven/server/Maven3XProfileUtil";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "interpolateAndAlignModel";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/maven/server/Maven3XProfileUtil";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "doInterpolate";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "doInterpolate325";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "doInterpolate330";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "doInterpolate";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "doInterpolate325";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "doInterpolate330";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

