/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.ui;

import com.intellij.codeWithMe.ClientId;
import com.intellij.collaboration.auth.AccountManager;
import com.intellij.collaboration.auth.DefaultAccountHolder;
import com.intellij.collaboration.auth.ui.AccountsListModel;
import com.intellij.collaboration.auth.ui.AccountsPanelActionsController;
import com.intellij.collaboration.auth.ui.AccountsPanelFactory;
import com.intellij.collaboration.auth.ui.LoadingAccountsDetailsProvider;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.application.ModalityKt;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.options.BoundConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.AlignX;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.ButtonKt;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.RightGap;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.dsl.builder.TextFieldKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.github.authentication.accounts.GHAccountManager;
import org.jetbrains.plugins.github.authentication.accounts.GithubAccount;
import org.jetbrains.plugins.github.authentication.accounts.GithubProjectDefaultAccountHolder;
import org.jetbrains.plugins.github.authentication.ui.GHAccountsDetailsProvider;
import org.jetbrains.plugins.github.authentication.ui.GHAccountsListModel;
import org.jetbrains.plugins.github.authentication.ui.GHAccountsPanelActionsController;
import org.jetbrains.plugins.github.i18n.GithubBundle;
import org.jetbrains.plugins.github.ui.util.GHPluginProjectScopeProvider;
import org.jetbrains.plugins.github.util.GithubSettings;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/plugins/github/ui/GithubSettingsConfigurable;", "Lcom/intellij/openapi/options/BoundConfigurable;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "createPanel", "Lcom/intellij/openapi/ui/DialogPanel;", "intellij.vcs.github"})
@SourceDebugExtension(value={"SMAP\nGithubSettingsConfigurable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GithubSettingsConfigurable.kt\norg/jetbrains/plugins/github/ui/GithubSettingsConfigurable\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,78:1\n31#2,2:79\n31#2,2:81\n40#3,3:83\n*S KotlinDebug\n*F\n+ 1 GithubSettingsConfigurable.kt\norg/jetbrains/plugins/github/ui/GithubSettingsConfigurable\n*L\n29#1:79,2\n30#1:81,2\n31#1:83,3\n*E\n"})
public final class GithubSettingsConfigurable
extends BoundConfigurable {
    @NotNull
    private final Project project;

    public GithubSettingsConfigurable(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super("GitHub", "settings.github");
        this.project = project;
    }

    @NotNull
    public DialogPanel createPanel() {
        ComponentManager $this$service$iv = (ComponentManager)this.project;
        boolean $i$f$service = false;
        Class<GHPluginProjectScopeProvider> serviceClass$iv = GHPluginProjectScopeProvider.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        GHPluginProjectScopeProvider scopeProvider = (GHPluginProjectScopeProvider)((Object)object);
        ComponentManager $this$service$iv2 = (ComponentManager)this.project;
        boolean $i$f$service2 = false;
        Class serviceClass$iv2 = GithubProjectDefaultAccountHolder.class;
        Object object2 = $this$service$iv2.getService(serviceClass$iv2);
        if (object2 == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv2, serviceClass$iv2);
        }
        GithubProjectDefaultAccountHolder defaultAccountHolder = (GithubProjectDefaultAccountHolder)((Object)object2);
        $i$f$service2 = false;
        serviceClass$iv2 = GHAccountManager.class;
        Object object3 = ApplicationManager.getApplication().getService(serviceClass$iv2);
        if (object3 == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv2.getName() + " (classloader=" + serviceClass$iv2.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        GHAccountManager accountManager = (GHAccountManager)((Object)object3);
        GithubSettings ghSettings = GithubSettings.getInstance();
        String string = ((Object)((Object)this)).getClass().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        Disposable disposable = this.getDisposable();
        Intrinsics.checkNotNull((Object)disposable);
        CoroutineContext coroutineContext = CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE);
        ModalityState modalityState = ModalityState.any();
        Intrinsics.checkNotNullExpressionValue((Object)modalityState, (String)"any(...)");
        CoroutineScope scope = scopeProvider.createDisposedScope(string, disposable, coroutineContext.plus(ModalityKt.asContextElement((ModalityState)modalityState)));
        GHAccountsListModel accountsModel = new GHAccountsListModel();
        GHAccountsDetailsProvider detailsProvider = new GHAccountsDetailsProvider(scope, accountManager, accountsModel);
        AccountsPanelFactory panelFactory = new AccountsPanelFactory(scope, (AccountManager)accountManager, (DefaultAccountHolder)defaultAccountHolder, (AccountsListModel.WithDefault)accountsModel);
        GHAccountsPanelActionsController actionsController = new GHAccountsPanelActionsController(this.project, accountsModel);
        return BuilderKt.panel((Function1)((Function1)new Function1<Panel, Unit>((AccountsPanelFactory<GithubAccount, String>)panelFactory, detailsProvider, actionsController, ghSettings, scope){
            final /* synthetic */ AccountsPanelFactory<GithubAccount, String> $panelFactory;
            final /* synthetic */ GHAccountsDetailsProvider $detailsProvider;
            final /* synthetic */ GHAccountsPanelActionsController $actionsController;
            final /* synthetic */ GithubSettings $ghSettings;
            final /* synthetic */ CoroutineScope $scope;
            {
                this.$panelFactory = $panelFactory;
                this.$detailsProvider = $detailsProvider;
                this.$actionsController = $actionsController;
                this.$ghSettings = $ghSettings;
                this.$scope = $scope;
                super(1);
            }

            public final void invoke(@NotNull Panel $this$panel) {
                Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
                Panel.row$default((Panel)$this$panel, null, (Function1)((Function1)new Function1<Row, Unit>(this.$panelFactory, this.$detailsProvider, this.$actionsController){
                    final /* synthetic */ AccountsPanelFactory<GithubAccount, String> $panelFactory;
                    final /* synthetic */ GHAccountsDetailsProvider $detailsProvider;
                    final /* synthetic */ GHAccountsPanelActionsController $actionsController;
                    {
                        this.$panelFactory = $panelFactory;
                        this.$detailsProvider = $detailsProvider;
                        this.$actionsController = $actionsController;
                        super(1);
                    }

                    public final void invoke(@NotNull Row $this$row) {
                        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                        this.$panelFactory.accountsPanelCell($this$row, (LoadingAccountsDetailsProvider)this.$detailsProvider, (AccountsPanelActionsController)this.$actionsController).align(Align.FILL);
                    }
                }), (int)1, null).resizableRow();
                Panel.row$default((Panel)$this$panel, null, (Function1)((Function1)new Function1<Row, Unit>(this.$ghSettings){
                    final /* synthetic */ GithubSettings $ghSettings;
                    {
                        this.$ghSettings = $ghSettings;
                        super(1);
                    }

                    public final void invoke(@NotNull Row $this$row) {
                        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                        String string = GithubBundle.message("settings.clone.ssh", new Object[0]);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                        Cell cell = $this$row.checkBox(string);
                        GithubSettings githubSettings = this.$ghSettings;
                        Intrinsics.checkNotNullExpressionValue((Object)githubSettings, (String)"$ghSettings");
                        Function0 function0 = (Function0)new Function0<Boolean>((Object)githubSettings){

                            @NotNull
                            public final Boolean invoke() {
                                return ((GithubSettings)this.receiver).isCloneGitUsingSsh();
                            }
                        };
                        GithubSettings githubSettings2 = this.$ghSettings;
                        Intrinsics.checkNotNullExpressionValue((Object)githubSettings2, (String)"$ghSettings");
                        ButtonKt.bindSelected((Cell)cell, (Function0)function0, (Function1)((Function1)new Function1<Boolean, Unit>((Object)githubSettings2){

                            public final void invoke(boolean p0) {
                                ((GithubSettings)this.receiver).setCloneGitUsingSsh(p0);
                            }
                        }));
                    }
                }), (int)1, null);
                Panel.row$default((Panel)$this$panel, null, (Function1)((Function1)new Function1<Row, Unit>(this.$ghSettings){
                    final /* synthetic */ GithubSettings $ghSettings;
                    {
                        this.$ghSettings = $ghSettings;
                        super(1);
                    }

                    public final void invoke(@NotNull Row $this$row) {
                        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                        String string = GithubBundle.message("settings.automatically.mark.as.viewed", new Object[0]);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                        Cell cell = $this$row.checkBox(string);
                        GithubSettings githubSettings = this.$ghSettings;
                        Intrinsics.checkNotNullExpressionValue((Object)githubSettings, (String)"$ghSettings");
                        Function0 function0 = (Function0)new Function0<Boolean>((Object)githubSettings){

                            @NotNull
                            public final Boolean invoke() {
                                return ((GithubSettings)this.receiver).isAutomaticallyMarkAsViewed();
                            }
                        };
                        GithubSettings githubSettings2 = this.$ghSettings;
                        Intrinsics.checkNotNullExpressionValue((Object)githubSettings2, (String)"$ghSettings");
                        ButtonKt.bindSelected((Cell)cell, (Function0)function0, (Function1)((Function1)new Function1<Boolean, Unit>((Object)githubSettings2){

                            public final void invoke(boolean p0) {
                                ((GithubSettings)this.receiver).setAutomaticallyMarkAsViewed(p0);
                            }
                        }));
                    }
                }), (int)1, null);
                Panel.row$default((Panel)$this$panel, null, (Function1)((Function1)new Function1<Row, Unit>(this.$ghSettings){
                    final /* synthetic */ GithubSettings $ghSettings;
                    {
                        this.$ghSettings = $ghSettings;
                        super(1);
                    }

                    public final void invoke(@NotNull Row $this$row) {
                        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                        String string = GithubBundle.message("settings.enable.pr.seen.markers", new Object[0]);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                        Cell cell = $this$row.checkBox(string);
                        GithubSettings githubSettings = this.$ghSettings;
                        Intrinsics.checkNotNullExpressionValue((Object)githubSettings, (String)"$ghSettings");
                        Function0 function0 = (Function0)new Function0<Boolean>((Object)githubSettings){

                            @NotNull
                            public final Boolean invoke() {
                                return ((GithubSettings)this.receiver).isSeenMarkersEnabled();
                            }
                        };
                        GithubSettings githubSettings2 = this.$ghSettings;
                        Intrinsics.checkNotNullExpressionValue((Object)githubSettings2, (String)"$ghSettings");
                        ButtonKt.bindSelected((Cell)cell, (Function0)function0, (Function1)((Function1)new Function1<Boolean, Unit>((Object)githubSettings2){

                            public final void invoke(boolean p0) {
                                ((GithubSettings)this.receiver).setIsSeenMarkersEnabled(p0);
                            }
                        }));
                    }
                }), (int)1, null);
                String string = GithubBundle.message("settings.timeout", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                $this$panel.row(string, (Function1)new Function1<Row, Unit>(this.$scope, this.$ghSettings){
                    final /* synthetic */ CoroutineScope $scope;
                    final /* synthetic */ GithubSettings $ghSettings;
                    {
                        this.$scope = $scope;
                        this.$ghSettings = $ghSettings;
                        super(1);
                    }

                    public final void invoke(@NotNull Row $this$row) {
                        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                        TextFieldKt.bindIntText((Cell)TextFieldKt.columns((Cell)Row.intTextField$default((Row)$this$row, (IntRange)new IntRange(0, 60), null, (int)2, null), (int)2), (Function0)((Function0)new Function0<Integer>(this.$ghSettings){
                            final /* synthetic */ GithubSettings $ghSettings;
                            {
                                this.$ghSettings = $ghSettings;
                                super(0);
                            }

                            @NotNull
                            public final Integer invoke() {
                                return this.$ghSettings.getConnectionTimeout() / 1000;
                            }
                        }), (Function1)((Function1)new Function1<Integer, Unit>(this.$ghSettings){
                            final /* synthetic */ GithubSettings $ghSettings;
                            {
                                this.$ghSettings = $ghSettings;
                                super(1);
                            }

                            public final void invoke(int it) {
                                this.$ghSettings.setConnectionTimeout(it * 1000);
                            }
                        })).gap(RightGap.SMALL);
                        String string = GithubBundle.message("settings.timeout.seconds", new Object[0]);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                        $this$row.label(string).gap(RightGap.COLUMNS);
                        boolean $i$f$service = false;
                        Class<GHAccountManager> serviceClass$iv = GHAccountManager.class;
                        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
                        if (object == null) {
                            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
                        }
                        AccountsPanelFactory.Companion.addWarningForMemoryOnlyPasswordSafeAndGet(this.$scope, ((GHAccountManager)((Object)object)).getCanPersistCredentials(), (Function1)new Function1<Function1<? super Panel, ? extends Unit>, Panel>((Object)$this$row){

                            @NotNull
                            public final Panel invoke(@NotNull Function1<? super Panel, Unit> p0) {
                                Intrinsics.checkNotNullParameter(p0, (String)"p0");
                                return ((Row)this.receiver).panel(p0);
                            }
                        }).align((Align)AlignX.RIGHT.INSTANCE);
                    }
                });
            }
        }));
    }
}

