/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.lower;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.Reflection;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KDeclarationContainer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.BodyLoweringPass;
import org.jetbrains.kotlin.backend.common.CommonBackendContext;
import org.jetbrains.kotlin.backend.common.DeclarationTransformer;
import org.jetbrains.kotlin.backend.common.Mapping;
import org.jetbrains.kotlin.backend.common.MappingsKt;
import org.jetbrains.kotlin.backend.common.lower.InlineClassLowering;
import org.jetbrains.kotlin.backend.common.lower.LowerUtilsKt;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrElementsKt;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.builders.ExpressionHelpersKt;
import org.jetbrains.kotlin.ir.builders.IrBlockBodyBuilder;
import org.jetbrains.kotlin.ir.builders.IrBlockBuilder;
import org.jetbrains.kotlin.ir.builders.IrBuilderKt;
import org.jetbrains.kotlin.ir.builders.IrBuilderWithScope;
import org.jetbrains.kotlin.ir.builders.IrGeneratorWithScope;
import org.jetbrains.kotlin.ir.builders.IrStatementsBuilder;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationBase;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationsKt;
import org.jetbrains.kotlin.ir.declarations.IrFactoryHelpersKt;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrValueDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrBlockBody;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrDeclarationReference;
import org.jetbrains.kotlin.ir.expressions.IrDelegatingConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrGetField;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.IrReturn;
import org.jetbrains.kotlin.ir.expressions.IrSetField;
import org.jetbrains.kotlin.ir.expressions.IrSetValue;
import org.jetbrains.kotlin.ir.expressions.IrStatementOrigin;
import org.jetbrains.kotlin.ir.expressions.impl.IrTypeOperatorCallImpl;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.symbols.IrValueParameterSymbol;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypeSystemContextKt;
import org.jetbrains.kotlin.ir.types.SimpleTypeNullability;
import org.jetbrains.kotlin.ir.types.impl.IrSimpleTypeImpl;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.ir.util.DeepCopyIrTreeWithSymbols;
import org.jetbrains.kotlin.ir.util.DeepCopySymbolRemapper;
import org.jetbrains.kotlin.ir.util.DeepCopyTypeRemapper;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.PatchDeclarationParentsKt;
import org.jetbrains.kotlin.ir.util.ReferencedSymbolRemapper;
import org.jetbrains.kotlin.ir.util.SymbolRemapper;
import org.jetbrains.kotlin.ir.util.TypeRemapper;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoidKt;
import org.jetbrains.kotlin.ir.visitors.IrElementVisitorVoid;
import org.jetbrains.kotlin.ir.visitors.IrVisitorsKt;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\nH\u0002J\f\u0010\u001a\u001a\u00020\u001b*\u00020\nH\u0002J\u0010\u0010\u001c\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\nH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0016\u001a\u00020\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/InlineClassLowering;", "", "context", "Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;", "<init>", "(Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;", "transformedFunction", "Lorg/jetbrains/kotlin/backend/common/Mapping$DeclarationMapping;", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "isClassInlineLike", "", "irClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "inlineClassDeclarationLowering", "Lorg/jetbrains/kotlin/backend/common/DeclarationTransformer;", "getInlineClassDeclarationLowering", "()Lorg/jetbrains/kotlin/backend/common/DeclarationTransformer;", "getOrCreateStaticMethod", "function", "inlineClassUsageLowering", "Lorg/jetbrains/kotlin/backend/common/BodyLoweringPass;", "getInlineClassUsageLowering", "()Lorg/jetbrains/kotlin/backend/common/BodyLoweringPass;", "toInlineClassImplementationName", "Lorg/jetbrains/kotlin/name/Name;", "createStaticBodilessMethod", "ir.backend.common"})
public final class InlineClassLowering {
    @NotNull
    private final CommonBackendContext context;
    @NotNull
    private final Mapping.DeclarationMapping<IrFunction, IrSimpleFunction> transformedFunction;
    @NotNull
    private final DeclarationTransformer inlineClassDeclarationLowering;
    @NotNull
    private final BodyLoweringPass inlineClassUsageLowering;

    public InlineClassLowering(@NotNull CommonBackendContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
        this.transformedFunction = this.context.getMapping().getInlineClassMemberToStatic();
        this.inlineClassDeclarationLowering = new DeclarationTransformer(this){
            final /* synthetic */ InlineClassLowering this$0;
            {
                this.this$0 = $receiver;
            }

            public List<IrDeclaration> transformFlat(IrDeclaration declaration) {
                Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
                IrDeclarationParent irDeclarationParent = declaration.getParent();
                IrClass irClass = irDeclarationParent instanceof IrClass ? (IrClass)irDeclarationParent : null;
                if (irClass == null) {
                    return null;
                }
                IrClass irClass2 = irClass;
                if (!InlineClassLowering.access$isClassInlineLike(this.this$0, irClass2)) {
                    return null;
                }
                IrDeclaration irDeclaration = declaration;
                return irDeclaration instanceof IrConstructor ? this.transformConstructor((IrConstructor)declaration) : (irDeclaration instanceof IrSimpleFunction ? this.transformMethodFlat((IrSimpleFunction)declaration) : null);
            }

            private final List<IrDeclaration> transformConstructor(IrConstructor irConstructor) {
                if (irConstructor.isPrimary()) {
                    return this.transformPrimaryConstructor(irConstructor);
                }
                IrSimpleFunction result = InlineClassLowering.access$getOrCreateStaticMethod(this.this$0, irConstructor);
                this.transformConstructorBody(irConstructor, result);
                return CollectionsKt.listOf((Object)result);
            }

            private final List<IrDeclaration> transformMethodFlat(IrSimpleFunction function) {
                if (IrDeclarationsKt.isStaticMethodOfClass(function) || !AdditionalIrUtilsKt.isReal(function)) {
                    return null;
                }
                IrSimpleFunction staticMethod = InlineClassLowering.access$getOrCreateStaticMethod(this.this$0, function);
                this.transformMethodBodyFlat(function, staticMethod);
                function.setBody(this.delegateToStaticMethod(function, staticMethod));
                if (function.getOverriddenSymbols().isEmpty()) {
                    return CollectionsKt.listOf((Object)staticMethod);
                }
                Object[] objectArray = new IrSimpleFunction[]{function, staticMethod};
                return CollectionsKt.listOf((Object[])objectArray);
            }

            /*
             * WARNING - void declaration
             */
            private final List<IrDeclaration> transformPrimaryConstructor(IrConstructor irConstructor) {
                IrBlockBody irBlockBody;
                IrSimpleFunction irSimpleFunction;
                IrClass klass = IrUtilsKt.getParentAsClass(irConstructor);
                IrSimpleType inlineClassType = IrUtilsKt.getDefaultType(klass);
                IrSimpleFunction it = irSimpleFunction = InlineClassLowering.access$getOrCreateStaticMethod(this.this$0, irConstructor);
                boolean bl = false;
                it.setReturnType(inlineClassType);
                IrSimpleFunction initFunction = irSimpleFunction;
                Ref.ObjectRef delegatingCtorCall = new Ref.ObjectRef();
                Ref.ObjectRef setMemberField = new Ref.ObjectRef();
                IrSimpleFunction irSimpleFunction2 = initFunction;
                IrBody irBody = irConstructor.getBody();
                if (irBody != null) {
                    void body;
                    IrBody irBody2 = irBody;
                    InlineClassLowering inlineClassLowering = this.this$0;
                    IrBody irBody3 = irBody2;
                    IrSimpleFunction irSimpleFunction3 = irSimpleFunction2;
                    boolean bl2 = false;
                    irBlockBody = IrFactoryHelpersKt.createBlockBody(inlineClassLowering.getContext().getIrFactory(), -1, -1, (Function1<? super IrBlockBody, Unit>)((Function1)arg_0 -> inlineClassDeclarationLowering.1.transformPrimaryConstructor$lambda$4$lambda$3(irConstructor, inlineClassLowering, initFunction, (IrBody)body, delegatingCtorCall, klass, setMemberField, arg_0)));
                    irSimpleFunction2 = irSimpleFunction3;
                } else {
                    irBlockBody = null;
                }
                irSimpleFunction2.setBody(irBlockBody);
                if (irConstructor.getBody() != null) {
                    irConstructor.setBody(IrFactoryHelpersKt.createBlockBody(this.this$0.getContext().getIrFactory(), -1, -1, (Function1<? super IrBlockBody, Unit>)((Function1)arg_0 -> inlineClassDeclarationLowering.1.transformPrimaryConstructor$lambda$7(delegatingCtorCall, setMemberField, arg_0))));
                }
                Object[] objectArray = new IrFunction[]{irConstructor, initFunction};
                return CollectionsKt.listOf((Object[])objectArray);
            }

            /*
             * WARNING - void declaration
             */
            private final void transformConstructorBody(IrConstructor irConstructor, IrSimpleFunction staticMethod) {
                IrBlockBody irBlockBody;
                if (irConstructor.isPrimary()) {
                    return;
                }
                IrClass irClass = IrUtilsKt.getParentAsClass(irConstructor);
                IrSimpleFunction irSimpleFunction = staticMethod;
                IrBody irBody = irConstructor.getBody();
                if (irBody != null) {
                    void constructorBody;
                    IrBody irBody2 = irBody;
                    InlineClassLowering inlineClassLowering = this.this$0;
                    IrBody irBody3 = irBody2;
                    IrSimpleFunction irSimpleFunction2 = irSimpleFunction;
                    boolean bl = false;
                    irBlockBody = IrFactoryHelpersKt.createBlockBody(inlineClassLowering.getContext().getIrFactory(), -1, -1, (Function1<? super IrBlockBody, Unit>)((Function1)arg_0 -> inlineClassDeclarationLowering.1.transformConstructorBody$lambda$12$lambda$11(inlineClassLowering, staticMethod, (IrBody)constructorBody, irConstructor, irClass, arg_0)));
                    irSimpleFunction = irSimpleFunction2;
                } else {
                    irBlockBody = null;
                }
                irSimpleFunction.setBody(irBlockBody);
            }

            /*
             * WARNING - void declaration
             */
            private final void transformMethodBodyFlat(IrSimpleFunction function, IrSimpleFunction staticMethod) {
                IrBlockBody irBlockBody;
                if (IrDeclarationsKt.isStaticMethodOfClass(function) || !AdditionalIrUtilsKt.isReal(function)) {
                    return;
                }
                IrSimpleFunction irSimpleFunction = staticMethod;
                IrBody irBody = function.getBody();
                if (irBody != null) {
                    void functionBody;
                    IrBody irBody2 = irBody;
                    InlineClassLowering inlineClassLowering = this.this$0;
                    IrBody irBody3 = irBody2;
                    IrSimpleFunction irSimpleFunction2 = irSimpleFunction;
                    boolean bl = false;
                    irBlockBody = IrFactoryHelpersKt.createBlockBody(inlineClassLowering.getContext().getIrFactory(), -1, -1, (Function1<? super IrBlockBody, Unit>)((Function1)arg_0 -> inlineClassDeclarationLowering.1.transformMethodBodyFlat$lambda$14$lambda$13((IrBody)functionBody, function, staticMethod, inlineClassLowering, arg_0)));
                    irSimpleFunction = irSimpleFunction2;
                } else {
                    irBlockBody = null;
                }
                irSimpleFunction.setBody(irBlockBody);
            }

            private final IrBlockBody delegateToStaticMethod(IrSimpleFunction function, IrSimpleFunction staticMethod) {
                return IrFactoryHelpersKt.createBlockBody(this.this$0.getContext().getIrFactory(), -1, -1, (Function1<? super IrBlockBody, Unit>)((Function1)arg_0 -> inlineClassDeclarationLowering.1.delegateToStaticMethod$lambda$17(this.this$0, function, staticMethod, arg_0)));
            }

            private static final IrTypeOperatorCallImpl transformPrimaryConstructor$lambda$4$lambda$3$lambda$2$unboxedInlineClassValue(IrBlockBodyBuilder builder, IrSimpleFunction initFunction, IrClass klass) {
                return ExpressionHelpersKt.irReinterpretCast(builder, ExpressionHelpersKt.irGet(builder, (IrValueDeclaration)CollectionsKt.single(initFunction.getValueParameters())), IrUtilsKt.getDefaultType(klass));
            }

            /*
             * WARNING - void declaration
             */
            private static final Unit transformPrimaryConstructor$lambda$4$lambda$3(IrConstructor $irConstructor, InlineClassLowering this$0, IrSimpleFunction $initFunction, IrBody $body, Ref.ObjectRef $delegatingCtorCall, IrClass $klass, Ref.ObjectRef $setMemberField, IrBlockBody $this$createBlockBody) {
                void this_$iv$iv$iv;
                void startOffset$iv$iv;
                void $this$irBlockBody$iv$iv;
                Intrinsics.checkNotNullParameter((Object)$this$createBlockBody, (String)"$this$createBlockBody");
                IrValueParameterSymbol origParameterSymbol = ((IrValueParameter)CollectionsKt.single($irConstructor.getValueParameters())).getSymbol();
                Collection collection = $this$createBlockBody.getStatements();
                IrGeneratorWithScope $this$irBlockBody$iv = LowerUtilsKt.createIrBuilder$default(this$0.getContext(), (IrSymbol)$initFunction.getSymbol(), 0, 0, 6, null);
                boolean $i$f$irBlockBody = false;
                IrGeneratorWithScope irGeneratorWithScope = $this$irBlockBody$iv;
                int n = ((IrElement)$initFunction).getStartOffset();
                int endOffset$iv$iv = ((IrElement)$initFunction).getEndOffset();
                boolean $i$f$irBlockBody2 = false;
                IrBlockBodyBuilder irBlockBodyBuilder = new IrBlockBodyBuilder($this$irBlockBody$iv$iv.getContext(), $this$irBlockBody$iv$iv.getScope(), (int)startOffset$iv$iv, endOffset$iv$iv);
                boolean $i$f$blockBody = false;
                void $this$transformPrimaryConstructor_u24lambda_u244_u24lambda_u243_u24lambda_u242 = this_$iv$iv$iv;
                boolean bl = false;
                void builder = $this$transformPrimaryConstructor_u24lambda_u244_u24lambda_u243_u24lambda_u242;
                Intrinsics.checkNotNull((Object)$body, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrBlockBody");
                IrElement $this$deepCopyWithSymbols_u24default$iv = (IrBlockBody)$body;
                boolean $i$f$deepCopyWithSymbols = false;
                IrElement $this$deepCopyImpl$iv$iv = $this$deepCopyWithSymbols_u24default$iv;
                boolean $i$f$deepCopyImpl = false;
                DeepCopySymbolRemapper symbolRemapper$iv$iv = new DeepCopySymbolRemapper(null, 1, null);
                IrVisitorsKt.acceptVoid($this$deepCopyImpl$iv$iv, symbolRemapper$iv$iv);
                DeepCopySymbolRemapper deepCopySymbolRemapper = symbolRemapper$iv$iv;
                boolean bl2 = false;
                ReferencedSymbolRemapper p0 = deepCopySymbolRemapper;
                TypeRemapper typeRemapper$iv$iv = new DeepCopyTypeRemapper(p0);
                IrElement irElement = $this$deepCopyImpl$iv$iv.transform(new DeepCopyIrTreeWithSymbols(symbolRemapper$iv$iv, typeRemapper$iv$iv, null, 4, null), null);
                if (irElement == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrBlockBody");
                }
                Iterable $this$forEach$iv = ((IrBlockBody)PatchDeclarationParentsKt.patchDeclarationParents((IrElement)((IrBlockBody)irElement), $initFunction)).getStatements();
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    IrStatement statement = (IrStatement)element$iv;
                    boolean bl3 = false;
                    $this$transformPrimaryConstructor_u24lambda_u244_u24lambda_u243_u24lambda_u242.unaryPlus(IrElementsKt.transformStatement(statement, new IrElementTransformerVoid((Ref.ObjectRef<IrDelegatingConstructorCall>)$delegatingCtorCall, $irConstructor, (IrBlockBodyBuilder)builder, $klass, (Ref.ObjectRef<IrSetField>)$setMemberField, $initFunction, origParameterSymbol){
                        final /* synthetic */ Ref.ObjectRef<IrDelegatingConstructorCall> $delegatingCtorCall;
                        final /* synthetic */ IrConstructor $irConstructor;
                        final /* synthetic */ IrBlockBodyBuilder $builder;
                        final /* synthetic */ IrClass $klass;
                        final /* synthetic */ Ref.ObjectRef<IrSetField> $setMemberField;
                        final /* synthetic */ IrSimpleFunction $initFunction;
                        final /* synthetic */ IrValueParameterSymbol $origParameterSymbol;
                        {
                            this.$delegatingCtorCall = $delegatingCtorCall;
                            this.$irConstructor = $irConstructor;
                            this.$builder = $builder;
                            this.$klass = $klass;
                            this.$setMemberField = $setMemberField;
                            this.$initFunction = $initFunction;
                            this.$origParameterSymbol = $origParameterSymbol;
                        }

                        /*
                         * WARNING - void declaration
                         */
                        public IrExpression visitDelegatingConstructorCall(IrDelegatingConstructorCall expression) {
                            void this_$iv$iv;
                            void $this$deepCopyWithSymbols_u24default$iv;
                            Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
                            IrElement irElement = expression;
                            IrDeclarationParent initialParent$iv = this.$irConstructor;
                            boolean $i$f$deepCopyWithSymbols = false;
                            void $this$deepCopyImpl$iv$iv = $this$deepCopyWithSymbols_u24default$iv;
                            boolean $i$f$deepCopyImpl = false;
                            Object symbolRemapper$iv$iv = new DeepCopySymbolRemapper(null, 1, null);
                            IrVisitorsKt.acceptVoid((IrElement)$this$deepCopyImpl$iv$iv, (IrElementVisitorVoid)symbolRemapper$iv$iv);
                            DeepCopySymbolRemapper deepCopySymbolRemapper = symbolRemapper$iv$iv;
                            Ref.ObjectRef<IrDelegatingConstructorCall> objectRef = this.$delegatingCtorCall;
                            boolean bl = false;
                            ReferencedSymbolRemapper p0 = deepCopySymbolRemapper;
                            TypeRemapper typeRemapper$iv$iv = new DeepCopyTypeRemapper(p0);
                            IrElement irElement2 = $this$deepCopyImpl$iv$iv.transform(new DeepCopyIrTreeWithSymbols((SymbolRemapper)symbolRemapper$iv$iv, typeRemapper$iv$iv, null, 4, null), null);
                            if (irElement2 == null) {
                                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrDelegatingConstructorCall");
                            }
                            objectRef.element = PatchDeclarationParentsKt.patchDeclarationParents((IrElement)((IrDelegatingConstructorCall)irElement2), initialParent$iv);
                            IrBuilderWithScope $this$irBlock_u24default$iv = this.$builder;
                            int startOffset$iv = $this$irBlock_u24default$iv.getStartOffset();
                            int endOffset$iv = $this$irBlock_u24default$iv.getEndOffset();
                            IrStatementOrigin origin$iv = null;
                            IrType resultType$iv = null;
                            boolean $i$f$irBlock = false;
                            symbolRemapper$iv$iv = new IrBlockBuilder($this$irBlock_u24default$iv.getContext(), $this$irBlock_u24default$iv.getScope(), startOffset$iv, endOffset$iv, origin$iv, resultType$iv, false, 64, null);
                            boolean $i$f$block = false;
                            void $this$visitDelegatingConstructorCall_u24lambda_u240 = this_$iv$iv;
                            boolean bl2 = false;
                            return this_$iv$iv.doBuild();
                        }

                        /*
                         * WARNING - void declaration
                         */
                        public IrExpression visitSetField(IrSetField expression) {
                            Object typeRemapper$iv$iv;
                            IrBuilderWithScope $this$deepCopyWithSymbols_u24default$iv;
                            Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
                            boolean isMemberFieldSet = Intrinsics.areEqual((Object)((IrField)expression.getSymbol().getOwner()).getParent(), (Object)this.$klass);
                            if (isMemberFieldSet) {
                                IrElement irElement = expression;
                                IrDeclarationParent initialParent$iv = this.$irConstructor;
                                boolean $i$f$deepCopyWithSymbols = false;
                                IrBuilderWithScope $this$deepCopyImpl$iv$iv = $this$deepCopyWithSymbols_u24default$iv;
                                boolean $i$f$deepCopyImpl = false;
                                DeepCopySymbolRemapper symbolRemapper$iv$iv = new DeepCopySymbolRemapper(null, 1, null);
                                IrVisitorsKt.acceptVoid((IrElement)((Object)$this$deepCopyImpl$iv$iv), symbolRemapper$iv$iv);
                                DeepCopySymbolRemapper deepCopySymbolRemapper = symbolRemapper$iv$iv;
                                Ref.ObjectRef<IrSetField> objectRef = this.$setMemberField;
                                boolean bl = false;
                                ReferencedSymbolRemapper p0 = deepCopySymbolRemapper;
                                typeRemapper$iv$iv = new DeepCopyTypeRemapper(p0);
                                IrElement irElement2 = $this$deepCopyImpl$iv$iv.transform(new DeepCopyIrTreeWithSymbols(symbolRemapper$iv$iv, (TypeRemapper)typeRemapper$iv$iv, null, 4, null), null);
                                if (irElement2 == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrSetField");
                                }
                                objectRef.element = PatchDeclarationParentsKt.patchDeclarationParents((IrElement)((IrSetField)irElement2), initialParent$iv);
                            }
                            this.transformChildrenVoid(expression);
                            if (isMemberFieldSet) {
                                void this_$iv$iv;
                                void $this$irBlock_u24default$iv;
                                $this$deepCopyWithSymbols_u24default$iv = this.$builder;
                                IrBlockBodyBuilder irBlockBodyBuilder = this.$builder;
                                int startOffset$iv = $this$irBlock_u24default$iv.getStartOffset();
                                int endOffset$iv = $this$irBlock_u24default$iv.getEndOffset();
                                IrStatementOrigin origin$iv = null;
                                IrType resultType$iv = null;
                                boolean $i$f$irBlock = false;
                                typeRemapper$iv$iv = new IrBlockBuilder($this$irBlock_u24default$iv.getContext(), $this$irBlock_u24default$iv.getScope(), startOffset$iv, endOffset$iv, origin$iv, resultType$iv, false, 64, null);
                                boolean $i$f$block = false;
                                void $this$visitSetField_u24lambda_u242 = this_$iv$iv;
                                boolean bl = false;
                                if (!org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.isPure$default(expression.getValue(), true, false, null, 6, null)) {
                                    void this_$iv$iv2;
                                    $this$visitSetField_u24lambda_u242.unaryPlus(expression.getValue());
                                    IrBuilderWithScope $this$irBlock_u24default$iv2 = irBlockBodyBuilder;
                                    int startOffset$iv2 = $this$irBlock_u24default$iv2.getStartOffset();
                                    int endOffset$iv2 = $this$irBlock_u24default$iv2.getEndOffset();
                                    IrStatementOrigin origin$iv2 = null;
                                    IrType resultType$iv2 = null;
                                    boolean $i$f$irBlock2 = false;
                                    IrBlockBuilder irBlockBuilder = new IrBlockBuilder($this$irBlock_u24default$iv2.getContext(), $this$irBlock_u24default$iv2.getScope(), startOffset$iv2, endOffset$iv2, origin$iv2, resultType$iv2, false, 64, null);
                                    boolean $i$f$block2 = false;
                                    void var22_27 = this_$iv$iv2;
                                    void var23_28 = $this$visitSetField_u24lambda_u242;
                                    boolean bl2 = false;
                                    var23_28.unaryPlus(this_$iv$iv2.doBuild());
                                }
                                return this_$iv$iv.doBuild();
                            }
                            return expression;
                        }

                        public IrExpression visitGetField(IrGetField expression) {
                            Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
                            this.transformChildrenVoid(expression);
                            if (Intrinsics.areEqual((Object)((IrField)expression.getSymbol().getOwner()).getParent(), (Object)this.$klass)) {
                                return ExpressionHelpersKt.irGet(this.$builder, (IrValueDeclaration)CollectionsKt.single(this.$initFunction.getValueParameters()));
                            }
                            return expression;
                        }

                        public IrExpression visitGetValue(IrGetValue expression) {
                            Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
                            this.transformChildrenVoid(expression);
                            if (Intrinsics.areEqual((Object)expression.getSymbol().getOwner().getParent(), (Object)this.$klass)) {
                                return inlineClassDeclarationLowering.1.access$transformPrimaryConstructor$lambda$4$lambda$3$lambda$2$unboxedInlineClassValue(this.$builder, this.$initFunction, this.$klass);
                            }
                            if (Intrinsics.areEqual((Object)expression.getSymbol(), (Object)this.$origParameterSymbol)) {
                                return ExpressionHelpersKt.irGet(this.$builder, (IrValueDeclaration)CollectionsKt.single(this.$initFunction.getValueParameters()));
                            }
                            return expression;
                        }

                        public IrExpression visitSetValue(IrSetValue expression) {
                            Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
                            this.transformChildrenVoid(expression);
                            if (Intrinsics.areEqual((Object)expression.getSymbol(), (Object)this.$origParameterSymbol)) {
                                return ExpressionHelpersKt.irSet$default((IrBuilderWithScope)this.$builder, (IrValueDeclaration)CollectionsKt.single(this.$initFunction.getValueParameters()), expression.getValue(), null, 4, null);
                            }
                            return expression;
                        }
                    }));
                }
                $this$transformPrimaryConstructor_u24lambda_u244_u24lambda_u243_u24lambda_u242.unaryPlus(ExpressionHelpersKt.irReturn((IrBuilderWithScope)$this$transformPrimaryConstructor_u24lambda_u244_u24lambda_u243_u24lambda_u242, inlineClassDeclarationLowering.1.transformPrimaryConstructor$lambda$4$lambda$3$lambda$2$unboxedInlineClassValue((IrBlockBodyBuilder)builder, $initFunction, $klass)));
                Iterable iterable = this_$iv$iv$iv.doBuild().getStatements();
                CollectionsKt.addAll((Collection)collection, (Iterable)iterable);
                return Unit.INSTANCE;
            }

            private static final Unit transformPrimaryConstructor$lambda$7(Ref.ObjectRef $delegatingCtorCall, Ref.ObjectRef $setMemberField, IrBlockBody $this$createBlockBody) {
                block1: {
                    IrDeclarationReference it;
                    Intrinsics.checkNotNullParameter((Object)$this$createBlockBody, (String)"$this$createBlockBody");
                    IrDelegatingConstructorCall irDelegatingConstructorCall = (IrDelegatingConstructorCall)$delegatingCtorCall.element;
                    if (irDelegatingConstructorCall != null) {
                        it = irDelegatingConstructorCall;
                        boolean bl = false;
                        ((Collection)$this$createBlockBody.getStatements()).add(it);
                    }
                    IrSetField irSetField = (IrSetField)$setMemberField.element;
                    if (irSetField == null) break block1;
                    it = irSetField;
                    boolean bl = false;
                    ((Collection)$this$createBlockBody.getStatements()).add(it);
                }
                return Unit.INSTANCE;
            }

            /*
             * WARNING - void declaration
             */
            private static final Unit transformConstructorBody$lambda$12$lambda$11(InlineClassLowering this$0, IrSimpleFunction $staticMethod, IrBody $constructorBody, IrConstructor $irConstructor, IrClass $irClass, IrBlockBody $this$createBlockBody) {
                IrVariable irVariable;
                void $this$associateByTo$iv$iv;
                void this_$iv$iv$iv;
                void startOffset$iv$iv;
                void $this$irBlockBody$iv$iv;
                Intrinsics.checkNotNullParameter((Object)$this$createBlockBody, (String)"$this$createBlockBody");
                Collection collection = $this$createBlockBody.getStatements();
                IrGeneratorWithScope $this$irBlockBody$iv = LowerUtilsKt.createIrBuilder$default(this$0.getContext(), (IrSymbol)$staticMethod.getSymbol(), 0, 0, 6, null);
                boolean $i$f$irBlockBody = false;
                IrGeneratorWithScope irGeneratorWithScope = $this$irBlockBody$iv;
                int n = ((IrElement)$staticMethod).getStartOffset();
                int endOffset$iv$iv = ((IrElement)$staticMethod).getEndOffset();
                boolean $i$f$irBlockBody2 = false;
                IrBlockBodyBuilder irBlockBodyBuilder = new IrBlockBodyBuilder($this$irBlockBody$iv$iv.getContext(), $this$irBlockBody$iv$iv.getScope(), (int)startOffset$iv$iv, endOffset$iv$iv);
                boolean $i$f$blockBody = false;
                void $this$transformConstructorBody_u24lambda_u2412_u24lambda_u2411_u24lambda_u2410 = this_$iv$iv$iv;
                boolean bl = false;
                Ref.ObjectRef thisVar = new Ref.ObjectRef();
                Iterable $this$associateBy$iv = $staticMethod.getValueParameters();
                boolean $i$f$associateBy = false;
                int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
                Iterable iterable = $this$associateBy$iv;
                Map destination$iv$iv = new LinkedHashMap<K, V>(capacity$iv);
                boolean $i$f$associateByTo = false;
                for (T element$iv$iv : $this$associateByTo$iv$iv) {
                    void it;
                    IrValueParameter irValueParameter = (IrValueParameter)element$iv$iv;
                    Map map = destination$iv$iv;
                    boolean bl2 = false;
                    map.put($irConstructor.getValueParameters().get(it.getIndex()).getSymbol(), element$iv$iv);
                }
                Map parameterMapping = destination$iv$iv;
                Intrinsics.checkNotNull((Object)$constructorBody, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrBlockBody");
                Iterable $this$forEach$iv = ((IrBlockBody)$constructorBody).getStatements();
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    IrStatement statement = (IrStatement)element$iv;
                    boolean bl3 = false;
                    $this$transformConstructorBody_u24lambda_u2412_u24lambda_u2411_u24lambda_u2410.unaryPlus(IrElementsKt.transformStatement(statement, new IrElementTransformerVoid($irClass, (IrBlockBodyBuilder)$this$transformConstructorBody_u24lambda_u2412_u24lambda_u2411_u24lambda_u2410, (Ref.ObjectRef<IrVariable>)thisVar, $staticMethod, parameterMapping, $irConstructor){
                        final /* synthetic */ IrClass $irClass;
                        final /* synthetic */ IrBlockBodyBuilder $this_irBlockBody;
                        final /* synthetic */ Ref.ObjectRef<IrVariable> $thisVar;
                        final /* synthetic */ IrSimpleFunction $staticMethod;
                        final /* synthetic */ Map<IrValueParameterSymbol, IrValueParameter> $parameterMapping;
                        final /* synthetic */ IrConstructor $irConstructor;
                        {
                            this.$irClass = $irClass;
                            this.$this_irBlockBody = $receiver;
                            this.$thisVar = $thisVar;
                            this.$staticMethod = $staticMethod;
                            this.$parameterMapping = $parameterMapping;
                            this.$irConstructor = $irConstructor;
                        }

                        /*
                         * WARNING - void declaration
                         */
                        public IrExpression visitDelegatingConstructorCall(IrDelegatingConstructorCall expression) {
                            IrVariable irVariable;
                            void this_$iv$iv$iv;
                            void startOffset$iv$iv;
                            void $this$irBlock$iv$iv;
                            void $this$irBlock_u24default$iv;
                            Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
                            this.transformChildrenVoid(expression);
                            expression.setType(IrUtilsKt.getDefaultType(this.$irClass));
                            IrGeneratorWithScope irGeneratorWithScope = this.$this_irBlockBody;
                            Ref.ObjectRef<IrVariable> objectRef = this.$thisVar;
                            IrClass irClass = this.$irClass;
                            IrSimpleFunction irSimpleFunction = this.$staticMethod;
                            IrStatementOrigin origin$iv = null;
                            IrType resultType$iv = ((IrExpression)expression).getType();
                            boolean $i$f$irBlock = false;
                            void var9_9 = $this$irBlock_u24default$iv;
                            int n = ((IrExpression)expression).getStartOffset();
                            int endOffset$iv$iv = ((IrExpression)expression).getEndOffset();
                            boolean $i$f$irBlock2 = false;
                            IrBlockBuilder irBlockBuilder = new IrBlockBuilder($this$irBlock$iv$iv.getContext(), $this$irBlock$iv$iv.getScope(), (int)startOffset$iv$iv, endOffset$iv$iv, origin$iv, resultType$iv, false, 64, null);
                            boolean $i$f$block = false;
                            void $this$visitDelegatingConstructorCall_u24lambda_u240 = this_$iv$iv$iv;
                            boolean bl = false;
                            objectRef.element = IrBuilderKt.createTmpVariable$default((IrStatementsBuilder)$this$visitDelegatingConstructorCall_u24lambda_u240, (IrExpression)expression, null, false, null, (IrType)IrUtilsKt.getDefaultType(irClass), 14, null);
                            if (objectRef.element == null) {
                                Intrinsics.throwUninitializedPropertyAccessException((String)"thisVar");
                                irVariable = null;
                            } else {
                                irVariable = (IrVariable)objectRef.element;
                            }
                            irVariable.setParent(irSimpleFunction);
                            return this_$iv$iv$iv.doBuild();
                        }

                        public IrExpression visitGetValue(IrGetValue expression) {
                            Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
                            this.transformChildrenVoid(expression);
                            IrValueParameter irValueParameter = this.$irClass.getThisReceiver();
                            if (Intrinsics.areEqual((Object)expression.getSymbol(), (Object)(irValueParameter != null ? irValueParameter.getSymbol() : null))) {
                                IrVariable irVariable;
                                IrBuilderWithScope irBuilderWithScope = this.$this_irBlockBody;
                                if (this.$thisVar.element == null) {
                                    Intrinsics.throwUninitializedPropertyAccessException((String)"thisVar");
                                    irVariable = null;
                                } else {
                                    irVariable = (IrVariable)this.$thisVar.element;
                                }
                                return ExpressionHelpersKt.irGet(irBuilderWithScope, irVariable);
                            }
                            IrValueParameter irValueParameter2 = this.$parameterMapping.get(expression.getSymbol());
                            if (irValueParameter2 != null) {
                                IrValueParameter irValueParameter3 = irValueParameter2;
                                IrBlockBodyBuilder irBlockBodyBuilder = this.$this_irBlockBody;
                                IrValueParameter it = irValueParameter3;
                                boolean bl = false;
                                return ExpressionHelpersKt.irGet(irBlockBodyBuilder, it);
                            }
                            return expression;
                        }

                        public IrExpression visitSetValue(IrSetValue expression) {
                            Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
                            this.transformChildrenVoid(expression);
                            IrValueParameter irValueParameter = this.$parameterMapping.get(expression.getSymbol());
                            if (irValueParameter != null) {
                                IrValueParameter irValueParameter2 = irValueParameter;
                                IrBlockBodyBuilder irBlockBodyBuilder = this.$this_irBlockBody;
                                IrValueParameter it = irValueParameter2;
                                boolean bl = false;
                                return ExpressionHelpersKt.irSet$default((IrBuilderWithScope)irBlockBodyBuilder, it.getSymbol(), expression.getValue(), null, 4, null);
                            }
                            return expression;
                        }

                        public IrStatement visitDeclaration(IrDeclarationBase declaration) {
                            Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
                            IrElementTransformerVoidKt.transformChildrenVoid(declaration, this);
                            if (Intrinsics.areEqual((Object)declaration.getParent(), (Object)this.$irConstructor)) {
                                declaration.setParent(this.$staticMethod);
                            }
                            return declaration;
                        }

                        /*
                         * WARNING - void declaration
                         */
                        public IrExpression visitReturn(IrReturn expression) {
                            Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
                            this.transformChildrenVoid(expression);
                            if (Intrinsics.areEqual((Object)expression.getReturnTargetSymbol(), (Object)this.$irConstructor.getSymbol())) {
                                IrVariable irVariable;
                                void $this$visitReturn_u24lambda_u243;
                                void this_$iv$iv;
                                void endOffset$iv;
                                void startOffset$iv;
                                void $this$irBlock_u24default$iv;
                                IrBuilderWithScope irBuilderWithScope = this.$this_irBlockBody;
                                int n = expression.getStartOffset();
                                int n2 = expression.getEndOffset();
                                Ref.ObjectRef<IrVariable> objectRef = this.$thisVar;
                                IrStatementOrigin origin$iv = null;
                                IrType resultType$iv = null;
                                boolean $i$f$irBlock = false;
                                IrBlockBuilder irBlockBuilder = new IrBlockBuilder($this$irBlock_u24default$iv.getContext(), $this$irBlock_u24default$iv.getScope(), (int)startOffset$iv, (int)endOffset$iv, origin$iv, resultType$iv, false, 64, null);
                                boolean $i$f$block = false;
                                void var11_11 = this_$iv$iv;
                                IrBuilderWithScope irBuilderWithScope2 = this.$this_irBlockBody;
                                boolean bl = false;
                                $this$visitReturn_u24lambda_u243.unaryPlus(expression.getValue());
                                IrBuilderWithScope irBuilderWithScope3 = (IrBuilderWithScope)$this$visitReturn_u24lambda_u243;
                                if (objectRef.element == null) {
                                    Intrinsics.throwUninitializedPropertyAccessException((String)"thisVar");
                                    irVariable = null;
                                } else {
                                    irVariable = (IrVariable)objectRef.element;
                                }
                                $this$visitReturn_u24lambda_u243.unaryPlus(ExpressionHelpersKt.irGet(irBuilderWithScope3, irVariable));
                                return ExpressionHelpersKt.irReturn(irBuilderWithScope2, this_$iv$iv.doBuild());
                            }
                            return expression;
                        }
                    }));
                }
                IrBuilderWithScope irBuilderWithScope = (IrBuilderWithScope)$this$transformConstructorBody_u24lambda_u2412_u24lambda_u2411_u24lambda_u2410;
                IrBuilderWithScope irBuilderWithScope2 = (IrBuilderWithScope)$this$transformConstructorBody_u24lambda_u2412_u24lambda_u2411_u24lambda_u2410;
                if (thisVar.element == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"thisVar");
                    irVariable = null;
                } else {
                    irVariable = (IrVariable)thisVar.element;
                }
                $this$transformConstructorBody_u24lambda_u2412_u24lambda_u2411_u24lambda_u2410.unaryPlus(ExpressionHelpersKt.irReturn(irBuilderWithScope, ExpressionHelpersKt.irGet(irBuilderWithScope2, irVariable)));
                Iterable iterable2 = this_$iv$iv$iv.doBuild().getStatements();
                CollectionsKt.addAll((Collection)collection, (Iterable)iterable2);
                return Unit.INSTANCE;
            }

            private static final Unit transformMethodBodyFlat$lambda$14$lambda$13(IrBody $functionBody, IrSimpleFunction $function, IrSimpleFunction $staticMethod, InlineClassLowering this$0, IrBlockBody $this$createBlockBody) {
                Intrinsics.checkNotNullParameter((Object)$this$createBlockBody, (String)"$this$createBlockBody");
                List<IrStatement> list = $this$createBlockBody.getStatements();
                Intrinsics.checkNotNull((Object)$functionBody, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrBlockBody");
                list.addAll((Collection<IrStatement>)((IrBlockBody)$functionBody).getStatements());
                IrElementTransformerVoidKt.transformChildrenVoid($this$createBlockBody, new IrElementTransformerVoid($function, $staticMethod, this$0){
                    final /* synthetic */ IrSimpleFunction $function;
                    final /* synthetic */ IrSimpleFunction $staticMethod;
                    final /* synthetic */ InlineClassLowering this$0;
                    {
                        this.$function = $function;
                        this.$staticMethod = $staticMethod;
                        this.this$0 = $receiver;
                    }

                    public IrStatement visitDeclaration(IrDeclarationBase declaration) {
                        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
                        IrElementTransformerVoidKt.transformChildrenVoid(declaration, this);
                        if (Intrinsics.areEqual((Object)declaration.getParent(), (Object)this.$function)) {
                            declaration.setParent(this.$staticMethod);
                        }
                        return declaration;
                    }

                    public IrExpression visitGetValue(IrGetValue expression) {
                        IrValueParameter irValueParameter;
                        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
                        IrValueDeclaration irValueDeclaration = expression.getSymbol().getOwner();
                        IrValueParameter irValueParameter2 = irValueDeclaration instanceof IrValueParameter ? (IrValueParameter)irValueDeclaration : null;
                        if (irValueParameter2 == null) {
                            return super.visitGetValue(expression);
                        }
                        IrValueParameter valueDeclaration = irValueParameter2;
                        IrBuilderWithScope irBuilderWithScope = LowerUtilsKt.createIrBuilder$default(this.this$0.getContext(), (IrSymbol)this.$staticMethod.getSymbol(), 0, 0, 6, null);
                        IrValueParameter irValueParameter3 = valueDeclaration;
                        if (Intrinsics.areEqual((Object)irValueParameter3, (Object)this.$function.getDispatchReceiverParameter()) || Intrinsics.areEqual((Object)irValueParameter3, (Object)IrUtilsKt.getParentAsClass(this.$function).getThisReceiver())) {
                            irValueParameter = this.$staticMethod.getValueParameters().get(0);
                        } else if (Intrinsics.areEqual((Object)irValueParameter3, (Object)this.$function.getExtensionReceiverParameter())) {
                            irValueParameter = this.$staticMethod.getValueParameters().get(1);
                        } else if (this.$function.getValueParameters().contains(irValueParameter3)) {
                            int offset = this.$function.getExtensionReceiverParameter() != null ? 2 : 1;
                            irValueParameter = this.$staticMethod.getValueParameters().get(valueDeclaration.getIndex() + offset);
                        } else {
                            return expression;
                        }
                        return ExpressionHelpersKt.irGet(irBuilderWithScope, irValueParameter);
                    }

                    public IrExpression visitSetValue(IrSetValue expression) {
                        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
                        IrValueDeclaration irValueDeclaration = expression.getSymbol().getOwner();
                        IrValueParameter irValueParameter = irValueDeclaration instanceof IrValueParameter ? (IrValueParameter)irValueDeclaration : null;
                        if (irValueParameter == null) {
                            return super.visitSetValue(expression);
                        }
                        IrValueParameter valueDeclaration = irValueParameter;
                        this.transformChildrenVoid(expression);
                        IrValueParameter irValueParameter2 = valueDeclaration;
                        if (!this.$function.getValueParameters().contains(irValueParameter2)) {
                            return expression;
                        }
                        int offset = this.$function.getExtensionReceiverParameter() != null ? 2 : 1;
                        return ExpressionHelpersKt.irSet$default((IrBuilderWithScope)LowerUtilsKt.createIrBuilder$default(this.this$0.getContext(), (IrSymbol)this.$staticMethod.getSymbol(), 0, 0, 6, null), this.$staticMethod.getValueParameters().get(valueDeclaration.getIndex() + offset).getSymbol(), expression.getValue(), null, 4, null);
                    }
                });
                return Unit.INSTANCE;
            }

            /*
             * WARNING - void declaration
             */
            private static final Unit delegateToStaticMethod$lambda$17(InlineClassLowering this$0, IrSimpleFunction $function, IrSimpleFunction $staticMethod, IrBlockBody $this$createBlockBody) {
                void $this$delegateToStaticMethod_u24lambda_u2417_u24lambda_u2416_u24lambda_u2415;
                IrFunctionAccessExpression irFunctionAccessExpression;
                void this_$iv$iv;
                Intrinsics.checkNotNullParameter((Object)$this$createBlockBody, (String)"$this$createBlockBody");
                Collection collection = $this$createBlockBody.getStatements();
                IrBuilderWithScope $this$irBlockBody_u24default$iv = LowerUtilsKt.createIrBuilder$default(this$0.getContext(), (IrSymbol)$function.getSymbol(), 0, 0, 6, null);
                int startOffset$iv = $this$irBlockBody_u24default$iv.getStartOffset();
                int endOffset$iv = $this$irBlockBody_u24default$iv.getEndOffset();
                boolean $i$f$irBlockBody = false;
                IrBlockBodyBuilder irBlockBodyBuilder = new IrBlockBodyBuilder($this$irBlockBody_u24default$iv.getContext(), $this$irBlockBody_u24default$iv.getScope(), startOffset$iv, endOffset$iv);
                boolean $i$f$blockBody = false;
                void $this$delegateToStaticMethod_u24lambda_u2417_u24lambda_u2416 = this_$iv$iv;
                boolean bl = false;
                IrFunctionAccessExpression irFunctionAccessExpression2 = irFunctionAccessExpression = ExpressionHelpersKt.irCall((IrBuilderWithScope)$this$delegateToStaticMethod_u24lambda_u2417_u24lambda_u2416, $staticMethod);
                IrBuilderWithScope irBuilderWithScope = (IrBuilderWithScope)$this$delegateToStaticMethod_u24lambda_u2417_u24lambda_u2416;
                void var16_16 = $this$delegateToStaticMethod_u24lambda_u2417_u24lambda_u2416;
                boolean bl2 = false;
                Object object = new IrValueParameter[2];
                Intrinsics.checkNotNull((Object)$function.getDispatchReceiverParameter());
                object[1] = $function.getExtensionReceiverParameter();
                List parameters = CollectionsKt.plus((Collection)CollectionsKt.listOfNotNull((Object[])object), (Iterable)$function.getValueParameters());
                object = ((Iterable)parameters).iterator();
                int n = 0;
                while (object.hasNext()) {
                    int index = n++;
                    IrValueParameter valueParameter = (IrValueParameter)object.next();
                    $this$delegateToStaticMethod_u24lambda_u2417_u24lambda_u2416_u24lambda_u2415.putValueArgument(index, ExpressionHelpersKt.irGet((IrBuilderWithScope)$this$delegateToStaticMethod_u24lambda_u2417_u24lambda_u2416, valueParameter));
                }
                List typeParameters = CollectionsKt.plus((Collection)IrTypeSystemContextKt.extractTypeParameters(IrUtilsKt.getParentAsClass($function)), (Iterable)$function.getTypeParameters());
                Iterator<T> iterator = ((Iterable)typeParameters).iterator();
                int n2 = 0;
                while (iterator.hasNext()) {
                    int index = n2++;
                    IrTypeParameter typeParameter = (IrTypeParameter)iterator.next();
                    $this$delegateToStaticMethod_u24lambda_u2417_u24lambda_u2416_u24lambda_u2415.putTypeArgument(index, new IrSimpleTypeImpl((IrClassifierSymbol)typeParameter.getSymbol(), SimpleTypeNullability.NOT_SPECIFIED, CollectionsKt.emptyList(), CollectionsKt.emptyList(), null, 16, null));
                }
                Unit unit = Unit.INSTANCE;
                var16_16.unaryPlus(ExpressionHelpersKt.irReturn(irBuilderWithScope, irFunctionAccessExpression));
                Iterable iterable = this_$iv$iv.doBuild().getStatements();
                CollectionsKt.addAll((Collection)collection, (Iterable)iterable);
                return Unit.INSTANCE;
            }

            public static final /* synthetic */ IrTypeOperatorCallImpl access$transformPrimaryConstructor$lambda$4$lambda$3$lambda$2$unboxedInlineClassValue(IrBlockBodyBuilder builder, IrSimpleFunction initFunction, IrClass klass) {
                return inlineClassDeclarationLowering.1.transformPrimaryConstructor$lambda$4$lambda$3$lambda$2$unboxedInlineClassValue(builder, initFunction, klass);
            }
        };
        this.inlineClassUsageLowering = new BodyLoweringPass(this){
            final /* synthetic */ InlineClassLowering this$0;
            {
                this.this$0 = $receiver;
            }

            public void lower(IrBody irBody, IrDeclaration container) {
                Intrinsics.checkNotNullParameter((Object)irBody, (String)"irBody");
                Intrinsics.checkNotNullParameter((Object)container, (String)"container");
                IrElementTransformerVoidKt.transformChildrenVoid(irBody, new IrElementTransformerVoid(this.this$0){
                    final /* synthetic */ InlineClassLowering this$0;
                    {
                        this.this$0 = $receiver;
                    }

                    public IrExpression visitConstructorCall(IrConstructorCall expression) {
                        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
                        IrElementTransformerVoidKt.transformChildrenVoid(expression, this);
                        IrConstructor function = (IrConstructor)expression.getSymbol().getOwner();
                        if (!InlineClassLowering.access$isClassInlineLike(this.this$0, IrUtilsKt.getParentAsClass(function))) {
                            return expression;
                        }
                        return IrUtilsKt.irCall$default((IrFunctionAccessExpression)expression, InlineClassLowering.access$getOrCreateStaticMethod(this.this$0, function), false, false, null, null, 60, null);
                    }

                    public IrExpression visitCall(IrCall expression) {
                        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
                        IrElementTransformerVoidKt.transformChildrenVoid(expression, this);
                        IrSimpleFunction function = (IrSimpleFunction)expression.getSymbol().getOwner();
                        if (!(function.getParent() instanceof IrClass) || IrDeclarationsKt.isStaticMethodOfClass(function) || !InlineClassLowering.access$isClassInlineLike(this.this$0, IrUtilsKt.getParentAsClass(function)) || !AdditionalIrUtilsKt.isReal(function)) {
                            return expression;
                        }
                        return IrUtilsKt.irCall$default((IrFunctionAccessExpression)expression, InlineClassLowering.access$getOrCreateStaticMethod(this.this$0, function), true, false, null, null, 56, null);
                    }

                    public IrExpression visitDelegatingConstructorCall(IrDelegatingConstructorCall expression) {
                        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
                        IrElementTransformerVoidKt.transformChildrenVoid(expression, this);
                        IrConstructor function = (IrConstructor)expression.getSymbol().getOwner();
                        IrClass klass = IrUtilsKt.getParentAsClass(function);
                        return !InlineClassLowering.access$isClassInlineLike(this.this$0, klass) ? (IrExpression)expression : (IrExpression)IrUtilsKt.irCall$default((IrFunctionAccessExpression)expression, InlineClassLowering.access$getOrCreateStaticMethod(this.this$0, function), false, false, null, null, 60, null);
                    }
                });
            }
        };
    }

    @NotNull
    public final CommonBackendContext getContext() {
        return this.context;
    }

    private final boolean isClassInlineLike(IrClass irClass) {
        return this.context.getInlineClassesUtils().isClassInlineLike(irClass);
    }

    @NotNull
    public final DeclarationTransformer getInlineClassDeclarationLowering() {
        return this.inlineClassDeclarationLowering;
    }

    private final IrSimpleFunction getOrCreateStaticMethod(IrFunction function) {
        return MappingsKt.getOrPut(this.transformedFunction, (IrDeclaration)function, () -> InlineClassLowering.getOrCreateStaticMethod$lambda$0(this, function));
    }

    @NotNull
    public final BodyLoweringPass getInlineClassUsageLowering() {
        return this.inlineClassUsageLowering;
    }

    private final Name toInlineClassImplementationName(IrFunction $this$toInlineClassImplementationName) {
        Name name;
        String newName = IrUtilsKt.getParentAsClass($this$toInlineClassImplementationName).getName().asString() + "__" + $this$toInlineClassImplementationName.getName().asString() + "-impl";
        if ($this$toInlineClassImplementationName.getName().isSpecial()) {
            Name name2 = Name.special((String)('<' + newName + '>'));
            name = name2;
            Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"special(...)");
        } else {
            Name name3 = Name.identifier((String)newName);
            name = name3;
            Intrinsics.checkNotNullExpressionValue((Object)name3, (String)"identifier(...)");
        }
        return name;
    }

    private final IrSimpleFunction createStaticBodilessMethod(IrFunction function) {
        return IrUtilsKt.createStaticFunctionWithReceivers$default(this.context.getIrFactory(), function.getParent(), this.toInlineClassImplementationName(function), function, null, null, null, null, false, false, IrTypeSystemContextKt.extractTypeParameters(IrUtilsKt.getParentAsClass(function)), (Function3)new Function3<IrFunction, IrFunction, Map<IrValueParameter, ? extends IrValueParameter>, Unit>((Object)this.context){

            public final void invoke(IrFunction p0, IrFunction p1, Map<IrValueParameter, ? extends IrValueParameter> p2) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                ((CommonBackendContext)this.receiver).remapMultiFieldValueClassStructure(p0, p1, p2);
            }

            public final String getSignature() {
                return "remapMultiFieldValueClassStructure(Lorg/jetbrains/kotlin/ir/declarations/IrFunction;Lorg/jetbrains/kotlin/ir/declarations/IrFunction;Ljava/util/Map;)V";
            }

            public final String getName() {
                return "remapMultiFieldValueClassStructure";
            }

            public final KDeclarationContainer getOwner() {
                return (KDeclarationContainer)Reflection.getOrCreateKotlinClass(CommonBackendContext.class);
            }
        }, 504, null);
    }

    private static final IrSimpleFunction getOrCreateStaticMethod$lambda$0(InlineClassLowering this$0, IrFunction $function) {
        return this$0.createStaticBodilessMethod($function);
    }

    public static final /* synthetic */ boolean access$isClassInlineLike(InlineClassLowering $this, IrClass irClass) {
        return $this.isClassInlineLike(irClass);
    }

    public static final /* synthetic */ IrSimpleFunction access$getOrCreateStaticMethod(InlineClassLowering $this, IrFunction function) {
        return $this.getOrCreateStaticMethod(function);
    }
}

