/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.performancePlugin.commands;

import com.intellij.concurrency.JobLauncher;
import com.intellij.diagnostic.CoreAttachmentFactory;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.RuntimeExceptionWithAttachments;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.playback.PlaybackContext;
import com.intellij.openapi.ui.playback.commands.AbstractCommand;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.SerializationManagerEx;
import com.intellij.psi.stubs.SerializationManagerImpl;
import com.intellij.psi.stubs.SerializedStubTree;
import com.intellij.psi.stubs.StubForwardIndexExternalizer;
import com.intellij.psi.stubs.StubUpdatingIndex;
import com.intellij.util.Processors;
import com.intellij.util.SystemProperties;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.FileBasedIndexImpl;
import com.intellij.util.indexing.FileBasedIndexInfrastructureExtension;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.IndexDataComparer;
import com.intellij.util.indexing.IndexDataPresenter;
import com.intellij.util.indexing.IndexingBundle;
import com.intellij.util.indexing.SingleEntryFileBasedIndexExtension;
import com.intellij.util.indexing.UpdatableIndex;
import com.intellij.util.indexing.ValueContainer;
import com.intellij.util.indexing.diagnostic.dump.IndexContentDiagnostic;
import com.intellij.util.indexing.diagnostic.dump.IndexContentDiagnosticDumper;
import com.intellij.util.indexing.diagnostic.dump.paths.IndexedFilePath;
import com.intellij.util.indexing.diagnostic.dump.paths.IndexedFilePaths;
import com.intellij.util.indexing.diagnostic.dump.paths.PortableFilePath;
import com.intellij.util.indexing.diagnostic.dump.paths.PortableFilePathsKt;
import com.intellij.util.indexing.impl.storage.IndexStorageLayoutLocator;
import com.intellij.util.indexing.impl.storage.VfsAwareMapReduceIndex;
import com.intellij.util.progress.ConcurrentTasksProgressManager;
import com.intellij.util.progress.SubTaskProgressIndicator;
import com.jetbrains.performancePlugin.PerformanceTestingBundle;
import com.jetbrains.performancePlugin.commands.CompareIndices;
import com.jetbrains.performancePlugin.commands.CompareIndicesKt;
import com.jetbrains.performancePlugin.commands.StoreIndices;
import com.jetbrains.performancePlugin.commands.StoredIndexedFileResolver;
import com.jetbrains.performancePlugin.utils.ActionCallbackProfilerStopper;
import com.jetbrains.performancePlugin.utils.errors.ErrorCollector;
import com.jetbrains.performancePlugin.utils.errors.ToDirectoryWritingErrorCollector;
import com.jetbrains.performancePlugin.utils.indexes.CurrentIndexedFileResolver;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00c4\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u0000 X2\u00020\u0001:\u0002XYB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0016\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00180\u00172\u0006\u0010\u0019\u001a\u00020\u001aH\u0014J`\u0010\u001b\u001a\u00020\u001c\"\u0004\b\u0000\u0010\u001d\"\u0004\b\u0001\u0010\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0012\u0010!\u001a\u000e\u0012\u0004\u0012\u0002H\u001d\u0012\u0004\u0012\u0002H\u001e0\"2\u0012\u0010#\u001a\u000e\u0012\u0004\u0012\u0002H\u001d\u0012\u0004\u0012\u0002H\u001e0$2\u0012\u0010%\u001a\u000e\u0012\u0004\u0012\u0002H\u001d\u0012\u0004\u0012\u0002H\u001e0$2\u0006\u0010&\u001a\u00020'H\u0002J0\u0010(\u001a\u00020\u00032\u0006\u0010)\u001a\u00020\u00032\u000e\u0010!\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\"2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010&\u001a\u00020'H\u0002J\u0080\u0001\u0010*\u001a\u00020\u001c\"\u0004\b\u0000\u0010\u001d\"\u0004\b\u0001\u0010\u001e2\u0012\u0010!\u001a\u000e\u0012\u0004\u0012\u0002H\u001d\u0012\u0004\u0012\u0002H\u001e0\"2\u001c\u0010+\u001a\u0018\u0012\u0004\u0012\u0002H\u001d\u0012\u0004\u0012\u0002H\u001e\u0012\u0004\u0012\u00020-\u0012\u0002\b\u00030,2\f\u0010.\u001a\b\u0012\u0004\u0012\u00020 0\u000e2\f\u0010/\u001a\b\u0012\u0004\u0012\u0002H\u001d0\b2\f\u00100\u001a\b\u0012\u0004\u0012\u0002H\u001d0\b2\u0006\u00101\u001a\u0002022\u0006\u0010&\u001a\u00020'H\u0002JV\u00103\u001a\u00020\u001c\"\u0004\b\u0000\u0010\u001d\"\u0004\b\u0001\u0010\u001e2\f\u0010.\u001a\b\u0012\u0004\u0012\u00020 0\u000e2\u0012\u0010!\u001a\u000e\u0012\u0004\u0012\u0002H\u001d\u0012\u0004\u0012\u0002H\u001e0\"2\u0006\u00104\u001a\u0002052\u0006\u00106\u001a\u0002072\u0006\u00101\u001a\u0002022\u0006\u0010&\u001a\u00020'H\u0002J|\u00108\u001a\u00020\u001c\"\u0004\b\u0000\u0010\u001d\"\u0004\b\u0001\u0010\u001e2\u0006\u0010\u001f\u001a\u00020 2\u001c\u00109\u001a\u0018\u0012\u0004\u0012\u0002H\u001d\u0012\u0004\u0012\u0002H\u001e\u0012\u0004\u0012\u00020-\u0012\u0002\b\u00030,2\u001c\u0010+\u001a\u0018\u0012\u0004\u0012\u0002H\u001d\u0012\u0004\u0012\u0002H\u001e\u0012\u0004\u0012\u00020-\u0012\u0002\b\u00030,2\u0012\u0010!\u001a\u000e\u0012\u0004\u0012\u0002H\u001d\u0012\u0004\u0012\u0002H\u001e0\"2\u0006\u00101\u001a\u0002022\u0006\u0010&\u001a\u00020'H\u0002J\u008a\u0001\u0010:\u001a\u00020\u001c\"\u0004\b\u0000\u0010\u001d\"\u0004\b\u0001\u0010\u001e2\u0012\u0010!\u001a\u000e\u0012\u0004\u0012\u0002H\u001d\u0012\u0004\u0012\u0002H\u001e0\"2\f\u0010.\u001a\b\u0012\u0004\u0012\u00020 0\u000e2\u001c\u00109\u001a\u0018\u0012\u0004\u0012\u0002H\u001d\u0012\u0004\u0012\u0002H\u001e\u0012\u0004\u0012\u00020-\u0012\u0002\b\u00030,2\u001c\u0010+\u001a\u0018\u0012\u0004\u0012\u0002H\u001d\u0012\u0004\u0012\u0002H\u001e\u0012\u0004\u0012\u00020-\u0012\u0002\b\u00030,2\u0006\u00101\u001a\u0002022\u0006\u00106\u001a\u0002072\u0006\u0010&\u001a\u00020'H\u0002J \u0010;\u001a\u00020\u001c2\u0006\u00104\u001a\u0002052\u0006\u00106\u001a\u0002072\u0006\u0010&\u001a\u00020'H\u0002J\u008a\u0001\u0010<\u001a\u00020\u001c\"\u0004\b\u0000\u0010\u001d\"\u0004\b\u0001\u0010\u001e2\u0012\u0010!\u001a\u000e\u0012\u0004\u0012\u0002H\u001d\u0012\u0004\u0012\u0002H\u001e0\"2\f\u0010.\u001a\b\u0012\u0004\u0012\u00020 0\u000e2\u001c\u0010+\u001a\u0018\u0012\u0004\u0012\u0002H\u001d\u0012\u0004\u0012\u0002H\u001e\u0012\u0004\u0012\u00020-\u0012\u0002\b\u00030,2\u001c\u00109\u001a\u0018\u0012\u0004\u0012\u0002H\u001d\u0012\u0004\u0012\u0002H\u001e\u0012\u0004\u0012\u00020-\u0012\u0002\b\u00030,2\u0006\u00101\u001a\u0002022\u0006\u00106\u001a\u0002072\u0006\u0010&\u001a\u00020'H\u0002J \u0010=\u001a\b\u0012\u0004\u0012\u00020>0\u000e2\u0006\u0010\u001f\u001a\u00020 2\b\b\u0002\u0010?\u001a\u00020\u0003H\u0002J \u0010@\u001a\b\u0012\u0004\u0012\u00020>0\u000e2\u0006\u0010\u001f\u001a\u00020 2\b\b\u0002\u0010?\u001a\u00020\u0003H\u0002J(\u0010A\u001a\u00020B2\u0006\u0010C\u001a\u00020D2\u000e\u0010!\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\"2\u0006\u0010&\u001a\u00020'H\u0002J\u0016\u0010E\u001a\b\u0012\u0004\u0012\u00020D0\u000e2\u0006\u0010C\u001a\u00020DH\u0002J4\u0010F\u001a\u0016\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\"\u0012\u0004\u0012\u00020G0\u00132\u000e\u0010H\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030I2\u0006\u00104\u001a\u000205H\u0002J\b\u0010J\u001a\u000205H\u0002J\b\u0010K\u001a\u000205H\u0002J \u0010L\u001a\u00020B2\u000e\u0010!\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\"2\u0006\u0010\u001f\u001a\u00020 H\u0002J \u0010L\u001a\u00020B2\u000e\u0010!\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\"2\u0006\u0010M\u001a\u00020\u0003H\u0002JB\u0010N\u001a\u0014\u0012\u0004\u0012\u0002H\u001d\u0012\u0004\u0012\u0002H\u001e\u0012\u0004\u0012\u00020P0O\"\u0004\b\u0000\u0010\u001d\"\u0004\b\u0001\u0010\u001e2\u0006\u00104\u001a\u0002052\u0012\u0010!\u001a\u000e\u0012\u0004\u0012\u0002H\u001d\u0012\u0004\u0012\u0002H\u001e0\"H\u0002J.\u0010Q\u001a\b\u0012\u0004\u0012\u00020 0\u000e2\u0006\u0010R\u001a\u00020S2\u0006\u00101\u001a\u0002022\u0006\u00106\u001a\u0002072\u0006\u0010&\u001a\u00020'H\u0002J&\u0010T\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u0001H\u001e0$\"\u0004\b\u0000\u0010\u001e*\b\u0012\u0004\u0012\u0002H\u001e0UH\u0002J\u0014\u0010V\u001a\u00020\u0003*\u00020\u00032\u0006\u0010W\u001a\u00020\u0003H\u0002R!\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00030\b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\t\u0010\nR!\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00030\u000e8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\f\u001a\u0004\b\u000f\u0010\u0010R-\u0010\u0012\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u00130\u000e8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0015\u0010\f\u001a\u0004\b\u0014\u0010\u0010\u00a8\u0006Z"}, d2={"Lcom/jetbrains/performancePlugin/commands/CompareIndices;", "Lcom/intellij/openapi/ui/playback/commands/AbstractCommand;", "text", "", "line", "", "(Ljava/lang/String;I)V", "fileTypesWithNoStubTree", "", "getFileTypesWithNoStubTree", "()Ljava/util/Set;", "fileTypesWithNoStubTree$delegate", "Lkotlin/Lazy;", "ignoredFilesPatterns", "", "getIgnoredFilesPatterns", "()Ljava/util/List;", "ignoredFilesPatterns$delegate", "ignoredPatternsForReporting", "Lkotlin/Pair;", "getIgnoredPatternsForReporting", "ignoredPatternsForReporting$delegate", "_execute", "Lorg/jetbrains/concurrency/Promise;", "", "context", "Lcom/intellij/openapi/ui/playback/PlaybackContext;", "assertForwardIndexDataAreTheSameForFile", "", "K", "V", "fileDescriptor", "Lcom/jetbrains/performancePlugin/commands/CompareIndices$FileDescriptor;", "extension", "Lcom/intellij/util/indexing/FileBasedIndexExtension;", "expectedData0", "", "actualData0", "project", "Lcom/intellij/openapi/project/Project;", "buildFileDataMismatchMessage", "reason", "checkNoKeysAreMissing", "storedIndex", "Lcom/intellij/util/indexing/UpdatableIndex;", "Lcom/intellij/util/indexing/FileContent;", "resolvedFiles", "allStoredKeys", "allCurrentKeys", "errorCollector", "Lcom/jetbrains/performancePlugin/utils/errors/ErrorCollector;", "compareCurrentAndStoredIndexData", "storedIndexDir", "Ljava/nio/file/Path;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "compareFileData", "currentIndex", "compareForwardIndexes", "compareIndexes", "compareInvertedIndexes", "createAttachmentsForActualFile", "Lcom/intellij/openapi/diagnostic/Attachment;", "pathPrefix", "createAttachmentsForExpectedFile", "doesFileHaveProvidedIndex", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "findFileAndAllRelevantSiblings", "findFileBasedIndexExtension", "Lcom/intellij/openapi/Disposable;", "id", "Lcom/intellij/util/indexing/ID;", "getFailureDiagnosticDirectory", "getStoredIndicesDirectory", "isKnownError", "fileNameOrIndexData", "openStoredIndex", "Lcom/intellij/util/indexing/impl/storage/VfsAwareMapReduceIndex;", "Lcom/intellij/util/indexing/impl/storage/VfsAwareMapReduceIndex$IndexerIdHolder;", "resolveFiles", "storedIndexedFileResolver", "Lcom/jetbrains/performancePlugin/commands/StoredIndexedFileResolver;", "toMap", "Lcom/intellij/util/indexing/ValueContainer;", "withIndent", "indent", "Companion", "FileDescriptor", "intellij.performanceTesting"})
@SourceDebugExtension(value={"SMAP\nCompareIndices.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CompareIndices.kt\ncom/jetbrains/performancePlugin/commands/CompareIndices\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 6 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 7 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 8 ArrayIntrinsics.kt\nkotlin/ArrayIntrinsicsKt\n+ 9 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,692:1\n1#2:693\n1271#3,2:694\n1285#3,4:696\n1446#3,5:711\n1194#3,2:716\n1222#3,4:718\n1194#3,2:722\n1222#3,4:724\n1238#3,4:730\n1238#3,4:736\n1855#3,2:742\n1855#3,2:744\n1549#3:746\n1620#3,3:747\n1549#3:750\n1620#3,3:751\n1747#3,3:761\n494#4,7:700\n453#4:728\n403#4:729\n453#4:734\n403#4:735\n125#5:707\n152#5,3:708\n37#6,2:740\n18#6:756\n1247#7,2:754\n26#8:757\n3792#9:758\n4307#9,2:759\n*S KotlinDebug\n*F\n+ 1 CompareIndices.kt\ncom/jetbrains/performancePlugin/commands/CompareIndices\n*L\n190#1:694,2\n190#1:696,4\n261#1:711,5\n376#1:716,2\n376#1:718,4\n428#1:722,2\n428#1:724,4\n543#1:730,4\n544#1:736,4\n588#1:742,2\n600#1:744,2\n610#1:746\n610#1:747,3\n617#1:750\n617#1:751,3\n271#1:761,3\n223#1:700,7\n543#1:728\n543#1:729\n544#1:734\n544#1:735\n223#1:707\n223#1:708,3\n581#1:740,2\n659#1:756\n648#1:754,2\n659#1:757\n659#1:758\n659#1:759,2\n*E\n"})
public final class CompareIndices
extends AbstractCommand {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final Lazy ignoredFilesPatterns$delegate;
    @NotNull
    private final Lazy ignoredPatternsForReporting$delegate;
    @NotNull
    private final Lazy fileTypesWithNoStubTree$delegate;
    private static final int LIMIT_OF_ERRORS_PER_COLLECTOR = 100;

    public CompareIndices(@NotNull String text2, int line) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        super(text2, line);
        this.ignoredFilesPatterns$delegate = LazyKt.lazy((Function0)ignoredFilesPatterns.2.INSTANCE);
        this.ignoredPatternsForReporting$delegate = LazyKt.lazy((Function0)ignoredPatternsForReporting.2.INSTANCE);
        this.fileTypesWithNoStubTree$delegate = LazyKt.lazy((Function0)fileTypesWithNoStubTree.2.INSTANCE);
    }

    @NotNull
    protected Promise<Object> _execute(@NotNull PlaybackContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        ActionCallbackProfilerStopper actionCallback = new ActionCallbackProfilerStopper();
        Path storedIndexDir = this.getStoredIndicesDirectory();
        Project project = context.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        DumbService.Companion.getInstance(project2).smartInvokeLater(() -> CompareIndices._execute$lambda$0(project2, actionCallback, this, storedIndexDir));
        return Promises.toPromise((ActionCallback)actionCallback);
    }

    private final Path getStoredIndicesDirectory() {
        String property;
        String string = property = System.getProperty("compare.indices.command.stored.indexes.directory");
        if (string == null) {
            boolean bl = false;
            String string2 = "Path to stored indices is not specified";
            throw new IllegalStateException(string2.toString());
        }
        String it = string;
        boolean bl = false;
        Path path = Paths.get(it, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"let(...)");
        return path;
    }

    private final Path getFailureDiagnosticDirectory() {
        String property = System.getProperty("compare.indices.command.failure.diagnostic.directory");
        if (property != null) {
            Path path = Paths.get(property, new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
            return path;
        }
        Path path = FileUtil.createTempDirectory((String)"compare-indices", (String)"failure").toPath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toPath(...)");
        return path;
    }

    private final List<String> getIgnoredFilesPatterns() {
        Lazy lazy = this.ignoredFilesPatterns$delegate;
        return (List)lazy.getValue();
    }

    private final List<Pair<String, String>> getIgnoredPatternsForReporting() {
        Lazy lazy = this.ignoredPatternsForReporting$delegate;
        return (List)lazy.getValue();
    }

    private final Set<String> getFileTypesWithNoStubTree() {
        Lazy lazy = this.fileTypesWithNoStubTree$delegate;
        return (Set)lazy.getValue();
    }

    /*
     * WARNING - void declaration
     */
    private final void compareIndexes(Path storedIndexDir, ProgressIndicator indicator, Project project) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Object object;
        Path failureDiagnosticDirectory = this.getFailureDiagnosticDirectory();
        FileBasedIndex fileBasedIndex = FileBasedIndex.getInstance();
        Intrinsics.checkNotNull((Object)fileBasedIndex, (String)"null cannot be cast to non-null type com.intellij.util.indexing.FileBasedIndexImpl");
        ((FileBasedIndexImpl)fileBasedIndex).flushIndexes();
        indicator.setText(IndexingBundle.message((String)"index.content.diagnostic.reading", (Object[])new Object[0]));
        IndexContentDiagnostic storedIndexContentDiagnostic = IndexContentDiagnosticDumper.INSTANCE.readFrom(StoreIndices.Companion.getFileForDiagnostic(storedIndexDir));
        StoredIndexedFileResolver storedIndexedFileResolver = new StoredIndexedFileResolver(storedIndexContentDiagnostic);
        Path path = failureDiagnosticDirectory.resolve("files-resolution-errors");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        ToDirectoryWritingErrorCollector filesErrorCollector = new ToDirectoryWritingErrorCollector("resolve-files", path, 100);
        List<FileDescriptor> resolvedFiles = this.resolveFiles(storedIndexedFileResolver, filesErrorCollector, indicator, project);
        if (filesErrorCollector.getNumberOfErrors() > 0) {
            throw new IllegalArgumentException("Some files cannot be resolved. See <failure-diagnostics-dir>/files-resolution-errors");
        }
        CompareIndicesKt.access$getLOG$p().info("Stored index directory contains: " + StoreIndices.Companion.dumpDirectory(storedIndexDir));
        List idsToCompare2 = SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)FileBasedIndexExtension.EXTENSION_POINT_NAME.getExtensionList()), (Function1)compareIndexes.idsToCompare.1.INSTANCE), (Function1)compareIndexes.idsToCompare.2.INSTANCE));
        CompareIndicesKt.access$getLOG$p().info("Comparing indexes concurrently");
        Iterable $this$associateWith$iv = idsToCompare2;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            ID iD = (ID)element$iv$iv;
            Object t = element$iv$iv;
            object = result$iv;
            boolean bl = false;
            String string = iD.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            Path path2 = failureDiagnosticDirectory.resolve("errors-for-" + iD.getName());
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"resolve(...)");
            ToDirectoryWritingErrorCollector toDirectoryWritingErrorCollector = new ToDirectoryWritingErrorCollector(string, path2, 100);
            object.put(t, toDirectoryWritingErrorCollector);
        }
        Map errorCollectors = result$iv;
        AtomicInteger finishedCounter = new AtomicInteger();
        ConcurrentTasksProgressManager comparisonTaskProgressManager = new ConcurrentTasksProgressManager(indicator, idsToCompare2.size());
        JobLauncher.getInstance().invokeConcurrentlyUnderProgress(idsToCompare2, indicator, arg_0 -> CompareIndices.compareIndexes$lambda$6(comparisonTaskProgressManager, errorCollectors, this, resolvedFiles, storedIndexDir, project, finishedCounter, idsToCompare2, arg_0));
        Map $this$filterValues$iv = errorCollectors;
        boolean $i$f$filterValues = false;
        LinkedHashMap result$iv2 = new LinkedHashMap();
        for (Map.Entry entry : $this$filterValues$iv.entrySet()) {
            ToDirectoryWritingErrorCollector it = (ToDirectoryWritingErrorCollector)entry.getValue();
            boolean bl = false;
            if (!(it.getNumberOfErrors() > 0)) continue;
            result$iv2.put(entry.getKey(), entry.getValue());
        }
        $this$filterValues$iv = result$iv2;
        boolean $i$f$map = false;
        result$iv2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean bl = false;
        Iterator iterator2 = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            void it;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator2.next();
            object = destination$iv$iv;
            boolean bl2 = false;
            object.add((ID)it.getKey());
        }
        List failedIndexes = (List)destination$iv$iv;
        if (!((Collection)failedIndexes).isEmpty()) {
            throw new RuntimeException("Comparison has failed for indexes [" + CollectionsKt.joinToString$default((Iterable)failedIndexes, null, null, null, (int)0, null, (Function1)compareIndexes.2.INSTANCE, (int)31, null) + "]. Details are saved to " + failureDiagnosticDirectory);
        }
        CompareIndicesKt.access$getLOG$p().info("Success. All indices are equal: " + CollectionsKt.joinToString$default((Iterable)idsToCompare2, null, null, null, (int)0, null, (Function1)compareIndexes.3.INSTANCE, (int)31, null));
    }

    private final Pair<FileBasedIndexExtension<?, ?>, Disposable> findFileBasedIndexExtension(ID<?, ?> id, Path storedIndexDir) {
        Pair pair;
        if (Intrinsics.areEqual((Object)id.getName(), (Object)"Stubs")) {
            SerializationManagerImpl storedSerializationManager = new SerializationManagerImpl(storedIndexDir.resolve("rep.names"), true);
            Map nameStorageDump = storedSerializationManager.dumpNameStorage();
            CompareIndicesKt.access$getLOG$p().info("stored stub element name storage " + nameStorageDump);
            StubForwardIndexExternalizer stubForwardIndexExternalizer = StubForwardIndexExternalizer.createFileLocalExternalizer();
            Intrinsics.checkNotNullExpressionValue((Object)stubForwardIndexExternalizer, (String)"createFileLocalExternalizer(...)");
            StubForwardIndexExternalizer stubForwardIndexExternalizer2 = stubForwardIndexExternalizer;
            FileBasedIndexExtension storedStubUpdatingIndex = (FileBasedIndexExtension)new StubUpdatingIndex(stubForwardIndexExternalizer2, (SerializationManagerEx)storedSerializationManager);
            pair = TuplesKt.to((Object)storedStubUpdatingIndex, (Object)storedSerializationManager);
        } else {
            Object object = FileBasedIndexExtension.EXTENSION_POINT_NAME.findFirstSafe(arg_0 -> CompareIndices.findFileBasedIndexExtension$lambda$9((Function1)new Function1<FileBasedIndexExtension<?, ?>, Boolean>(id){
                final /* synthetic */ ID<?, ?> $id;
                {
                    this.$id = $id;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(FileBasedIndexExtension<?, ?> ex) {
                    return Intrinsics.areEqual((Object)ex.getName(), this.$id);
                }
            }, arg_0));
            Intrinsics.checkNotNull((Object)object);
            FileBasedIndexExtension usualExtension2 = (FileBasedIndexExtension)object;
            Disposable disposable = Disposer.newDisposable();
            Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"newDisposable(...)");
            Disposable emptyDisposable = disposable;
            pair = TuplesKt.to((Object)usualExtension2, (Object)emptyDisposable);
        }
        return pair;
    }

    /*
     * WARNING - void declaration
     */
    private final List<FileDescriptor> resolveFiles(StoredIndexedFileResolver storedIndexedFileResolver, ErrorCollector errorCollector, ProgressIndicator indicator, Project project) {
        void destination$iv;
        void $this$flatMapTo$iv;
        Iterable iterable = CurrentIndexedFileResolver.INSTANCE.getAllToBeIndexedFilesInProject(project, indicator).values();
        Collection collection = new HashSet();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv : $this$flatMapTo$iv) {
            Set it = (Set)element$iv;
            boolean bl = false;
            Iterable list$iv = it;
            CollectionsKt.addAll((Collection)destination$iv, (Iterable)list$iv);
        }
        HashSet allCurrentFiles = (HashSet)destination$iv;
        indicator.setText(PerformanceTestingBundle.message("compare.indexes.resolving.files", new Object[0]));
        indicator.setIndeterminate(false);
        List<FileDescriptor> fileDescriptors = Collections.synchronizedList(new ArrayList());
        AtomicInteger finished = new AtomicInteger();
        JobLauncher.getInstance().invokeConcurrentlyUnderProgress(CollectionsKt.toList((Iterable)storedIndexedFileResolver.getOriginalIndexedFiles()), indicator, arg_0 -> CompareIndices.resolveFiles$lambda$12(this, errorCollector, indicator, finished, storedIndexedFileResolver, allCurrentFiles, fileDescriptors, project, arg_0));
        Intrinsics.checkNotNull(fileDescriptors);
        return fileDescriptors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final <K, V> void compareCurrentAndStoredIndexData(List<FileDescriptor> resolvedFiles, FileBasedIndexExtension<K, V> extension, Path storedIndexDir, ProgressIndicator indicator, ErrorCollector errorCollector, Project project) {
        ID iD = extension.getName();
        Intrinsics.checkNotNullExpressionValue((Object)iD, (String)"getName(...)");
        ID indexId = iD;
        Object[] objectArray = new Object[]{indexId.getName()};
        indicator.setText(PerformanceTestingBundle.message("compare.indexes.comparing.index", objectArray));
        indicator.setText2(PerformanceTestingBundle.message("compare.indexes.preparing.indexes", new Object[0]));
        indicator.setIndeterminate(true);
        FileBasedIndex fileBasedIndex = FileBasedIndex.getInstance();
        Intrinsics.checkNotNull((Object)fileBasedIndex, (String)"null cannot be cast to non-null type com.intellij.util.indexing.FileBasedIndexImpl");
        FileBasedIndexImpl fileBasedIndex2 = (FileBasedIndexImpl)fileBasedIndex;
        ActionsKt.runReadAction((Function0)((Function0)new Function0<Unit>(fileBasedIndex2, indexId, project){
            final /* synthetic */ FileBasedIndexImpl $fileBasedIndex;
            final /* synthetic */ ID<K, V> $indexId;
            final /* synthetic */ Project $project;
            {
                this.$fileBasedIndex = $fileBasedIndex;
                this.$indexId = $indexId;
                this.$project = $project;
                super(0);
            }

            public final void invoke() {
                this.$fileBasedIndex.ensureUpToDate(this.$indexId, this.$project, GlobalSearchScope.allScope((Project)this.$project));
            }
        }));
        UpdatableIndex updatableIndex = fileBasedIndex2.getIndex(indexId);
        Intrinsics.checkNotNullExpressionValue((Object)updatableIndex, (String)"getIndex(...)");
        UpdatableIndex currentIndex = updatableIndex;
        VfsAwareMapReduceIndex<K, V, VfsAwareMapReduceIndex.IndexerIdHolder> storedIndex = this.openStoredIndex(storedIndexDir, extension);
        try {
            indicator.setIndeterminate(false);
            indicator.setFraction(0.0);
            indicator.setText2("");
            if (!(extension.needsForwardIndexWhenSharing() || !(extension instanceof SingleEntryFileBasedIndexExtension))) {
                boolean bl = false;
                String string = "Index " + indexId.getName() + " is SingleEntryFileBasedIndexExtension and does not need forward index. This is a wrong index because SingleEntryFileBasedIndexExtension by its nature effectively consists of only the forward index.";
                throw new IllegalStateException(string.toString());
            }
            if (extension.needsForwardIndexWhenSharing()) {
                this.compareForwardIndexes(extension, resolvedFiles, currentIndex, (UpdatableIndex)storedIndex, errorCollector, indicator, project);
            }
            if (!(extension instanceof SingleEntryFileBasedIndexExtension)) {
                this.compareInvertedIndexes(extension, resolvedFiles, (UpdatableIndex)storedIndex, currentIndex, errorCollector, indicator, project);
            }
        }
        finally {
            storedIndex.dispose();
        }
    }

    private final <K, V> void compareForwardIndexes(FileBasedIndexExtension<K, V> extension, List<FileDescriptor> resolvedFiles, UpdatableIndex<K, V, FileContent, ?> currentIndex, UpdatableIndex<K, V, FileContent, ?> storedIndex, ErrorCollector errorCollector, ProgressIndicator indicator, Project project) {
        ID iD = extension.getName();
        Intrinsics.checkNotNullExpressionValue((Object)iD, (String)"getName(...)");
        ID indexId = iD;
        Object object = new Object[]{indexId.getName()};
        indicator.setText(PerformanceTestingBundle.message("compare.indexes.comparing.forward.index", (Object[])object));
        object = resolvedFiles.iterator();
        int n = 0;
        while (object.hasNext()) {
            int finished = n++;
            FileDescriptor resolvedFile = (FileDescriptor)object.next();
            indicator.setFraction((double)finished / (double)resolvedFiles.size());
            indicator.setText2(resolvedFile.getCurrentFile().getUrl());
            this.compareFileData(resolvedFile, currentIndex, storedIndex, extension, errorCollector, project);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final <K, V> void compareInvertedIndexes(FileBasedIndexExtension<K, V> extension, List<FileDescriptor> resolvedFiles, UpdatableIndex<K, V, FileContent, ?> storedIndex, UpdatableIndex<K, V, FileContent, ?> currentIndex, ErrorCollector errorCollector, ProgressIndicator indicator, Project project) {
        void $this$associateByTo$iv$iv;
        ID iD = extension.getName();
        Intrinsics.checkNotNullExpressionValue((Object)iD, (String)"getName(...)");
        ID indexId = iD;
        Object[] objectArray = new Object[]{indexId.getName()};
        indicator.setText(PerformanceTestingBundle.message("compare.indexes.comparing.inverted.index", objectArray));
        indicator.setText2(PerformanceTestingBundle.message("compare.indexes.comparing.inverted.index.collecting.keys", new Object[0]));
        indicator.setIndeterminate(true);
        HashSet allStoredKeys = new HashSet();
        errorCollector.runCatchingError((Function0)new Function0<Boolean>(storedIndex, allStoredKeys, project){
            final /* synthetic */ UpdatableIndex<K, V, FileContent, ?> $storedIndex;
            final /* synthetic */ HashSet<K> $allStoredKeys;
            final /* synthetic */ Project $project;
            {
                this.$storedIndex = $storedIndex;
                this.$allStoredKeys = $allStoredKeys;
                this.$project = $project;
                super(0);
            }

            @NotNull
            public final Boolean invoke() {
                return (Boolean)ActionsKt.runReadAction((Function0)((Function0)new Function0<Boolean>(this.$storedIndex, this.$allStoredKeys, this.$project){
                    final /* synthetic */ UpdatableIndex<K, V, FileContent, ?> $storedIndex;
                    final /* synthetic */ HashSet<K> $allStoredKeys;
                    final /* synthetic */ Project $project;
                    {
                        this.$storedIndex = $storedIndex;
                        this.$allStoredKeys = $allStoredKeys;
                        this.$project = $project;
                        super(0);
                    }

                    @NotNull
                    public final Boolean invoke() {
                        return this.$storedIndex.processAllKeys(Processors.cancelableCollectProcessor((Collection)this.$allStoredKeys), GlobalSearchScope.allScope((Project)this.$project), null);
                    }
                }));
            }
        });
        HashSet allCurrentKeys = new HashSet();
        errorCollector.runCatchingError((Function0)new Function0<Boolean>(currentIndex, allCurrentKeys, project){
            final /* synthetic */ UpdatableIndex<K, V, FileContent, ?> $currentIndex;
            final /* synthetic */ HashSet<K> $allCurrentKeys;
            final /* synthetic */ Project $project;
            {
                this.$currentIndex = $currentIndex;
                this.$allCurrentKeys = $allCurrentKeys;
                this.$project = $project;
                super(0);
            }

            @NotNull
            public final Boolean invoke() {
                return (Boolean)ActionsKt.runReadAction((Function0)((Function0)new Function0<Boolean>(this.$currentIndex, this.$allCurrentKeys, this.$project){
                    final /* synthetic */ UpdatableIndex<K, V, FileContent, ?> $currentIndex;
                    final /* synthetic */ HashSet<K> $allCurrentKeys;
                    final /* synthetic */ Project $project;
                    {
                        this.$currentIndex = $currentIndex;
                        this.$allCurrentKeys = $allCurrentKeys;
                        this.$project = $project;
                        super(0);
                    }

                    @NotNull
                    public final Boolean invoke() {
                        return this.$currentIndex.processAllKeys(Processors.cancelableCollectProcessor((Collection)this.$allCurrentKeys), GlobalSearchScope.allScope((Project)this.$project), null);
                    }
                }));
            }
        });
        this.checkNoKeysAreMissing(extension, storedIndex, resolvedFiles, allStoredKeys, allCurrentKeys, errorCollector, project);
        Iterable $this$associateBy$iv = resolvedFiles;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Iterable iterable = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object entry : $this$associateByTo$iv$iv) {
            void it;
            FileDescriptor fileDescriptor = (FileDescriptor)entry;
            Map map = destination$iv$iv;
            boolean bl = false;
            map.put(it.getOriginalFilePath().getOriginalFileSystemId(), entry);
        }
        Map originalFileIdToFileDescriptor = destination$iv$iv;
        indicator.setIndeterminate(false);
        indicator.setFraction(0.0);
        Iterator iterator2 = allStoredKeys.iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            Map storedFileIdToValue2;
            int index = n++;
            Object storedKey = iterator2.next();
            indicator.setFraction((double)index / (double)allStoredKeys.size());
            if ((Map)errorCollector.runCatchingError((Function0)new Function0<Map<Integer, ? extends V>>(this, storedIndex, storedKey){
                final /* synthetic */ CompareIndices this$0;
                final /* synthetic */ UpdatableIndex<K, V, FileContent, ?> $storedIndex;
                final /* synthetic */ K $storedKey;
                {
                    this.this$0 = $receiver;
                    this.$storedIndex = $storedIndex;
                    this.$storedKey = $storedKey;
                    super(0);
                }

                @NotNull
                public final Map<Integer, V> invoke() {
                    return (Map)ActionsKt.runReadAction((Function0)((Function0)new Function0<Map<Integer, ? extends V>>(this.this$0, this.$storedIndex, this.$storedKey){
                        final /* synthetic */ CompareIndices this$0;
                        final /* synthetic */ UpdatableIndex<K, V, FileContent, ?> $storedIndex;
                        final /* synthetic */ K $storedKey;
                        {
                            this.this$0 = $receiver;
                            this.$storedIndex = $storedIndex;
                            this.$storedKey = $storedKey;
                            super(0);
                        }

                        @NotNull
                        public final Map<Integer, V> invoke() {
                            K k = this.$storedKey;
                            Intrinsics.checkNotNull(k);
                            ValueContainer valueContainer = this.$storedIndex.getData(k);
                            Intrinsics.checkNotNullExpressionValue((Object)valueContainer, (String)"getData(...)");
                            return CompareIndices.access$toMap(this.this$0, valueContainer);
                        }
                    }));
                }
            }) == null || (Map)errorCollector.runCatchingError((Function0)new Function0<Map<Integer, ? extends V>>(this, currentIndex, storedKey){
                final /* synthetic */ CompareIndices this$0;
                final /* synthetic */ UpdatableIndex<K, V, FileContent, ?> $currentIndex;
                final /* synthetic */ K $storedKey;
                {
                    this.this$0 = $receiver;
                    this.$currentIndex = $currentIndex;
                    this.$storedKey = $storedKey;
                    super(0);
                }

                @NotNull
                public final Map<Integer, V> invoke() {
                    return (Map)ActionsKt.runReadAction((Function0)((Function0)new Function0<Map<Integer, ? extends V>>(this.this$0, this.$currentIndex, this.$storedKey){
                        final /* synthetic */ CompareIndices this$0;
                        final /* synthetic */ UpdatableIndex<K, V, FileContent, ?> $currentIndex;
                        final /* synthetic */ K $storedKey;
                        {
                            this.this$0 = $receiver;
                            this.$currentIndex = $currentIndex;
                            this.$storedKey = $storedKey;
                            super(0);
                        }

                        @NotNull
                        public final Map<Integer, V> invoke() {
                            K k = this.$storedKey;
                            Intrinsics.checkNotNull(k);
                            ValueContainer valueContainer = this.$currentIndex.getData(k);
                            Intrinsics.checkNotNullExpressionValue((Object)valueContainer, (String)"getData(...)");
                            return CompareIndices.access$toMap(this.this$0, valueContainer);
                        }
                    }));
                }
            }) == null) continue;
            for (Map.Entry entry : storedFileIdToValue2.entrySet()) {
                FileDescriptor fileDescriptor;
                int currentFileId;
                Map currentFileIdToValue2;
                Object currentValue;
                int storedFileId = ((Number)entry.getKey()).intValue();
                Object storedValue = entry.getValue();
                if ((FileDescriptor)originalFileIdToFileDescriptor.get(storedFileId) == null || IndexDataComparer.INSTANCE.areValuesTheSame(extension, storedValue, currentValue = currentFileIdToValue2.get(currentFileId = FileBasedIndexImpl.getFileId((VirtualFile)fileDescriptor.getCurrentFile()))) || !this.getIgnoredPatternsForReporting().isEmpty() && this.isKnownError(extension, fileDescriptor.getOriginalFilePath().getPortableFilePath().getPresentablePath())) continue;
                errorCollector.runCatchingError((Function0)new Function0(this, storedKey, extension, fileDescriptor, project, storedValue, currentValue){
                    final /* synthetic */ CompareIndices this$0;
                    final /* synthetic */ K $storedKey;
                    final /* synthetic */ FileBasedIndexExtension<K, V> $extension;
                    final /* synthetic */ FileDescriptor $fileDescriptor;
                    final /* synthetic */ Project $project;
                    final /* synthetic */ V $storedValue;
                    final /* synthetic */ V $currentValue;
                    {
                        this.this$0 = $receiver;
                        this.$storedKey = $storedKey;
                        this.$extension = $extension;
                        this.$fileDescriptor = $fileDescriptor;
                        this.$project = $project;
                        this.$storedValue = $storedValue;
                        this.$currentValue = $currentValue;
                        super(0);
                    }

                    @NotNull
                    public final Void invoke() {
                        String message = CompareIndices.access$buildFileDataMismatchMessage(this.this$0, "Values mismatch for key " + IndexDataPresenter.INSTANCE.getPresentableIndexKey(this.$storedKey), this.$extension, this.$fileDescriptor, this.$project);
                        ArrayList<E> attachments = new ArrayList<E>();
                        ((Collection)attachments).add(new Attachment("expected-value.txt", IndexDataPresenter.INSTANCE.getPresentableIndexValue(this.$storedValue)));
                        ((Collection)attachments).add(new Attachment("actual-value.txt", IndexDataPresenter.INSTANCE.getPresentableIndexValue(this.$currentValue)));
                        CollectionsKt.addAll((Collection)attachments, (Iterable)CompareIndices.createAttachmentsForActualFile$default(this.this$0, this.$fileDescriptor, null, 2, null));
                        Collection $this$toTypedArray$iv = attachments;
                        boolean $i$f$toTypedArray = false;
                        Collection thisCollection$iv = $this$toTypedArray$iv;
                        Attachment[] attachmentArray = thisCollection$iv.toArray(new Attachment[0]);
                        throw new RuntimeExceptionWithAttachments(message, Arrays.copyOf(attachmentArray, attachmentArray.length));
                    }
                });
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final <K, V> void checkNoKeysAreMissing(FileBasedIndexExtension<K, V> extension, UpdatableIndex<K, V, FileContent, ?> storedIndex, List<FileDescriptor> resolvedFiles, Set<? extends K> allStoredKeys, Set<? extends K> allCurrentKeys, ErrorCollector errorCollector, Project project) {
        Set missingKeys = SetsKt.minus(allStoredKeys, (Iterable)allCurrentKeys);
        if (!((Collection)missingKeys).isEmpty()) {
            void $this$associateByTo$iv$iv;
            Iterable $this$associateBy$iv = resolvedFiles;
            boolean $i$f$associateBy = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
            Iterable iterable = $this$associateBy$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv : $this$associateByTo$iv$iv) {
                void it;
                FileDescriptor fileDescriptor = (FileDescriptor)element$iv$iv;
                Map map = destination$iv$iv;
                boolean bl = false;
                map.put(it.getOriginalFilePath().getOriginalFileSystemId(), element$iv$iv);
            }
            Map originalFileIdToFileDescriptor = destination$iv$iv;
            for (Object missingKey : missingKeys) {
                Map storedFileIdToValue2;
                if ((Map)errorCollector.runCatchingError((Function0)new Function0<Map<Integer, ? extends V>>(this, storedIndex, missingKey, originalFileIdToFileDescriptor){
                    final /* synthetic */ CompareIndices this$0;
                    final /* synthetic */ UpdatableIndex<K, V, FileContent, ?> $storedIndex;
                    final /* synthetic */ K $missingKey;
                    final /* synthetic */ Map<Integer, FileDescriptor> $originalFileIdToFileDescriptor;
                    {
                        this.this$0 = $receiver;
                        this.$storedIndex = $storedIndex;
                        this.$missingKey = $missingKey;
                        this.$originalFileIdToFileDescriptor = $originalFileIdToFileDescriptor;
                        super(0);
                    }

                    @NotNull
                    public final Map<Integer, V> invoke() {
                        return (Map)ActionsKt.runReadAction((Function0)((Function0)new Function0<Map<Integer, ? extends V>>(this.this$0, this.$storedIndex, this.$missingKey, this.$originalFileIdToFileDescriptor){
                            final /* synthetic */ CompareIndices this$0;
                            final /* synthetic */ UpdatableIndex<K, V, FileContent, ?> $storedIndex;
                            final /* synthetic */ K $missingKey;
                            final /* synthetic */ Map<Integer, FileDescriptor> $originalFileIdToFileDescriptor;
                            {
                                this.this$0 = $receiver;
                                this.$storedIndex = $storedIndex;
                                this.$missingKey = $missingKey;
                                this.$originalFileIdToFileDescriptor = $originalFileIdToFileDescriptor;
                                super(0);
                            }

                            /*
                             * WARNING - void declaration
                             */
                            @NotNull
                            public final Map<Integer, V> invoke() {
                                void $this$filterKeys$iv;
                                K k = this.$missingKey;
                                Intrinsics.checkNotNull(k);
                                ValueContainer valueContainer = this.$storedIndex.getData(k);
                                Intrinsics.checkNotNullExpressionValue((Object)valueContainer, (String)"getData(...)");
                                Map map = CompareIndices.access$toMap(this.this$0, valueContainer);
                                Map<Integer, FileDescriptor> map2 = this.$originalFileIdToFileDescriptor;
                                boolean $i$f$filterKeys = false;
                                LinkedHashMap<K, V> result$iv = new LinkedHashMap<K, V>();
                                for (Map.Entry<K, V> entry$iv : $this$filterKeys$iv.entrySet()) {
                                    int it = ((Number)entry$iv.getKey()).intValue();
                                    boolean bl = false;
                                    Integer n = it;
                                    if (!map2.containsKey(n)) continue;
                                    result$iv.put(entry$iv.getKey(), entry$iv.getValue());
                                }
                                return result$iv;
                            }
                        }));
                    }
                }) == null || storedFileIdToValue2.isEmpty()) continue;
                FileDescriptor fileDescriptor = (FileDescriptor)originalFileIdToFileDescriptor.get(storedFileIdToValue2.entrySet().iterator().next().getKey());
                if (!this.getIgnoredPatternsForReporting().isEmpty() && this.isKnownError(extension, IndexDataPresenter.INSTANCE.getPresentableIndexKey(missingKey))) continue;
                FileDescriptor fileDescriptor2 = fileDescriptor;
                Intrinsics.checkNotNull((Object)fileDescriptor2);
                if (this.isKnownError(extension, fileDescriptor2)) continue;
                errorCollector.runCatchingError((Function0)new Function0(missingKey, storedFileIdToValue2, originalFileIdToFileDescriptor, this, extension, project){
                    final /* synthetic */ K $missingKey;
                    final /* synthetic */ Map<Integer, V> $storedFileIdToValue;
                    final /* synthetic */ Map<Integer, FileDescriptor> $originalFileIdToFileDescriptor;
                    final /* synthetic */ CompareIndices this$0;
                    final /* synthetic */ FileBasedIndexExtension<K, V> $extension;
                    final /* synthetic */ Project $project;
                    {
                        this.$missingKey = $missingKey;
                        this.$storedFileIdToValue = $storedFileIdToValue;
                        this.$originalFileIdToFileDescriptor = $originalFileIdToFileDescriptor;
                        this.this$0 = $receiver;
                        this.$extension = $extension;
                        this.$project = $project;
                        super(0);
                    }

                    @NotNull
                    public final Void invoke() {
                        StringBuilder stringBuilder;
                        FileBasedIndexExtension<K, V> fileBasedIndexExtension = this.$extension;
                        K k = this.$missingKey;
                        Attachment[] attachmentArray = this.$storedFileIdToValue;
                        Map<Integer, FileDescriptor> object2 = this.$originalFileIdToFileDescriptor;
                        CompareIndices compareIndices = this.this$0;
                        Project project = this.$project;
                        StringBuilder $this$invoke_u24lambda_u240 = stringBuilder = new StringBuilder();
                        boolean bl = false;
                        StringBuilder stringBuilder2 = $this$invoke_u24lambda_u240.append("Index " + fileBasedIndexExtension.getName().getName() + ": key is unknown to actual index data: " + IndexDataPresenter.INSTANCE.getPresentableIndexKey(k));
                        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(...)");
                        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2.append('\n'), (String)"append(...)");
                        StringBuilder stringBuilder3 = $this$invoke_u24lambda_u240.append("The key must be present in the index for the following files: ");
                        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append(...)");
                        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3.append('\n'), (String)"append(...)");
                        Iterator<Map.Entry<Integer, V>> iterator2 = attachmentArray.entrySet().iterator();
                        while (iterator2.hasNext()) {
                            FileDescriptor fileDescriptor;
                            int storedFileId = ((Number)iterator2.next().getKey()).intValue();
                            if (object2.get(storedFileId) == null) continue;
                            StringBuilder stringBuilder4 = $this$invoke_u24lambda_u240.append(CompareIndices.access$withIndent(compareIndices, CompareIndices.access$buildFileDataMismatchMessage(compareIndices, "Key is not available in the actual index for the file", fileBasedIndexExtension, fileDescriptor, project), "  "));
                            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4, (String)"append(...)");
                            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4.append('\n'), (String)"append(...)");
                            Intrinsics.checkNotNullExpressionValue((Object)$this$invoke_u24lambda_u240.append('\n'), (String)"append(...)");
                        }
                        String string = stringBuilder.toString();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                        String message = string;
                        ArrayList<E> attachments = new ArrayList<E>();
                        ((Collection)attachments).add(new Attachment("key.txt", IndexDataPresenter.INSTANCE.getPresentableIndexKey(this.$missingKey)));
                        int nextMismatchedFileId = 1;
                        for (Map.Entry entry : this.$storedFileIdToValue.entrySet()) {
                            FileDescriptor fileDescriptor;
                            int storedFileId = ((Number)entry.getKey()).intValue();
                            V storedValue = entry.getValue();
                            if (this.$originalFileIdToFileDescriptor.get(storedFileId) == null) continue;
                            String pathPrefix = "file-and-value-" + nextMismatchedFileId++ + "/";
                            ((Collection)attachments).add(new Attachment(pathPrefix + "value.txt", IndexDataPresenter.INSTANCE.getPresentableIndexValue(storedValue)));
                            CollectionsKt.addAll((Collection)attachments, (Iterable)CompareIndices.access$createAttachmentsForActualFile(this.this$0, fileDescriptor, pathPrefix));
                        }
                        Collection collection = attachments;
                        boolean $i$f$toTypedArray = false;
                        Collection thisCollection$iv = collection;
                        attachmentArray = thisCollection$iv.toArray(new Attachment[0]);
                        throw new RuntimeExceptionWithAttachments(message, Arrays.copyOf(attachmentArray, attachmentArray.length));
                    }
                });
            }
        }
    }

    private final <V> Map<Integer, V> toMap(ValueContainer<V> $this$toMap) {
        HashMap map = new HashMap();
        $this$toMap.forEach((arg_0, arg_1) -> CompareIndices.toMap$lambda$16((Function2)new Function2<Integer, V, Boolean>(map){
            final /* synthetic */ HashMap<Integer, V> $map;
            {
                this.$map = $map;
                super(2);
            }

            @NotNull
            public final Boolean invoke(int fileId, V value) {
                if (value != null) {
                    Integer n = fileId;
                    ((Map)this.$map).put(n, value);
                }
                return true;
            }
        }, arg_0, arg_1));
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final synchronized <K, V> VfsAwareMapReduceIndex<K, V, VfsAwareMapReduceIndex.IndexerIdHolder> openStoredIndex(Path storedIndexDir, FileBasedIndexExtension<K, V> extension) {
        String propertyName = "index_root_path";
        String oldValue = System.setProperty(propertyName, ((Object)storedIndexDir.toAbsolutePath()).toString());
        try {
            VfsAwareMapReduceIndex vfsAwareMapReduceIndex = new VfsAwareMapReduceIndex(extension, IndexStorageLayoutLocator.getLayout(extension));
            return vfsAwareMapReduceIndex;
        }
        finally {
            SystemProperties.setProperty((String)propertyName, (String)oldValue);
        }
    }

    private final <K, V> void compareFileData(FileDescriptor fileDescriptor, UpdatableIndex<K, V, FileContent, ?> currentIndex, UpdatableIndex<K, V, FileContent, ?> storedIndex, FileBasedIndexExtension<K, V> extension, ErrorCollector errorCollector, Project project) {
        Map map = (Map)errorCollector.runCatchingError((Function0)new Function0<Map<K, V>>(storedIndex, fileDescriptor){
            final /* synthetic */ UpdatableIndex<K, V, FileContent, ?> $storedIndex;
            final /* synthetic */ FileDescriptor $fileDescriptor;
            {
                this.$storedIndex = $storedIndex;
                this.$fileDescriptor = $fileDescriptor;
                super(0);
            }

            @NotNull
            public final Map<K, V> invoke() {
                return (Map)ActionsKt.runReadAction((Function0)((Function0)new Function0<Map<K, V>>(this.$storedIndex, this.$fileDescriptor){
                    final /* synthetic */ UpdatableIndex<K, V, FileContent, ?> $storedIndex;
                    final /* synthetic */ FileDescriptor $fileDescriptor;
                    {
                        this.$storedIndex = $storedIndex;
                        this.$fileDescriptor = $fileDescriptor;
                        super(0);
                    }

                    @NotNull
                    public final Map<K, V> invoke() {
                        return this.$storedIndex.getIndexedFileData(this.$fileDescriptor.getOriginalFilePath().getOriginalFileSystemId());
                    }
                }));
            }
        });
        if (map == null) {
            return;
        }
        Map storedData2 = map;
        Map map2 = (Map)errorCollector.runCatchingError((Function0)new Function0<Map<K, V>>(currentIndex, fileDescriptor){
            final /* synthetic */ UpdatableIndex<K, V, FileContent, ?> $currentIndex;
            final /* synthetic */ FileDescriptor $fileDescriptor;
            {
                this.$currentIndex = $currentIndex;
                this.$fileDescriptor = $fileDescriptor;
                super(0);
            }

            @NotNull
            public final Map<K, V> invoke() {
                return (Map)ActionsKt.runReadAction((Function0)((Function0)new Function0<Map<K, V>>(this.$currentIndex, this.$fileDescriptor){
                    final /* synthetic */ UpdatableIndex<K, V, FileContent, ?> $currentIndex;
                    final /* synthetic */ FileDescriptor $fileDescriptor;
                    {
                        this.$currentIndex = $currentIndex;
                        this.$fileDescriptor = $fileDescriptor;
                        super(0);
                    }

                    @NotNull
                    public final Map<K, V> invoke() {
                        return this.$currentIndex.getIndexedFileData(FileBasedIndex.getFileId((VirtualFile)this.$fileDescriptor.getCurrentFile()));
                    }
                }));
            }
        });
        if (map2 == null) {
            return;
        }
        Map currentData2 = map2;
        if ((Unit)errorCollector.runCatchingError((Function0)new Function0<Unit>(this, fileDescriptor, extension, storedData2, currentData2, project){
            final /* synthetic */ CompareIndices this$0;
            final /* synthetic */ FileDescriptor $fileDescriptor;
            final /* synthetic */ FileBasedIndexExtension<K, V> $extension;
            final /* synthetic */ Map<K, V> $storedData;
            final /* synthetic */ Map<K, V> $currentData;
            final /* synthetic */ Project $project;
            {
                this.this$0 = $receiver;
                this.$fileDescriptor = $fileDescriptor;
                this.$extension = $extension;
                this.$storedData = $storedData;
                this.$currentData = $currentData;
                this.$project = $project;
                super(0);
            }

            public final void invoke() {
                CompareIndices.access$assertForwardIndexDataAreTheSameForFile(this.this$0, this.$fileDescriptor, this.$extension, this.$storedData, this.$currentData, this.$project);
            }
        }) == null) {
            return;
        }
    }

    private final <K, V> void assertForwardIndexDataAreTheSameForFile(FileDescriptor fileDescriptor, FileBasedIndexExtension<K, V> extension, Map<K, ? extends V> expectedData0, Map<K, ? extends V> actualData0, Project project) {
        Map expectedData = null;
        Map actualData = null;
        if (Intrinsics.areEqual((Object)extension.getName(), (Object)StubUpdatingIndex.INDEX_ID) && CollectionsKt.contains((Iterable)this.getFileTypesWithNoStubTree(), (Object)fileDescriptor.getOriginalFilePath().getFileType())) {
            SerializedStubTree serializedStubTree;
            Map.Entry it;
            Map map;
            Object k;
            Map.Entry it$iv$iv;
            boolean bl;
            Map map2;
            Map $this$mapValuesTo$iv$iv;
            Map $this$mapValues$iv = expectedData0;
            boolean $i$f$mapValues = false;
            Map map3 = $this$mapValues$iv;
            Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
            boolean $i$f$mapValuesTo = false;
            Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                map2 = destination$iv$iv;
                bl = false;
                Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
                k = it$iv$iv.getKey();
                map = map2;
                boolean bl2 = false;
                Object v = it.getValue();
                Intrinsics.checkNotNull(v, (String)"null cannot be cast to non-null type com.intellij.psi.stubs.SerializedStubTree");
                serializedStubTree = ((SerializedStubTree)v).withoutStub();
                map.put(k, serializedStubTree);
            }
            expectedData = destination$iv$iv;
            $this$mapValues$iv = actualData0;
            $i$f$mapValues = false;
            $this$mapValuesTo$iv$iv = $this$mapValues$iv;
            destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
            $i$f$mapValuesTo = false;
            $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
            $i$f$associateByTo = false;
            for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                it$iv$iv = (Map.Entry)element$iv$iv$iv;
                map2 = destination$iv$iv;
                bl = false;
                it = (Map.Entry)element$iv$iv$iv;
                k = it$iv$iv.getKey();
                map = map2;
                boolean bl3 = false;
                Object v = it.getValue();
                Intrinsics.checkNotNull(v, (String)"null cannot be cast to non-null type com.intellij.psi.stubs.SerializedStubTree");
                serializedStubTree = ((SerializedStubTree)v).withoutStub();
                map.put(k, serializedStubTree);
            }
            actualData = destination$iv$iv;
        } else {
            expectedData = expectedData0;
            actualData = actualData0;
        }
        if (IndexDataComparer.INSTANCE.areIndexedDataOfFileTheSame(extension, expectedData, actualData)) {
            return;
        }
        if (this.getIgnoredPatternsForReporting().isEmpty() || !this.isKnownError(extension, fileDescriptor.getOriginalFilePath().getPortableFilePath().getPresentablePath())) {
            String message = this.buildFileDataMismatchMessage("Indexed data maps do not match for " + fileDescriptor.getOriginalFilePath().getPortableFilePath().getPresentablePath(), extension, fileDescriptor, project);
            Attachment expectedDataAttachment = expectedData.isEmpty() ? new Attachment("expected-data-is-empty.txt", "") : new Attachment("expected-data.txt", IndexDataPresenter.INSTANCE.getPresentableKeyValueMap(expectedData));
            Attachment actualDataAttachment = actualData.isEmpty() ? new Attachment("actual-data-is-empty.txt", "") : new Attachment("actual-data.txt", IndexDataPresenter.INSTANCE.getPresentableKeyValueMap(actualData));
            Object[] objectArray = new Attachment[]{expectedDataAttachment, actualDataAttachment};
            ArrayList attachments = CollectionsKt.arrayListOf((Object[])objectArray);
            CollectionsKt.addAll((Collection)attachments, (Iterable)CompareIndices.createAttachmentsForActualFile$default(this, fileDescriptor, null, 2, null));
            CollectionsKt.addAll((Collection)attachments, (Iterable)CompareIndices.createAttachmentsForExpectedFile$default(this, fileDescriptor, null, 2, null));
            Collection $this$toTypedArray$iv = attachments;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            objectArray = thisCollection$iv.toArray(new Attachment[0]);
            throw new RuntimeExceptionWithAttachments(message, (Attachment[])Arrays.copyOf(objectArray, objectArray.length));
        }
    }

    private final boolean isKnownError(FileBasedIndexExtension<?, ?> extension, String fileNameOrIndexData) {
        String fileExtension = FilesKt.getExtension((File)new File(fileNameOrIndexData));
        Iterable $this$forEach$iv = this.getIgnoredPatternsForReporting();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Pair it = (Pair)element$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getFirst(), (Object)extension.getName().getName()) || !Intrinsics.areEqual((Object)it.getSecond(), (Object)fileExtension)) continue;
            CompareIndicesKt.access$getLOG$p().info("Reporting index mismatch of " + fileNameOrIndexData + " in " + extension.getName().getName() + " extension is ignored");
            return true;
        }
        return false;
    }

    private final boolean isKnownError(FileBasedIndexExtension<?, ?> extension, FileDescriptor fileDescriptor) {
        String fileExtension = fileDescriptor.getCurrentFile().getExtension();
        Iterable $this$forEach$iv = this.getIgnoredPatternsForReporting();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Pair it = (Pair)element$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getFirst(), (Object)extension.getName().getName()) || !Intrinsics.areEqual((Object)it.getSecond(), (Object)fileExtension)) continue;
            CompareIndicesKt.access$getLOG$p().info("Reporting index mismatch of " + fileExtension + " in " + extension.getName().getName() + " extension is ignored");
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private final List<Attachment> createAttachmentsForActualFile(FileDescriptor fileDescriptor, String pathPrefix) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.findFileAndAllRelevantSiblings(fileDescriptor.getCurrentFile());
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void file;
            VirtualFile virtualFile = (VirtualFile)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(CoreAttachmentFactory.createAttachment((String)(pathPrefix + "actual-file/" + file.getName()), (VirtualFile)file));
        }
        return (List)destination$iv$iv;
    }

    static /* synthetic */ List createAttachmentsForActualFile$default(CompareIndices compareIndices, FileDescriptor fileDescriptor, String string, int n, Object object) {
        if ((n & 2) != 0) {
            string = "";
        }
        return compareIndices.createAttachmentsForActualFile(fileDescriptor, string);
    }

    /*
     * WARNING - void declaration
     */
    private final List<Attachment> createAttachmentsForExpectedFile(FileDescriptor fileDescriptor, String pathPrefix) {
        List list;
        VirtualFile expectedFile = VirtualFileManager.getInstance().refreshAndFindFileByUrl(fileDescriptor.getOriginalFilePath().getOriginalFileUrl());
        if (expectedFile != null) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = this.findFileAndAllRelevantSiblings(expectedFile);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void file;
                VirtualFile virtualFile = (VirtualFile)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Attachment attachment = CoreAttachmentFactory.createAttachment((String)(pathPrefix + "expected-file/" + file.getName()), (VirtualFile)file);
                Intrinsics.checkNotNullExpressionValue((Object)attachment, (String)"createAttachment(...)");
                collection.add(attachment);
            }
            list = (List)destination$iv$iv;
        } else {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    static /* synthetic */ List createAttachmentsForExpectedFile$default(CompareIndices compareIndices, FileDescriptor fileDescriptor, String string, int n, Object object) {
        if ((n & 2) != 0) {
            string = "";
        }
        return compareIndices.createAttachmentsForExpectedFile(fileDescriptor, string);
    }

    private final String buildFileDataMismatchMessage(String reason, FileBasedIndexExtension<?, ?> extension, FileDescriptor fileDescriptor, Project project) {
        StringBuilder stringBuilder;
        StringBuilder $this$buildFileDataMismatchMessage_u24lambda_u2423 = stringBuilder = new StringBuilder();
        boolean bl = false;
        StringBuilder stringBuilder2 = $this$buildFileDataMismatchMessage_u24lambda_u2423.append("Index mismatch " + extension.getName().getName() + " for " + fileDescriptor.getOriginalFilePath().getPortableFilePath().getPresentablePath() + ": " + reason);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2.append('\n'), (String)"append(...)");
        StringBuilder stringBuilder3 = $this$buildFileDataMismatchMessage_u24lambda_u2423.append("File of expected data:");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3.append('\n'), (String)"append(...)");
        StringBuilder stringBuilder4 = $this$buildFileDataMismatchMessage_u24lambda_u2423.append(this.withIndent(fileDescriptor.getOriginalFilePath().toString(), "  "));
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4.append('\n'), (String)"append(...)");
        StringBuilder stringBuilder5 = $this$buildFileDataMismatchMessage_u24lambda_u2423.append("File of actual data:");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder5, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder5.append('\n'), (String)"append(...)");
        IndexedFilePath actualIndexedFilePath = IndexedFilePaths.INSTANCE.createIndexedFilePath(fileDescriptor.getCurrentFile(), project);
        StringBuilder stringBuilder6 = $this$buildFileDataMismatchMessage_u24lambda_u2423.append(this.withIndent(actualIndexedFilePath.toString(), "  "));
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder6, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder6.append('\n'), (String)"append(...)");
        if (this.doesFileHaveProvidedIndex(fileDescriptor.getCurrentFile(), extension, project)) {
            StringBuilder stringBuilder7 = $this$buildFileDataMismatchMessage_u24lambda_u2423.append("  Index " + extension.getName().getName() + " of this file is provided by index infrastructure extension");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder7, (String)"append(...)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder7.append('\n'), (String)"append(...)");
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean doesFileHaveProvidedIndex(VirtualFile file, FileBasedIndexExtension<?, ?> extension, Project project) {
        boolean bl;
        block1: {
            void $this$any$iv;
            int fileId = FileBasedIndex.getFileId((VirtualFile)file);
            Sequence sequence = SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)FileBasedIndexInfrastructureExtension.EP_NAME.getExtensionList()), (Function1)((Function1)new Function1<FileBasedIndexInfrastructureExtension, FileBasedIndexInfrastructureExtension.FileIndexingStatusProcessor>(project){
                final /* synthetic */ Project $project;
                {
                    this.$project = $project;
                    super(1);
                }

                @Nullable
                public final FileBasedIndexInfrastructureExtension.FileIndexingStatusProcessor invoke(FileBasedIndexInfrastructureExtension it) {
                    return it.createFileIndexingStatusProcessor(this.$project);
                }
            }));
            boolean $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                FileBasedIndexInfrastructureExtension.FileIndexingStatusProcessor it = (FileBasedIndexInfrastructureExtension.FileIndexingStatusProcessor)element$iv;
                boolean bl2 = false;
                if (!it.hasIndexForFile(file, fileId, extension)) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    /*
     * Unable to fully structure code
     */
    private final List<VirtualFile> findFileAndAllRelevantSiblings(VirtualFile file) {
        if (!Intrinsics.areEqual((Object)file.getExtension(), (Object)"class")) {
            return CollectionsKt.listOf((Object)file);
        }
        v0 = file.getNameWithoutExtension();
        Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"getNameWithoutExtension(...)");
        fullClassName = v0;
        baseClassName = StringsKt.substringBefore$default((String)fullClassName, (String)"$", null, (int)2, null);
        v1 = file.getParent();
        if (v1 == null) {
            return CollectionsKt.listOf((Object)file);
        }
        parent = v1;
        parent.refresh(false, true);
        $this$orEmpty$iv = parent.getChildren();
        $i$f$orEmpty = false;
        v2 = $this$orEmpty$iv;
        if ($this$orEmpty$iv == null) {
            $i$f$emptyArray = false;
            v2 = new VirtualFile[]{};
        }
        $this$orEmpty$iv = v2;
        $i$f$filter = false;
        $i$f$emptyArray = $this$filter$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterTo = false;
        var11_12 = ((void)$this$filterTo$iv$iv).length;
        for (var10_11 = 0; var10_11 < var11_12; ++var10_11) {
            it = element$iv$iv = $this$filterTo$iv$iv[var10_11];
            $i$a$-filter-CompareIndices$findFileAndAllRelevantSiblings$1 = false;
            if (!Intrinsics.areEqual((Object)it.getExtension(), (Object)"class")) ** GOTO lbl-1000
            if (Intrinsics.areEqual((Object)it.getNameWithoutExtension(), (Object)fullClassName)) ** GOTO lbl-1000
            v3 = it.getNameWithoutExtension();
            Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"getNameWithoutExtension(...)");
            if (StringsKt.startsWith$default((String)v3, (String)(baseClassName + "$"), (boolean)false, (int)2, null)) lbl-1000:
            // 2 sources

            {
                v4 = true;
            } else lbl-1000:
            // 2 sources

            {
                v4 = false;
            }
            if (!v4) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final String withIndent(String $this$withIndent, String indent) {
        return SequencesKt.joinToString$default((Sequence)StringsKt.lineSequence((CharSequence)$this$withIndent), (CharSequence)"\n", null, null, (int)0, null, (Function1)((Function1)new Function1<String, CharSequence>(indent){
            final /* synthetic */ String $indent;
            {
                this.$indent = $indent;
                super(1);
            }

            @NotNull
            public final CharSequence invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return this.$indent + it;
            }
        }), (int)30, null);
    }

    private static final void _execute$lambda$0(Project $project, ActionCallbackProfilerStopper $actionCallback, CompareIndices this$0, Path $storedIndexDir) {
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        Intrinsics.checkNotNullParameter((Object)((Object)$actionCallback), (String)"$actionCallback");
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$storedIndexDir, (String)"$storedIndexDir");
        String string = PerformanceTestingBundle.message("comparing.indexes", new Object[0]);
        new Task.Modal($project, $actionCallback, this$0, $storedIndexDir, string){
            final /* synthetic */ Project $project;
            final /* synthetic */ ActionCallbackProfilerStopper $actionCallback;
            final /* synthetic */ CompareIndices this$0;
            final /* synthetic */ Path $storedIndexDir;
            {
                this.$project = $project;
                this.$actionCallback = $actionCallback;
                this.this$0 = $receiver;
                this.$storedIndexDir = $storedIndexDir;
                super($project, $super_call_param$1, false);
            }

            public void run(@NotNull ProgressIndicator indicator) {
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                if (!StubForwardIndexExternalizer.USE_SHAREABLE_STUBS) {
                    this.$actionCallback.reject("Index comparison available only with with -Didea.uses.shareable.serialized.stubs=true");
                    return;
                }
                try {
                    CompareIndices.access$compareIndexes(this.this$0, this.$storedIndexDir, indicator, this.$project);
                    this.$actionCallback.setDone();
                }
                catch (Throwable e) {
                    CompareIndicesKt.access$getLOG$p().error(e);
                    this.$actionCallback.reject(e.getMessage());
                }
            }
        }.queue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final boolean compareIndexes$lambda$6(ConcurrentTasksProgressManager $comparisonTaskProgressManager, Map $errorCollectors, CompareIndices this$0, List $resolvedFiles, Path $storedIndexDir, Project $project, AtomicInteger $finishedCounter, List $idsToCompare, ID id) {
        Intrinsics.checkNotNullParameter((Object)$comparisonTaskProgressManager, (String)"$comparisonTaskProgressManager");
        Intrinsics.checkNotNullParameter((Object)$errorCollectors, (String)"$errorCollectors");
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$resolvedFiles, (String)"$resolvedFiles");
        Intrinsics.checkNotNullParameter((Object)$storedIndexDir, (String)"$storedIndexDir");
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        Intrinsics.checkNotNullParameter((Object)$finishedCounter, (String)"$finishedCounter");
        Intrinsics.checkNotNullParameter((Object)$idsToCompare, (String)"$idsToCompare");
        SubTaskProgressIndicator subTaskProgressIndicator = $comparisonTaskProgressManager.createSubTaskIndicator(1);
        Intrinsics.checkNotNullExpressionValue((Object)subTaskProgressIndicator, (String)"createSubTaskIndicator(...)");
        SubTaskProgressIndicator subIndicator = subTaskProgressIndicator;
        Pair pair = (Pair)ActionsKt.runReadAction((Function0)new Function0<Pair<? extends FileBasedIndexExtension<?, ?>, ? extends Disposable>>(this$0, (ID<? extends Object, ? extends Object>)id, $storedIndexDir){
            final /* synthetic */ CompareIndices this$0;
            final /* synthetic */ ID<? extends Object, ? extends Object> $id;
            final /* synthetic */ Path $storedIndexDir;
            {
                this.this$0 = $receiver;
                this.$id = $id;
                this.$storedIndexDir = $storedIndexDir;
                super(0);
            }

            @NotNull
            public final Pair<FileBasedIndexExtension<?, ?>, Disposable> invoke() {
                ID<? extends Object, ? extends Object> iD = this.$id;
                Intrinsics.checkNotNullExpressionValue(iD, (String)"$id");
                return CompareIndices.access$findFileBasedIndexExtension(this.this$0, iD, this.$storedIndexDir);
            }
        });
        FileBasedIndexExtension extension = (FileBasedIndexExtension)pair.component1();
        Disposable disposable = (Disposable)pair.component2();
        try {
            Object errorCollector = (ToDirectoryWritingErrorCollector)MapsKt.getValue((Map)$errorCollectors, (Object)id);
            this$0.compareCurrentAndStoredIndexData($resolvedFiles, (FileBasedIndexExtension)extension, $storedIndexDir, (ProgressIndicator)subIndicator, (ErrorCollector)errorCollector, $project);
        }
        catch (Exception e) {
            CompareIndicesKt.access$getLOG$p().warn("Index comparison for " + id.getName() + " has failed", (Throwable)e);
        }
        finally {
            Object object;
            Object object2 = this$0;
            try {
                CompareIndices $this$compareIndexes_u24lambda_u246_u24lambda_u244 = object2;
                boolean bl = false;
                Disposer.dispose((Disposable)disposable);
                object = Result.constructor-impl((Object)Unit.INSTANCE);
            }
            catch (Throwable bl) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
            }
            object2 = object;
            Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
            if (throwable != null) {
                Object it = object = throwable;
                boolean bl = false;
                CompareIndicesKt.access$getLOG$p().warn((Throwable)it);
            }
        }
        CompareIndicesKt.access$getLOG$p().info("Index comparison has finished for " + $finishedCounter.incrementAndGet() + " / " + $idsToCompare.size());
        return true;
    }

    private static final boolean findFileBasedIndexExtension$lambda$9(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean resolveFiles$lambda$12(CompareIndices this$0, ErrorCollector $errorCollector, ProgressIndicator $indicator, AtomicInteger $finished, StoredIndexedFileResolver $storedIndexedFileResolver, HashSet $allCurrentFiles, List $fileDescriptors, Project $project, IndexedFilePath originalFilePath) {
        boolean bl;
        block6: {
            Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)$errorCollector, (String)"$errorCollector");
            Intrinsics.checkNotNullParameter((Object)$indicator, (String)"$indicator");
            Intrinsics.checkNotNullParameter((Object)$finished, (String)"$finished");
            Intrinsics.checkNotNullParameter((Object)$storedIndexedFileResolver, (String)"$storedIndexedFileResolver");
            Intrinsics.checkNotNullParameter((Object)$allCurrentFiles, (String)"$allCurrentFiles");
            Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
            Iterable $this$any$iv = this$0.getIgnoredFilesPatterns();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (!PortableFilePathsKt.hasPresentablePathMatching((PortableFilePath)originalFilePath.getPortableFilePath(), (String)it)) continue;
                    bl = true;
                    break block6;
                }
                bl = false;
            }
        }
        if (bl) {
            return true;
        }
        VirtualFile virtualFile = (VirtualFile)$errorCollector.runCatchingError((Function0)new Function0<VirtualFile>($storedIndexedFileResolver, originalFilePath, $project){
            final /* synthetic */ StoredIndexedFileResolver $storedIndexedFileResolver;
            final /* synthetic */ IndexedFilePath $originalFilePath;
            final /* synthetic */ Project $project;
            {
                this.$storedIndexedFileResolver = $storedIndexedFileResolver;
                this.$originalFilePath = $originalFilePath;
                this.$project = $project;
                super(0);
            }

            @NotNull
            public final VirtualFile invoke() {
                IndexedFilePath indexedFilePath = this.$originalFilePath;
                Intrinsics.checkNotNullExpressionValue((Object)indexedFilePath, (String)"$originalFilePath");
                return this.$storedIndexedFileResolver.findFileInCurrentProject(indexedFilePath, this.$project);
            }
        });
        if (virtualFile == null) {
            return true;
        }
        VirtualFile currentFile2 = virtualFile;
        $indicator.setFraction((double)$finished.incrementAndGet() / (double)$storedIndexedFileResolver.getOriginalIndexedFiles().size());
        $indicator.setText2(currentFile2.getUrl());
        if ($allCurrentFiles.contains(currentFile2)) {
            Intrinsics.checkNotNull((Object)$fileDescriptors);
            Collection collection = $fileDescriptors;
            Intrinsics.checkNotNull((Object)originalFilePath);
            collection.add(new FileDescriptor(originalFilePath, currentFile2));
        }
        return true;
    }

    private static final boolean toMap$lambda$16(Function2 $tmp0, int p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke((Object)p0, p1);
    }

    public static final /* synthetic */ Map access$toMap(CompareIndices $this, ValueContainer $receiver) {
        return $this.toMap($receiver);
    }

    public static final /* synthetic */ String access$buildFileDataMismatchMessage(CompareIndices $this, String reason, FileBasedIndexExtension extension, FileDescriptor fileDescriptor, Project project) {
        return $this.buildFileDataMismatchMessage(reason, extension, fileDescriptor, project);
    }

    public static final /* synthetic */ List access$createAttachmentsForActualFile(CompareIndices $this, FileDescriptor fileDescriptor, String pathPrefix) {
        return $this.createAttachmentsForActualFile(fileDescriptor, pathPrefix);
    }

    public static final /* synthetic */ String access$withIndent(CompareIndices $this, String $receiver, String indent) {
        return $this.withIndent($receiver, indent);
    }

    public static final /* synthetic */ void access$assertForwardIndexDataAreTheSameForFile(CompareIndices $this, FileDescriptor fileDescriptor, FileBasedIndexExtension extension, Map expectedData0, Map actualData0, Project project) {
        $this.assertForwardIndexDataAreTheSameForFile(fileDescriptor, extension, expectedData0, actualData0, project);
    }

    public static final /* synthetic */ void access$compareIndexes(CompareIndices $this, Path storedIndexDir, ProgressIndicator indicator, Project project) {
        $this.compareIndexes(storedIndexDir, indicator, project);
    }

    public static final /* synthetic */ Pair access$findFileBasedIndexExtension(CompareIndices $this, ID id, Path storedIndexDir) {
        return $this.findFileBasedIndexExtension(id, storedIndexDir);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/jetbrains/performancePlugin/commands/CompareIndices$Companion;", "", "()V", "LIMIT_OF_ERRORS_PER_COLLECTOR", "", "intellij.performanceTesting"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lcom/jetbrains/performancePlugin/commands/CompareIndices$FileDescriptor;", "", "originalFilePath", "Lcom/intellij/util/indexing/diagnostic/dump/paths/IndexedFilePath;", "currentFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "(Lcom/intellij/util/indexing/diagnostic/dump/paths/IndexedFilePath;Lcom/intellij/openapi/vfs/VirtualFile;)V", "getCurrentFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "getOriginalFilePath", "()Lcom/intellij/util/indexing/diagnostic/dump/paths/IndexedFilePath;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.performanceTesting"})
    private static final class FileDescriptor {
        @NotNull
        private final IndexedFilePath originalFilePath;
        @NotNull
        private final VirtualFile currentFile;

        public FileDescriptor(@NotNull IndexedFilePath originalFilePath, @NotNull VirtualFile currentFile2) {
            Intrinsics.checkNotNullParameter((Object)originalFilePath, (String)"originalFilePath");
            Intrinsics.checkNotNullParameter((Object)currentFile2, (String)"currentFile");
            this.originalFilePath = originalFilePath;
            this.currentFile = currentFile2;
        }

        @NotNull
        public final IndexedFilePath getOriginalFilePath() {
            return this.originalFilePath;
        }

        @NotNull
        public final VirtualFile getCurrentFile() {
            return this.currentFile;
        }

        @NotNull
        public final IndexedFilePath component1() {
            return this.originalFilePath;
        }

        @NotNull
        public final VirtualFile component2() {
            return this.currentFile;
        }

        @NotNull
        public final FileDescriptor copy(@NotNull IndexedFilePath originalFilePath, @NotNull VirtualFile currentFile2) {
            Intrinsics.checkNotNullParameter((Object)originalFilePath, (String)"originalFilePath");
            Intrinsics.checkNotNullParameter((Object)currentFile2, (String)"currentFile");
            return new FileDescriptor(originalFilePath, currentFile2);
        }

        public static /* synthetic */ FileDescriptor copy$default(FileDescriptor fileDescriptor, IndexedFilePath indexedFilePath, VirtualFile virtualFile, int n, Object object) {
            if ((n & 1) != 0) {
                indexedFilePath = fileDescriptor.originalFilePath;
            }
            if ((n & 2) != 0) {
                virtualFile = fileDescriptor.currentFile;
            }
            return fileDescriptor.copy(indexedFilePath, virtualFile);
        }

        @NotNull
        public String toString() {
            return "FileDescriptor(originalFilePath=" + this.originalFilePath + ", currentFile=" + this.currentFile + ")";
        }

        public int hashCode() {
            int result2 = this.originalFilePath.hashCode();
            result2 = result2 * 31 + this.currentFile.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof FileDescriptor)) {
                return false;
            }
            FileDescriptor fileDescriptor = (FileDescriptor)other;
            if (!Intrinsics.areEqual((Object)this.originalFilePath, (Object)fileDescriptor.originalFilePath)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.currentFile, (Object)fileDescriptor.currentFile);
        }
    }
}

