/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.performancePlugin.commands;

import com.intellij.openapi.project.BaseProjectDirectories;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.playback.PlaybackContext;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import com.intellij.xdebugger.impl.XDebuggerUtilImpl;
import com.jetbrains.performancePlugin.commands.DebugToggleBreakpointCommandKt;
import com.jetbrains.performancePlugin.utils.AbstractCallbackBasedCommand;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0014J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0003H\u0002J\u001c\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00050\u00132\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u00a8\u0006\u0015"}, d2={"Lcom/jetbrains/performancePlugin/commands/DebugToggleBreakpointCommand;", "Lcom/jetbrains/performancePlugin/utils/AbstractCallbackBasedCommand;", "text", "", "line", "", "(Ljava/lang/String;I)V", "execute", "", "callback", "Lcom/intellij/openapi/util/ActionCallback;", "context", "Lcom/intellij/openapi/ui/playback/PlaybackContext;", "findFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "filePath", "getArguments", "Lkotlin/Pair;", "Companion", "intellij.performanceTesting"})
@SourceDebugExtension(value={"SMAP\nDebugToggleBreakpointCommand.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DebugToggleBreakpointCommand.kt\ncom/jetbrains/performancePlugin/commands/DebugToggleBreakpointCommand\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,53:1\n1#2:54\n*E\n"})
public final class DebugToggleBreakpointCommand
extends AbstractCallbackBasedCommand {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String PREFIX = "%breakpointToggle";

    public DebugToggleBreakpointCommand(@NotNull String text2, int line) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        super(text2, line, true);
    }

    @Override
    protected void execute(@NotNull ActionCallback callback2, @NotNull PlaybackContext context) {
        Intrinsics.checkNotNullParameter((Object)callback2, (String)"callback");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        DebugToggleBreakpointCommandKt.access$getLogger$p().debug("Breakpoint toggle start");
        Project project = context.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Pair<VirtualFile, Integer> pair = this.getArguments(project);
        VirtualFile virtualFile = (VirtualFile)pair.component1();
        int line = ((Number)pair.component2()).intValue();
        XDebuggerUtil xDebuggerUtil = XDebuggerUtilImpl.getInstance();
        Intrinsics.checkNotNull((Object)xDebuggerUtil, (String)"null cannot be cast to non-null type com.intellij.xdebugger.impl.XDebuggerUtilImpl");
        XDebuggerUtilImpl utils = (XDebuggerUtilImpl)xDebuggerUtil;
        utils.toggleAndReturnLineBreakpoint(context.getProject(), virtualFile, line, false).onError(arg_0 -> DebugToggleBreakpointCommand.execute$lambda$0((Function1)new Function1<Throwable, Unit>(callback2){
            final /* synthetic */ ActionCallback $callback;
            {
                this.$callback = $callback;
                super(1);
            }

            public final void invoke(Throwable it) {
                DebugToggleBreakpointCommandKt.access$getLogger$p().info("Error on breakpoint toggling " + it);
                this.$callback.reject(it.getMessage());
            }
        }, arg_0)).onSuccess(arg_0 -> DebugToggleBreakpointCommand.execute$lambda$1((Function1)new Function1<XLineBreakpoint, Unit>(callback2){
            final /* synthetic */ ActionCallback $callback;
            {
                this.$callback = $callback;
                super(1);
            }

            public final void invoke(@Nullable XLineBreakpoint it) {
                DebugToggleBreakpointCommandKt.access$getLogger$p().info("The breakpoint was successfully toggled");
                this.$callback.setDone();
            }
        }, arg_0));
        DebugToggleBreakpointCommandKt.access$getLogger$p().info("Breakpoint toggle finish");
    }

    private final Pair<VirtualFile, Integer> getArguments(Project project) {
        ArrayList arrayList = this.extractCommandList(PREFIX, ",");
        Intrinsics.checkNotNull((Object)arrayList);
        String fileString = (String)((List)arrayList).get(0);
        String lineString = (String)((List)arrayList).get(1);
        Intrinsics.checkNotNull((Object)fileString);
        VirtualFile virtualFile = this.findFile(project, fileString);
        Intrinsics.checkNotNull((Object)lineString);
        return new Pair((Object)virtualFile, (Object)Integer.parseInt(lineString));
    }

    private final VirtualFile findFile(Project project, String filePath) {
        VirtualFile relativePath;
        VirtualFile virtualFile;
        block3: {
            VirtualFile absolutePath;
            VirtualFile virtualFile2 = absolutePath = VfsUtil.findFileByIoFile((File)new File(filePath), (boolean)true);
            if (virtualFile2 != null) {
                return virtualFile2;
            }
            for (VirtualFile it : (Iterable)BaseProjectDirectories.Companion.getBaseDirectories(project)) {
                boolean bl = false;
                VirtualFile virtualFile3 = it.findFileByRelativePath(filePath);
                if (virtualFile3 == null) continue;
                virtualFile = virtualFile3;
                break block3;
            }
            virtualFile = null;
        }
        VirtualFile virtualFile4 = relativePath = virtualFile;
        if (virtualFile4 == null) {
            throw new IllegalStateException(("Can't find " + filePath + " on disk").toString());
        }
        return virtualFile4;
    }

    private static final void execute$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void execute$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/jetbrains/performancePlugin/commands/DebugToggleBreakpointCommand$Companion;", "", "()V", "PREFIX", "", "intellij.performanceTesting"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

