/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.performancePlugin.commands;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.extensions.ExtensionNotApplicableException;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.jetbrains.performancePlugin.commands.ListenerState;
import com.jetbrains.performancePlugin.commands.WaitForFinishedCodeAnalysisKt;
import com.jetbrains.performancePlugin.commands.WaitForFinishedCodeAnalysisListener;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0016J\u0016\u0010\f\u001a\u00020\u00062\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0016J\u0016\u0010\r\u001a\u00020\u00062\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0016J\u001e\u0010\u000e\u001a\u00020\u00062\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/jetbrains/performancePlugin/commands/WaitForFinishedCodeAnalysisListener;", "Lcom/intellij/codeInsight/daemon/DaemonCodeAnalyzer$DaemonListener;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "daemonCanceled", "", "reason", "", "fileEditors", "", "Lcom/intellij/openapi/fileEditor/FileEditor;", "daemonFinished", "daemonStarting", "daemonStopped", "isCancelled", "", "intellij.performanceTesting"})
@SourceDebugExtension(value={"SMAP\nWaitForFinishedCodeAnalysis.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WaitForFinishedCodeAnalysis.kt\ncom/jetbrains/performancePlugin/commands/WaitForFinishedCodeAnalysisListener\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,405:1\n31#2,2:406\n31#2,2:408\n*S KotlinDebug\n*F\n+ 1 WaitForFinishedCodeAnalysis.kt\ncom/jetbrains/performancePlugin/commands/WaitForFinishedCodeAnalysisListener\n*L\n303#1:406,2\n325#1:408,2\n*E\n"})
public final class WaitForFinishedCodeAnalysisListener
implements DaemonCodeAnalyzer.DaemonListener {
    @NotNull
    private final Project project;

    public WaitForFinishedCodeAnalysisListener(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        if (!ApplicationManagerEx.isInIntegrationTest()) {
            ExtensionNotApplicableException extensionNotApplicableException = ExtensionNotApplicableException.create();
            Intrinsics.checkNotNullExpressionValue((Object)extensionNotApplicableException, (String)"create(...)");
            throw (Throwable)extensionNotApplicableException;
        }
    }

    public void daemonStarting(@NotNull Collection<? extends FileEditor> fileEditors) {
        Intrinsics.checkNotNullParameter(fileEditors, (String)"fileEditors");
        ListenerState.Companion.getLOG().info("daemon starting with " + fileEditors.size() + " unfiltered editors: " + CollectionsKt.joinToString$default((Iterable)fileEditors, (CharSequence)"\n", null, null, (int)0, null, (Function1)daemonStarting.1.INSTANCE, (int)30, null));
        ComponentManager $this$service$iv = (ComponentManager)this.project;
        boolean $i$f$service = false;
        Class<ListenerState> serviceClass$iv = ListenerState.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        ((ListenerState)object).registerAnalysisStarted(WaitForFinishedCodeAnalysisKt.access$getWorthy(fileEditors));
    }

    public void daemonCanceled(@NotNull String reason, @NotNull Collection<? extends FileEditor> fileEditors) {
        Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
        Intrinsics.checkNotNullParameter(fileEditors, (String)"fileEditors");
        ListenerState.Companion.getLOG().info("daemon canceled by the reason of '" + reason + "'");
        this.daemonStopped(fileEditors, true);
    }

    public void daemonFinished(@NotNull Collection<? extends FileEditor> fileEditors) {
        Intrinsics.checkNotNullParameter(fileEditors, (String)"fileEditors");
        this.daemonStopped(fileEditors, false);
    }

    private final void daemonStopped(Collection<? extends FileEditor> fileEditors, boolean isCancelled) {
        ListenerState.Companion.getLOG().info("daemon stopped with " + fileEditors.size() + " unfiltered editors");
        List worthy = WaitForFinishedCodeAnalysisKt.access$getWorthy(fileEditors);
        if (worthy.isEmpty()) {
            return;
        }
        Map highlightedEditors2 = (Map)ActionsKt.runReadAction((Function0)((Function0)new Function0<Map<TextEditor, ? extends ListenerState.HighlightedEditor>>(this, (List<? extends TextEditor>)worthy, isCancelled){
            final /* synthetic */ WaitForFinishedCodeAnalysisListener this$0;
            final /* synthetic */ List<TextEditor> $worthy;
            final /* synthetic */ boolean $isCancelled;
            {
                this.this$0 = $receiver;
                this.$worthy = $worthy;
                this.$isCancelled = $isCancelled;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final Map<TextEditor, ListenerState.HighlightedEditor> invoke() {
                void $this$associateWith$iv;
                boolean isFinishedInDumbMode = DumbService.Companion.isDumb(WaitForFinishedCodeAnalysisListener.access$getProject$p(this.this$0));
                Iterable iterable = this.$worthy;
                WaitForFinishedCodeAnalysisListener waitForFinishedCodeAnalysisListener = this.this$0;
                boolean bl = this.$isCancelled;
                boolean $i$f$associateWith = false;
                LinkedHashMap<K, V> result$iv = new LinkedHashMap<K, V>(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
                void $this$associateWithTo$iv$iv = $this$associateWith$iv;
                boolean $i$f$associateWithTo = false;
                for (T element$iv$iv : $this$associateWithTo$iv$iv) {
                    void it;
                    TextEditor textEditor = (TextEditor)element$iv$iv;
                    T t = element$iv$iv;
                    Map map = result$iv;
                    boolean bl2 = false;
                    ListenerState.HighlightedEditor highlightedEditor = ListenerState.HighlightedEditor.Companion.create((TextEditor)it, WaitForFinishedCodeAnalysisListener.access$getProject$p(waitForFinishedCodeAnalysisListener), bl, isFinishedInDumbMode);
                    map.put(t, highlightedEditor);
                }
                return result$iv;
            }
        }));
        ComponentManager $this$service$iv = (ComponentManager)this.project;
        boolean $i$f$service = false;
        Class<ListenerState> serviceClass$iv = ListenerState.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        ((ListenerState)object).registerAnalysisFinished$intellij_performanceTesting(highlightedEditors2);
    }

    public static final /* synthetic */ Project access$getProject$p(WaitForFinishedCodeAnalysisListener $this) {
        return $this.project;
    }
}

