/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api.recursive.assertion;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.assertj.core.api.recursive.assertion.RecursiveAssertionConfiguration;
import org.assertj.core.api.recursive.comparison.FieldLocation;
import org.assertj.core.util.Arrays;
import org.assertj.core.util.Lists;
import org.assertj.core.util.Sets;
import org.assertj.core.util.introspection.ClassUtils;

public class RecursiveAssertionDriver {
    private static final String NULL = "null";
    private static final String INDEX_FORMAT = "[%d]";
    private static final String KEY_FORMAT = "KEY[%s]";
    private static final String VALUE_FORMAT = "VAL[%s]";
    private final Set<String> visitedNodeIds = Sets.newHashSet();
    private final List<FieldLocation> fieldsFailingTheAssertion = Lists.list(new FieldLocation[0]);
    private final RecursiveAssertionConfiguration configuration;

    public RecursiveAssertionDriver(RecursiveAssertionConfiguration configuration) {
        this.configuration = configuration;
    }

    public List<FieldLocation> assertOverObjectGraph(Predicate<Object> predicate, Object graphNode) {
        this.assertRecursively(predicate, graphNode, graphNode.getClass(), FieldLocation.rootFieldLocation());
        return this.fieldsFailingTheAssertion.stream().sorted().collect(Collectors.toList());
    }

    public void reset() {
        this.visitedNodeIds.clear();
        this.fieldsFailingTheAssertion.clear();
    }

    private void assertRecursively(Predicate<Object> predicate, Object node2, Class<?> nodeType, FieldLocation fieldLocation) {
        if (this.nodeMustBeIgnored(node2, nodeType, fieldLocation)) {
            return;
        }
        boolean nodeAlreadyVisited = this.markNodeAsVisited(node2);
        if (nodeAlreadyVisited) {
            return;
        }
        if (!this.isRootObject(fieldLocation) && this.shouldEvaluateAssertion(nodeType)) {
            this.evaluateAssertion(predicate, node2, fieldLocation);
        }
        this.recurseIntoFieldsOfCurrentNode(predicate, node2, nodeType, fieldLocation);
    }

    private boolean nodeMustBeIgnored(Object node2, Class<?> nodeType, FieldLocation fieldLocation) {
        return this.isNullWhichAreIgnored(node2) || this.isPrimitiveWhichAreIgnored(nodeType) || this.configuration.matchesAnIgnoredField(fieldLocation) || this.configuration.matchesAnIgnoredFieldRegex(fieldLocation) || this.configuration.getIgnoredTypes().contains(nodeType);
    }

    private boolean isRootObject(FieldLocation fieldLocation) {
        return fieldLocation.equals(FieldLocation.rootFieldLocation());
    }

    private boolean isNullWhichAreIgnored(Object node2) {
        return node2 == null && this.configuration.shouldIgnoreAllNullFields();
    }

    private boolean isPrimitiveWhichAreIgnored(Class<?> nodeType) {
        return this.configuration.shouldIgnorePrimitiveFields() && ClassUtils.isPrimitiveOrWrapper(nodeType);
    }

    private void evaluateAssertion(Predicate<Object> predicate, Object node2, FieldLocation fieldLocation) {
        if (this.assertionFails(predicate, node2)) {
            this.fieldsFailingTheAssertion.add(fieldLocation);
        }
    }

    private boolean assertionFails(Predicate<Object> predicate, Object node2) {
        return !predicate.test(node2);
    }

    private boolean shouldEvaluateAssertion(Class<?> nodeType) {
        boolean ignoreContainerAssertion = this.configuration.shouldIgnoreContainer() && this.isContainer(nodeType);
        boolean ignoreMapAssertion = this.configuration.shouldIgnoreMap() && this.isMap(nodeType);
        boolean ignoreOptionalAssertion = this.configuration.shouldIgnoreOptional() && ClassUtils.isOptionalOrPrimitiveOptional(nodeType);
        return !ignoreContainerAssertion && !ignoreMapAssertion && !ignoreOptionalAssertion;
    }

    private boolean isContainer(Class<?> nodeType) {
        return this.isCollection(nodeType) || this.isArray(nodeType);
    }

    private void recurseIntoFieldsOfCurrentNode(Predicate<Object> predicate, Object node2, Class<?> nodeType, FieldLocation fieldLocation) {
        if (this.isTypeRequiringSpecificHandling(nodeType)) {
            if (this.shouldRecurseOverSpecialTypes(nodeType)) {
                this.doRecursionForSpecialTypes(predicate, node2, nodeType, fieldLocation);
            }
        } else if (this.shouldRecurseIntoNode(node2)) {
            this.evaluateFieldsOfCurrentNodeRecursively(predicate, node2, fieldLocation);
        }
    }

    private boolean isTypeRequiringSpecificHandling(Class<?> nodeType) {
        return this.isCollection(nodeType) || this.isMap(nodeType) || this.isArray(nodeType) || ClassUtils.isOptionalOrPrimitiveOptional(nodeType);
    }

    private boolean shouldRecurseOverSpecialTypes(Class<?> nodeType) {
        boolean recurseOverContainer = this.isContainer(nodeType) && this.configuration.getCollectionAssertionPolicy() != RecursiveAssertionConfiguration.CollectionAssertionPolicy.COLLECTION_OBJECT_ONLY;
        boolean recurseOverMap = this.isMap(nodeType) && this.configuration.getMapAssertionPolicy() != RecursiveAssertionConfiguration.MapAssertionPolicy.MAP_OBJECT_ONLY;
        boolean recurseOverOptional = ClassUtils.isOptionalOrPrimitiveOptional(nodeType) && this.configuration.getOptionalAssertionPolicy() != RecursiveAssertionConfiguration.OptionalAssertionPolicy.OPTIONAL_OBJECT_ONLY;
        return recurseOverContainer || recurseOverMap || recurseOverOptional;
    }

    private void doRecursionForSpecialTypes(Predicate<Object> predicate, Object node2, Class<?> nodeType, FieldLocation fieldLocation) {
        if (this.isCollection(nodeType)) {
            this.recurseIntoCollection(predicate, (Collection)node2, fieldLocation);
        } else if (this.isArray(nodeType)) {
            this.recurseIntoArray(predicate, node2, nodeType, fieldLocation);
        } else if (this.isMap(nodeType)) {
            this.recurseIntoMap(predicate, (Map)node2, fieldLocation);
        } else if (ClassUtils.isOptionalOrPrimitiveOptional(nodeType)) {
            this.recurseIntoOptional(predicate, node2, fieldLocation);
        }
    }

    private void recurseIntoCollection(Predicate<Object> predicate, Collection<?> collection, FieldLocation fieldLocation) {
        if (collection == null) {
            return;
        }
        int index = 0;
        for (Object element2 : collection) {
            this.assertRecursively(predicate, element2, RecursiveAssertionDriver.safeGetClass(element2), fieldLocation.field(String.format(INDEX_FORMAT, index)));
            ++index;
        }
    }

    private void recurseIntoArray(Predicate<Object> predicate, Object node2, Class<?> nodeType, FieldLocation fieldLocation) {
        if (node2 == null) {
            return;
        }
        Class<?> arrayType = nodeType.getComponentType();
        Object[] array = Arrays.asObjectArray(node2);
        for (int i = 0; i < array.length; ++i) {
            this.assertRecursively(predicate, array[i], arrayType, fieldLocation.field(String.format(INDEX_FORMAT, i)));
        }
    }

    private void recurseIntoOptional(Predicate<Object> predicate, Object node2, FieldLocation fieldLocation) {
        OptionalDouble optionalDoubleNode;
        if (node2 instanceof Optional) {
            Optional optionalNode = (Optional)node2;
            if (optionalNode.isPresent()) {
                Class<?> nextNodeType = RecursiveAssertionDriver.safeGetClass(optionalNode.get());
                this.assertRecursively(predicate, optionalNode.get(), nextNodeType, fieldLocation.field("value"));
            }
        } else if (node2 instanceof OptionalInt) {
            OptionalInt optionalIntNode = (OptionalInt)node2;
            if (optionalIntNode.isPresent()) {
                this.evaluateAssertion(predicate, optionalIntNode.getAsInt(), fieldLocation.field("value"));
            }
        } else if (node2 instanceof OptionalLong) {
            OptionalLong optionalLongNode = (OptionalLong)node2;
            if (optionalLongNode.isPresent()) {
                this.evaluateAssertion(predicate, optionalLongNode.getAsLong(), fieldLocation.field("value"));
            }
        } else if (node2 instanceof OptionalDouble && (optionalDoubleNode = (OptionalDouble)node2).isPresent()) {
            this.evaluateAssertion(predicate, optionalDoubleNode.getAsDouble(), fieldLocation.field("value"));
        }
    }

    private void recurseIntoMap(Predicate<Object> predicate, Map<?, ?> node2, FieldLocation fieldLocation) {
        if (node2 == null) {
            return;
        }
        this.recurseIntoMapValues(predicate, node2, fieldLocation);
        if (this.configuration.getMapAssertionPolicy() == RecursiveAssertionConfiguration.MapAssertionPolicy.MAP_OBJECT_AND_ENTRIES) {
            this.recurseIntoMapKeys(predicate, node2, fieldLocation);
        }
    }

    private void recurseIntoMapValues(Predicate<Object> predicate, Map<?, ?> currentNode, FieldLocation fieldLocation) {
        currentNode.values().forEach(nextNode -> this.recurseIntoMapElement(predicate, fieldLocation, nextNode, VALUE_FORMAT));
    }

    private void recurseIntoMapKeys(Predicate<Object> predicate, Map<?, ?> currentNode, FieldLocation fieldLocation) {
        currentNode.keySet().forEach(nextNode -> this.recurseIntoMapElement(predicate, fieldLocation, nextNode, KEY_FORMAT));
    }

    private void recurseIntoMapElement(Predicate<Object> predicate, FieldLocation fieldLocation, Object nextNode, String msgFormat) {
        Class<?> nextNodeType = RecursiveAssertionDriver.safeGetClass(nextNode);
        String nextNodeFieldName = nextNode != null ? nextNode.toString() : NULL;
        this.assertRecursively(predicate, nextNode, nextNodeType, fieldLocation.field(String.format(msgFormat, nextNodeFieldName)));
    }

    private static Class<?> safeGetClass(Object object) {
        return object != null ? object.getClass() : Object.class;
    }

    private boolean shouldRecurseIntoNode(Object node2) {
        return node2 != null && !this.nodeIsJavaTypeToIgnore(node2);
    }

    private boolean nodeIsJavaTypeToIgnore(Object node2) {
        String canonicalName = node2.getClass().getCanonicalName();
        boolean isJCLType = canonicalName.startsWith("java.") || canonicalName.startsWith("javax.");
        return isJCLType && this.configuration.shouldSkipJavaLibraryTypeObjects();
    }

    private void evaluateFieldsOfCurrentNodeRecursively(Predicate<Object> predicate, Object node2, FieldLocation fieldLocation) {
        this.configuration.getIntrospectionStrategy().getChildNodesOf(node2).forEach(field -> this.assertRecursively(predicate, field.value, field.type, fieldLocation.field(field.name)));
    }

    private boolean markNodeAsVisited(Object node2) {
        if (node2 == null) {
            return false;
        }
        String objectId = RecursiveAssertionDriver.identityToString(node2);
        return !this.visitedNodeIds.add(objectId);
    }

    private static String identityToString(Object object) {
        if (object == null) {
            return null;
        }
        String name = object.getClass().getName();
        String hexString = Integer.toHexString(System.identityHashCode(object));
        return name + '@' + hexString;
    }

    private boolean isCollection(Class<?> nodeType) {
        return Collection.class.isAssignableFrom(nodeType);
    }

    private boolean isArray(Class<?> nodeType) {
        return nodeType.isArray();
    }

    private boolean isMap(Class<?> nodeType) {
        return Map.class.isAssignableFrom(nodeType);
    }
}

