/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.error;

import java.time.Period;
import org.assertj.core.error.BasicErrorMessageFactory;

public class ShouldHavePeriod
extends BasicErrorMessageFactory {
    private static final String EXPECTED_PREFIX = "%nExpecting Period:%n  %s%nto have %s ";

    private ShouldHavePeriod(Period actual, int actualSpecific, int expectedSpecific, String metric) {
        super(EXPECTED_PREFIX + metric + " but had %s", actual, expectedSpecific, actualSpecific);
    }

    public static ShouldHavePeriod shouldHaveYears(Period actual, int actualYear, int expectedYear) {
        String metric = Math.abs(expectedYear) == 1 ? "year" : "years";
        return new ShouldHavePeriod(actual, actualYear, expectedYear, metric);
    }

    public static ShouldHavePeriod shouldHaveMonths(Period actual, int actualMonths, int expectedMonths) {
        String metric = Math.abs(expectedMonths) == 1 ? "month" : "months";
        return new ShouldHavePeriod(actual, actualMonths, expectedMonths, metric);
    }

    public static ShouldHavePeriod shouldHaveDays(Period actual, int actualDays, int expectedDays) {
        String metric = Math.abs(expectedDays) == 1 ? "day" : "days";
        return new ShouldHavePeriod(actual, actualDays, expectedDays, metric);
    }
}

