/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.swing.data;

import org.assertj.swing.dependency.jsr305.Nonnull;

public class TableCell {
    public final int row;
    public final int column;

    @Nonnull
    public static TableCellBuilder row(int row) {
        return new TableCellBuilder(row);
    }

    protected TableCell(int row, int column) {
        this.row = row;
        this.column = column;
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TableCell)) {
            return false;
        }
        TableCell other = (TableCell)obj;
        if (this.row != other.row) {
            return false;
        }
        return this.column == other.column;
    }

    public final int hashCode() {
        int result2 = 1;
        result2 = 31 * result2 + this.column;
        result2 = 31 * result2 + this.row;
        return result2;
    }

    public String toString() {
        return String.format("[row=%d, column=%d]", this.row, this.column);
    }

    public static class TableCellBuilder {
        private final int row;

        TableCellBuilder(int row) {
            this.row = row;
        }

        @Nonnull
        public TableCell column(int column) {
            return new TableCell(this.row, column);
        }
    }
}

