/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.swing.util;

import java.lang.reflect.Array;
import org.assertj.core.presentation.StandardRepresentation;
import org.assertj.core.util.Objects;
import org.assertj.core.util.Preconditions;
import org.assertj.core.util.Strings;
import org.assertj.swing.dependency.jsr305.Nonnull;
import org.assertj.swing.dependency.jsr305.Nullable;
import org.assertj.swing.internal.annotation.InternalApi;

public final class Arrays {
    private static final String NO_COLUMNS = "[[]]";
    private static final String NO_ROWS = "[]";
    private static final String NULL = "null";

    public static boolean equal(@Nullable String[][] one, @Nullable String[][] two) {
        if (one == null && two == null) {
            return true;
        }
        if (one == null || two == null) {
            return false;
        }
        if (one.length != two.length) {
            return false;
        }
        if (one.length == 0) {
            return true;
        }
        if (one[0].length != two[0].length) {
            return false;
        }
        for (int i = 0; i < one.length; ++i) {
            for (int j = 0; j < one[i].length; ++j) {
                if (Objects.areEqual(one[i][j], two[i][j])) continue;
                return false;
            }
        }
        return true;
    }

    @InternalApi
    public static String format(Object object) {
        return new StandardRepresentation().toStringOf(object);
    }

    @Nonnull
    public static String format(@Nullable String[][] array) {
        if (array == null) {
            return NULL;
        }
        int size = array.length;
        if (size == 0) {
            return NO_ROWS;
        }
        if (array[0].length == 0) {
            return NO_COLUMNS;
        }
        StringBuilder b = new StringBuilder();
        b.append("[");
        for (int i = 0; i < size; ++i) {
            if (i != 0) {
                b.append(System.lineSeparator()).append(" ");
            }
            Arrays.addLine(array[i], b);
            if (i == size - 1) continue;
            b.append(",");
        }
        b.append("]");
        return b.toString();
    }

    private static void addLine(@Nullable String[] line, @Nonnull StringBuilder b) {
        if (line == null) {
            b.append(NULL);
            return;
        }
        int lineSize = line.length;
        b.append("[");
        for (int i = 0; i < lineSize; ++i) {
            b.append(Strings.quote(line[i]));
            if (i == lineSize - 1) continue;
            b.append(", ");
        }
        b.append("]");
    }

    @Nonnull
    public static int[] copyOf(@Nonnull int[] array) {
        Preconditions.checkNotNull(array);
        int arraySize = array.length;
        int[] copy = new int[arraySize];
        for (int i = 0; i < arraySize; ++i) {
            copy[i] = array[i];
        }
        return copy;
    }

    public static <T> T[] copyOf(@Nonnull T[] array) {
        Preconditions.checkNotNull(array);
        int arraySize = array.length;
        Object[] copy = (Object[])Array.newInstance(array.getClass().getComponentType(), arraySize);
        for (int i = 0; i < arraySize; ++i) {
            copy[i] = array[i];
        }
        return copy;
    }

    private Arrays() {
    }
}

