/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coverage;

import com.intellij.coverage.CoverageDataManager;
import com.intellij.coverage.CoverageSuite;
import com.intellij.coverage.CoverageSuitesBundle;
import com.intellij.coverage.JavaCoverageSuite;
import com.intellij.coverage.analysis.JavaCoverageClassesEnumerator;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.rt.coverage.util.classFinder.ClassFinder;
import com.intellij.rt.coverage.util.classFinder.ClassPathEntry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Pattern;

final class IdeaClassFinder
extends ClassFinder {
    private final Project myProject;
    private final CoverageSuitesBundle myCurrentSuite;

    IdeaClassFinder(Project project, CoverageSuitesBundle currentSuite) {
        super(IdeaClassFinder.obtainPatternsFromSuite(currentSuite), new ArrayList());
        this.myProject = project;
        this.myCurrentSuite = currentSuite;
    }

    private static List<Pattern> obtainPatternsFromSuite(CoverageSuitesBundle currentSuiteBundle) {
        ArrayList<Pattern> includePatterns = new ArrayList<Pattern>();
        for (CoverageSuite currentSuite : currentSuiteBundle.getSuites()) {
            for (String pattern : ((JavaCoverageSuite)currentSuite).getFilteredPackageNames()) {
                includePatterns.add(Pattern.compile(pattern + ".*"));
            }
            for (String pattern : ((JavaCoverageSuite)currentSuite).getFilteredClassNames()) {
                includePatterns.add(Pattern.compile(pattern));
            }
        }
        return includePatterns;
    }

    protected Collection<ClassPathEntry> getClassPathEntries() {
        HashSet<ClassPathEntry> entries = new HashSet<ClassPathEntry>();
        Module[] modules2 = ModuleManager.getInstance((Project)this.myProject).getModules();
        CoverageDataManager coverageManager = CoverageDataManager.getInstance((Project)this.myProject);
        for (Module module : modules2) {
            VirtualFile[] roots;
            for (VirtualFile root : roots = JavaCoverageClassesEnumerator.getRoots(coverageManager, module, this.myCurrentSuite.isTrackTestFolders())) {
                entries.add(new ClassPathEntry(root.getPath()));
            }
        }
        return entries;
    }
}

