/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coverage.analysis;

import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import org.jetbrains.annotations.NotNull;

public final class AnalysisUtils {
    static boolean isClassFile(@NotNull File classFile) {
        if (classFile == null) {
            AnalysisUtils.$$$reportNull$$$0(0);
        }
        return classFile.getPath().endsWith(".class");
    }

    public static String getClassName(File classFile) {
        return StringUtil.trimEnd((String)classFile.getName(), (String)".class");
    }

    public static String getSourceToplevelFQName(String classFQVMName) {
        int index = classFQVMName.indexOf(36);
        if (index > 0) {
            classFQVMName = classFQVMName.substring(0, index);
        }
        classFQVMName = StringUtil.trimStart((String)classFQVMName, (String)"/");
        return AnalysisUtils.internalNameToFqn(classFQVMName);
    }

    @NotNull
    public static String internalNameToFqn(@NotNull String internalName) {
        if (internalName == null) {
            AnalysisUtils.$$$reportNull$$$0(1);
        }
        String string = internalName.replace('\\', '.').replace('/', '.');
        if (string == null) {
            AnalysisUtils.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public static String fqnToInternalName(@NotNull String fqn2) {
        if (fqn2 == null) {
            AnalysisUtils.$$$reportNull$$$0(3);
        }
        String string = fqn2.replace('.', '/');
        if (string == null) {
            AnalysisUtils.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    public static String buildVMName(@NotNull String packageVMName, @NotNull String simpleName) {
        if (packageVMName == null) {
            AnalysisUtils.$$$reportNull$$$0(5);
        }
        if (simpleName == null) {
            AnalysisUtils.$$$reportNull$$$0(6);
        }
        Object object = packageVMName.isEmpty() ? simpleName : packageVMName + "/" + simpleName;
        if (object == null) {
            AnalysisUtils.$$$reportNull$$$0(7);
        }
        return object;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 4, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classFile";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "internalName";
                break;
            }
            case 2: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/coverage/analysis/AnalysisUtils";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqn";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageVMName";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "simpleName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/coverage/analysis/AnalysisUtils";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "internalNameToFqn";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "fqnToInternalName";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVMName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isClassFile";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "internalNameToFqn";
                break;
            }
            case 2: 
            case 4: 
            case 7: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "fqnToInternalName";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "buildVMName";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 4, 7 -> new IllegalStateException(string);
        };
    }
}

