/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.navbar.backend.impl;

import com.intellij.model.Pointer;
import com.intellij.platform.navbar.NavBarItemExpandResult;
import com.intellij.platform.navbar.NavBarItemExpandResultKt;
import com.intellij.platform.navbar.NavBarItemPresentation;
import com.intellij.platform.navbar.NavBarItemPresentationData;
import com.intellij.platform.navbar.NavBarVmItem;
import com.intellij.platform.navbar.backend.NavBarItem;
import com.intellij.platform.navbar.backend.impl.IdeNavBarVmItemKt;
import com.intellij.platform.navbar.backend.impl.ImplKt;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import java.util.List;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u0010H\u0096@\u00a2\u0006\u0002\u0010\u0011J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0096\u0002J\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0096@\u00a2\u0006\u0002\u0010\u0011J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u000eH\u0016J\u0012\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00010\u0010*\u00020\u0003H\u0002R\u0019\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00030\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/intellij/platform/navbar/backend/impl/IdeNavBarVmItem;", "Lcom/intellij/platform/navbar/NavBarVmItem;", "item", "Lcom/intellij/platform/navbar/backend/NavBarItem;", "(Lcom/intellij/platform/navbar/backend/NavBarItem;)V", "pointer", "Lcom/intellij/model/Pointer;", "getPointer", "()Lcom/intellij/model/Pointer;", "presentation", "Lcom/intellij/platform/navbar/NavBarItemPresentationData;", "getPresentation", "()Lcom/intellij/platform/navbar/NavBarItemPresentationData;", "texts", "", "children", "", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "equals", "", "other", "", "expand", "Lcom/intellij/platform/navbar/NavBarItemExpandResult;", "hashCode", "", "toString", "childItems", "intellij.platform.navbar.backend"})
public final class IdeNavBarVmItem
implements NavBarVmItem {
    @NotNull
    private final Pointer<? extends NavBarItem> pointer;
    @NotNull
    private final NavBarItemPresentationData presentation;
    @NotNull
    private final String texts;

    @RequiresReadLock
    public IdeNavBarVmItem(@NotNull NavBarItem item) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        ThreadingAssertions.assertReadAccess();
        this.pointer = item.createPointer();
        NavBarItemPresentation navBarItemPresentation = item.presentation();
        Intrinsics.checkNotNull((Object)navBarItemPresentation, (String)"null cannot be cast to non-null type com.intellij.platform.navbar.NavBarItemPresentationData");
        this.presentation = (NavBarItemPresentationData)navBarItemPresentation;
        String string = this.getPresentation().getPopupText();
        this.texts = item.getClass().getCanonicalName() + "$" + StringsKt.replace$default((String)this.getPresentation().getText(), (String)"$", (String)"$$", (boolean)false, (int)4, null) + "$" + (string != null ? StringsKt.replace$default((String)string, (String)"$", (String)"$$", (boolean)false, (int)4, null) : null);
    }

    @NotNull
    public final Pointer<? extends NavBarItem> getPointer() {
        return this.pointer;
    }

    @NotNull
    public NavBarItemPresentationData getPresentation() {
        return this.presentation;
    }

    @Nullable
    public Object children(@NotNull Continuation<? super List<? extends NavBarVmItem>> $completion) {
        return IdeNavBarVmItemKt.access$fetch(this, (Function1)new Function1<NavBarItem, List<? extends NavBarVmItem>>(this){
            final /* synthetic */ IdeNavBarVmItem this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final List<NavBarVmItem> invoke(@NotNull NavBarItem $this$fetch) {
                Intrinsics.checkNotNullParameter((Object)$this$fetch, (String)"$this$fetch");
                return IdeNavBarVmItem.access$childItems(this.this$0, $this$fetch);
            }
        }, $completion);
    }

    @Nullable
    public Object expand(@NotNull Continuation<? super NavBarItemExpandResult> $completion) {
        return IdeNavBarVmItemKt.access$fetch(this, (Function1)new Function1<NavBarItem, NavBarItemExpandResult>(this){
            final /* synthetic */ IdeNavBarVmItem this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final NavBarItemExpandResult invoke(@NotNull NavBarItem $this$fetch) {
                Intrinsics.checkNotNullParameter((Object)$this$fetch, (String)"$this$fetch");
                return NavBarItemExpandResultKt.NavBarItemExpandResult((List)IdeNavBarVmItem.access$childItems(this.this$0, $this$fetch), (boolean)$this$fetch.navigateOnClick());
            }
        }, $completion);
    }

    private final List<NavBarVmItem> childItems(NavBarItem $this$childItems) {
        return IdeNavBarVmItemKt.toVmItems(ImplKt.children($this$childItems));
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type com.intellij.platform.navbar.backend.impl.IdeNavBarVmItem");
        IdeNavBarVmItem cfr_ignored_0 = (IdeNavBarVmItem)other;
        return Intrinsics.areEqual((Object)this.texts, (Object)((IdeNavBarVmItem)other).texts);
    }

    public int hashCode() {
        return this.texts.hashCode();
    }

    @NotNull
    public String toString() {
        return this.texts;
    }

    public static final /* synthetic */ List access$childItems(IdeNavBarVmItem $this, NavBarItem $receiver) {
        return $this.childItems($receiver);
    }
}

