/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.dependency.impl;

import com.intellij.util.SmartList;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import org.jetbrains.jps.javac.Iterators;

public final class RW {
    private RW() {
    }

    public static <T> void writeCollection(DataOutput out, Iterable<? extends T> seq, Writer<? super T> writable) throws IOException {
        Collection col = seq instanceof Collection ? (Collection)seq : Iterators.collect(seq, (Collection)new SmartList());
        out.writeInt(col.size());
        for (Object t : col) {
            writable.write(t);
        }
    }

    public static <T> List<T> readCollection(DataInput in, Reader<? extends T> reader) throws IOException {
        return (List)RW.readCollection(in, reader, new SmartList());
    }

    public static <T, C extends Collection<? super T>> C readCollection(DataInput in, Reader<? extends T> reader, C acc) throws IOException {
        int size = in.readInt();
        while (size-- > 0) {
            acc.add(reader.read());
        }
        return acc;
    }

    public static interface Writer<T> {
        public void write(T var1) throws IOException;
    }

    public static interface Reader<T> {
        public T read() throws IOException;
    }
}

