/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental.storage;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FileCollectionFactory;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.builders.BuildTarget;
import org.jetbrains.jps.cmdline.ProjectDescriptor;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.GlobalContextKey;
import org.jetbrains.jps.incremental.ModuleBuildTarget;
import org.jetbrains.jps.incremental.relativizer.PathRelativizerService;
import org.jetbrains.jps.incremental.storage.BuildTargetsState;
import org.jetbrains.jps.model.module.JpsModule;

public final class BuildTargetConfiguration {
    public static final Key<Set<JpsModule>> MODULES_WITH_TARGET_CONFIG_CHANGED_KEY = GlobalContextKey.create("_modules_with_target_config_changed_");
    private static final Logger LOG = Logger.getInstance(BuildTargetConfiguration.class);
    private static final GlobalContextKey<Set<File>> ALL_DELETED_ROOTS_KEY = GlobalContextKey.create("_all_deleted_output_roots_");
    private static final String DIRTY_MARK = "$dirty_mark$";
    private final BuildTarget<?> myTarget;
    private final BuildTargetsState myTargetsState;
    private String myConfiguration;
    private volatile String myCurrentState;

    public BuildTargetConfiguration(BuildTarget<?> target, BuildTargetsState targetsState) {
        this.myTarget = target;
        this.myTargetsState = targetsState;
        this.myConfiguration = this.load();
    }

    private String load() {
        File configFile = this.getConfigFile();
        if (configFile.exists()) {
            try {
                return new String(FileUtil.loadFileText((File)configFile));
            }
            catch (IOException e) {
                LOG.info("Cannot load configuration of " + this.myTarget);
            }
        }
        return "";
    }

    public boolean isTargetDirty(@NotNull ProjectDescriptor pd) {
        if (pd == null) {
            BuildTargetConfiguration.$$$reportNull$$$0(0);
        }
        return DIRTY_MARK.equals(this.myConfiguration) || !this.getCurrentState(pd).equals(this.myConfiguration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logDiagnostics(CompileContext context) {
        if (DIRTY_MARK.equals(this.myConfiguration)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(this.myTarget + " has been marked dirty in the previous compilation session");
            }
        } else {
            String currentState = this.getCurrentState(context.getProjectDescriptor());
            if (!currentState.equals(this.myConfiguration)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug(this.myTarget + " configuration was changed:");
                    LOG.debug("Old:");
                    LOG.debug(this.myConfiguration);
                    LOG.debug("New:");
                    LOG.debug(currentState);
                    LOG.debug(this.myTarget + " will be recompiled");
                }
                if (this.myTarget instanceof ModuleBuildTarget) {
                    JpsModule module = ((ModuleBuildTarget)this.myTarget).getModule();
                    Key<Set<JpsModule>> key = MODULES_WITH_TARGET_CONFIG_CHANGED_KEY;
                    synchronized (key) {
                        HashSet<JpsModule> modules = (HashSet<JpsModule>)MODULES_WITH_TARGET_CONFIG_CHANGED_KEY.get((UserDataHolder)context);
                        if (modules == null) {
                            modules = new HashSet<JpsModule>();
                            MODULES_WITH_TARGET_CONFIG_CHANGED_KEY.set((UserDataHolder)context, modules);
                        }
                        modules.add(module);
                    }
                }
            }
        }
    }

    public void save(CompileContext context) {
        this.persist(this.getCurrentState(context.getProjectDescriptor()));
    }

    public void invalidate() {
        this.persist(DIRTY_MARK);
    }

    private void persist(String data) {
        try {
            File configFile = this.getConfigFile();
            FileUtil.createParentDirs((File)configFile);
            try (BufferedWriter out = new BufferedWriter(new FileWriter(configFile));){
                out.write(data);
                this.myConfiguration = data;
            }
        }
        catch (IOException e) {
            LOG.info("Cannot save configuration of " + this.myConfiguration, (Throwable)e);
        }
    }

    private File getConfigFile() {
        return new File(this.myTargetsState.getDataPaths().getTargetDataRoot(this.myTarget), "config.dat");
    }

    private File getNonexistentOutputsFile() {
        return new File(this.myTargetsState.getDataPaths().getTargetDataRoot(this.myTarget), "nonexistent-outputs.dat");
    }

    @NotNull
    private String getCurrentState(@NotNull ProjectDescriptor pd) {
        String state;
        if (pd == null) {
            BuildTargetConfiguration.$$$reportNull$$$0(1);
        }
        if ((state = this.myCurrentState) == null) {
            this.myCurrentState = state = this.saveToString(pd);
        }
        String string = state;
        if (string == null) {
            BuildTargetConfiguration.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    private String saveToString(@NotNull ProjectDescriptor pd) {
        if (pd == null) {
            BuildTargetConfiguration.$$$reportNull$$$0(3);
        }
        StringWriter out = new StringWriter();
        this.myTarget.writeConfiguration(pd, new PrintWriter(out));
        String string = out.toString();
        if (string == null) {
            BuildTargetConfiguration.$$$reportNull$$$0(4);
        }
        return string;
    }

    public void storeNonexistentOutputRoots(CompileContext context) throws IOException {
        PathRelativizerService relativizer = context.getProjectDescriptor().dataManager.getRelativizer();
        Collection<File> outputRoots = this.myTarget.getOutputRoots(context);
        SmartList nonexistentOutputRoots = new SmartList();
        for (File root : outputRoots) {
            if (root.exists()) continue;
            nonexistentOutputRoots.add(relativizer.toRelative(root.getAbsolutePath()));
        }
        File file = this.getNonexistentOutputsFile();
        if (nonexistentOutputRoots.isEmpty()) {
            file.delete();
        } else {
            FileUtil.writeToFile((File)file, (String)StringUtil.join((Collection)nonexistentOutputRoots, (String)"\n"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean outputRootWasDeleted(CompileContext context) throws IOException {
        Set storedNonExistentOutputs;
        SmartList nonexistentOutputRoots = new SmartList();
        Collection<File> targetRoots = this.myTarget.getOutputRoots(context);
        GlobalContextKey<Set<File>> globalContextKey = ALL_DELETED_ROOTS_KEY;
        synchronized (globalContextKey) {
            Set allDeletedRoots = (Set)ALL_DELETED_ROOTS_KEY.get(context);
            for (File outputRoot : targetRoots) {
                boolean wasDeleted;
                boolean bl = wasDeleted = allDeletedRoots != null && allDeletedRoots.contains(outputRoot);
                if (!wasDeleted) {
                    boolean bl2 = wasDeleted = !outputRoot.exists();
                    if (wasDeleted) {
                        if (allDeletedRoots == null) {
                            allDeletedRoots = FileCollectionFactory.createCanonicalFileSet();
                            ALL_DELETED_ROOTS_KEY.set(context, allDeletedRoots);
                        }
                        allDeletedRoots.add(outputRoot);
                    }
                }
                if (!wasDeleted) continue;
                nonexistentOutputRoots.add(FileUtil.toSystemIndependentName((String)outputRoot.getAbsolutePath()));
            }
        }
        if (nonexistentOutputRoots.isEmpty()) {
            return false;
        }
        File file = this.getNonexistentOutputsFile();
        if (!file.exists()) {
            storedNonExistentOutputs = Collections.emptySet();
        } else {
            PathRelativizerService relativizer = context.getProjectDescriptor().dataManager.getRelativizer();
            List lines = ContainerUtil.map((Collection)StringUtil.split((String)FileUtil.loadFile((File)file), (String)"\n"), s -> relativizer.toFull((String)s));
            storedNonExistentOutputs = CollectionFactory.createFilePathSet((Collection)lines);
        }
        return !storedNonExistentOutputs.containsAll((Collection<?>)nonexistentOutputRoots);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pd";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/jps/incremental/storage/BuildTargetConfiguration";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/jps/incremental/storage/BuildTargetConfiguration";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentState";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "saveToString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isTargetDirty";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getCurrentState";
                break;
            }
            case 2: 
            case 4: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "saveToString";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

