/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental.storage;

import com.intellij.util.Function;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.IOUtil;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.incremental.relativizer.PathRelativizerService;
import org.jetbrains.jps.incremental.storage.AbstractStateStorage;
import org.jetbrains.jps.incremental.storage.PathStringDescriptor;
import org.jetbrains.jps.javac.Iterators;

public final class OneToManyPathsMapping
extends AbstractStateStorage<String, Collection<String>> {
    private final PathRelativizerService myRelativizer;

    public OneToManyPathsMapping(File storePath, PathRelativizerService relativizer) throws IOException {
        super(storePath, PathStringDescriptor.INSTANCE, new PathCollectionExternalizer());
        this.myRelativizer = relativizer;
    }

    @Override
    public void update(@NotNull String keyPath, @NotNull Collection<String> boundPaths) throws IOException {
        if (keyPath == null) {
            OneToManyPathsMapping.$$$reportNull$$$0(0);
        }
        if (boundPaths == null) {
            OneToManyPathsMapping.$$$reportNull$$$0(1);
        }
        super.update(this.normalizePath(keyPath), this.normalizePaths(boundPaths));
    }

    @Override
    public void update(@NotNull String keyPath, @NotNull String boundPath) throws IOException {
        if (keyPath == null) {
            OneToManyPathsMapping.$$$reportNull$$$0(2);
        }
        if (boundPath == null) {
            OneToManyPathsMapping.$$$reportNull$$$0(3);
        }
        super.update(this.normalizePath(keyPath), Collections.singleton(this.normalizePath(boundPath)));
    }

    @Override
    public void appendData(@NotNull String keyPath, @NotNull String boundPath) throws IOException {
        if (keyPath == null) {
            OneToManyPathsMapping.$$$reportNull$$$0(4);
        }
        if (boundPath == null) {
            OneToManyPathsMapping.$$$reportNull$$$0(5);
        }
        super.appendData(this.normalizePath(keyPath), Collections.singleton(this.normalizePath(boundPath)));
    }

    @Override
    public void appendData(@NotNull String keyPath, @NotNull Collection<String> boundPaths) throws IOException {
        if (keyPath == null) {
            OneToManyPathsMapping.$$$reportNull$$$0(6);
        }
        if (boundPaths == null) {
            OneToManyPathsMapping.$$$reportNull$$$0(7);
        }
        super.appendData(this.normalizePath(keyPath), this.normalizePaths(boundPaths));
    }

    @Override
    @Nullable
    public Collection<String> getState(@NotNull String keyPath) throws IOException {
        Collection collection;
        if (keyPath == null) {
            OneToManyPathsMapping.$$$reportNull$$$0(8);
        }
        return (collection = (Collection)super.getState(this.normalizePath(keyPath))) != null ? ContainerUtil.map((Collection)collection, this.toFull()) : null;
    }

    @NotNull
    public Iterator<String> getStateIterator(@NotNull String keyPath) throws IOException {
        Collection collection;
        if (keyPath == null) {
            OneToManyPathsMapping.$$$reportNull$$$0(9);
        }
        Iterator iterator = (collection = (Collection)super.getState(this.normalizePath(keyPath))) == null ? Collections.emptyIterator() : Iterators.map(collection.iterator(), this.myRelativizer::toFull);
        if (iterator == null) {
            OneToManyPathsMapping.$$$reportNull$$$0(10);
        }
        return iterator;
    }

    @Override
    public void remove(@NotNull String keyPath) throws IOException {
        if (keyPath == null) {
            OneToManyPathsMapping.$$$reportNull$$$0(11);
        }
        super.remove(this.normalizePath(keyPath));
    }

    @Override
    public Collection<String> getKeys() throws IOException {
        return ContainerUtil.map(super.getKeys(), this.toFull());
    }

    @Override
    public Iterator<String> getKeysIterator() throws IOException {
        return Iterators.map(super.getKeysIterator(), this.myRelativizer::toFull);
    }

    public void removeData(@NotNull String keyPath, @NotNull String boundPath) throws IOException {
        Collection<String> outputPaths;
        if (keyPath == null) {
            OneToManyPathsMapping.$$$reportNull$$$0(12);
        }
        if (boundPath == null) {
            OneToManyPathsMapping.$$$reportNull$$$0(13);
        }
        if ((outputPaths = this.getState(keyPath)) != null) {
            boolean removed;
            String normalizedPath = this.normalizePath(boundPath);
            List newState = ContainerUtil.filter(outputPaths, path -> !normalizedPath.equals(path));
            boolean bl = removed = newState.size() != outputPaths.size();
            if (removed) {
                if (newState.isEmpty()) {
                    this.remove(keyPath);
                } else {
                    this.update(keyPath, newState);
                }
            }
        }
    }

    @NotNull
    private Function<String, String> toFull() {
        Function function = s -> this.myRelativizer.toFull((String)s);
        if (function == null) {
            OneToManyPathsMapping.$$$reportNull$$$0(14);
        }
        return function;
    }

    private String normalizePath(@NotNull String path) {
        if (path == null) {
            OneToManyPathsMapping.$$$reportNull$$$0(15);
        }
        return this.myRelativizer.toRelative(path);
    }

    private Collection<String> normalizePaths(Collection<String> outputs) {
        ArrayList<String> normalized = new ArrayList<String>(outputs.size());
        for (String out : outputs) {
            normalized.add(this.normalizePath(out));
        }
        return normalized;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyPath";
                break;
            }
            case 1: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "boundPaths";
                break;
            }
            case 3: 
            case 5: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "boundPath";
                break;
            }
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/jps/incremental/storage/OneToManyPathsMapping";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/jps/incremental/storage/OneToManyPathsMapping";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getStateIterator";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "toFull";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "appendData";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getState";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getStateIterator";
                break;
            }
            case 10: 
            case 14: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "remove";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "removeData";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "normalizePath";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class PathCollectionExternalizer
    implements DataExternalizer<Collection<String>> {
        private PathCollectionExternalizer() {
        }

        public void save(@NotNull DataOutput out, Collection<String> value) throws IOException {
            if (out == null) {
                PathCollectionExternalizer.$$$reportNull$$$0(0);
            }
            for (String str : value) {
                IOUtil.writeUTF((DataOutput)out, (String)str);
            }
        }

        public Collection<String> read(@NotNull DataInput in) throws IOException {
            if (in == null) {
                PathCollectionExternalizer.$$$reportNull$$$0(1);
            }
            Set result = CollectionFactory.createFilePathLinkedSet();
            DataInputStream stream = (DataInputStream)in;
            while (stream.available() > 0) {
                String str = IOUtil.readUTF((DataInput)stream);
                result.add(str);
            }
            return result;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "out";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "in";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/jps/incremental/storage/OneToManyPathsMapping$PathCollectionExternalizer";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "save";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "read";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

