/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.project.data;

import com.intellij.openapi.externalSystem.ExternalSystemModulePropertyManager;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.manage.AbstractModuleDataService;
import com.intellij.openapi.externalSystem.settings.ExternalProjectSettings;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.Order;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.util.SmartList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.model.data.GradleSourceSetData;
import org.jetbrains.plugins.gradle.util.GradleConstants;

@Order(value=-2147483637)
public final class GradleSourceSetDataService
extends AbstractModuleDataService<GradleSourceSetData> {
    @NotNull
    public Key<GradleSourceSetData> getTargetDataKey() {
        Key<GradleSourceSetData> key = GradleSourceSetData.KEY;
        if (key == null) {
            GradleSourceSetDataService.$$$reportNull$$$0(0);
        }
        return key;
    }

    @NotNull
    public Computable<Collection<Module>> computeOrphanData(@NotNull Collection<? extends DataNode<GradleSourceSetData>> toImport, @NotNull ProjectData projectData, @NotNull Project project2, @NotNull IdeModifiableModelsProvider modelsProvider) {
        if (toImport == null) {
            GradleSourceSetDataService.$$$reportNull$$$0(1);
        }
        if (projectData == null) {
            GradleSourceSetDataService.$$$reportNull$$$0(2);
        }
        if (project2 == null) {
            GradleSourceSetDataService.$$$reportNull$$$0(3);
        }
        if (modelsProvider == null) {
            GradleSourceSetDataService.$$$reportNull$$$0(4);
        }
        Computable computable = () -> {
            SmartList orphanIdeModules = new SmartList();
            for (Module module : modelsProvider.getModules()) {
                if (module.isDisposed() || !ExternalSystemApiUtil.isExternalSystemAwareModule((ProjectSystemId)projectData.getOwner(), (Module)module) || !"sourceSet".equals(ExternalSystemApiUtil.getExternalModuleType((Module)module))) continue;
                String rootProjectPath = ExternalSystemApiUtil.getExternalRootProjectPath((Module)module);
                if (!projectData.getLinkedExternalProjectPath().equals(rootProjectPath) || module.getUserData(AbstractModuleDataService.MODULE_DATA_KEY) != null) continue;
                orphanIdeModules.add(module);
            }
            return orphanIdeModules;
        };
        if (computable == null) {
            GradleSourceSetDataService.$$$reportNull$$$0(5);
        }
        return computable;
    }

    @NotNull
    protected Module createModule(@NotNull DataNode<GradleSourceSetData> sourceSetModuleNode, @NotNull IdeModifiableModelsProvider modelsProvider) {
        String sourceSetModuleInternalName;
        if (sourceSetModuleNode == null) {
            GradleSourceSetDataService.$$$reportNull$$$0(6);
        }
        if (modelsProvider == null) {
            GradleSourceSetDataService.$$$reportNull$$$0(7);
        }
        DataNode parentModuleNode = sourceSetModuleNode.getParent();
        assert (parentModuleNode != null);
        Module parentModule = (Module)parentModuleNode.getUserData(MODULE_KEY);
        assert (parentModule != null);
        String projectPath = ((GradleSourceSetData)((Object)sourceSetModuleNode.getData())).getLinkedExternalProjectPath();
        String actualModuleName = modelsProvider.getModifiableModuleModel().getActualName(parentModule);
        ExternalProjectSettings settings2 = ExternalSystemApiUtil.getSettings((Project)parentModule.getProject(), (ProjectSystemId)GradleConstants.SYSTEM_ID).getLinkedProjectSettings(projectPath);
        if (settings2 != null && settings2.isUseQualifiedModuleNames() && !(sourceSetModuleInternalName = ((GradleSourceSetData)((Object)sourceSetModuleNode.getData())).getInternalName()).startsWith(actualModuleName)) {
            String sourceSetName = ((GradleSourceSetData)((Object)sourceSetModuleNode.getData())).getModuleName();
            String adjustedInternalName = GradleSourceSetDataService.findDeduplicatedModuleName(actualModuleName + "." + sourceSetName, modelsProvider);
            ((GradleSourceSetData)((Object)sourceSetModuleNode.getData())).setInternalName(adjustedInternalName);
        }
        Module module = super.createModule(sourceSetModuleNode, modelsProvider);
        if (module == null) {
            GradleSourceSetDataService.$$$reportNull$$$0(8);
        }
        return module;
    }

    @NotNull
    private static String findDeduplicatedModuleName(@NotNull String moduleName, @NotNull IdeModifiableModelsProvider modelsProvider) {
        String nextModuleNameCandidate;
        Module ideModule;
        if (moduleName == null) {
            GradleSourceSetDataService.$$$reportNull$$$0(9);
        }
        if (modelsProvider == null) {
            GradleSourceSetDataService.$$$reportNull$$$0(10);
        }
        if ((ideModule = modelsProvider.findIdeModule(moduleName)) == null) {
            String string2 = moduleName;
            if (string2 == null) {
                GradleSourceSetDataService.$$$reportNull$$$0(11);
            }
            return string2;
        }
        int i = 0;
        while ((ideModule = modelsProvider.findIdeModule(nextModuleNameCandidate = moduleName + "~" + ++i)) != null) {
        }
        String string3 = nextModuleNameCandidate;
        if (string3 == null) {
            GradleSourceSetDataService.$$$reportNull$$$0(12);
        }
        return string3;
    }

    protected void setModuleOptions(Module module, DataNode<GradleSourceSetData> moduleDataNode) {
        super.setModuleOptions(module, moduleDataNode);
        ExternalSystemModulePropertyManager.getInstance((Module)module).setExternalModuleType("sourceSet");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 6, 7, 9, 10 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/gradle/service/project/data/GradleSourceSetDataService";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toImport";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectData";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelsProvider";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceSetModuleNode";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetDataKey";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/gradle/service/project/data/GradleSourceSetDataService";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "computeOrphanData";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createModule";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "findDeduplicatedModuleName";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "computeOrphanData";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createModule";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "findDeduplicatedModuleName";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string2);
            case 1, 2, 3, 4, 6, 7, 9, 10 -> new IllegalArgumentException(string2);
        };
    }
}

