/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.archetype.source;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Reader;
import java.util.Iterator;
import org.apache.maven.archetype.catalog.Archetype;
import org.apache.maven.archetype.catalog.ArchetypeCatalog;
import org.apache.maven.archetype.source.ArchetypeDataSource;
import org.apache.maven.archetype.source.ArchetypeDataSourceException;
import org.apache.maven.archetype.source.CatalogArchetypeDataSource;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.shared.transfer.repository.RepositoryManager;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.util.ReaderFactory;

@Component(role=ArchetypeDataSource.class, hint="catalog")
public class LocalCatalogArchetypeDataSource
extends CatalogArchetypeDataSource {
    @Requirement
    private RepositoryManager repositoryManager;

    @Override
    public void updateCatalog(ProjectBuildingRequest buildingRequest, Archetype archetype) throws ArchetypeDataSourceException {
        ArchetypeCatalog catalog;
        File localRepo = this.repositoryManager.getLocalRepositoryBasedir(buildingRequest);
        File catalogFile = new File(localRepo, "archetype-catalog.xml");
        this.getLogger().debug("Catalog to be used for update: " + catalogFile.getAbsolutePath());
        if (catalogFile.exists()) {
            try {
                this.getLogger().debug("Reading catalog to be updated: " + catalogFile);
                catalog = this.readCatalog((Reader)ReaderFactory.newXmlReader((File)catalogFile));
            }
            catch (FileNotFoundException ex) {
                this.getLogger().debug("Catalog file don't exist");
                catalog = new ArchetypeCatalog();
            }
            catch (IOException e) {
                throw new ArchetypeDataSourceException("Error reading archetype catalog.", e);
            }
        } else {
            this.getLogger().debug("Catalog file don't exist");
            catalog = new ArchetypeCatalog();
        }
        Iterator<Archetype> archetypes = catalog.getArchetypes().iterator();
        boolean found = false;
        Archetype newArchetype = archetype;
        while (!found && archetypes.hasNext()) {
            Archetype a = archetypes.next();
            if (!a.getGroupId().equals(archetype.getGroupId()) || !a.getArtifactId().equals(archetype.getArtifactId())) continue;
            newArchetype = a;
            found = true;
        }
        if (!found) {
            catalog.addArchetype(newArchetype);
        }
        newArchetype.setVersion(archetype.getVersion());
        newArchetype.setRepository(archetype.getRepository());
        newArchetype.setDescription(archetype.getDescription());
        newArchetype.setProperties(archetype.getProperties());
        newArchetype.setGoals(archetype.getGoals());
        this.writeLocalCatalog(catalog, catalogFile);
    }

    @Override
    public ArchetypeCatalog getArchetypeCatalog(ProjectBuildingRequest buildingRequest) throws ArchetypeDataSourceException {
        File localRepo = this.repositoryManager.getLocalRepositoryBasedir(buildingRequest);
        File catalogFile = new File(localRepo, "archetype-catalog.xml");
        if (catalogFile.exists() && catalogFile.isDirectory()) {
            catalogFile = new File(catalogFile, "archetype-catalog.xml");
        }
        this.getLogger().debug("Getting archetypes from catalog: " + catalogFile);
        if (catalogFile.exists()) {
            try {
                return this.readCatalog((Reader)ReaderFactory.newXmlReader((File)catalogFile));
            }
            catch (FileNotFoundException e) {
                throw new ArchetypeDataSourceException("The specific archetype catalog does not exist.", e);
            }
            catch (IOException e) {
                throw new ArchetypeDataSourceException("Error reading archetype catalog.", e);
            }
        }
        return new ArchetypeCatalog();
    }
}

