/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.aether.graph;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import org.sonatype.aether.artifact.Artifact;
import org.sonatype.aether.graph.Exclusion;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Dependency {
    private static final Exclusion[] NO_EXCLUSIONS = new Exclusion[0];
    private final Artifact artifact;
    private final String scope;
    private final boolean optional;
    private final Exclusion[] exclusions;

    public Dependency(Artifact artifact, String scope) {
        this(artifact, scope, false);
    }

    public Dependency(Artifact artifact, String scope, boolean optional) {
        this(artifact, scope, optional, NO_EXCLUSIONS);
    }

    public Dependency(Artifact artifact, String scope, boolean optional, Collection<Exclusion> exclusions) {
        this(artifact, scope, optional, Dependency.toArray(exclusions));
    }

    private static Exclusion[] toArray(Collection<Exclusion> exclusions) {
        if (exclusions != null && !exclusions.isEmpty()) {
            return exclusions.toArray(new Exclusion[exclusions.size()]);
        }
        return NO_EXCLUSIONS;
    }

    private Dependency(Artifact artifact, String scope, boolean optional, Exclusion[] exclusions) {
        if (artifact == null) {
            throw new IllegalArgumentException("no artifact specified for dependency");
        }
        this.artifact = artifact;
        this.scope = scope != null ? scope : "";
        this.optional = optional;
        this.exclusions = exclusions;
    }

    public Artifact getArtifact() {
        return this.artifact;
    }

    public Dependency setArtifact(Artifact artifact) {
        if (this.artifact.equals(artifact)) {
            return this;
        }
        return new Dependency(artifact, this.scope, this.optional, this.exclusions);
    }

    public String getScope() {
        return this.scope;
    }

    public Dependency setScope(String scope) {
        if (this.scope.equals(scope) || scope == null && this.scope.length() <= 0) {
            return this;
        }
        return new Dependency(this.artifact, scope, this.optional, this.exclusions);
    }

    public boolean isOptional() {
        return this.optional;
    }

    public Dependency setOptional(boolean optional) {
        if (this.optional == optional) {
            return this;
        }
        return new Dependency(this.artifact, this.scope, optional, this.exclusions);
    }

    public Collection<Exclusion> getExclusions() {
        return Collections.unmodifiableCollection(Arrays.asList(this.exclusions));
    }

    public Dependency setExclusions(Collection<Exclusion> exclusions) {
        if (((Object)this.getExclusions()).equals(exclusions) || exclusions == null && this.exclusions.length <= 0) {
            return this;
        }
        return new Dependency(this.artifact, this.scope, this.optional, exclusions);
    }

    public String toString() {
        return String.valueOf(this.getArtifact()) + " (" + this.getScope() + (this.isOptional() ? "?" : "") + ")";
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !this.getClass().equals(obj.getClass())) {
            return false;
        }
        Dependency that = (Dependency)obj;
        return this.artifact.equals(that.artifact) && this.scope.equals(that.scope) && this.optional == that.optional && new HashSet<Exclusion>(Arrays.asList(this.exclusions)).equals(new HashSet<Exclusion>(Arrays.asList(that.exclusions)));
    }

    public int hashCode() {
        int hash = 17;
        hash = hash * 31 + this.artifact.hashCode();
        hash = hash * 31 + this.scope.hashCode();
        hash = hash * 31 + (this.optional ? 1 : 0);
        hash = hash * 31 + this.exclusions.length;
        return hash;
    }
}

