/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.maven.server.m40.utils;

import com.intellij.maven.server.m40.Maven40ServerEmbedderImpl;
import com.intellij.maven.server.m40.utils.Maven40AetherModelConverter;
import com.intellij.maven.server.m40.utils.Maven40EffectivePomDumper;
import com.intellij.maven.server.m40.utils.Maven40ExecutionResult;
import com.intellij.maven.server.m40.utils.Maven40ImporterSpy;
import com.intellij.maven.server.m40.utils.Maven40ModelConverter;
import com.intellij.maven.server.m40.utils.Maven40ProfileUtil;
import com.intellij.maven.server.m40.utils.Maven40ResolverUtil;
import com.intellij.maven.server.m40.utils.Maven40WorkspaceReader;
import com.intellij.maven.server.m40.utils.RemoteNativeMaven40ProjectHolder;
import com.intellij.maven.server.telemetry.MavenServerOpenTelemetry;
import java.io.File;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.maven.AbstractMavenLifecycleParticipant;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Model;
import org.apache.maven.model.building.ModelProblem;
import org.apache.maven.plugin.LegacySupport;
import org.apache.maven.project.DefaultDependencyResolutionRequest;
import org.apache.maven.project.DependencyResolutionException;
import org.apache.maven.project.DependencyResolutionRequest;
import org.apache.maven.project.DependencyResolutionResult;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.project.ProjectBuildingResult;
import org.apache.maven.project.ProjectDependenciesResolver;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.graph.DependencyVisitor;
import org.eclipse.aether.repository.LocalRepositoryManager;
import org.eclipse.aether.repository.WorkspaceReader;
import org.eclipse.aether.util.graph.visitor.TreeDependencyVisitor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.model.MavenArtifact;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.model.MavenModel;
import org.jetbrains.idea.maven.model.MavenProjectProblem;
import org.jetbrains.idea.maven.model.MavenWorkspaceMap;
import org.jetbrains.idea.maven.server.LongRunningTask;
import org.jetbrains.idea.maven.server.MavenServerExecutionResult;
import org.jetbrains.idea.maven.server.MavenServerGlobals;
import org.jetbrains.idea.maven.server.NativeMavenProjectHolder;
import org.jetbrains.idea.maven.server.PomHashMap;

public class Maven40ProjectResolver {
    @NotNull
    private final Maven40ServerEmbedderImpl myEmbedder;
    @NotNull
    private final MavenServerOpenTelemetry myTelemetry;
    private final boolean myUpdateSnapshots;
    @NotNull
    private final Maven40ImporterSpy myImporterSpy;
    private final LongRunningTask myLongRunningTask;
    private final PomHashMap myPomHashMap;
    private final List<String> myActiveProfiles;
    private final List<String> myInactiveProfiles;
    @Nullable
    private final MavenWorkspaceMap myWorkspaceMap;
    @NotNull
    private final File myLocalRepositoryFile;
    @NotNull
    private final Properties userProperties;
    private final boolean myResolveInParallel;

    public Maven40ProjectResolver(@NotNull Maven40ServerEmbedderImpl embedder, @NotNull MavenServerOpenTelemetry telemetry, boolean updateSnapshots, @NotNull Maven40ImporterSpy importerSpy, @NotNull LongRunningTask longRunningTask, @NotNull PomHashMap pomHashMap, @NotNull List<String> activeProfiles, @NotNull List<String> inactiveProfiles, @Nullable MavenWorkspaceMap workspaceMap, @NotNull File localRepositoryFile, @NotNull Properties userProperties, boolean resolveInParallel) {
        if (embedder == null) {
            Maven40ProjectResolver.$$$reportNull$$$0(0);
        }
        if (telemetry == null) {
            Maven40ProjectResolver.$$$reportNull$$$0(1);
        }
        if (importerSpy == null) {
            Maven40ProjectResolver.$$$reportNull$$$0(2);
        }
        if (longRunningTask == null) {
            Maven40ProjectResolver.$$$reportNull$$$0(3);
        }
        if (pomHashMap == null) {
            Maven40ProjectResolver.$$$reportNull$$$0(4);
        }
        if (activeProfiles == null) {
            Maven40ProjectResolver.$$$reportNull$$$0(5);
        }
        if (inactiveProfiles == null) {
            Maven40ProjectResolver.$$$reportNull$$$0(6);
        }
        if (localRepositoryFile == null) {
            Maven40ProjectResolver.$$$reportNull$$$0(7);
        }
        if (userProperties == null) {
            Maven40ProjectResolver.$$$reportNull$$$0(8);
        }
        this.myEmbedder = embedder;
        this.myTelemetry = telemetry;
        this.myUpdateSnapshots = updateSnapshots;
        this.myImporterSpy = importerSpy;
        this.myLongRunningTask = longRunningTask;
        this.myPomHashMap = pomHashMap;
        this.myActiveProfiles = activeProfiles;
        this.myInactiveProfiles = inactiveProfiles;
        this.myWorkspaceMap = workspaceMap;
        this.myLocalRepositoryFile = localRepositoryFile;
        this.userProperties = userProperties;
        this.myResolveInParallel = resolveInParallel;
    }

    @NotNull
    public ArrayList<MavenServerExecutionResult> resolveProjects() {
        ArrayList<MavenServerExecutionResult> arrayList;
        try {
            Collection results = (Collection)this.myTelemetry.callWithSpan("doResolveProject", () -> this.doResolveProject());
            ArrayList<MavenServerExecutionResult> list = new ArrayList<MavenServerExecutionResult>();
            results.stream().map(result -> this.createExecutionResult((Maven40ExecutionResult)result)).forEachOrdered(list::add);
            arrayList = list;
        }
        catch (Exception e) {
            throw this.myEmbedder.wrapToSerializableRuntimeException(e);
        }
        if (arrayList == null) {
            Maven40ProjectResolver.$$$reportNull$$$0(9);
        }
        return arrayList;
    }

    @NotNull
    private Collection<Maven40ExecutionResult> doResolveProject() {
        Set files = this.myPomHashMap.keySet();
        File file = !files.isEmpty() ? (File)files.iterator().next() : null;
        MavenExecutionRequest request = this.myEmbedder.createRequest(file, this.myActiveProfiles, this.myInactiveProfiles, this.userProperties);
        request.setUpdateSnapshots(this.myUpdateSnapshots);
        ArrayList<Maven40ExecutionResult> executionResults = new ArrayList<Maven40ExecutionResult>();
        ArrayList buildingResultInfos = new ArrayList();
        this.myEmbedder.executeWithMavenSession(request, this.myWorkspaceMap, this.myLongRunningTask.getIndicator(), session -> {
            try {
                List buildingResults = (List)this.myTelemetry.callWithSpan("getProjectBuildingResults " + files.size(), () -> this.getProjectBuildingResults(request, files, (MavenSession)session));
                boolean runInParallel = this.myResolveInParallel;
                ConcurrentHashMap fileToNewDependencyHash = new ConcurrentHashMap();
                this.myTelemetry.callWithSpan("dependencyHashes", () -> this.myTelemetry.execute(runInParallel, (Collection)buildingResults, br -> {
                    String newDependencyHash = Maven40EffectivePomDumper.dependencyHash(br.getProject());
                    if (null != newDependencyHash) {
                        fileToNewDependencyHash.put(br.getPomFile(), newDependencyHash);
                    }
                    return br;
                }));
                for (ProjectBuildingResult buildingResult : buildingResults) {
                    MavenProject project = buildingResult.getProject();
                    File pomFile = buildingResult.getPomFile();
                    if (project == null) {
                        executionResults.add(new Maven40ExecutionResult(pomFile, buildingResult.getProblems()));
                        continue;
                    }
                    String previousDependencyHash = this.myPomHashMap.getDependencyHash(buildingResult.getPomFile());
                    String newDependencyHash = (String)fileToNewDependencyHash.get(pomFile);
                    if (null != previousDependencyHash && previousDependencyHash.equals(newDependencyHash)) {
                        Maven40ExecutionResult res = new Maven40ExecutionResult(project, null, new ArrayList<Exception>(), new ArrayList<ModelProblem>());
                        res.setDependencyHash(previousDependencyHash);
                        res.setDependencyResolutionSkipped(true);
                        executionResults.add(res);
                        continue;
                    }
                    ArrayList<Exception> exceptions = new ArrayList<Exception>();
                    this.loadExtensions(project, exceptions);
                    buildingResultInfos.add(new ProjectBuildingResultInfo(buildingResult, exceptions, newDependencyHash));
                    this.myLongRunningTask.updateTotalRequests(buildingResultInfos.size());
                    Collection execResults = (Collection)this.myTelemetry.callWithSpan("resolveBuildingResults", () -> this.myTelemetry.execute(runInParallel, (Collection)buildingResultInfos, br -> {
                        if (this.myLongRunningTask.isCanceled()) {
                            return new Maven40ExecutionResult(Collections.emptyList());
                        }
                        Maven40ExecutionResult result = (Maven40ExecutionResult)this.myTelemetry.callWithSpan("resolveBuildingResult " + br.buildingResult.getProjectId(), () -> this.resolveBuildingResult(session.getRepositorySession(), br.buildingResult, br.exceptions));
                        result.setDependencyHash(br.dependencyHash);
                        this.myLongRunningTask.incrementFinishedRequests();
                        return result;
                    }));
                    executionResults.addAll(execResults);
                }
            }
            catch (Exception e) {
                executionResults.add(Maven40ProjectResolver.handleException(e));
            }
        });
        ArrayList<Maven40ExecutionResult> arrayList = executionResults;
        if (arrayList == null) {
            Maven40ProjectResolver.$$$reportNull$$$0(10);
        }
        return arrayList;
    }

    @NotNull
    private Maven40ExecutionResult resolveBuildingResult(RepositorySystemSession repositorySession, ProjectBuildingResult buildingResult, List<Exception> exceptions) {
        MavenProject project = buildingResult.getProject();
        try {
            ArrayList<ModelProblem> modelProblems = new ArrayList<ModelProblem>();
            if (buildingResult.getProblems() != null) {
                modelProblems.addAll(buildingResult.getProblems());
            }
            DependencyResolutionResult dependencyResolutionResult = this.resolveDependencies(project, repositorySession);
            Set<Artifact> artifacts = this.resolveArtifacts(dependencyResolutionResult);
            project.setArtifacts(artifacts);
            return new Maven40ExecutionResult(project, dependencyResolutionResult, exceptions, modelProblems);
        }
        catch (Exception e) {
            Maven40ExecutionResult maven40ExecutionResult = Maven40ProjectResolver.handleException(project, e);
            if (maven40ExecutionResult == null) {
                Maven40ProjectResolver.$$$reportNull$$$0(11);
            }
            return maven40ExecutionResult;
        }
    }

    private DependencyResolutionResult resolveDependencies(MavenProject project, RepositorySystemSession session) {
        DependencyResolutionResult resolutionResult;
        try {
            ProjectDependenciesResolver dependencyResolver = this.myEmbedder.getComponent(ProjectDependenciesResolver.class);
            DefaultDependencyResolutionRequest resolution = new DefaultDependencyResolutionRequest(project, session);
            resolutionResult = dependencyResolver.resolve((DependencyResolutionRequest)resolution);
        }
        catch (DependencyResolutionException e) {
            MavenServerGlobals.getLogger().warn((Throwable)e);
            resolutionResult = e.getResult();
        }
        LinkedHashSet artifacts = new LinkedHashSet();
        if (resolutionResult.getDependencyGraph() != null) {
            try {
                RepositoryUtils.toArtifacts(artifacts, (Collection)resolutionResult.getDependencyGraph().getChildren(), null == project.getArtifact() ? Collections.emptyList() : Collections.singletonList(project.getArtifact().getId()), null);
            }
            catch (Exception resolution) {
                // empty catch block
            }
            LocalRepositoryManager lrm = session.getLocalRepositoryManager();
            for (Artifact artifact : artifacts) {
                if (artifact.isResolved()) continue;
                String path = lrm.getPathForLocalArtifact(RepositoryUtils.toArtifact((Artifact)artifact));
                artifact.setFile(new File(lrm.getRepository().getBasedir(), path));
            }
        }
        project.setResolvedArtifacts(artifacts);
        project.setArtifacts(artifacts);
        return resolutionResult;
    }

    @NotNull
    private MavenServerExecutionResult createExecutionResult(Maven40ExecutionResult result) {
        File file = result.getPomFile();
        Collection problems = MavenProjectProblem.createProblemsList();
        this.myEmbedder.collectProblems(file, result.getExceptions(), result.getModelProblems(), problems);
        HashSet<MavenProjectProblem> unresolvedProblems = new HashSet<MavenProjectProblem>();
        this.collectUnresolvedArtifactProblems(file, result.getDependencyResolutionResult(), unresolvedProblems);
        MavenProject mavenProject = result.getMavenProject();
        if (mavenProject == null) {
            return new MavenServerExecutionResult(null, problems, Collections.emptySet());
        }
        MavenModel model = new MavenModel();
        try {
            DependencyResolutionResult dependencyResolutionResult = result.getDependencyResolutionResult();
            DependencyNode dependencyGraph = dependencyResolutionResult != null ? dependencyResolutionResult.getDependencyGraph() : null;
            List dependencyNodes = dependencyGraph != null ? dependencyGraph.getChildren() : Collections.emptyList();
            model = Maven40AetherModelConverter.convertModelWithAetherDependencyTree(mavenProject.getModel(), mavenProject.getCompileSourceRoots(), mavenProject.getTestCompileSourceRoots(), mavenProject.getArtifacts(), dependencyNodes, Collections.emptyList(), this.myLocalRepositoryFile);
        }
        catch (Exception e) {
            this.myEmbedder.collectProblems(mavenProject.getFile(), Collections.singleton(e), result.getModelProblems(), problems);
        }
        RemoteNativeMaven40ProjectHolder holder = new RemoteNativeMaven40ProjectHolder(mavenProject);
        try {
            UnicastRemoteObject.exportObject((Remote)((Object)holder), 0);
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
        Collection<String> activatedProfiles = Maven40ProfileUtil.collectActivatedProfiles(mavenProject);
        Map<String, String> mavenModelMap = Maven40ModelConverter.convertToMap(mavenProject.getModel());
        MavenServerExecutionResult.ProjectData data = new MavenServerExecutionResult.ProjectData(model, result.getDependencyHash(), result.isDependencyResolutionSkipped(), mavenModelMap, (NativeMavenProjectHolder)holder, activatedProfiles);
        if (null == model.getBuild() || null == model.getBuild().getDirectory()) {
            data = null;
        }
        return new MavenServerExecutionResult(data, problems, Collections.emptySet(), unresolvedProblems);
    }

    private void collectUnresolvedArtifactProblems(@Nullable File file, @Nullable DependencyResolutionResult result, Collection<MavenProjectProblem> problems) {
        if (result == null) {
            return;
        }
        String path = file == null ? "" : file.getPath();
        for (Dependency unresolvedDependency : result.getUnresolvedDependencies()) {
            Iterator iterator = result.getResolutionErrors(unresolvedDependency).iterator();
            if (!iterator.hasNext()) continue;
            Exception exception = (Exception)iterator.next();
            String message = Maven40ServerEmbedderImpl.getRootMessage(exception);
            Artifact artifact = RepositoryUtils.toArtifact((org.eclipse.aether.artifact.Artifact)unresolvedDependency.getArtifact());
            MavenArtifact mavenArtifact = Maven40ModelConverter.convertArtifact(artifact, this.myLocalRepositoryFile);
            problems.add(MavenProjectProblem.createUnresolvedArtifactProblem((String)path, (String)message, (boolean)true, (MavenArtifact)mavenArtifact));
        }
    }

    private static Maven40ExecutionResult handleException(Exception e) {
        return new Maven40ExecutionResult(Collections.singletonList(e));
    }

    private static Maven40ExecutionResult handleException(MavenProject mavenProject, Exception e) {
        return new Maven40ExecutionResult(mavenProject, Collections.singletonList(e));
    }

    @NotNull
    private Set<Artifact> resolveArtifacts(DependencyResolutionResult dependencyResolutionResult) {
        IdentityHashMap<Dependency, Artifact> winnerDependencyMap = new IdentityHashMap<Dependency, Artifact>();
        LinkedHashSet<Artifact> artifacts = new LinkedHashSet<Artifact>();
        Set addedDependencies = Collections.newSetFromMap(new IdentityHashMap());
        Maven40ProjectResolver.resolveConflicts(dependencyResolutionResult, winnerDependencyMap);
        for (Dependency dependency : dependencyResolutionResult.getDependencies()) {
            Artifact artifact = dependency == null ? null : (Artifact)winnerDependencyMap.get(dependency);
            if (artifact == null) continue;
            addedDependencies.add(dependency);
            artifacts.add(artifact);
            this.resolveAsModule(artifact);
        }
        ArrayDeque queue = new ArrayDeque(dependencyResolutionResult.getDependencyGraph().getChildren());
        while (!queue.isEmpty()) {
            Artifact artifact;
            DependencyNode node = (DependencyNode)queue.poll();
            queue.addAll(node.getChildren());
            Dependency dependency = node.getDependency();
            if (dependency == null || !addedDependencies.add(dependency) || (artifact = (Artifact)winnerDependencyMap.get(dependency)) == null) continue;
            addedDependencies.add(dependency);
            artifacts.add(artifact);
            this.resolveAsModule(artifact);
        }
        LinkedHashSet<Artifact> linkedHashSet = artifacts;
        if (linkedHashSet == null) {
            Maven40ProjectResolver.$$$reportNull$$$0(12);
        }
        return linkedHashSet;
    }

    private static void fillSessionCache(MavenSession mavenSession, RepositorySystemSession session, List<ProjectBuildingResult> buildingResults) {
        if (session instanceof DefaultRepositorySystemSession) {
            int initialCapacity = (int)((double)buildingResults.size() * 1.5);
            HashMap<MavenId, Model> cacheMavenModelMap = new HashMap<MavenId, Model>(initialCapacity);
            HashMap<String, MavenProject> mavenProjectMap = new HashMap<String, MavenProject>(initialCapacity);
            for (ProjectBuildingResult result : buildingResults) {
                if (result.getProblems() != null && !result.getProblems().isEmpty()) continue;
                Model model = result.getProject().getModel();
                String key = ArtifactUtils.key((String)model.getGroupId(), (String)model.getArtifactId(), (String)model.getVersion());
                mavenProjectMap.put(key, result.getProject());
                cacheMavenModelMap.put(new MavenId(model.getGroupId(), model.getArtifactId(), model.getVersion()), model);
            }
            mavenSession.setProjectMap(mavenProjectMap);
            ((DefaultRepositorySystemSession)session).setWorkspaceReader((WorkspaceReader)new Maven40WorkspaceReader(session.getWorkspaceReader(), cacheMavenModelMap));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadExtensions(MavenProject project, List<Exception> exceptions) {
        LegacySupport legacySupport;
        MavenSession session;
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        Collection<AbstractMavenLifecycleParticipant> lifecycleParticipants = this.myEmbedder.getLifecycleParticipants(Collections.singletonList(project));
        if (!lifecycleParticipants.isEmpty() && null != (session = (legacySupport = this.myEmbedder.getComponent(LegacySupport.class)).getSession())) {
            session.setCurrentProject(project);
            try {
                session.setAllProjects(Collections.singletonList(project));
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
            session.setProjects(Collections.singletonList(project));
            for (AbstractMavenLifecycleParticipant listener : lifecycleParticipants) {
                Thread.currentThread().setContextClassLoader(listener.getClass().getClassLoader());
                try {
                    listener.afterProjectsRead(session);
                }
                catch (Exception e) {
                    exceptions.add(e);
                }
                finally {
                    Thread.currentThread().setContextClassLoader(originalClassLoader);
                }
            }
        }
    }

    private boolean resolveAsModule(Artifact a) {
        MavenWorkspaceMap map = this.myWorkspaceMap;
        if (map == null) {
            return false;
        }
        MavenWorkspaceMap.Data resolved = map.findFileAndOriginalId(Maven40ModelConverter.createMavenId(a));
        if (resolved == null) {
            return false;
        }
        a.setResolved(true);
        a.setFile(resolved.getFile(a.getType()));
        a.selectVersion(resolved.originalId.getVersion());
        return true;
    }

    private static void resolveConflicts(DependencyResolutionResult dependencyResolutionResult, final Map<Dependency, Artifact> winnerDependencyMap) {
        dependencyResolutionResult.getDependencyGraph().accept((DependencyVisitor)new TreeDependencyVisitor(new DependencyVisitor(){

            public boolean visitEnter(DependencyNode node) {
                Object winner = node.getData().get("conflict.winner");
                Dependency dependency = node.getDependency();
                if (dependency != null && winner == null) {
                    Artifact winnerArtifact = Maven40AetherModelConverter.toArtifact(dependency);
                    winnerDependencyMap.put(dependency, winnerArtifact);
                }
                return true;
            }

            public boolean visitLeave(DependencyNode node) {
                return true;
            }
        }));
    }

    @NotNull
    private List<ProjectBuildingResult> getProjectBuildingResults(@NotNull MavenExecutionRequest request, @NotNull Collection<File> files, MavenSession session) {
        if (request == null) {
            Maven40ProjectResolver.$$$reportNull$$$0(13);
        }
        if (files == null) {
            Maven40ProjectResolver.$$$reportNull$$$0(14);
        }
        ProjectBuilder builder = this.myEmbedder.getComponent(ProjectBuilder.class);
        List<Object> buildingResults = new ArrayList<ProjectBuildingResult>();
        ProjectBuildingRequest projectBuildingRequest = request.getProjectBuildingRequest();
        projectBuildingRequest.setRepositorySession(session.getRepositorySession());
        projectBuildingRequest.setValidationLevel(0);
        projectBuildingRequest.setResolveDependencies(false);
        if (files.size() == 1) {
            Maven40ProjectResolver.buildSinglePom(builder, buildingResults, projectBuildingRequest, files.iterator().next());
        } else {
            try {
                buildingResults = builder.build(new ArrayList<File>(files), false, projectBuildingRequest);
            }
            catch (ProjectBuildingException e) {
                for (ProjectBuildingResult result : e.getResults()) {
                    if (result.getProject() != null) {
                        buildingResults.add(result);
                        continue;
                    }
                    Maven40ProjectResolver.buildSinglePom(builder, buildingResults, projectBuildingRequest, result.getPomFile());
                }
            }
        }
        ArrayList<ProjectBuildingResult> arrayList = buildingResults;
        if (arrayList == null) {
            Maven40ProjectResolver.$$$reportNull$$$0(15);
        }
        return arrayList;
    }

    private static void buildSinglePom(ProjectBuilder builder, List<ProjectBuildingResult> buildingResults, ProjectBuildingRequest projectBuildingRequest, File pomFile) {
        try {
            ProjectBuildingResult build = builder.build(pomFile, projectBuildingRequest);
            buildingResults.add(build);
        }
        catch (ProjectBuildingException e) {
            Maven40ResolverUtil.handleProjectBuildingException(buildingResults, e);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "embedder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "telemetry";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importerSpy";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "longRunningTask";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pomHashMap";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "activeProfiles";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inactiveProfiles";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localRepositoryFile";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "userProperties";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/maven/server/m40/utils/Maven40ProjectResolver";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/maven/server/m40/utils/Maven40ProjectResolver";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveProjects";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "doResolveProject";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveBuildingResult";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveArtifacts";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectBuildingResults";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 15: {
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getProjectBuildingResults";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ProjectBuildingResultInfo {
        ProjectBuildingResult buildingResult;
        List<Exception> exceptions;
        String dependencyHash;

        private ProjectBuildingResultInfo(ProjectBuildingResult buildingResult, List<Exception> exceptions, String dependencyHash) {
            this.buildingResult = buildingResult;
            this.exceptions = exceptions;
            this.dependencyHash = dependencyHash;
        }

        public String toString() {
            return "ProjectBuildingResultData{projectId=" + this.buildingResult.getProjectId() + ", dependencyHash=" + this.dependencyHash + '}';
        }
    }
}

