/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog;

import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.internal.statistic.eventLog.ExternalEventLogListenerProvider;
import com.intellij.internal.statistic.eventLog.ExternalEventLogListenerProviderExtension;
import com.intellij.internal.statistic.eventLog.ExternalEventLogSettings;
import com.intellij.internal.statistic.eventLog.StatisticsEventLogListener;
import com.intellij.internal.statistic.eventLog.StatisticsEventLogProviderUtil;
import com.intellij.internal.statistic.eventLog.StatisticsEventLoggerProvider;
import com.intellij.internal.statistic.utils.PluginInfoDetectorKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.ExtensionsArea;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.fus.reporting.model.lion3.LogEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.APP})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0007H\u0002J>\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00052\u0014\u0010\u0014\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\fJ\u0016\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0005J\u0010\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0016\u0010\u001c\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0005J\u0010\u0010\u001d\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002R)\u0010\u0003\u001a\u001d\u0012\t\u0012\u00070\u0005\u00a2\u0006\u0002\b\u0006\u0012\t\u0012\u00070\u0007\u00a2\u0006\u0002\b\u00060\u0004\u00a2\u0006\u0002\b\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R/\u0010\b\u001a#\u0012\f\u0012\n \n*\u0004\u0018\u00010\u00050\u0005\u0012\f\u0012\n \n*\u0004\u0018\u00010\u00070\u00070\t\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/intellij/internal/statistic/eventLog/EventLogListenersManager;", "", "()V", "listenersFromEP", "Ljava/util/concurrent/ConcurrentMap;", "", "Lorg/jetbrains/annotations/NotNull;", "Lcom/intellij/internal/statistic/eventLog/StatisticsEventLogListener;", "subscribers", "Lcom/intellij/util/containers/MultiMap;", "kotlin.jvm.PlatformType", "isLocalAllowed", "", "listener", "notifySubscribers", "", "recorderId", "validatedEvent", "Lcom/jetbrains/fus/reporting/model/lion3/LogEvent;", "rawEventId", "rawData", "", "isFromLocalRecorder", "subscribe", "subscriber", "subscribeFromExtension", "listenerProvider", "Lcom/intellij/internal/statistic/eventLog/ExternalEventLogListenerProvider;", "unsubscribe", "unsubscribeExtension", "intellij.platform.statistics"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nEventLogListenersManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EventLogListenersManager.kt\ncom/intellij/internal/statistic/eventLog/EventLogListenersManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,98:1\n1855#2,2:99\n1855#2,2:101\n766#2:103\n857#2,2:104\n1855#2,2:106\n1855#2,2:108\n*S KotlinDebug\n*F\n+ 1 EventLogListenersManager.kt\ncom/intellij/internal/statistic/eventLog/EventLogListenersManager\n*L\n22#1:99,2\n35#1:101,2\n48#1:103\n48#1:104,2\n48#1:106,2\n61#1:108,2\n*E\n"})
public final class EventLogListenersManager {
    @NotNull
    private final MultiMap<String, StatisticsEventLogListener> subscribers;
    @NotNull
    private ConcurrentMap<String, StatisticsEventLogListener> listenersFromEP;

    public EventLogListenersManager() {
        ExternalEventLogListenerProvider it;
        boolean $i$f$forEach;
        Iterable $this$forEach$iv;
        MultiMap multiMap = MultiMap.createConcurrent();
        Intrinsics.checkNotNullExpressionValue((Object)multiMap, (String)"createConcurrent(...)");
        this.subscribers = multiMap;
        ConcurrentMap concurrentMap = ConcurrentCollectionFactory.createConcurrentMap();
        Intrinsics.checkNotNullExpressionValue((Object)concurrentMap, (String)"createConcurrentMap(...)");
        this.listenersFromEP = concurrentMap;
        ExtensionsArea extensionsArea = ApplicationManager.getApplication().getExtensionArea();
        ExtensionPointName<ExternalEventLogSettings> extensionPointName = ExternalEventLogSettings.EP_NAME;
        Intrinsics.checkNotNullExpressionValue(extensionPointName, (String)"EP_NAME");
        if (extensionsArea.hasExtensionPoint(extensionPointName)) {
            $this$forEach$iv = ExternalEventLogSettings.EP_NAME.getExtensionList();
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (ExternalEventLogSettings)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                this.subscribeFromExtension(it);
            }
            ExternalEventLogSettings.EP_NAME.addExtensionPointListener((ExtensionPointListener)new ExtensionPointListener<ExternalEventLogSettings>(){

                public void extensionAdded(@NotNull ExternalEventLogSettings extension, @NotNull PluginDescriptor pluginDescriptor) {
                    Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
                    Intrinsics.checkNotNullParameter((Object)pluginDescriptor, (String)"pluginDescriptor");
                    this.subscribeFromExtension(extension);
                }

                public void extensionRemoved(@NotNull ExternalEventLogSettings extension, @NotNull PluginDescriptor pluginDescriptor) {
                    Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
                    Intrinsics.checkNotNullParameter((Object)pluginDescriptor, (String)"pluginDescriptor");
                    this.unsubscribeExtension(extension);
                }
            });
        }
        ExtensionsArea extensionsArea2 = ApplicationManager.getApplication().getExtensionArea();
        ExtensionPointName<ExternalEventLogListenerProviderExtension> extensionPointName2 = ExternalEventLogListenerProviderExtension.EP_NAME;
        Intrinsics.checkNotNullExpressionValue(extensionPointName2, (String)"EP_NAME");
        if (extensionsArea2.hasExtensionPoint(extensionPointName2)) {
            $this$forEach$iv = ExternalEventLogListenerProviderExtension.EP_NAME.getExtensionList();
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (ExternalEventLogListenerProviderExtension)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                this.subscribeFromExtension(it);
            }
            ExternalEventLogListenerProviderExtension.EP_NAME.addExtensionPointListener((ExtensionPointListener)new ExtensionPointListener<ExternalEventLogListenerProviderExtension>(){

                public void extensionAdded(@NotNull ExternalEventLogListenerProviderExtension extension, @NotNull PluginDescriptor pluginDescriptor) {
                    Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
                    Intrinsics.checkNotNullParameter((Object)pluginDescriptor, (String)"pluginDescriptor");
                    this.subscribeFromExtension(extension);
                }

                public void extensionRemoved(@NotNull ExternalEventLogListenerProviderExtension extension, @NotNull PluginDescriptor pluginDescriptor) {
                    Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
                    Intrinsics.checkNotNullParameter((Object)pluginDescriptor, (String)"pluginDescriptor");
                    this.unsubscribeExtension(extension);
                }
            });
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void subscribeFromExtension(ExternalEventLogListenerProvider listenerProvider) {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = StatisticsEventLogProviderUtil.getEventLogProviders();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            StatisticsEventLoggerProvider it = (StatisticsEventLoggerProvider)element$iv$iv;
            boolean bl = false;
            if (!it.isLoggingAlwaysActive()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            StatisticsEventLogListener eventLogListener;
            StatisticsEventLoggerProvider loggerProvider = (StatisticsEventLoggerProvider)element$iv;
            boolean bl = false;
            String recorderId = loggerProvider.getRecorderId();
            if (listenerProvider.getEventLogListener(recorderId) == null) continue;
            boolean bl2 = false;
            ((Map)this.listenersFromEP).put(listenerProvider.getClass().getName(), eventLogListener);
            Intrinsics.checkNotNull((Object)eventLogListener);
            this.subscribe(eventLogListener, recorderId);
        }
    }

    private final void unsubscribeExtension(ExternalEventLogListenerProvider listenerProvider) {
        if (this.listenersFromEP.isEmpty()) {
            return;
        }
        StatisticsEventLogListener statisticsEventLogListener = (StatisticsEventLogListener)this.listenersFromEP.get(listenerProvider.getClass().getName());
        if (statisticsEventLogListener == null) {
            return;
        }
        StatisticsEventLogListener listener = statisticsEventLogListener;
        Iterable $this$forEach$iv = StatisticsEventLogProviderUtil.getEventLogProviders();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            StatisticsEventLoggerProvider it = (StatisticsEventLoggerProvider)element$iv;
            boolean bl = false;
            this.unsubscribe(listener, it.getRecorderId());
        }
    }

    public final void notifySubscribers(@NotNull String recorderId, @NotNull LogEvent validatedEvent, @Nullable String rawEventId, @Nullable Map<String, ? extends Object> rawData, boolean isFromLocalRecorder) {
        Intrinsics.checkNotNullParameter((Object)recorderId, (String)"recorderId");
        Intrinsics.checkNotNullParameter((Object)validatedEvent, (String)"validatedEvent");
        Collection collection = this.subscribers.get((Object)recorderId);
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"get(...)");
        Collection listeners = collection;
        for (StatisticsEventLogListener listener : listeners) {
            if (isFromLocalRecorder) {
                Intrinsics.checkNotNull((Object)listener);
                if (!this.isLocalAllowed(listener)) continue;
            }
            listener.onLogEvent(validatedEvent, rawEventId, rawData);
        }
    }

    private final boolean isLocalAllowed(StatisticsEventLogListener listener) {
        return Intrinsics.areEqual((Object)listener.getClass().getName(), (Object)"com.intellij.ae.database.core.baseEvents.fus.Listener");
    }

    public final void subscribe(@NotNull StatisticsEventLogListener subscriber, @NotNull String recorderId) {
        Intrinsics.checkNotNullParameter((Object)subscriber, (String)"subscriber");
        Intrinsics.checkNotNullParameter((Object)recorderId, (String)"recorderId");
        if (!PluginInfoDetectorKt.getPluginInfo(subscriber.getClass()).isDevelopedByJetBrains()) {
            return;
        }
        this.subscribers.putValue((Object)recorderId, (Object)subscriber);
    }

    public final void unsubscribe(@NotNull StatisticsEventLogListener subscriber, @NotNull String recorderId) {
        Intrinsics.checkNotNullParameter((Object)subscriber, (String)"subscriber");
        Intrinsics.checkNotNullParameter((Object)recorderId, (String)"recorderId");
        this.subscribers.remove((Object)recorderId, (Object)subscriber);
    }
}

