/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog.fus;

import com.intellij.internal.statistic.eventLog.EmptyStatisticsEventLogger;
import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.StatisticsEventLogProviderUtil;
import com.intellij.internal.statistic.eventLog.StatisticsEventLogger;
import com.intellij.internal.statistic.eventLog.StatisticsEventLoggerProvider;
import com.intellij.internal.statistic.eventLog.StatisticsFileEventLogger;
import com.intellij.internal.statistic.eventLog.fus.FeatureUsageStateEventTrackerKt;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\f\u001a\u00020\rJ\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fJ\u0006\u0010\u0011\u001a\u00020\tJ\u0006\u0010\u0012\u001a\u00020\u0013J\u001c\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018J*\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00010\u001aJ\u0016\u0010\u0014\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u0017\u001a\u00020\u0018J\u001c\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018J0\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00010\u001aJ\u0006\u0010\u001d\u001a\u00020\rR\u001a\u0010\u0003\u001a\u00020\u00048FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u0005\u0010\u0002\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001e"}, d2={"Lcom/intellij/internal/statistic/eventLog/fus/FeatureUsageLogger;", "", "()V", "configVersion", "", "getConfigVersion$annotations", "getConfigVersion", "()I", "loggerProvider", "Lcom/intellij/internal/statistic/eventLog/StatisticsEventLoggerProvider;", "getLoggerProvider", "()Lcom/intellij/internal/statistic/eventLog/StatisticsEventLoggerProvider;", "cleanup", "", "flush", "Ljava/util/concurrent/CompletableFuture;", "Ljava/lang/Void;", "getConfig", "isEnabled", "", "log", "group", "Lcom/intellij/internal/statistic/eventLog/EventLogGroup;", "action", "", "data", "", "groupId", "logState", "rollOver", "intellij.platform.statistics"})
public final class FeatureUsageLogger {
    @NotNull
    public static final FeatureUsageLogger INSTANCE = new FeatureUsageLogger();

    private FeatureUsageLogger() {
    }

    private final StatisticsEventLoggerProvider getLoggerProvider() {
        return StatisticsEventLogProviderUtil.getEventLogProvider("FUS");
    }

    @NotNull
    public final CompletableFuture<Void> log(@NotNull EventLogGroup group, @NotNull String action) {
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        return this.getLoggerProvider().getLogger().logAsync(group, action, false);
    }

    public final void log(@NotNull EventLogGroup group, @NotNull String action, @NotNull Map<String, ? extends Object> data) {
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        Intrinsics.checkNotNullParameter(data, (String)"data");
        this.getLoggerProvider().getLogger().logAsync(group, action, data, false);
    }

    @NotNull
    public final CompletableFuture<Void> logState(@NotNull EventLogGroup group, @NotNull String action) {
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        return this.getLoggerProvider().getLogger().logAsync(group, action, true);
    }

    @NotNull
    public final CompletableFuture<Void> logState(@NotNull EventLogGroup group, @NotNull String action, @NotNull Map<String, ? extends Object> data) {
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        Intrinsics.checkNotNullParameter(data, (String)"data");
        return this.getLoggerProvider().getLogger().logAsync(group, action, data, true);
    }

    public final void log(@NotNull String groupId, @NotNull String action) {
        Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        this.getLoggerProvider().getLogger().logAsync(new EventLogGroup(groupId, 1, null, 4, null), action, true);
    }

    public final void cleanup() {
        this.getLoggerProvider().getLogger().cleanup();
    }

    public final void rollOver() {
        this.getLoggerProvider().getLogger().rollOver();
    }

    @NotNull
    public final CompletableFuture<Void> flush() {
        StatisticsEventLogger logger = this.getLoggerProvider().getLogger();
        if (logger instanceof StatisticsFileEventLogger) {
            return ((StatisticsFileEventLogger)logger).flush();
        }
        CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(null);
        Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"completedFuture(...)");
        return completableFuture;
    }

    @NotNull
    public final StatisticsEventLoggerProvider getConfig() {
        return this.getLoggerProvider();
    }

    public final boolean isEnabled() {
        return !(this.getLoggerProvider().getLogger() instanceof EmptyStatisticsEventLogger);
    }

    public static final int getConfigVersion() {
        return INSTANCE.getConfig().getVersion();
    }

    @JvmStatic
    public static /* synthetic */ void getConfigVersion$annotations() {
    }

    static {
        if (INSTANCE.isEnabled()) {
            FeatureUsageStateEventTrackerKt.initStateEventTrackers();
        }
    }
}

