/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog.validator.rules.impl;

import com.intellij.internal.statistic.eventLog.validator.ValidationResultType;
import com.intellij.internal.statistic.eventLog.validator.rules.EventContext;
import com.intellij.internal.statistic.eventLog.validator.rules.FUSRule;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000e"}, d2={"Lcom/intellij/internal/statistic/eventLog/validator/rules/impl/ComposerValidationRule;", "", "rules", "", "Lcom/intellij/internal/statistic/eventLog/validator/rules/FUSRule;", "(Ljava/util/List;)V", "getRules", "()Ljava/util/List;", "doValidate", "Lcom/intellij/internal/statistic/eventLog/validator/ValidationResultType;", "data", "", "context", "Lcom/intellij/internal/statistic/eventLog/validator/rules/EventContext;", "intellij.platform.statistics"})
public final class ComposerValidationRule {
    @NotNull
    private final List<FUSRule> rules;

    public ComposerValidationRule(@NotNull List<? extends FUSRule> rules) {
        Intrinsics.checkNotNullParameter(rules, (String)"rules");
        this.rules = rules;
    }

    @NotNull
    public final List<FUSRule> getRules() {
        return this.rules;
    }

    @NotNull
    public final ValidationResultType doValidate(@NotNull String data, @NotNull EventContext context) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        for (FUSRule rule : this.rules) {
            ValidationResultType validationResultType;
            Intrinsics.checkNotNullExpressionValue((Object)rule.validate(data, context), (String)"validate(...)");
            if (validationResultType != ValidationResultType.ACCEPTED) continue;
            return ValidationResultType.ACCEPTED;
        }
        return ValidationResultType.REJECTED;
    }
}

