/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.utils;

import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.internal.statistic.utils.PluginInfoDetectorKt;
import com.intellij.internal.statistic.utils.PluginType;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\b\u0086\b\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0007J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u000e\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u000b\u0010\u000f\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J+\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\u0006\u0010\u0016\u001a\u00020\u0012J\u0006\u0010\u0017\u001a\u00020\u0012J\u0006\u0010\u0018\u001a\u00020\u0012J\t\u0010\u0019\u001a\u00020\u0005H\u00d6\u0001R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\t\u00a8\u0006\u001a"}, d2={"Lcom/intellij/internal/statistic/utils/PluginInfo;", "", "type", "Lcom/intellij/internal/statistic/utils/PluginType;", "id", "", "version", "(Lcom/intellij/internal/statistic/utils/PluginType;Ljava/lang/String;Ljava/lang/String;)V", "getId", "()Ljava/lang/String;", "getType", "()Lcom/intellij/internal/statistic/utils/PluginType;", "getVersion", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "isAllowedToInjectIntoFUS", "isDevelopedByJetBrains", "isSafeToReport", "toString", "intellij.platform.statistics"})
public final class PluginInfo {
    @NotNull
    private final PluginType type;
    @Nullable
    private final String id;
    @Nullable
    private final String version;

    public PluginInfo(@NotNull PluginType type, @Nullable String id, @Nullable String version) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        this.type = type;
        this.id = id;
        this.version = version;
    }

    @NotNull
    public final PluginType getType() {
        return this.type;
    }

    @Nullable
    public final String getId() {
        return this.id;
    }

    @Nullable
    public final String getVersion() {
        return this.version;
    }

    public final boolean isDevelopedByJetBrains() {
        return this.type.isDevelopedByJetBrains();
    }

    public final boolean isSafeToReport() {
        return this.type.isSafeToReport();
    }

    public final boolean isAllowedToInjectIntoFUS() {
        return this.type.isDevelopedByJetBrains() && CollectionsKt.contains((Iterable)PluginInfoDetectorKt.access$getAllowedPlugins$p(), (Object)this.id) || PluginManagerCore.isUnitTestMode && (this.type == PluginType.PLATFORM || this.type == PluginType.FROM_SOURCES);
    }

    @NotNull
    public final PluginType component1() {
        return this.type;
    }

    @Nullable
    public final String component2() {
        return this.id;
    }

    @Nullable
    public final String component3() {
        return this.version;
    }

    @NotNull
    public final PluginInfo copy(@NotNull PluginType type, @Nullable String id, @Nullable String version) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        return new PluginInfo(type, id, version);
    }

    public static /* synthetic */ PluginInfo copy$default(PluginInfo pluginInfo, PluginType pluginType, String string, String string2, int n, Object object) {
        if ((n & 1) != 0) {
            pluginType = pluginInfo.type;
        }
        if ((n & 2) != 0) {
            string = pluginInfo.id;
        }
        if ((n & 4) != 0) {
            string2 = pluginInfo.version;
        }
        return pluginInfo.copy(pluginType, string, string2);
    }

    @NotNull
    public String toString() {
        return "PluginInfo(type=" + this.type + ", id=" + this.id + ", version=" + this.version + ")";
    }

    public int hashCode() {
        int result = this.type.hashCode();
        result = result * 31 + (this.id == null ? 0 : this.id.hashCode());
        result = result * 31 + (this.version == null ? 0 : this.version.hashCode());
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof PluginInfo)) {
            return false;
        }
        PluginInfo pluginInfo = (PluginInfo)other;
        if (this.type != pluginInfo.type) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.id, (Object)pluginInfo.id)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.version, (Object)pluginInfo.version);
    }
}

