/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.perforce;

import com.intellij.credentialStore.CredentialAttributes;
import com.intellij.credentialStore.CredentialPromptDialog;
import com.intellij.ide.passwordSafe.PasswordSafe;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.LastUnchangedContentTracker;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.messages.Topic;
import com.intellij.util.xmlb.XmlSerializerUtil;
import com.intellij.util.xmlb.annotations.MapAnnotation;
import com.intellij.util.xmlb.annotations.Property;
import com.intellij.util.xmlb.annotations.Transient;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.perforce.PerforceBundle;
import org.jetbrains.idea.perforce.ServerVersion;
import org.jetbrains.idea.perforce.application.ConnectionKey;
import org.jetbrains.idea.perforce.application.PerforceManager;
import org.jetbrains.idea.perforce.application.UpdatePasswordKt;
import org.jetbrains.idea.perforce.operations.VcsOperationLog;
import org.jetbrains.idea.perforce.perforce.ConnectionId;
import org.jetbrains.idea.perforce.perforce.ParticularConnectionSettings;
import org.jetbrains.idea.perforce.perforce.PerforcePhysicalConnectionParameters;
import org.jetbrains.idea.perforce.perforce.PerforcePhysicalConnectionParametersI;
import org.jetbrains.idea.perforce.perforce.connections.P4Connection;
import org.jetbrains.idea.perforce.perforce.connections.P4EnvHelper;
import org.jetbrains.idea.perforce.perforce.connections.PerforceConnectionManager;
import org.jetbrains.idea.perforce.perforce.login.AttemptsStateMachine;
import org.jetbrains.idea.perforce.perforce.login.PerforceLoginManager;
import org.jetbrains.idea.perforce.perforce.login.PerforceOfflineNotification;

@State(name="PerforceDirect.Settings", storages={@Storage(value="$WORKSPACE_FILE$")}, reportStatistic=false)
public final class PerforceSettings
implements PersistentStateComponent<PerforceSettings>,
PerforcePhysicalConnectionParametersI {
    private static final Logger LOG = Logger.getInstance(PerforceSettings.class);
    public static final Topic<Runnable> OFFLINE_MODE_EXITED = new Topic("Perforce.offline_mode_exited", Runnable.class);
    private static final String PERFORCE_SETTINGS_PASSWORD_KEY = "PERFORCE_SETTINGS_PASSWORD_KEY";
    private final Project myProject;
    private final PerforceOfflineNotification myOfflineNotification;
    private String myEnvIgnore = P4EnvHelper.getP4IgnoreFileNameFromEnv();
    @Property(surroundWithTag=false)
    @MapAnnotation(surroundWithTag=false, surroundKeyWithTag=false, surroundValueWithTag=false, entryTagName="CURRENT_CHANGE_LIST")
    public Map<ConnectionId, ParticularConnectionSettings> myConnectionSettings = new LinkedHashMap<ConnectionId, ParticularConnectionSettings>();
    public boolean useP4CONFIG = true;
    public boolean useP4IGNORE = true;
    public String port = "<perforce_server>:1666";
    public String client = "";
    public String user = "";
    public boolean showCmds = false;
    @NlsSafe
    public String pathToExec = "p4";
    @NlsSafe
    public String pathToIgnore = ".p4ignore";
    @NlsSafe
    public String PATH_TO_P4VC = "p4vc";
    public boolean myCanGoOffline = false;
    public boolean SYNC_FORCE = false;
    public boolean SYNC_RUN_RESOLVE = true;
    public boolean REVERT_UNCHANGED_FILES = true;
    public boolean REVERT_UNCHANGED_FILES_CHECKIN = false;
    @NlsSafe
    public String CHARSET = PerforcePhysicalConnectionParametersI.getCharsetNone();
    public boolean SHOW_BRANCHES_HISTORY = true;
    public boolean ENABLED = true;
    public boolean USE_LOGIN = true;
    public boolean INTEGRATE_RUN_RESOLVE = true;
    public boolean INTEGRATE_REVERT_UNCHANGED = true;
    public int SERVER_TIMEOUT = 20000;
    public boolean USE_PERFORCE_JOBS = false;
    public boolean SHOW_INTEGRATED_IN_COMMITTED_CHANGES = true;
    public boolean USE_PATTERN_MATCHING_IGNORE = false;
    public boolean FORCE_SYNC_CHANGELISTS = true;

    public PerforceSettings() {
        this.myProject = null;
        this.myOfflineNotification = null;
    }

    public PerforceSettings(Project project) {
        this.myProject = project;
        this.myOfflineNotification = new PerforceOfflineNotification(this.myProject);
    }

    public static PerforceSettings getSettings(Project project) {
        return (PerforceSettings)project.getService(PerforceSettings.class);
    }

    public void setEnvP4IgnoreVar(String p4Ignore) {
        this.myEnvIgnore = p4Ignore;
    }

    public PerforcePhysicalConnectionParameters getPhysicalSettings(boolean useP4Ignore) {
        return new PerforcePhysicalConnectionParameters(this.getPathToExec(), useP4Ignore ? this.getPathToIgnore() : null, this.myProject, this.getServerTimeout(), this.getCharsetName());
    }

    public String[] getConnectArgs() {
        String pass;
        assert (!this.useP4CONFIG);
        ArrayList<String> args = new ArrayList<String>();
        if (!StringUtil.isEmptyOrSpaces((String)this.port)) {
            args.add("-p");
            args.add(this.port);
        }
        if (!StringUtil.isEmptyOrSpaces((String)this.client)) {
            args.add("-c");
            args.add(this.client);
        }
        if (!StringUtil.isEmptyOrSpaces((String)this.user)) {
            args.add("-u");
            args.add(this.user);
        }
        if (!this.USE_LOGIN && !StringUtil.isEmptyOrSpaces((String)(pass = this.getPasswd()))) {
            args.add("-P");
            args.add(pass);
        }
        if (!this.isNoneCharset()) {
            args.add("-C");
            args.add(this.CHARSET);
        }
        return ArrayUtilRt.toStringArray(args);
    }

    @Override
    public String getPathToExec() {
        return this.pathToExec;
    }

    @Override
    public String getPathToIgnore() {
        if (this.useP4IGNORE) {
            return this.myEnvIgnore;
        }
        return this.pathToIgnore;
    }

    @Override
    public Project getProject() {
        return this.myProject;
    }

    @Transient
    @Nullable
    public String getPasswd() {
        return PasswordSafe.getInstance().getPassword(new CredentialAttributes(this.getClass().getName(), PERFORCE_SETTINGS_PASSWORD_KEY));
    }

    @Nullable
    public String requestForPassword(P4Connection connection) {
        String prompt = connection == null ? PerforceBundle.message("message.text.perforce.command.failed.enter.password.v2", new Object[0]) : PerforceBundle.message("message.text.perforce.command.failed.withdir.enter.password.v2", connection.getWorkingDir());
        String title = PerforceBundle.message("dialog.title.perforce.login", new Object[0]);
        return CredentialPromptDialog.askPassword((Project)this.myProject, (String)title, (String)prompt, (CredentialAttributes)new CredentialAttributes(this.getClass().getName(), PERFORCE_SETTINGS_PASSWORD_KEY), (boolean)true);
    }

    public boolean requestForPasswordUpdate(AttemptsStateMachine attemptsMachine) {
        assert (this.myProject != null);
        return UpdatePasswordKt.askUpdatePassword(this.myProject, attemptsMachine, new CredentialAttributes(this.getClass().getName(), PERFORCE_SETTINGS_PASSWORD_KEY));
    }

    public long getServerVersion(@Nullable P4Connection connection) throws VcsException {
        return PerforceManager.getInstance(this.myProject).getServerVersionYear(connection);
    }

    public long getServerVersionCached(@Nullable P4Connection connection) throws VcsException {
        return PerforceManager.getInstance(this.myProject).getServerVersionYearCached(connection);
    }

    @Nullable
    public ServerVersion getServerFullVersion(@Nullable P4Connection connection) throws VcsException {
        return PerforceManager.getInstance(this.myProject).getServerVersion(connection);
    }

    public void ensureOfflineNotify() {
        if (this.myCanGoOffline && !this.ENABLED) {
            this.myOfflineNotification.ensureNotify((Object)this.myOfflineNotification);
        }
    }

    @Override
    public void disable() {
        this.disable(false);
    }

    public void disable(boolean byUser) {
        if (!this.myCanGoOffline && !byUser) {
            return;
        }
        if (byUser) {
            this.saveUnchangedContentsForModifiedFiles();
        }
        this.doDisable();
        if (PerforceManager.getInstance(this.myProject).isActive()) {
            this.myOfflineNotification.ensureNotify((Object)this.myOfflineNotification);
            PerforceManager.getInstance(this.myProject).configurationChanged();
        }
    }

    private void doDisable() {
        if (this.ENABLED) {
            LOG.info("Perforce going offline");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("doDisable, " + this.ENABLED + "\n" + DebugUtil.currentStackTrace());
        }
        this.ENABLED = false;
    }

    private void saveUnchangedContentsForModifiedFiles() {
        ThreadingAssertions.assertEventDispatchThread();
        ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> {
            for (LocalChangeList list : ChangeListManager.getInstance((Project)this.myProject).getChangeLists()) {
                for (Change change : list.getChanges()) {
                    VirtualFile file = change.getVirtualFile();
                    ContentRevision before = change.getBeforeRevision();
                    if (file == null || before == null || LastUnchangedContentTracker.hasSavedContent((VirtualFile)file)) continue;
                    try {
                        String content = before.getContent();
                        if (content == null) continue;
                        LastUnchangedContentTracker.forceSavedContent((VirtualFile)file, (String)content);
                    }
                    catch (VcsException e) {
                        LOG.info((Throwable)e);
                    }
                }
            }
        }, PerforceBundle.message("file.caching.contents", new Object[0]), true, this.myProject);
    }

    public void enable() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("enable, " + this.ENABLED + "\n" + DebugUtil.currentStackTrace());
        }
        this.ENABLED = true;
        PerforceManager perforceManager = PerforceManager.getInstance(this.myProject);
        if (!perforceManager.isActive()) {
            return;
        }
        PerforceConnectionManager.getInstance(this.myProject).updateConnections();
        if (!PerforceLoginManager.getInstance(this.myProject).checkAndRepairAll() || !this.ENABLED) {
            LOG.debug("enable failed 1 ");
            this.doDisable();
            this.myOfflineNotification.ensureNotify((Object)this.myOfflineNotification);
            return;
        }
        VcsException[] exc = new VcsException[]{null};
        Runnable process = () -> {
            Collection<P4Connection> allConnections = this.getAllConnections();
            if (allConnections.isEmpty()) {
                return;
            }
            try {
                perforceManager.getClientRoots(allConnections.iterator().next());
            }
            catch (VcsException e) {
                LOG.info((Throwable)e);
                exc[0] = e;
            }
        };
        if (ProgressManager.getInstance().runProcessWithProgressSynchronously(process, PerforceBundle.message("connection.going.online", new Object[0]), true, this.myProject)) {
            if (exc[0] != null && !ApplicationManager.getApplication().isUnitTestMode()) {
                Messages.showWarningDialog((Project)this.myProject, (String)exc[0].getMessage(), (String)PerforceBundle.message("connection.cannot.connect", new Object[0]));
                this.doDisable();
                this.myOfflineNotification.ensureNotify((Object)this.myOfflineNotification);
                return;
            }
            if (this.ENABLED) {
                VcsOperationLog.getInstance(this.myProject).replayLog();
                if (!this.myOfflineNotification.isEmpty()) {
                    this.myOfflineNotification.clear();
                }
                ((Runnable)this.myProject.getMessageBus().syncPublisher(OFFLINE_MODE_EXITED)).run();
            } else {
                LOG.debug("enable failed 2");
                this.myOfflineNotification.ensureNotify((Object)this.myOfflineNotification);
            }
        }
    }

    @Nullable
    public P4Connection getConnectionForFile(File file) {
        return PerforceConnectionManager.getInstance(this.getProject()).getConnectionForFile(file);
    }

    @Nullable
    public P4Connection getConnectionForFile(VirtualFile file) {
        return PerforceConnectionManager.getInstance(this.getProject()).getConnectionForFile(file);
    }

    public Map<ConnectionKey, P4Connection> getConnectionsByKeys() {
        HashMap<ConnectionKey, P4Connection> key2connection = new HashMap<ConnectionKey, P4Connection>();
        for (P4Connection connection : this.getAllConnections()) {
            key2connection.put(connection.getConnectionKey(), connection);
        }
        return key2connection;
    }

    public Collection<P4Connection> getAllConnections() {
        return Collections.unmodifiableCollection(new HashSet<P4Connection>(PerforceConnectionManager.getInstance(this.getProject()).getAllConnections().values()));
    }

    public ParticularConnectionSettings getSettings(@NotNull P4Connection connection) {
        ConnectionId id;
        if (connection == null) {
            PerforceSettings.$$$reportNull$$$0(0);
        }
        if (!this.myConnectionSettings.containsKey(id = connection.getId())) {
            this.myConnectionSettings.put(id, new ParticularConnectionSettings());
        }
        return this.myConnectionSettings.get(id);
    }

    public boolean isNoneCharset() {
        return StringUtil.isEmptyOrSpaces((String)this.CHARSET) || PerforcePhysicalConnectionParametersI.getCharsetNone().equals(this.CHARSET);
    }

    public PerforceSettings getState() {
        return this;
    }

    public void loadState(@NotNull PerforceSettings object) {
        if (object == null) {
            PerforceSettings.$$$reportNull$$$0(1);
        }
        XmlSerializerUtil.copyBean((Object)object, (Object)this);
    }

    public void setCanGoOffline(boolean canGoOffline) {
        this.myCanGoOffline = canGoOffline;
    }

    @Override
    public int getServerTimeout() {
        return this.SERVER_TIMEOUT;
    }

    @Override
    @NotNull
    public String getCharsetName() {
        String string = this.CHARSET;
        if (string == null) {
            PerforceSettings.$$$reportNull$$$0(2);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/perforce/perforce/PerforceSettings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/perforce/perforce/PerforceSettings";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getCharsetName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getSettings";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

