/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.collaboration.ui.codereview.reactions;

import com.intellij.collaboration.messages.CollaborationToolsBundle;
import com.intellij.collaboration.ui.codereview.reactions.CodeReviewReactionsUIUtil;
import com.intellij.collaboration.ui.codereview.reactions.UnicodeEmojiIcon;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.util.List;
import javax.swing.Icon;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u001cB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J!\u0010\u0013\u001a\u00070\u0011\u00a2\u0006\u0002\b\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0016\u001a\u00020\u0011J\u0016\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u0004J\n\u0010\u001b\u001a\u0004\u0018\u00010\bH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0007\u001a\u0004\u0018\u00010\b8@X\u0080\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\t\u0010\nR\u000e\u0010\r\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0011X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/intellij/collaboration/ui/codereview/reactions/CodeReviewReactionsUIUtil;", "", "()V", "BUTTON_HEIGHT", "", "COUNTER_FONT_SIZE", "", "EMOJI_FONT", "Ljava/awt/Font;", "getEMOJI_FONT$intellij_platform_collaborationTools", "()Ljava/awt/Font;", "EMOJI_FONT$delegate", "Lkotlin/Lazy;", "HORIZONTAL_GAP", "ICON_SIZE", "PREFERRED_EMOJI_FONTS", "", "", "VARIATION_SELECTOR", "createTooltipText", "Lorg/jetbrains/annotations/Nls;", "users", "reactionName", "createUnicodeEmojiIcon", "Ljavax/swing/Icon;", "text", "size", "findEmojiFont", "Picker", "intellij.platform.collaborationTools"})
public final class CodeReviewReactionsUIUtil {
    @NotNull
    public static final CodeReviewReactionsUIUtil INSTANCE = new CodeReviewReactionsUIUtil();
    @NotNull
    private static final List<String> PREFERRED_EMOJI_FONTS;
    @NotNull
    private static final Lazy EMOJI_FONT$delegate;
    @NotNull
    public static final String VARIATION_SELECTOR = "\ufe0f";
    public static final int BUTTON_HEIGHT = 24;
    public static final int HORIZONTAL_GAP = 8;
    public static final int ICON_SIZE = 20;
    public static final float COUNTER_FONT_SIZE = 11.0f;

    private CodeReviewReactionsUIUtil() {
    }

    @Nullable
    public final Font getEMOJI_FONT$intellij_platform_collaborationTools() {
        Lazy lazy = EMOJI_FONT$delegate;
        return (Font)lazy.getValue();
    }

    private final Font findEmojiFont() {
        Pair found = null;
        Font[] fontArray = GraphicsEnvironment.getLocalGraphicsEnvironment().getAllFonts();
        Intrinsics.checkNotNullExpressionValue((Object)fontArray, (String)"getAllFonts(...)");
        for (Font font : fontArray) {
            String name = font.getName();
            int priority = PREFERRED_EMOJI_FONTS.indexOf(name);
            if (priority < 0) {
                Intrinsics.checkNotNull((Object)name);
                if (StringsKt.contains((CharSequence)name, (CharSequence)"emoji", (boolean)true)) {
                    priority = Integer.MAX_VALUE;
                }
            }
            if (priority < 0 || found != null && priority >= ((Number)found.getFirst()).intValue()) continue;
            found = TuplesKt.to((Object)priority, (Object)font);
        }
        Pair pair = found;
        return pair != null ? (Font)pair.getSecond() : null;
    }

    @NotNull
    public final Icon createUnicodeEmojiIcon(@NotNull String text2, int size) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        return new UnicodeEmojiIcon(text2, size);
    }

    @NotNull
    public final String createTooltipText(@NotNull List<String> users, @NotNull String reactionName) {
        Intrinsics.checkNotNullParameter(users, (String)"users");
        Intrinsics.checkNotNullParameter((Object)reactionName, (String)"reactionName");
        Iterable iterable = CollectionsKt.chunked((Iterable)users, (int)3);
        String string = HtmlChunk.br().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String reactors2 = CollectionsKt.joinToString$default((Iterable)iterable, (CharSequence)string, null, null, (int)0, null, (Function1)createTooltipText.reactors.1.INSTANCE, (int)30, null) + HtmlChunk.br();
        Object[] objectArray = new Object[]{reactors2, reactionName};
        String string2 = new HtmlBuilder().appendRaw(CollaborationToolsBundle.message("review.comments.reaction.tooltip", objectArray)).wrapWith(HtmlChunk.div((String)"text-align: center")).wrapWith(HtmlChunk.body()).wrapWith(HtmlChunk.html()).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        return string2;
    }

    public static final /* synthetic */ Font access$findEmojiFont(CodeReviewReactionsUIUtil $this) {
        return $this.findEmojiFont();
    }

    static {
        Object[] objectArray = new String[]{"Apple Color Emoji", "Segoe UI Emoji", "Segoe UI Symbol", "Noto Color Emoji"};
        PREFERRED_EMOJI_FONTS = CollectionsKt.listOf((Object[])objectArray);
        EMOJI_FONT$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Font>((Object)INSTANCE){

            @Nullable
            public final Font invoke() {
                return CodeReviewReactionsUIUtil.access$findEmojiFont((CodeReviewReactionsUIUtil)this.receiver);
            }
        }));
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/intellij/collaboration/ui/codereview/reactions/CodeReviewReactionsUIUtil$Picker;", "", "()V", "BLOCK_PADDING", "", "HEIGHT", "WIDTH", "intellij.platform.collaborationTools"})
    public static final class Picker {
        @NotNull
        public static final Picker INSTANCE = new Picker();
        public static final int WIDTH = 358;
        public static final int HEIGHT = 415;
        public static final int BLOCK_PADDING = 5;

        private Picker() {
        }
    }
}

