/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.collaboration.ui.util.popup;

import com.intellij.collaboration.ui.codereview.list.search.PopupConfig;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.ui.ExperimentalUI;
import com.intellij.ui.SearchTextField;
import com.intellij.ui.components.TextComponentEmptyText;
import com.intellij.ui.popup.AbstractPopup;
import com.intellij.util.ui.UIUtil;
import javax.swing.JComponent;
import javax.swing.text.JTextComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u001f\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\r\u0010\f\u001a\t\u0018\u00010\r\u00a2\u0006\u0002\b\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\u0010"}, d2={"Lcom/intellij/collaboration/ui/util/popup/CollaborationToolsPopupUtil;", "", "()V", "configureSearchField", "", "popup", "Lcom/intellij/openapi/ui/popup/JBPopup;", "popupConfig", "Lcom/intellij/collaboration/ui/codereview/list/search/PopupConfig;", "setSearchFieldPlaceholder", "searchTextField", "Lcom/intellij/ui/SearchTextField;", "placeholderText", "", "Lcom/intellij/openapi/util/NlsContexts$StatusText;", "tuneSearchFieldForNewUI", "intellij.platform.collaborationTools"})
public final class CollaborationToolsPopupUtil {
    @NotNull
    public static final CollaborationToolsPopupUtil INSTANCE = new CollaborationToolsPopupUtil();

    private CollaborationToolsPopupUtil() {
    }

    public final void configureSearchField(@NotNull JBPopup popup, @NotNull PopupConfig popupConfig) {
        Intrinsics.checkNotNullParameter((Object)popup, (String)"popup");
        Intrinsics.checkNotNullParameter((Object)popupConfig, (String)"popupConfig");
        SearchTextField searchTextField = (SearchTextField)UIUtil.findComponentOfType((JComponent)popup.getContent(), SearchTextField.class);
        if (searchTextField != null) {
            this.tuneSearchFieldForNewUI(searchTextField);
            this.setSearchFieldPlaceholder(searchTextField, popupConfig.getSearchTextPlaceHolder());
        }
    }

    private final void tuneSearchFieldForNewUI(SearchTextField searchTextField) {
        if (!ExperimentalUI.Companion.isNewUI()) {
            return;
        }
        AbstractPopup.customizeSearchFieldLook((SearchTextField)searchTextField, (boolean)true);
    }

    private final void setSearchFieldPlaceholder(SearchTextField searchTextField, String placeholderText) {
        if (placeholderText == null) {
            return;
        }
        searchTextField.getTextEditor().getEmptyText().setText(placeholderText);
        TextComponentEmptyText.setupPlaceholderVisibility((JTextComponent)((JTextComponent)searchTextField.getTextEditor()));
    }
}

