/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.yaml.navigation;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.cache.CacheManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.gist.GistManager;
import com.intellij.util.gist.PsiFileGist;
import com.intellij.util.io.DataExternalizer;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.yaml.YAMLFileType;
import org.jetbrains.yaml.YAMLUtil;
import org.jetbrains.yaml.navigation.YamlConcatenatedKey;
import org.jetbrains.yaml.navigation.YamlKeyExternalizer;
import org.jetbrains.yaml.navigation.YamlKeyWithFile;
import org.jetbrains.yaml.navigation.YamlKeysSearcherKt;
import org.jetbrains.yaml.navigation.YamlKeysSearcherKt$findYamlFilesWithWord$;
import org.jetbrains.yaml.psi.YAMLFile;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.YAMLPsiElement;
import org.jetbrains.yaml.psi.YAMLSequence;
import org.jetbrains.yaml.psi.YamlRecursivePsiElementVisitor;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000F\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u001a\u0010\u0007\u001a\f\u0012\u0004\u0012\u00020\u00030\u0002j\u0002`\u00042\u0006\u0010\b\u001a\u00020\tH\u0002\u001a&\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002\u001a,\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u000b2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00022\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0000\u001a\u0016\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00140\u000b2\u0006\u0010\b\u001a\u00020\tH\u0002\"7\u0010\u0000\u001a+\u0012\"\u0012 \u0012\u0004\u0012\u00020\u0003 \u0005*\u0010\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u0002j\u0004\u0018\u0001`\u00040\u0002j\u0002`\u00040\u0001\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000*\u0018\b\u0000\u0010\u0017\"\b\u0012\u0004\u0012\u00020\u00030\u00022\b\u0012\u0004\u0012\u00020\u00030\u0002\u00a8\u0006\u0018"}, d2={"YAML_CONCATENATED_KEYS_GIST", "Lcom/intellij/util/gist/PsiFileGist;", "", "Lorg/jetbrains/yaml/navigation/YamlConcatenatedKey;", "Lorg/jetbrains/yaml/navigation/YamlConcatenatedKeys;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "computeAllConcatenatedKeys", "file", "Lcom/intellij/psi/PsiFile;", "findYamlFilesWithWord", "Lkotlin/sequences/Sequence;", "Lorg/jetbrains/yaml/psi/YAMLFile;", "keyPart", "", "searchScope", "Lcom/intellij/psi/search/GlobalSearchScope;", "project", "Lcom/intellij/openapi/project/Project;", "findYamlKeysByPattern", "Lorg/jetbrains/yaml/navigation/YamlKeyWithFile;", "searchedKeyParts", "mapGistData", "YamlConcatenatedKeys", "intellij.yaml"})
@SourceDebugExtension(value={"SMAP\nYamlKeysSearcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 YamlKeysSearcher.kt\norg/jetbrains/yaml/navigation/YamlKeysSearcherKt\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,112:1\n473#2:113\n*S KotlinDebug\n*F\n+ 1 YamlKeysSearcher.kt\norg/jetbrains/yaml/navigation/YamlKeysSearcherKt\n*L\n39#1:113\n*E\n"})
public final class YamlKeysSearcherKt {
    @NotNull
    private static final PsiFileGist<List<YamlConcatenatedKey>> YAML_CONCATENATED_KEYS_GIST;

    @NotNull
    public static final Sequence<YamlKeyWithFile> findYamlKeysByPattern(@NotNull List<String> searchedKeyParts, @NotNull GlobalSearchScope searchScope, @NotNull Project project) {
        Intrinsics.checkNotNullParameter(searchedKeyParts, (String)"searchedKeyParts");
        Intrinsics.checkNotNullParameter((Object)searchScope, (String)"searchScope");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        FileType[] fileTypeArray = new FileType[]{YAMLFileType.YML};
        GlobalSearchScope globalSearchScope = GlobalSearchScope.getScopeRestrictedByFileTypes((GlobalSearchScope)searchScope, (FileType[])fileTypeArray);
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"getScopeRestrictedByFileTypes(...)");
        GlobalSearchScope fileTypeRestrictedScope = globalSearchScope;
        return SequencesKt.flatMap((Sequence)SequencesKt.distinct((Sequence)SequencesKt.onEach((Sequence)SequencesKt.flatMap((Sequence)CollectionsKt.asSequence((Iterable)searchedKeyParts), (Function1)((Function1)new Function1<String, Sequence<? extends YAMLFile>>(fileTypeRestrictedScope, project){
            final /* synthetic */ GlobalSearchScope $fileTypeRestrictedScope;
            final /* synthetic */ Project $project;
            {
                this.$fileTypeRestrictedScope = $fileTypeRestrictedScope;
                this.$project = $project;
                super(1);
            }

            @NotNull
            public final Sequence<YAMLFile> invoke(@NotNull String searchedKeyPart) {
                Intrinsics.checkNotNullParameter((Object)searchedKeyPart, (String)"searchedKeyPart");
                return YamlKeysSearcherKt.access$findYamlFilesWithWord(searchedKeyPart, this.$fileTypeRestrictedScope, this.$project);
            }
        })), (Function1)findYamlKeysByPattern.2.INSTANCE)), (Function1)findYamlKeysByPattern.3.INSTANCE);
    }

    private static final Sequence<YAMLFile> findYamlFilesWithWord(String keyPart, GlobalSearchScope searchScope, Project project) {
        PsiFile[] psiFileArray = CacheManager.getInstance((Project)project).getFilesWithWord(keyPart, (short)255, searchScope, false);
        Intrinsics.checkNotNullExpressionValue((Object)psiFileArray, (String)"getFilesWithWord(...)");
        Sequence $this$filterIsInstance$iv = ArraysKt.asSequence((Object[])psiFileArray);
        boolean $i$f$filterIsInstance = false;
        Sequence sequence = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)findYamlFilesWithWord$$inlined$filterIsInstance$1.INSTANCE);
        Intrinsics.checkNotNull((Object)sequence, (String)"null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
        return sequence;
    }

    private static final Sequence<YamlKeyWithFile> mapGistData(PsiFile file) {
        Object object = YAML_CONCATENATED_KEYS_GIST.getFileData(file);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getFileData(...)");
        return SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)((Iterable)object)), (Function1)((Function1)new Function1<YamlConcatenatedKey, YamlKeyWithFile>(file){
            final /* synthetic */ PsiFile $file;
            {
                this.$file = $file;
                super(1);
            }

            @NotNull
            public final YamlKeyWithFile invoke(@NotNull YamlConcatenatedKey keyAndOffset) {
                Intrinsics.checkNotNullParameter((Object)keyAndOffset, (String)"keyAndOffset");
                String string = keyAndOffset.getKey();
                int n = keyAndOffset.getOffset();
                VirtualFile virtualFile = this.$file.getVirtualFile();
                Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getVirtualFile(...)");
                return new YamlKeyWithFile(string, n, virtualFile);
            }
        }));
    }

    private static final List<YamlConcatenatedKey> computeAllConcatenatedKeys(PsiFile file) {
        if (!(file instanceof YAMLFile)) {
            return CollectionsKt.emptyList();
        }
        List allKeys = new ArrayList();
        file.accept((PsiElementVisitor)new YamlRecursivePsiElementVisitor(allKeys){
            final /* synthetic */ List<YamlConcatenatedKey> $allKeys;
            {
                this.$allKeys = $allKeys;
            }

            public void visitKeyValue(@NotNull YAMLKeyValue keyValue) {
                Intrinsics.checkNotNullParameter((Object)keyValue, (String)"keyValue");
                PsiElement key = keyValue.getKey();
                if (key != null) {
                    String string = YAMLUtil.getConfigFullName((YAMLPsiElement)((YAMLPsiElement)keyValue));
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getConfigFullName(...)");
                    String concatenatedKey = string;
                    this.$allKeys.add(new YamlConcatenatedKey(concatenatedKey, key.getTextOffset()));
                }
                super.visitKeyValue(keyValue);
            }

            public void visitSequence(@NotNull YAMLSequence sequence) {
                Intrinsics.checkNotNullParameter((Object)sequence, (String)"sequence");
            }
        });
        return allKeys;
    }

    private static final List YAML_CONCATENATED_KEYS_GIST$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (List)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ Sequence access$findYamlFilesWithWord(String keyPart, GlobalSearchScope searchScope, Project project) {
        return YamlKeysSearcherKt.findYamlFilesWithWord(keyPart, searchScope, project);
    }

    public static final /* synthetic */ Sequence access$mapGistData(PsiFile file) {
        return YamlKeysSearcherKt.mapGistData(file);
    }

    public static final /* synthetic */ List access$computeAllConcatenatedKeys(PsiFile file) {
        return YamlKeysSearcherKt.computeAllConcatenatedKeys(file);
    }

    static {
        PsiFileGist psiFileGist = GistManager.getInstance().newPsiFileGist("yamlConcatenatedKeysGist", 1, (DataExternalizer)new YamlKeyExternalizer(), arg_0 -> YamlKeysSearcherKt.YAML_CONCATENATED_KEYS_GIST$lambda$0(YAML_CONCATENATED_KEYS_GIST.1.INSTANCE, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)psiFileGist, (String)"newPsiFileGist(...)");
        YAML_CONCATENATED_KEYS_GIST = psiFileGist;
    }
}

