/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.llmInstaller.ui.welcome;

import com.intellij.llmInstaller.ui.welcome.features.WelcomeFeatureDescriptor;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0007\u0018\u0000 \u00112\u00020\u0001:\u0004\u0011\u0012\u0013\u0014B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\n\u001a\u00020\u000bJ\b\u0010\f\u001a\u0004\u0018\u00010\rJ\u0010\u0010\u000e\u001a\u00020\u000b2\b\u0010\u000f\u001a\u0004\u0018\u00010\rJ\b\u0010\u0010\u001a\u00020\u000bH\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0015"}, d2={"Lcom/intellij/llmInstaller/ui/welcome/WelcomeNavigationHistoryService;", "", "()V", "history", "", "Lcom/intellij/llmInstaller/ui/welcome/WelcomeNavigationHistoryService$HistoryItem;", "size", "", "getSize", "()I", "clear", "", "popPrevious", "Lcom/intellij/llmInstaller/ui/welcome/features/WelcomeFeatureDescriptor;", "push", "featureDescriptor", "pushDiscoverAll", "Companion", "DiscoverAllHistoryItem", "FeatureHistoryItem", "HistoryItem", "intellij.llmInstaller"})
public final class WelcomeNavigationHistoryService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<HistoryItem> history = new ArrayList();

    public final int getSize() {
        return this.history.size();
    }

    public final void clear() {
        this.history.clear();
    }

    public final void push(@Nullable WelcomeFeatureDescriptor featureDescriptor) {
        if (featureDescriptor == null) {
            this.pushDiscoverAll();
            return;
        }
        HistoryItem lastItem = (HistoryItem)CollectionsKt.lastOrNull(this.history);
        if (!(lastItem instanceof FeatureHistoryItem) || ((FeatureHistoryItem)lastItem).getFeatureDescriptor() != featureDescriptor) {
            this.history.add(new FeatureHistoryItem(featureDescriptor));
        }
    }

    @Nullable
    public final WelcomeFeatureDescriptor popPrevious() {
        WelcomeFeatureDescriptor welcomeFeatureDescriptor;
        CollectionsKt.removeLastOrNull(this.history);
        HistoryItem historyItem = (HistoryItem)CollectionsKt.lastOrNull(this.history);
        if (historyItem == null) {
            return null;
        }
        HistoryItem lastItem = historyItem;
        HistoryItem historyItem2 = lastItem;
        if (historyItem2 instanceof DiscoverAllHistoryItem) {
            welcomeFeatureDescriptor = null;
        } else if (historyItem2 instanceof FeatureHistoryItem) {
            welcomeFeatureDescriptor = ((FeatureHistoryItem)lastItem).getFeatureDescriptor();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return welcomeFeatureDescriptor;
    }

    private final void pushDiscoverAll() {
        HistoryItem lastItem = (HistoryItem)CollectionsKt.lastOrNull(this.history);
        if (!(lastItem instanceof DiscoverAllHistoryItem)) {
            this.history.add(DiscoverAllHistoryItem.INSTANCE);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\u0007"}, d2={"Lcom/intellij/llmInstaller/ui/welcome/WelcomeNavigationHistoryService$Companion;", "", "()V", "getInstance", "Lcom/intellij/llmInstaller/ui/welcome/WelcomeNavigationHistoryService;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.llmInstaller"})
    @SourceDebugExtension(value={"SMAP\nWelcomeNavigationHistoryService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WelcomeNavigationHistoryService.kt\ncom/intellij/llmInstaller/ui/welcome/WelcomeNavigationHistoryService$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,72:1\n31#2,2:73\n*S KotlinDebug\n*F\n+ 1 WelcomeNavigationHistoryService.kt\ncom/intellij/llmInstaller/ui/welcome/WelcomeNavigationHistoryService$Companion\n*L\n17#1:73,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @RequiresEdt
        @NotNull
        public final WelcomeNavigationHistoryService getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ThreadingAssertions.assertEventDispatchThread();
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<WelcomeNavigationHistoryService> serviceClass$iv = WelcomeNavigationHistoryService.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (WelcomeNavigationHistoryService)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/intellij/llmInstaller/ui/welcome/WelcomeNavigationHistoryService$DiscoverAllHistoryItem;", "Lcom/intellij/llmInstaller/ui/welcome/WelcomeNavigationHistoryService$HistoryItem;", "()V", "intellij.llmInstaller"})
    private static final class DiscoverAllHistoryItem
    implements HistoryItem {
        @NotNull
        public static final DiscoverAllHistoryItem INSTANCE = new DiscoverAllHistoryItem();

        private DiscoverAllHistoryItem() {
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/llmInstaller/ui/welcome/WelcomeNavigationHistoryService$FeatureHistoryItem;", "Lcom/intellij/llmInstaller/ui/welcome/WelcomeNavigationHistoryService$HistoryItem;", "featureDescriptor", "Lcom/intellij/llmInstaller/ui/welcome/features/WelcomeFeatureDescriptor;", "(Lcom/intellij/llmInstaller/ui/welcome/features/WelcomeFeatureDescriptor;)V", "getFeatureDescriptor", "()Lcom/intellij/llmInstaller/ui/welcome/features/WelcomeFeatureDescriptor;", "intellij.llmInstaller"})
    private static final class FeatureHistoryItem
    implements HistoryItem {
        @NotNull
        private final WelcomeFeatureDescriptor featureDescriptor;

        public FeatureHistoryItem(@NotNull WelcomeFeatureDescriptor featureDescriptor) {
            Intrinsics.checkNotNullParameter((Object)featureDescriptor, (String)"featureDescriptor");
            this.featureDescriptor = featureDescriptor;
        }

        @NotNull
        public final WelcomeFeatureDescriptor getFeatureDescriptor() {
            return this.featureDescriptor;
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\br\u0018\u00002\u00020\u0001\u0082\u0001\u0002\u0002\u0003\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0004\u00c0\u0006\u0001"}, d2={"Lcom/intellij/llmInstaller/ui/welcome/WelcomeNavigationHistoryService$HistoryItem;", "", "Lcom/intellij/llmInstaller/ui/welcome/WelcomeNavigationHistoryService$DiscoverAllHistoryItem;", "Lcom/intellij/llmInstaller/ui/welcome/WelcomeNavigationHistoryService$FeatureHistoryItem;", "intellij.llmInstaller"})
    private static interface HistoryItem {
    }
}

