/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rd.platform.internal;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ApplicationKt;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.Date;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000 \u000e2\u00020\u00012\u00020\u0002:\u0001\u000eB\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0003B\u0011\b\u0016\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J$\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\b0\fH\u0004\u00a8\u0006\u000f"}, d2={"Lcom/jetbrains/rd/platform/internal/DumpAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "Lcom/intellij/openapi/project/DumbAware;", "()V", "name", "", "(Ljava/lang/String;)V", "dump", "", "project", "Lcom/intellij/openapi/project/Project;", "dumper", "Lkotlin/Function1;", "Ljava/io/OutputStreamWriter;", "Companion", "intellij.rd.platform"})
public abstract class DumpAction
extends AnAction
implements DumbAware {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public DumpAction() {
    }

    public DumpAction(@NlsActions.ActionText @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        super(name);
    }

    protected final void dump(@NotNull Project project, @NotNull Function1<? super OutputStreamWriter, Unit> dumper) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(dumper, (String)"dumper");
        String string = this.getTemplateText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getTemplateText(...)");
        Companion.dumpToFile(project, StringsKt.replace$default((String)string, (String)" ", (String)"", (boolean)false, (int)4, null), dumper);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J,\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00040\n\u00a8\u0006\f"}, d2={"Lcom/jetbrains/rd/platform/internal/DumpAction$Companion;", "", "()V", "dumpToFile", "", "project", "Lcom/intellij/openapi/project/Project;", "name", "", "dumper", "Lkotlin/Function1;", "Ljava/io/OutputStreamWriter;", "intellij.rd.platform"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void dumpToFile(@Nullable Project project, @NotNull String name, @NotNull Function1<? super OutputStreamWriter, Unit> dumper) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter(dumper, (String)"dumper");
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd-HH-mm-ss");
            String fileName = name + dateFormat.format(new Date());
            File file = File.createTempFile(fileName, ".txt");
            Intrinsics.checkNotNull((Object)file);
            File file2 = file;
            Charset charset = Charsets.UTF_8;
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file2), charset);
            try {
                dumper.invoke((Object)writer);
            }
            finally {
                writer.flush();
                writer.close();
            }
            if (project != null) {
                ApplicationKt.getApplication().invokeAndWait(() -> Companion.dumpToFile$lambda$0(file, project));
            }
        }

        private static final void dumpToFile$lambda$0(File $file, Project $project) {
            VirtualFile virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByIoFile($file);
            Intrinsics.checkNotNull((Object)virtualFile);
            VirtualFile virtualFile2 = virtualFile;
            FileEditorManager.getInstance((Project)$project).openFile(virtualFile2, true);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

