/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.inline.completion.impl.diagnostic;

import com.intellij.codeWithMe.ClientId;
import com.intellij.ml.inline.completion.impl.diagnostic.ConnectionAddress;
import com.intellij.ml.inline.completion.impl.diagnostic.DiagnosticLoggersKt;
import com.intellij.ml.inline.completion.impl.diagnostic.DiagnosticsListener;
import com.intellij.ml.inline.completion.impl.diagnostic.GrpcChannelState;
import com.intellij.ml.inline.completion.impl.diagnostic.MLCompletionLogger;
import com.intellij.ml.inline.completion.impl.diagnostic.MLCompletionNativeServerLogger;
import com.intellij.ml.inline.completion.impl.diagnostic.MLCompletionSessionLogger;
import com.intellij.ml.inline.completion.impl.diagnostic.NativeServerMessage;
import com.intellij.ml.inline.completion.impl.diagnostic.ProcessStarted;
import com.intellij.ml.inline.completion.impl.diagnostic.ProcessTerminated;
import com.intellij.ml.inline.completion.impl.diagnostic.SessionMessage;
import com.intellij.ml.inline.completion.impl.diagnostic.SessionMessagePayload;
import com.intellij.ml.inline.completion.impl.diagnostic.TextDiagnostics;
import com.intellij.ml.inline.completion.impl.diagnostic.TextMessage;
import com.intellij.ml.inline.completion.impl.id.CompletionId;
import com.intellij.ml.inline.completion.impl.id.NativeServerId;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.EventDispatcher;
import java.util.EventListener;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Service
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u000bJ\u0016\u0010\f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0016\u0010\u0010\u001a\u00020\u00112\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u0013J\u0016\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u0018R!\u0010\u0003\u001a\u0015\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u0004\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/intellij/ml/inline/completion/impl/diagnostic/MLCompletionDiagnosticsService;", "", "()V", "dispatcher", "Lcom/intellij/util/EventDispatcher;", "Lcom/intellij/ml/inline/completion/impl/diagnostic/DiagnosticsListener;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "logger", "Lcom/intellij/ml/inline/completion/impl/diagnostic/MLCompletionLogger;", "log", "Lcom/intellij/openapi/diagnostic/Logger;", "nativeServerLogger", "Lcom/intellij/ml/inline/completion/impl/diagnostic/MLCompletionNativeServerLogger;", "serverId", "Lcom/intellij/ml/inline/completion/impl/id/NativeServerId;", "sessionLogger", "Lcom/intellij/ml/inline/completion/impl/diagnostic/MLCompletionSessionLogger;", "completionId", "Lcom/intellij/ml/inline/completion/impl/id/CompletionId;", "subscribe", "", "listener", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "Companion", "intellij.ml.inline.completion"})
public final class MLCompletionDiagnosticsService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final EventDispatcher<DiagnosticsListener> dispatcher;

    public MLCompletionDiagnosticsService() {
        EventDispatcher eventDispatcher = EventDispatcher.create(DiagnosticsListener.class);
        Intrinsics.checkNotNullExpressionValue((Object)eventDispatcher, (String)"create(...)");
        this.dispatcher = eventDispatcher;
        this.dispatcher.addListener((EventListener)new TextDiagnostics());
    }

    public final void subscribe(@NotNull DiagnosticsListener listener2, @NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        this.dispatcher.addListener((EventListener)listener2, parentDisposable);
    }

    @NotNull
    public final MLCompletionLogger logger(@NotNull Logger log) {
        Intrinsics.checkNotNullParameter((Object)log, (String)"log");
        return new MLCompletionLogger(log, this){
            private final boolean isDebugEnabled;
            final /* synthetic */ Logger $log;
            final /* synthetic */ MLCompletionDiagnosticsService this$0;
            {
                this.$log = $log;
                this.this$0 = $receiver;
                this.isDebugEnabled = $log.isDebugEnabled() || MLCompletionDiagnosticsService.access$getDispatcher$p($receiver).hasListeners();
            }

            public void error(@NotNull Throwable throwable) {
                Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
                this.$log.error(throwable);
            }

            public void debug(@NotNull String text2) {
                Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
                this.onTextMessage(text2, (Function1<? super Logger, Unit>)((Function1)new Function1<Logger, Unit>(text2){
                    final /* synthetic */ String $text;
                    {
                        this.$text = $text;
                        super(1);
                    }

                    public final void invoke(@NotNull Logger $this$onTextMessage) {
                        Intrinsics.checkNotNullParameter((Object)$this$onTextMessage, (String)"$this$onTextMessage");
                        $this$onTextMessage.debug(this.$text);
                    }
                }));
            }

            public void info(@NotNull String text2) {
                Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
                this.onTextMessage(text2, (Function1<? super Logger, Unit>)((Function1)new Function1<Logger, Unit>(text2){
                    final /* synthetic */ String $text;
                    {
                        this.$text = $text;
                        super(1);
                    }

                    public final void invoke(@NotNull Logger $this$onTextMessage) {
                        Intrinsics.checkNotNullParameter((Object)$this$onTextMessage, (String)"$this$onTextMessage");
                        $this$onTextMessage.info(this.$text);
                    }
                }));
            }

            public void debug(@NotNull String text2, @NotNull Throwable throwable) {
                Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
                Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
                this.onTextMessage(text2, (Function1<? super Logger, Unit>)((Function1)new Function1<Logger, Unit>(text2, throwable){
                    final /* synthetic */ String $text;
                    final /* synthetic */ Throwable $throwable;
                    {
                        this.$text = $text;
                        this.$throwable = $throwable;
                        super(1);
                    }

                    public final void invoke(@NotNull Logger $this$onTextMessage) {
                        Intrinsics.checkNotNullParameter((Object)$this$onTextMessage, (String)"$this$onTextMessage");
                        $this$onTextMessage.debug(this.$text, this.$throwable);
                    }
                }));
            }

            public void warn(@NotNull String text2) {
                Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
                this.onTextMessage(text2, (Function1<? super Logger, Unit>)((Function1)new Function1<Logger, Unit>(text2){
                    final /* synthetic */ String $text;
                    {
                        this.$text = $text;
                        super(1);
                    }

                    public final void invoke(@NotNull Logger $this$onTextMessage) {
                        Intrinsics.checkNotNullParameter((Object)$this$onTextMessage, (String)"$this$onTextMessage");
                        $this$onTextMessage.warn(this.$text);
                    }
                }));
            }

            public void warn(@NotNull String text2, @NotNull Throwable throwable) {
                Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
                Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
                this.onTextMessage(text2, (Function1<? super Logger, Unit>)((Function1)new Function1<Logger, Unit>(text2, throwable){
                    final /* synthetic */ String $text;
                    final /* synthetic */ Throwable $throwable;
                    {
                        this.$text = $text;
                        this.$throwable = $throwable;
                        super(1);
                    }

                    public final void invoke(@NotNull Logger $this$onTextMessage) {
                        Intrinsics.checkNotNullParameter((Object)$this$onTextMessage, (String)"$this$onTextMessage");
                        $this$onTextMessage.warn(this.$text, this.$throwable);
                    }
                }));
            }

            private final void onTextMessage(String text2, Function1<? super Logger, Unit> block) {
                block.invoke((Object)this.$log);
                if (!MLCompletionDiagnosticsService.access$getDispatcher$p(this.this$0).hasListeners()) {
                    return;
                }
                TextMessage message = new TextMessage(text2, System.currentTimeMillis());
                ((DiagnosticsListener)MLCompletionDiagnosticsService.access$getDispatcher$p(this.this$0).getMulticaster()).messageReceived(message);
            }

            public boolean isDebugEnabled() {
                return this.isDebugEnabled;
            }
        };
    }

    public static /* synthetic */ MLCompletionLogger logger$default(MLCompletionDiagnosticsService mLCompletionDiagnosticsService, Logger logger2, int n, Object object) {
        if ((n & 1) != 0) {
            logger2 = DiagnosticLoggersKt.access$getLOG$p();
        }
        return mLCompletionDiagnosticsService.logger(logger2);
    }

    @NotNull
    public final MLCompletionSessionLogger sessionLogger(@NotNull MLCompletionLogger logger2, @NotNull CompletionId completionId) {
        Intrinsics.checkNotNullParameter((Object)logger2, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)completionId, (String)"completionId");
        return (MLCompletionSessionLogger)new MLCompletionLogger(logger2, this, completionId){
            private final /* synthetic */ MLCompletionLogger $$delegate_0;
            final /* synthetic */ MLCompletionDiagnosticsService this$0;
            final /* synthetic */ CompletionId $completionId;
            {
                this.this$0 = $receiver;
                this.$completionId = $completionId;
                this.$$delegate_0 = $logger;
            }

            public boolean isDebugEnabled() {
                return this.$$delegate_0.isDebugEnabled();
            }

            public void debug(@NotNull String text2) {
                Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
                this.$$delegate_0.debug(text2);
            }

            public void debug(@NotNull String text2, @NotNull Throwable throwable) {
                Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
                Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
                this.$$delegate_0.debug(text2, throwable);
            }

            public void error(@NotNull Throwable throwable) {
                Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
                this.$$delegate_0.error(throwable);
            }

            public void info(@NotNull String text2) {
                Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
                this.$$delegate_0.info(text2);
            }

            public void warn(@NotNull String text2) {
                Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
                this.$$delegate_0.warn(text2);
            }

            public void warn(@NotNull String text2, @NotNull Throwable throwable) {
                Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
                Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
                this.$$delegate_0.warn(text2, throwable);
            }

            public void sendSessionMessage(@NotNull SessionMessagePayload sessionMessage) {
                Intrinsics.checkNotNullParameter((Object)sessionMessage, (String)"sessionMessage");
                if (!MLCompletionDiagnosticsService.access$getDispatcher$p(this.this$0).hasListeners()) {
                    return;
                }
                ((DiagnosticsListener)MLCompletionDiagnosticsService.access$getDispatcher$p(this.this$0).getMulticaster()).messageReceived(new SessionMessage(this.$completionId, sessionMessage));
            }
        };
    }

    @NotNull
    public final MLCompletionNativeServerLogger nativeServerLogger(@NotNull MLCompletionLogger logger2, @NotNull NativeServerId serverId) {
        Intrinsics.checkNotNullParameter((Object)logger2, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)serverId, (String)"serverId");
        return new MLCompletionNativeServerLogger(logger2, serverId, this){
            private final /* synthetic */ MLCompletionLogger $$delegate_0;
            final /* synthetic */ NativeServerId $serverId;
            final /* synthetic */ MLCompletionDiagnosticsService this$0;
            {
                this.$serverId = $serverId;
                this.this$0 = $receiver;
                this.$$delegate_0 = $logger;
            }

            public boolean isDebugEnabled() {
                return this.$$delegate_0.isDebugEnabled();
            }

            public void debug(@NotNull String text2) {
                Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
                this.$$delegate_0.debug(text2);
            }

            public void debug(@NotNull String text2, @NotNull Throwable throwable) {
                Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
                Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
                this.$$delegate_0.debug(text2, throwable);
            }

            public void error(@NotNull Throwable throwable) {
                Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
                this.$$delegate_0.error(throwable);
            }

            public void info(@NotNull String text2) {
                Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
                this.$$delegate_0.info(text2);
            }

            public void warn(@NotNull String text2) {
                Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
                this.$$delegate_0.warn(text2);
            }

            public void warn(@NotNull String text2, @NotNull Throwable throwable) {
                Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
                Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
                this.$$delegate_0.warn(text2, throwable);
            }

            public void grpcChannelState(@NotNull String state) {
                Intrinsics.checkNotNullParameter((Object)state, (String)"state");
                this.sendNativeServerMessage(new GrpcChannelState(this.$serverId, state));
            }

            public void processStarted() {
                this.sendNativeServerMessage(new ProcessStarted(this.$serverId));
            }

            public void processTerminated(int exitCode) {
                this.sendNativeServerMessage(new ProcessTerminated(this.$serverId, exitCode));
            }

            public void connectionAddress(@NotNull String hostname, int port) {
                Intrinsics.checkNotNullParameter((Object)hostname, (String)"hostname");
                this.sendNativeServerMessage(new ConnectionAddress(this.$serverId, hostname, port));
            }

            private final void sendNativeServerMessage(NativeServerMessage nativeServerMessage) {
                if (!MLCompletionDiagnosticsService.access$getDispatcher$p(this.this$0).hasListeners()) {
                    return;
                }
                ((DiagnosticsListener)MLCompletionDiagnosticsService.access$getDispatcher$p(this.this$0).getMulticaster()).messageReceived(nativeServerMessage);
            }
        };
    }

    public static final /* synthetic */ EventDispatcher access$getDispatcher$p(MLCompletionDiagnosticsService $this) {
        return $this.dispatcher;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0003\u001a\u00020\u0004\u00a8\u0006\u0005"}, d2={"Lcom/intellij/ml/inline/completion/impl/diagnostic/MLCompletionDiagnosticsService$Companion;", "", "()V", "getInstance", "Lcom/intellij/ml/inline/completion/impl/diagnostic/MLCompletionDiagnosticsService;", "intellij.ml.inline.completion"})
    @SourceDebugExtension(value={"SMAP\ndiagnosticLoggers.kt\nKotlin\n*S Kotlin\n*F\n+ 1 diagnosticLoggers.kt\ncom/intellij/ml/inline/completion/impl/diagnostic/MLCompletionDiagnosticsService$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,122:1\n40#2,3:123\n*S KotlinDebug\n*F\n+ 1 diagnosticLoggers.kt\ncom/intellij/ml/inline/completion/impl/diagnostic/MLCompletionDiagnosticsService$Companion\n*L\n117#1:123,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final MLCompletionDiagnosticsService getInstance() {
            boolean $i$f$service = false;
            Class<MLCompletionDiagnosticsService> serviceClass$iv = MLCompletionDiagnosticsService.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            return (MLCompletionDiagnosticsService)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

