/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.inline.completion.impl.diagnostic.ui.completions.info;

import com.intellij.ml.inline.completion.impl.diagnostic.AddCachedProposals;
import com.intellij.ml.inline.completion.impl.diagnostic.Analyzed;
import com.intellij.ml.inline.completion.impl.diagnostic.ContextMessage;
import com.intellij.ml.inline.completion.impl.diagnostic.FilterModelMessage;
import com.intellij.ml.inline.completion.impl.diagnostic.FilteredAnalyzed;
import com.intellij.ml.inline.completion.impl.diagnostic.FilteredRaw;
import com.intellij.ml.inline.completion.impl.diagnostic.Grouped;
import com.intellij.ml.inline.completion.impl.diagnostic.Mapper;
import com.intellij.ml.inline.completion.impl.diagnostic.Mappings;
import com.intellij.ml.inline.completion.impl.diagnostic.PipelineStartsWith;
import com.intellij.ml.inline.completion.impl.diagnostic.ProviderSelected;
import com.intellij.ml.inline.completion.impl.diagnostic.ResultProposals;
import com.intellij.ml.inline.completion.impl.diagnostic.SessionMessagePayload;
import com.intellij.ml.inline.completion.impl.diagnostic.SilentCompletion;
import com.intellij.ml.inline.completion.impl.diagnostic.SkipReason;
import com.intellij.ml.inline.completion.impl.diagnostic.TriggerModelMessage;
import com.intellij.ml.inline.completion.impl.diagnostic.ui.completions.components.SideTabs;
import com.intellij.ml.inline.completion.impl.diagnostic.ui.completions.info.MLCompletionContextPanel;
import com.intellij.ml.inline.completion.impl.diagnostic.ui.completions.info.MLCompletionInformationPanel;
import com.intellij.ml.inline.completion.impl.diagnostic.ui.completions.info.MLCompletionMappersPanel;
import com.intellij.ml.inline.completion.impl.diagnostic.ui.completions.info.MLCompletionProposalsList;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/intellij/ml/inline/completion/impl/diagnostic/ui/completions/info/CompletionsWindowTabs;", "", "()V", "analyzed", "Lcom/intellij/ml/inline/completion/impl/diagnostic/ui/completions/info/MLCompletionProposalsList;", "component", "Ljavax/swing/JComponent;", "getComponent", "()Ljavax/swing/JComponent;", "composedContext", "Lcom/intellij/ml/inline/completion/impl/diagnostic/ui/completions/info/MLCompletionContextPanel;", "filterModelProcessing", "filteredAnalyzed", "filteredRaw", "generalInformation", "Lcom/intellij/ml/inline/completion/impl/diagnostic/ui/completions/info/MLCompletionInformationPanel;", "grouping", "mappingStep", "Lcom/intellij/ml/inline/completion/impl/diagnostic/ui/completions/info/MLCompletionMappersPanel;", "receivedProposals", "resultProposals", "tabsPanel", "Lcom/intellij/ml/inline/completion/impl/diagnostic/ui/completions/components/SideTabs;", "addMessage", "", "message", "Lcom/intellij/ml/inline/completion/impl/diagnostic/SessionMessagePayload;", "intellij.ml.inline.completion"})
public final class CompletionsWindowTabs {
    @NotNull
    private final SideTabs tabsPanel = new SideTabs();
    @NotNull
    private final JComponent component = this.tabsPanel.getComponent();
    @NotNull
    private final MLCompletionInformationPanel generalInformation = new MLCompletionInformationPanel("General information");
    @NotNull
    private final MLCompletionContextPanel composedContext = new MLCompletionContextPanel("Composed context");
    @NotNull
    private final MLCompletionProposalsList receivedProposals = new MLCompletionProposalsList("Received proposals");
    @NotNull
    private final MLCompletionMappersPanel mappingStep = new MLCompletionMappersPanel("Mappings");
    @NotNull
    private final MLCompletionProposalsList grouping = new MLCompletionProposalsList("Groups");
    @NotNull
    private final MLCompletionProposalsList filteredRaw = new MLCompletionProposalsList("Raw filters");
    @NotNull
    private final MLCompletionProposalsList analyzed = new MLCompletionProposalsList("Analyzed proposals");
    @NotNull
    private final MLCompletionProposalsList filteredAnalyzed = new MLCompletionProposalsList("Analyzed filters");
    @NotNull
    private final MLCompletionProposalsList filterModelProcessing = new MLCompletionProposalsList("Filter model");
    @NotNull
    private final MLCompletionProposalsList resultProposals = new MLCompletionProposalsList("Result proposals");

    public CompletionsWindowTabs() {
        this.tabsPanel.insert(this.generalInformation);
        this.tabsPanel.insert(this.composedContext);
        this.tabsPanel.insert(this.receivedProposals);
        this.tabsPanel.insert(this.mappingStep);
        this.tabsPanel.insert(this.grouping);
        this.tabsPanel.insert(this.filteredRaw);
        this.tabsPanel.insert(this.analyzed);
        this.tabsPanel.insert(this.filteredAnalyzed);
        this.tabsPanel.insert(this.filterModelProcessing);
        this.tabsPanel.insert(this.resultProposals);
    }

    @NotNull
    public final JComponent getComponent() {
        return this.component;
    }

    public final void addMessage(@NotNull SessionMessagePayload message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        SessionMessagePayload sessionMessagePayload = message;
        if (sessionMessagePayload instanceof ProviderSelected) {
            this.generalInformation.addProviderName((ProviderSelected)message);
        } else if (sessionMessagePayload instanceof PipelineStartsWith) {
            this.receivedProposals.add(((PipelineStartsWith)message).getProposals());
            this.generalInformation.addStartProposalsCount(((PipelineStartsWith)message).getProposals().size());
        } else if (sessionMessagePayload instanceof Mappings) {
            this.mappingStep.afterTransformations(((Mappings)message).getBefore(), ((Mappings)message).getAfter());
        } else if (sessionMessagePayload instanceof Mapper) {
            this.mappingStep.addMapper(((Mapper)message).getMapperDiagnostics());
        } else if (sessionMessagePayload instanceof Grouped) {
            this.grouping.addGroups(((Grouped)message).getGroups());
        } else if (sessionMessagePayload instanceof FilteredRaw) {
            this.filteredRaw.addFiltered(((FilteredRaw)message).getItems());
        } else if (sessionMessagePayload instanceof Analyzed) {
            this.analyzed.addAnalyzed(((Analyzed)message).getProposals());
        } else if (sessionMessagePayload instanceof FilteredAnalyzed) {
            this.filteredAnalyzed.addFiltered(((FilteredAnalyzed)message).getItems());
        } else if (sessionMessagePayload instanceof ResultProposals) {
            this.generalInformation.addFinishAddingProposal(((ResultProposals)message).getProposals().size());
            this.resultProposals.add(((ResultProposals)message).getProposals());
        } else if (sessionMessagePayload instanceof AddCachedProposals) {
            this.generalInformation.addCachedProposalsCount((AddCachedProposals)message);
        } else if (sessionMessagePayload instanceof TriggerModelMessage) {
            this.generalInformation.addTriggerModelResponse(((TriggerModelMessage)message).getResponse());
        } else if (sessionMessagePayload instanceof FilterModelMessage) {
            this.generalInformation.addFilterModelResponse(((FilterModelMessage)message).getResponse());
            this.filterModelProcessing.addFilterModelResponse((FilterModelMessage)message);
        } else if (sessionMessagePayload instanceof SkipReason) {
            this.generalInformation.addSkipReason((SkipReason)message);
        } else if (sessionMessagePayload instanceof SilentCompletion) {
            this.generalInformation.addSilentCompletionMessage();
        } else if (sessionMessagePayload instanceof ContextMessage) {
            this.composedContext.addContext((ContextMessage)message);
        } else {
            throw new NoWhenBranchMatchedException();
        }
    }
}

