/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.inline.completion.impl.inline;

import com.intellij.codeInsight.inline.completion.DefaultInlineCompletionInsertHandler;
import com.intellij.codeInsight.inline.completion.InlineCompletionInsertEnvironment;
import com.intellij.codeInsight.inline.completion.elements.InlineCompletionElement;
import com.intellij.lang.Language;
import com.intellij.ml.inline.completion.features.autoimport.ImportFixer;
import com.intellij.ml.inline.completion.features.autoimport.ImportFixerKt;
import com.intellij.ml.inline.completion.impl.kit.MLCompletionLanguageKit;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH$J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H$J\u0010\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006\u0015"}, d2={"Lcom/intellij/ml/inline/completion/impl/inline/MLCompletionInsertHandler;", "Lcom/intellij/codeInsight/inline/completion/DefaultInlineCompletionInsertHandler;", "()V", "afterInsertion", "", "environment", "Lcom/intellij/codeInsight/inline/completion/InlineCompletionInsertEnvironment;", "elements", "", "Lcom/intellij/codeInsight/inline/completion/elements/InlineCompletionElement;", "getCoroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "project", "Lcom/intellij/openapi/project/Project;", "getLanguageKit", "Lcom/intellij/ml/inline/completion/impl/kit/MLCompletionLanguageKit;", "language", "Lcom/intellij/lang/Language;", "moveCaretBeforeSuffix", "performAutoImport", "Companion", "intellij.ml.inline.completion"})
public abstract class MLCompletionInsertHandler
extends DefaultInlineCompletionInsertHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Key<Integer> CARET_SHIFT_AFTER_INSERTION_KEY;

    @Nullable
    protected abstract MLCompletionLanguageKit getLanguageKit(@NotNull Language var1);

    @NotNull
    protected abstract CoroutineScope getCoroutineScope(@NotNull Project var1);

    public void afterInsertion(@NotNull InlineCompletionInsertEnvironment environment, @NotNull List<? extends InlineCompletionElement> elements2) {
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        Intrinsics.checkNotNullParameter(elements2, (String)"elements");
        super.afterInsertion(environment, elements2);
        this.moveCaretBeforeSuffix(environment);
        this.performAutoImport(environment);
    }

    private final void moveCaretBeforeSuffix(InlineCompletionInsertEnvironment environment) {
        block0: {
            Integer n = (Integer)environment.getUserData(CARET_SHIFT_AFTER_INSERTION_KEY);
            if (n == null) break block0;
            Integer shift = n;
            boolean bl = false;
            Caret caret = environment.getEditor().getCaretModel().getCurrentCaret();
            boolean bl2 = false;
            caret.moveToOffset(caret.getOffset() + shift);
        }
    }

    private final void performAutoImport(InlineCompletionInsertEnvironment environment) {
        Language language = environment.getFile().getLanguage();
        Intrinsics.checkNotNullExpressionValue((Object)language, (String)"getLanguage(...)");
        Object object = this.getLanguageKit(language);
        if (object == null || (object = object.getImportFixer()) == null) {
            return;
        }
        Object importFixer = object;
        Project project = environment.getFile().getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        ImportFixerKt.runAutoImportAsync((ImportFixer)importFixer, this.getCoroutineScope(project), environment.getFile(), environment.getEditor(), environment.getInsertedRange());
    }

    static {
        Key key = Key.create((String)"full.line.inline.caret.shift");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        CARET_SHIFT_AFTER_INSERTION_KEY = key;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R$\u0010\u0003\u001a\u0015\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u0004\u00a2\u0006\u0002\b\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lcom/intellij/ml/inline/completion/impl/inline/MLCompletionInsertHandler$Companion;", "", "()V", "CARET_SHIFT_AFTER_INSERTION_KEY", "Lcom/intellij/openapi/util/Key;", "", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "getCARET_SHIFT_AFTER_INSERTION_KEY", "()Lcom/intellij/openapi/util/Key;", "intellij.ml.inline.completion"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Key<Integer> getCARET_SHIFT_AFTER_INSERTION_KEY() {
            return CARET_SHIFT_AFTER_INSERTION_KEY;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

