/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.main;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.java.decompiler.code.Instruction;
import org.jetbrains.java.decompiler.code.InstructionSequence;
import org.jetbrains.java.decompiler.main.ClassWriter;
import org.jetbrains.java.decompiler.main.DecompilerContext;
import org.jetbrains.java.decompiler.main.collectors.BytecodeSourceMapper;
import org.jetbrains.java.decompiler.main.collectors.ImportCollector;
import org.jetbrains.java.decompiler.main.extern.IFernflowerLogger;
import org.jetbrains.java.decompiler.main.extern.IIdentifierRenamer;
import org.jetbrains.java.decompiler.main.rels.ClassWrapper;
import org.jetbrains.java.decompiler.main.rels.LambdaProcessor;
import org.jetbrains.java.decompiler.main.rels.NestedClassProcessor;
import org.jetbrains.java.decompiler.main.rels.NestedMemberAccess;
import org.jetbrains.java.decompiler.modules.decompiler.exps.InvocationExprent;
import org.jetbrains.java.decompiler.modules.decompiler.vars.VarVersionPair;
import org.jetbrains.java.decompiler.struct.StructClass;
import org.jetbrains.java.decompiler.struct.StructContext;
import org.jetbrains.java.decompiler.struct.StructMethod;
import org.jetbrains.java.decompiler.struct.attr.StructEnclosingMethodAttribute;
import org.jetbrains.java.decompiler.struct.attr.StructGeneralAttribute;
import org.jetbrains.java.decompiler.struct.attr.StructInnerClassesAttribute;
import org.jetbrains.java.decompiler.struct.consts.ConstantPool;
import org.jetbrains.java.decompiler.struct.consts.PrimitiveConstant;
import org.jetbrains.java.decompiler.struct.gen.VarType;
import org.jetbrains.java.decompiler.util.InterpreterUtil;
import org.jetbrains.java.decompiler.util.TextBuffer;

public class ClassesProcessor {
    public static final int AVERAGE_CLASS_SIZE = 16384;
    private final StructContext context;
    private final Map<String, ClassNode> mapRootClasses = new HashMap<String, ClassNode>();

    public ClassesProcessor(StructContext context) {
        this.context = context;
    }

    public void loadClasses(IIdentifierRenamer renamer) {
        HashMap<String, Inner> mapInnerClasses = new HashMap<String, Inner>();
        HashMap<String, Set> mapNestedClassReferences = new HashMap<String, Set>();
        HashMap<String, Set> mapEnclosingClassReferences = new HashMap<String, Set>();
        HashMap<String, String> mapNewSimpleNames = new HashMap<String, String>();
        boolean bDecompileInner = DecompilerContext.getOption("din");
        boolean verifyAnonymousClasses = DecompilerContext.getOption("vac");
        for (StructClass structClass : this.context.getClasses().values()) {
            StructInnerClassesAttribute inner;
            if (!structClass.isOwn() || this.mapRootClasses.containsKey(structClass.qualifiedName)) continue;
            if (bDecompileInner && (inner = structClass.getAttribute(StructGeneralAttribute.ATTRIBUTE_INNER_CLASSES)) != null) {
                for (StructInnerClassesAttribute.Entry entry : inner.getEntries()) {
                    StructClass enclosingClass;
                    String innerName = entry.innerName;
                    String simpleName = entry.simpleName;
                    String savedName = (String)mapNewSimpleNames.get(innerName);
                    if (savedName != null) {
                        simpleName = savedName;
                    } else if (simpleName != null && renamer != null && renamer.toBeRenamed(IIdentifierRenamer.Type.ELEMENT_CLASS, simpleName, null, null)) {
                        simpleName = renamer.getNextClassName(innerName, simpleName);
                        mapNewSimpleNames.put(innerName, simpleName);
                    }
                    Inner rec = new Inner();
                    rec.simpleName = simpleName;
                    rec.type = entry.simpleNameIdx == 0 ? 2 : (entry.outerNameIdx == 0 ? 4 : 1);
                    rec.accessFlags = entry.accessFlags;
                    String enclClassName = entry.outerNameIdx != 0 ? entry.enclosingName : structClass.qualifiedName;
                    if (enclClassName == null || innerName.equals(enclClassName) || rec.type == 1 && !innerName.equals(enclClassName + "$" + entry.simpleName) || (enclosingClass = this.context.getClasses().get(enclClassName)) == null || !enclosingClass.isOwn()) continue;
                    Inner existingRec = (Inner)mapInnerClasses.get(innerName);
                    if (existingRec == null) {
                        mapInnerClasses.put(innerName, rec);
                    } else if (!Inner.equal(existingRec, rec)) {
                        String message = "Inconsistent inner class entries for " + innerName + "!";
                        DecompilerContext.getLogger().writeMessage(message, IFernflowerLogger.Severity.WARN);
                    }
                    mapNestedClassReferences.computeIfAbsent(enclClassName, k -> new HashSet()).add(innerName);
                    mapEnclosingClassReferences.computeIfAbsent(innerName, k -> new HashSet()).add(enclClassName);
                }
            }
            ClassNode node = new ClassNode(0, structClass);
            node.access = structClass.getAccessFlags();
            this.mapRootClasses.put(structClass.qualifiedName, node);
        }
        for (ClassNode classNode : this.mapRootClasses.values()) {
            if (!classNode.classStruct.hasSealedClassesSupport() || (classNode.access & 0x10) != 0 || classNode.classStruct.getPermittedSubclasses() != null) continue;
            ArrayList<String> qualifiedSealedSuperNames = new ArrayList<String>(Arrays.asList(classNode.classStruct.getInterfaceNames()));
            PrimitiveConstant superConst = classNode.classStruct.superClass;
            if (superConst != null) {
                qualifiedSealedSuperNames.add(superConst.getString());
            }
            classNode.setNonSealed(qualifiedSealedSuperNames.stream().map(this.mapRootClasses::get).filter(Objects::nonNull).map(potentialSuper -> potentialSuper.classStruct.getPermittedSubclasses()).filter(Objects::nonNull).anyMatch(permittedList -> permittedList.contains(clazz.classStruct.qualifiedName)));
        }
        if (bDecompileInner) {
            for (Map.Entry entry : this.mapRootClasses.entrySet()) {
                if (mapInnerClasses.containsKey(entry.getKey())) continue;
                HashSet<String> setVisited = new HashSet<String>();
                LinkedList<String> stack = new LinkedList<String>();
                stack.add((String)entry.getKey());
                setVisited.add((String)entry.getKey());
                while (!stack.isEmpty()) {
                    String superClass = (String)stack.removeFirst();
                    ClassNode superNode = this.mapRootClasses.get(superClass);
                    Set setNestedClasses = (Set)mapNestedClassReferences.get(superClass);
                    if (setNestedClasses == null) continue;
                    StructClass scl = superNode.classStruct;
                    StructInnerClassesAttribute inner = scl.getAttribute(StructGeneralAttribute.ATTRIBUTE_INNER_CLASSES);
                    if (inner == null || inner.getEntries().isEmpty()) {
                        DecompilerContext.getLogger().writeMessage(superClass + " does not contain inner classes!", IFernflowerLogger.Severity.WARN);
                        continue;
                    }
                    for (StructInnerClassesAttribute.Entry entry2 : inner.getEntries()) {
                        String nestedClass = entry2.innerName;
                        if (!setNestedClasses.contains(nestedClass) || !setVisited.add(nestedClass)) continue;
                        ClassNode nestedNode = this.mapRootClasses.get(nestedClass);
                        if (nestedNode == null) {
                            DecompilerContext.getLogger().writeMessage("Nested class " + nestedClass + " missing!", IFernflowerLogger.Severity.WARN);
                            continue;
                        }
                        Inner rec = (Inner)mapInnerClasses.get(nestedClass);
                        nestedNode.simpleName = rec.simpleName;
                        nestedNode.type = rec.type;
                        nestedNode.access = rec.accessFlags;
                        if (verifyAnonymousClasses && nestedNode.type == 2 && !ClassesProcessor.isAnonymous(nestedNode.classStruct, scl)) {
                            nestedNode.type = 4;
                        }
                        if (nestedNode.type == 2) {
                            StructClass cl = nestedNode.classStruct;
                            nestedNode.access &= 0xFFFFFFF7;
                            int[] interfaces = cl.getInterfaces();
                            nestedNode.anonymousClassType = interfaces.length > 0 ? new VarType(cl.getInterface(0), true) : new VarType(cl.superClass.getString(), true);
                        } else if (nestedNode.type == 4) {
                            nestedNode.access &= 0x410;
                        }
                        superNode.nested.add(nestedNode);
                        nestedNode.parent = superNode;
                        nestedNode.enclosingClasses.addAll((Collection)mapEnclosingClassReferences.get(nestedClass));
                        stack.add(nestedClass);
                    }
                }
            }
        }
    }

    private static boolean isAnonymous(StructClass cl, StructClass enclosingCl) {
        int[] interfaces = cl.getInterfaces();
        if (interfaces.length > 0) {
            boolean hasNonTrivialSuperClass;
            boolean bl = hasNonTrivialSuperClass = cl.superClass != null && !VarType.VARTYPE_OBJECT.equals(new VarType(cl.superClass.getString(), true));
            if (hasNonTrivialSuperClass || interfaces.length > 1) {
                String message = "Inconsistent anonymous class definition: '" + cl.qualifiedName + "'. Multiple interfaces and/or super class defined.";
                DecompilerContext.getLogger().writeMessage(message, IFernflowerLogger.Severity.WARN);
                return false;
            }
        } else if (cl.superClass == null) {
            String message = "Inconsistent anonymous class definition: '" + cl.qualifiedName + "'. Neither interface nor super class defined.";
            DecompilerContext.getLogger().writeMessage(message, IFernflowerLogger.Severity.WARN);
            return false;
        }
        ConstantPool pool = enclosingCl.getPool();
        int refCounter = 0;
        boolean refNotNew = false;
        StructEnclosingMethodAttribute attribute = cl.getAttribute(StructGeneralAttribute.ATTRIBUTE_ENCLOSING_METHOD);
        String enclosingMethod = attribute != null ? attribute.getMethodName() : null;
        for (StructMethod mt : enclosingCl.getMethods()) {
            if (enclosingMethod != null && !enclosingMethod.equals(mt.getName())) continue;
            try {
                mt.expandData(enclosingCl);
                InstructionSequence seq = mt.getInstructionSequence();
                if (seq != null) {
                    int len = seq.length();
                    block8: for (int i = 0; i < len; ++i) {
                        Instruction instr = seq.getInstr(i);
                        switch (instr.opcode) {
                            case 192: 
                            case 193: {
                                if (!cl.qualifiedName.equals(pool.getPrimitiveConstant(instr.operand(0)).getString())) continue block8;
                                ++refCounter;
                                refNotNew = true;
                                continue block8;
                            }
                            case 187: 
                            case 189: 
                            case 197: {
                                if (!cl.qualifiedName.equals(pool.getPrimitiveConstant(instr.operand(0)).getString())) continue block8;
                                ++refCounter;
                                continue block8;
                            }
                            case 178: 
                            case 179: {
                                if (!cl.qualifiedName.equals(pool.getLinkConstant((int)instr.operand((int)0)).className)) continue block8;
                                ++refCounter;
                                refNotNew = true;
                            }
                        }
                    }
                }
                mt.releaseResources();
            }
            catch (IOException ex) {
                String message = "Could not read method while checking anonymous class definition: '" + enclosingCl.qualifiedName + "', '" + InterpreterUtil.makeUniqueKey(mt.getName(), mt.getDescriptor()) + "'";
                DecompilerContext.getLogger().writeMessage(message, IFernflowerLogger.Severity.WARN);
                return false;
            }
            if (refCounter <= 1 && !refNotNew) continue;
            String message = "Inconsistent references to the class '" + cl.qualifiedName + "' which is supposed to be anonymous";
            DecompilerContext.getLogger().writeMessage(message, IFernflowerLogger.Severity.WARN);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeClass(StructClass cl, TextBuffer buffer) throws IOException {
        ClassNode root = this.mapRootClasses.get(cl.qualifiedName);
        if (root.type != 0) {
            return;
        }
        boolean packageInfo = cl.isSynthetic() && "package-info".equals(root.simpleName);
        boolean moduleInfo = cl.hasModifier(32768) && cl.hasAttribute(StructGeneralAttribute.ATTRIBUTE_MODULE);
        DecompilerContext.getLogger().startReadingClass(cl.qualifiedName);
        try {
            ImportCollector importCollector = new ImportCollector(root);
            DecompilerContext.startClass(importCollector);
            if (packageInfo) {
                ClassWriter.packageInfoToJava(cl, buffer);
                importCollector.writeImports(buffer, false);
            } else if (moduleInfo) {
                TextBuffer moduleBuffer = new TextBuffer(16384);
                ClassWriter.moduleInfoToJava(cl, moduleBuffer);
                importCollector.writeImports(buffer, true);
                buffer.append(moduleBuffer);
            } else {
                new LambdaProcessor().processClass(root);
                ClassesProcessor.addClassNameToImport(root, importCollector);
                ClassesProcessor.initWrappers(root);
                new NestedClassProcessor().processClass(root, root);
                new NestedMemberAccess().propagateMemberAccess(root);
                TextBuffer classBuffer = new TextBuffer(16384);
                new ClassWriter().classToJava(root, classBuffer, 0, null);
                int index = cl.qualifiedName.lastIndexOf(47);
                if (index >= 0) {
                    String packageName = cl.qualifiedName.substring(0, index).replace('/', '.');
                    buffer.append("package ").append(packageName).append(';').appendLineSeparator().appendLineSeparator();
                }
                importCollector.writeImports(buffer, true);
                int offsetLines = buffer.countLines();
                buffer.append(classBuffer);
                if (DecompilerContext.getOption("bsm")) {
                    BytecodeSourceMapper mapper = DecompilerContext.getBytecodeSourceMapper();
                    mapper.addTotalOffset(offsetLines);
                    if (DecompilerContext.getOption("__dump_original_lines__")) {
                        buffer.dumpOriginalLineNumbers(mapper.getOriginalLinesMapping());
                    }
                    if (DecompilerContext.getOption("__unit_test_mode__")) {
                        buffer.appendLineSeparator();
                        mapper.dumpMapping(buffer, true);
                    }
                }
            }
        }
        finally {
            ClassesProcessor.destroyWrappers(root);
            DecompilerContext.getLogger().endReadingClass();
        }
    }

    private static void initWrappers(ClassNode node) {
        if (node.type == 8) {
            return;
        }
        ClassWrapper wrapper = new ClassWrapper(node.classStruct);
        wrapper.init();
        node.wrapper = wrapper;
        for (ClassNode nd : node.nested) {
            ClassesProcessor.initWrappers(nd);
        }
    }

    private static void addClassNameToImport(ClassNode node, ImportCollector imp) {
        if (node.simpleName != null && node.simpleName.length() > 0) {
            imp.getNestedName(node.type == 0 ? node.classStruct.qualifiedName : node.simpleName, false);
        }
        for (ClassNode nd : node.nested) {
            ClassesProcessor.addClassNameToImport(nd, imp);
        }
    }

    private static void destroyWrappers(ClassNode node) {
        node.wrapper = null;
        node.classStruct.releaseResources();
        for (ClassNode nd : node.nested) {
            ClassesProcessor.destroyWrappers(nd);
        }
    }

    public Map<String, ClassNode> getMapRootClasses() {
        return this.mapRootClasses;
    }

    private static class Inner {
        private String simpleName;
        private int type;
        private int accessFlags;

        private Inner() {
        }

        private static boolean equal(Inner o1, Inner o2) {
            return o1.type == o2.type && o1.accessFlags == o2.accessFlags && Objects.equals(o1.simpleName, o2.simpleName);
        }
    }

    public static class ClassNode {
        public static final int CLASS_ROOT = 0;
        public static final int CLASS_MEMBER = 1;
        public static final int CLASS_ANONYMOUS = 2;
        public static final int CLASS_LOCAL = 4;
        public static final int CLASS_LAMBDA = 8;
        public int type;
        public int access;
        public boolean isNonSealed = false;
        public String simpleName;
        public final StructClass classStruct;
        private ClassWrapper wrapper;
        public String enclosingMethod;
        public InvocationExprent superInvocation;
        public final Map<String, VarVersionPair> mapFieldsToVars = new HashMap<String, VarVersionPair>();
        public VarType anonymousClassType;
        public final List<ClassNode> nested = new ArrayList<ClassNode>();
        public final Set<String> enclosingClasses = new HashSet<String>();
        public ClassNode parent;
        public LambdaInformation lambdaInformation;

        public ClassNode(String content_class_name, String content_method_name, String content_method_descriptor, int content_method_invocation_type, String lambda_class_name, String lambda_method_name, String lambda_method_descriptor, StructClass classStruct) {
            boolean is_method_reference;
            this.type = 8;
            this.classStruct = classStruct;
            this.lambdaInformation = new LambdaInformation();
            this.lambdaInformation.method_name = lambda_method_name;
            this.lambdaInformation.method_descriptor = lambda_method_descriptor;
            this.lambdaInformation.content_class_name = content_class_name;
            this.lambdaInformation.content_method_name = content_method_name;
            this.lambdaInformation.content_method_descriptor = content_method_descriptor;
            this.lambdaInformation.content_method_invocation_type = content_method_invocation_type;
            this.lambdaInformation.content_method_key = InterpreterUtil.makeUniqueKey(this.lambdaInformation.content_method_name, this.lambdaInformation.content_method_descriptor);
            this.anonymousClassType = new VarType(lambda_class_name, true);
            boolean bl = is_method_reference = !Objects.equals(content_class_name, classStruct.qualifiedName);
            if (!is_method_reference) {
                StructMethod mt = classStruct.getMethod(content_method_name, content_method_descriptor);
                is_method_reference = !mt.isSynthetic();
            }
            this.lambdaInformation.is_method_reference = is_method_reference;
            this.lambdaInformation.is_content_method_static = this.lambdaInformation.content_method_invocation_type == 6;
        }

        public ClassNode(int type, StructClass classStruct) {
            this.type = type;
            this.classStruct = classStruct;
            this.simpleName = classStruct.qualifiedName.substring(classStruct.qualifiedName.lastIndexOf(47) + 1);
        }

        public ClassNode getClassNode(String qualifiedName) {
            for (ClassNode node : this.nested) {
                if (!qualifiedName.equals(node.classStruct.qualifiedName)) continue;
                return node;
            }
            return null;
        }

        public ClassWrapper getWrapper() {
            ClassNode node = this;
            while (node.type == 8) {
                node = node.parent;
            }
            return node.wrapper;
        }

        public boolean isNonSealed() {
            return this.isNonSealed;
        }

        public void setNonSealed(boolean nonSealed) {
            this.isNonSealed = nonSealed;
        }

        public static class LambdaInformation {
            public String method_name;
            public String method_descriptor;
            public String content_class_name;
            public String content_method_name;
            public String content_method_descriptor;
            public int content_method_invocation_type;
            public String content_method_key;
            public boolean is_method_reference;
            public boolean is_content_method_static;
        }
    }
}

