/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.modules.decompiler.stats;

import org.jetbrains.java.decompiler.main.rels.ClassWrapper;
import org.jetbrains.java.decompiler.main.rels.MethodWrapper;
import org.jetbrains.java.decompiler.modules.decompiler.exps.InvocationExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.VarExprent;
import org.jetbrains.java.decompiler.modules.decompiler.stats.Statement;
import org.jetbrains.java.decompiler.modules.decompiler.vars.VarVersionPair;

public final class Statements {
    public static Statement findFirstData(Statement stat) {
        if (stat.getExprents() != null) {
            return stat;
        }
        if (stat.isLabeled()) {
            return null;
        }
        return switch (stat.type) {
            case Statement.StatementType.SEQUENCE, Statement.StatementType.IF, Statement.StatementType.ROOT, Statement.StatementType.SWITCH, Statement.StatementType.SYNCHRONIZED -> Statements.findFirstData(stat.getFirst());
            default -> null;
        };
    }

    public static boolean isInvocationInitConstructor(InvocationExprent inv, MethodWrapper method, ClassWrapper wrapper, boolean withThis) {
        if (inv.getFuncType() == 2 && inv.getInstance().type == 12) {
            VarExprent instVar = (VarExprent)inv.getInstance();
            VarVersionPair varPair = new VarVersionPair(instVar);
            String className = method.varproc.getThisVars().get(varPair);
            if (className != null) {
                return withThis || !wrapper.getClassStruct().qualifiedName.equals(inv.getClassName());
            }
        }
        return false;
    }
}

