/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.jps;

import com.intellij.compiler.server.BuildProcessParametersProvider;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.PathUtil;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.base.plugin.KotlinBasePluginBundle;
import org.jetbrains.kotlin.idea.compiler.configuration.KotlinArtifactsDownloader;
import org.jetbrains.kotlin.idea.compiler.configuration.KotlinJpsPluginSettings;
import org.jetbrains.kotlin.idea.compiler.configuration.LazyKotlinJpsPluginClasspathDownloader;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u000e\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\nH\u0016J\u001a\u0010\u000b\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\r0\f0\nH\u0016J\u000e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\b0\nH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/idea/jps/KotlinJpsBuildProcessParametersProvider;", "Lcom/intellij/compiler/server/BuildProcessParametersProvider;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "downloadOrThrow", "", "version", "", "getClassPath", "", "getPathParameters", "Lcom/intellij/openapi/util/Pair;", "Ljava/nio/file/Path;", "getVMArguments", "kotlin.base.jps"})
@SourceDebugExtension(value={"SMAP\nKotlinJpsBuildProcessParametersProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinJpsBuildProcessParametersProvider.kt\norg/jetbrains/kotlin/idea/jps/KotlinJpsBuildProcessParametersProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,99:1\n1549#2:100\n1620#2,3:101\n*S KotlinDebug\n*F\n+ 1 KotlinJpsBuildProcessParametersProvider.kt\norg/jetbrains/kotlin/idea/jps/KotlinJpsBuildProcessParametersProvider\n*L\n45#1:100\n45#1:101,3\n*E\n"})
public final class KotlinJpsBuildProcessParametersProvider
extends BuildProcessParametersProvider {
    @NotNull
    private final Project project;

    public KotlinJpsBuildProcessParametersProvider(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<String> getClassPath() {
        void $this$mapTo$iv$iv;
        Iterable iterable;
        Iterable jpsPluginClasspathAfterDownloading;
        String version = KotlinJpsPluginSettings.Companion.jpsVersion(this.project);
        List existingJpsPluginClasspath = new LazyKotlinJpsPluginClasspathDownloader(version).getDownloadedIfUpToDateOrEmpty();
        Collection collection = existingJpsPluginClasspath;
        if (collection.isEmpty()) {
            boolean bl = false;
            this.downloadOrThrow(version);
            jpsPluginClasspathAfterDownloading = new LazyKotlinJpsPluginClasspathDownloader(version).getDownloadedIfUpToDateOrEmpty();
            if (jpsPluginClasspathAfterDownloading.isEmpty()) {
                throw new IllegalStateException(("Unable to download required Kotlin JPS plugin version " + version + ": classpath is not available after downloading").toString());
            }
            iterable = jpsPluginClasspathAfterDownloading;
        } else {
            iterable = collection;
        }
        List jpsPluginClassPath = (List)iterable;
        Iterable $this$map$iv = jpsPluginClassPath;
        boolean $i$f$map = false;
        jpsPluginClasspathAfterDownloading = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            File file = (File)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(it.getCanonicalPath());
        }
        return CollectionsKt.plus((Collection)((List)destination$iv$iv), (Iterable)CollectionsKt.listOf((Object)PathUtil.getJarPathForClass(PathUtil.class)));
    }

    @NotNull
    public List<Pair<String, Path>> getPathParameters() {
        String version = KotlinJpsPluginSettings.Companion.jpsVersion(this.project);
        File kotlinDist = KotlinArtifactsDownloader.INSTANCE.getUnpackedKotlinDistPath(this.project);
        if (!kotlinDist.isDirectory()) {
            this.downloadOrThrow(version);
            if (!kotlinDist.isDirectory()) {
                throw new IllegalStateException(("Unable to download required Kotlin JPS plugin version " + version + ": dist is not available after downloading at " + kotlinDist).toString());
            }
        }
        return CollectionsKt.listOf((Object)new Pair((Object)"-Djps.kotlin.home=", (Object)kotlinDist.toPath()));
    }

    @NotNull
    public List<String> getVMArguments() {
        return Registry.is((String)"kotlin.jps.instrument.bytecode", (boolean)false) ? CollectionsKt.listOf((Object)"-Dkotlin.jps.instrument.bytecode=true") : CollectionsKt.emptyList();
    }

    private final void downloadOrThrow(String version) {
        CompletableFuture<Unit> future = new CompletableFuture<Unit>();
        String title = KotlinBasePluginBundle.message((String)"progress.text.downloading.kotlin.jps.plugin", (Object[])new Object[0]);
        Project project = this.project;
        PerformInBackgroundOption performInBackgroundOption = Task.Backgroundable.ALWAYS_BACKGROUND;
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(title, version, future, project, performInBackgroundOption){
            final /* synthetic */ String $version;
            final /* synthetic */ CompletableFuture<Unit> $future;
            {
                this.$version = $version;
                this.$future = $future;
                super($super_call_param$1, $title, true, $super_call_param$2);
            }

            public void run(@NotNull ProgressIndicator indicator) {
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                try {
                    AtomicReference<String> errorMessageRef = new AtomicReference<String>();
                    Project project = this.getProject();
                    Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                    ProgressIndicator progressIndicator = ProgressManager.getInstance().getProgressIndicator();
                    Intrinsics.checkNotNullExpressionValue((Object)progressIndicator, (String)"getProgressIndicator(...)");
                    boolean success2 = KotlinArtifactsDownloader.INSTANCE.lazyDownloadMissingJpsPluginDependencies(project, this.$version, progressIndicator, (Function1)new Function1<String, Unit>(errorMessageRef){
                        final /* synthetic */ AtomicReference<String> $errorMessageRef;
                        {
                            this.$errorMessageRef = $errorMessageRef;
                            super(1);
                        }

                        public final void invoke(@NotNull String it) {
                            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                            this.$errorMessageRef.set(it);
                        }
                    });
                    if (!success2) {
                        String string = errorMessageRef.get();
                        if (string == null) {
                            string = "unknown error";
                        }
                        String errorMessage = string;
                        throw new IllegalStateException(("Unable to download required Kotlin JPS plugin version " + this.$version + ": " + errorMessage).toString());
                    }
                    this.$future.complete(Unit.INSTANCE);
                }
                catch (Throwable t) {
                    this.$future.completeExceptionally(t);
                }
            }
        });
        future.get();
    }
}

